/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.pcsc.android.Card;
import kz.gamma.crypto.pcsc.android.CardChannel;
import kz.gamma.crypto.pcsc.android.CardException;
import kz.gamma.crypto.pcsc.android.CardTerminal;
import kz.gamma.crypto.pcsc.android.CommandAPDU;
import kz.gamma.crypto.pcsc.android.ResponseAPDU;
import kz.gamma.crypto.pcsc.android.TerminalFactory;

public class PCSCHelper {
    private static byte[] GAMMA_JACARTA_APPLET = new byte[]{0, -92, 4, 0, 12, -96, 0, 103, 97, 109, 109, 97, 116, 101, 99, 104, 0};
    private static byte[] GAMMA_JAVA_TOKEN_APPLET = new byte[]{0, -92, 4, 0, 10, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0};
    private static byte[] GAMMA_JAVA_SAFENET_APPLET = new byte[]{0, -92, 4, 0, 12, -96, 0, 103, 97, 109, 109, 97, 116, 101, 99, 104, 103, 0};
    private static byte[] KZ_TOKEN_STATUS = new byte[]{0, -54, 1, -119, 38};
    private static byte[] KZ_TOKEN_SERIAL = new byte[]{0, -54, 1, -127, -1};

    private static boolean isAppletLoaded(CardChannel ch, byte[] applet) {
        boolean ret = false;
        ResponseAPDU respApdu = null;
        CommandAPDU capdu = null;
        try {
            System.out.println("isAppletLoaded: " + UtilCM.array2hex(applet));
            capdu = new CommandAPDU(applet);
            respApdu = ch.transmit(capdu);
            if (respApdu.getSW() == 36864) {
                ret = true;
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            ret = false;
        }
        return ret;
    }

    private static boolean isKzToken(CardChannel ch) {
        try {
            CommandAPDU capdu = new CommandAPDU(KZ_TOKEN_STATUS);
            ResponseAPDU respApdu = ch.transmit(capdu);
            if (respApdu.getSW() != 36864) {
                return false;
            }
            capdu = new CommandAPDU(KZ_TOKEN_SERIAL);
            respApdu = ch.transmit(capdu);
            return respApdu.getSW() == 36864;
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            return false;
        }
    }

    public static Map<String, String> getAvaibleToken() throws CardException {
        LinkedHashMap<String, String> tokenList = new LinkedHashMap<String, String>();
        TerminalFactory factory = null;
        Object cardTerminals = null;
        factory = TerminalFactory.getDefault();
        System.out.println("getToken avaible");
        List<CardTerminal> terminals = factory.terminals().listTerminals("");
        CardTerminal terminal = terminals.get(0);
        Card sc = terminal.connect("*");
        CardChannel ch = sc.getBasicChannel();
        if (PCSCHelper.isAppletLoaded(ch, GAMMA_JAVA_SAFENET_APPLET)) {
            tokenList.put("SAFENET", UtilCM.array2hex(sc.getATR().getBytes()));
        } else if (PCSCHelper.isAppletLoaded(ch, GAMMA_JAVA_TOKEN_APPLET)) {
            tokenList.put("ETOKEN", UtilCM.array2hex(sc.getATR().getBytes()));
        } else if (PCSCHelper.isAppletLoaded(ch, GAMMA_JACARTA_APPLET)) {
            tokenList.put("JACARTA", UtilCM.array2hex(sc.getATR().getBytes()));
        } else if (PCSCHelper.isKzToken(ch)) {
            tokenList.put("KAZTOKEN", UtilCM.array2hex(sc.getATR().getBytes()));
        }
        return tokenList;
    }
}

