/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.android;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import java.io.IOException;
import kz.gamma.crypto.pcsc.android.ATR;
import kz.gamma.crypto.pcsc.android.CardChannel;
import kz.gamma.crypto.pcsc.android.CcidInfo;

public class Card {
    private UsbDeviceConnection usbConnection = null;
    private UsbEndpoint usbOut = null;
    private UsbEndpoint usbIn = null;
    private UsbEndpoint usbInterrupt = null;
    private ATR atr = null;
    private CcidInfo ccidInfo;
    private CardChannel cardChannel = null;

    public Card(UsbDeviceConnection usbConnection, UsbEndpoint usbOut, UsbEndpoint usbIn, UsbEndpoint usbInterrupt) {
        this.usbConnection = usbConnection;
        this.usbOut = usbOut;
        this.usbIn = usbIn;
        this.usbInterrupt = usbInterrupt;
        this.ccidInfo = new CcidInfo(usbConnection.getRawDescriptors());
    }

    public ATR getATR() {
        try {
            if (this.cardChannel == null) {
                this.cardChannel = new CardChannel(this.usbConnection, this.usbOut, this.usbIn, this.usbInterrupt, this.ccidInfo);
                CardChannel.Response resp = this.cardChannel.transmit((byte)98, null, (byte)-128, false);
                if (resp.param == 0 && resp.data.length > 1) {
                    this.atr = new ATR(resp.data);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this.atr;
    }

    public CardChannel getBasicChannel() {
        try {
            if (this.cardChannel == null) {
                this.cardChannel = new CardChannel(this.usbConnection, this.usbOut, this.usbIn, this.usbInterrupt, this.ccidInfo);
                CardChannel.Response resp = this.cardChannel.transmit((byte)98, null, (byte)-128, false);
                if (resp.param == 0 && resp.data.length > 1) {
                    this.atr = new ATR(resp.data);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this.cardChannel;
    }

    public String getProtocol() {
        if (this.ccidInfo.getProtocols().contains((Object)CcidInfo.Protocol.T0)) {
            return "T=0";
        }
        return "T=1";
    }

    public boolean isSupportTAPDU() {
        return this.ccidInfo.getFeatures().contains((Object)CcidInfo.Feature.TPDU);
    }
}

