/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.android;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import java.io.IOException;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.pcsc.android.CardException;
import kz.gamma.crypto.pcsc.android.CcidInfo;
import kz.gamma.crypto.pcsc.android.CommandAPDU;
import kz.gamma.crypto.pcsc.android.ResponseAPDU;

public class CardChannel {
    private int sequence;
    private UsbDeviceConnection usbConnection;
    private UsbEndpoint usbOut;
    private UsbEndpoint usbIn;
    private UsbEndpoint usbInterrupt;
    private boolean isF = true;
    private CcidInfo ccidInfo;
    private boolean ignoreT0 = true;
    private boolean isKzToken = false;
    private int indx = 3;

    public CardChannel(UsbDeviceConnection usbConnection, UsbEndpoint usbOut, UsbEndpoint usbIn, UsbEndpoint usbInterrupt, CcidInfo ccidInfo) {
        this.usbConnection = usbConnection;
        this.usbOut = usbOut;
        this.usbIn = usbIn;
        this.usbInterrupt = usbInterrupt;
        this.ccidInfo = ccidInfo;
    }

    private boolean isTPDUT1() {
        boolean ret = this.ccidInfo.getFeatures().contains((Object)CcidInfo.Feature.TPDU) & !(this.ccidInfo.getProtocols().contains((Object)CcidInfo.Protocol.T0) & this.ignoreT0);
        System.out.println("isTPDUT1: " + ret + ", TPDU: " + this.ccidInfo.getFeatures().contains((Object)CcidInfo.Feature.TPDU) + ", T0: " + this.ccidInfo.getProtocols().contains((Object)CcidInfo.Protocol.T0) + ", ignoreT0: " + this.ignoreT0);
        return ret;
    }

    private byte[] getAPDUData(byte[] data) {
        byte[] ret = new byte[data.length + 4];
        ret[0] = 0;
        if (this.isF) {
            ret[1] = 0;
            this.isF = false;
        } else {
            ret[1] = 64;
            this.isF = true;
        }
        ret[2] = (byte)data.length;
        System.arraycopy(data, 0, ret, 3, data.length);
        ret[ret.length - 1] = 0;
        for (int i = 0; i < ret.length - 1; ++i) {
            int n = ret.length - 1;
            ret[n] = (byte)(ret[n] ^ ret[i]);
        }
        return ret;
    }

    public ResponseAPDU transmit(CommandAPDU apdu) throws CardException {
        ResponseAPDU rapdu = null;
        try {
            rapdu = this.transmit(apdu, (byte)111, (byte)-128);
            if (rapdu.getSW1() == 97) {
                CommandAPDU command = new CommandAPDU(apdu.getCLA(), 192, 0, 0, rapdu.getSW2() == 0 ? 256 : rapdu.getSW2());
                rapdu = this.transmit(command, (byte)111, (byte)-128);
            } else if (rapdu.getSW1() == 108) {
                byte[] data = new byte[]{};
                CommandAPDU command = new CommandAPDU(apdu.getCLA(), apdu.getINS(), apdu.getP1(), apdu.getP2(), data, 0, 0, (byte)rapdu.getSW2());
                rapdu = this.transmit(command, (byte)111, (byte)-128);
            }
        }
        catch (CardException ex) {
            System.out.println("indx: " + this.indx + ", Exception: " + ex.getMessage());
            if (ex.getMessage().equalsIgnoreCase("Failed to read data from the CCID reader")) {
                if (!this.isKzToken) {
                    if (this.indx > 0) {
                        --this.indx;
                        this.ignoreT0 = !this.ignoreT0;
                        rapdu = this.transmit(apdu);
                    }
                    throw ex;
                }
                throw ex;
            }
            if (ex.getMessage().equalsIgnoreCase("Error response faild: 6d != 00")) {
                this.isKzToken = true;
                this.ignoreT0 = true;
                rapdu = new ResponseAPDU(27904, null);
            }
            throw ex;
        }
        this.indx = 3;
        return rapdu;
    }

    public ResponseAPDU transmit(CommandAPDU apdu, byte cmd, byte rtn) throws CardException {
        byte[] data = null;
        byte[] allData = null;
        byte[] ccidData = null;
        try {
            byte checkSum;
            ccidData = this.isTPDUT1() ? this.getAPDUData(apdu.getBytes()) : apdu.getBytes();
            Response rsp = this.transmit(cmd, ccidData, rtn, true);
            data = rsp.data;
            if (rsp.param != 0) {
                throw new CardException("Error transmit apdu: " + Integer.toString((rsp.param & 0xFF) + 256, 16).substring(1));
            }
            if (this.isTPDUT1()) {
                checkSum = 0;
                for (int i = 0; i < data.length - 1; ++i) {
                    checkSum = (byte)(checkSum ^ data[i]);
                }
                if (checkSum != data[data.length - 1]) {
                    throw new CardException("Error response faild: " + Integer.toString((checkSum & 0xFF) + 256, 16).substring(1) + " != " + Integer.toString((data[data.length - 1] & 0xFF) + 256, 16).substring(1));
                }
            }
            if (this.isTPDUT1() && (data[1] == 32 || data[1] == 96)) {
                byte[] next1 = new byte[]{0, -128, 0, -128};
                byte[] next2 = new byte[]{0, -112, 0, -112};
                boolean extF = true;
                allData = data[1] == 96 ? UtilCM.concat(allData, UtilCM.copyByte(data, 3, data[2])) : null;
                do {
                    if (extF) {
                        rsp = this.transmit((byte)111, next1, (byte)-128, true);
                        extF = false;
                    } else {
                        rsp = this.transmit((byte)111, next2, (byte)-128, true);
                        extF = true;
                    }
                    data = rsp.data;
                    if (rsp.param != 0) {
                        throw new CardException("Error transmit apdu: " + Integer.toString((rsp.param & 0xFF) + 256, 16).substring(1));
                    }
                    checkSum = 0;
                    for (int i = 0; i < data.length - 1; ++i) {
                        checkSum = (byte)(checkSum ^ data[i]);
                    }
                    if (checkSum != data[data.length - 1]) {
                        throw new CardException("Error response faild: " + Integer.toString((checkSum & 0xFF) + 256, 16).substring(1) + " != " + Integer.toString((data[data.length - 1] & 0xFF) + 256, 16).substring(1));
                    }
                    allData = UtilCM.concat(allData, UtilCM.copyByte(data, 3, data[2]));
                } while (data[1] == 32 || data[1] == 96);
            }
        }
        catch (IOException ex) {
            throw new CardException(ex.getMessage());
        }
        if (allData == null) {
            if (this.isTPDUT1()) {
                return new ResponseAPDU(UtilCM.copyByte(data, 3, data[2]));
            }
            return new ResponseAPDU(data);
        }
        return new ResponseAPDU(36864, allData);
    }

    public Response transmit(byte cmd, byte[] data, byte rtn, boolean waitIcc) throws IOException {
        SlotStatus status;
        int count;
        this.sequence = (this.sequence + 1) % 255;
        byte[] req = new byte[(data == null ? 0 : data.length) + 10];
        req[0] = cmd;
        req[1] = (byte)(req.length - 10);
        req[2] = 0;
        req[3] = 0;
        req[4] = 0;
        req[5] = 0;
        req[6] = (byte)this.sequence;
        req[7] = 0;
        req[8] = 0;
        req[9] = 0;
        if (data != null) {
            System.arraycopy(data, 0, req, 10, data.length);
        }
        if ((count = this.usbConnection.bulkTransfer(this.usbOut, req, req.length, 5000)) < 0) {
            throw new IOException("Failed to send data to the CCID reader");
        }
        System.out.println("Send to card command: " + UtilCM.array2hex(req, 0, count));
        byte[] rsp = new byte[512];
        do {
            if ((count = this.usbConnection.bulkTransfer(this.usbIn, rsp, rsp.length, 3000)) < 0) {
                throw new IOException("Failed to read data from the CCID reader");
            }
            status = this.validateResponse(rsp, rtn);
        } while (waitIcc && status != SlotStatus.Active);
        Response retVal = new Response();
        retVal.param = rsp[9];
        if (count > 10) {
            retVal.data = new byte[count - 10];
            System.arraycopy(rsp, 10, retVal.data, 0, count - 10);
        } else {
            retVal.data = new byte[0];
        }
        return retVal;
    }

    private SlotStatus validateResponse(byte[] rsp, byte type) throws IOException {
        if (rsp.length < 10) {
            throw new IOException("The response is to short");
        }
        if (rsp[0] != type) {
            throw new IOException(String.format("Illegal CCID reader response (wrong type: %X)", rsp[0]));
        }
        if (rsp[6] != (byte)this.sequence) {
            throw new IOException("Illegal CCID reader response (wrong sequence)");
        }
        if ((rsp[7] & 3) == 1 && rsp[8] == 0) {
            throw new UnsupportedOperationException("Command not supported by the reader");
        }
        if ((rsp[7] & 3) != 0) {
            throw new CardException(String.format("Command Error returned by the CCID reader: %x", rsp[8]), rsp[7], rsp[8]);
        }
        switch ((byte)(rsp[7] & 0xFFFFFFC0)) {
            case -128: {
                return SlotStatus.Missing;
            }
            case 64: {
                return SlotStatus.Inactive;
            }
            case 0: {
                return SlotStatus.Active;
            }
        }
        throw new IOException(String.format("Invalid slot status received from the CCID reader: %X", (byte)(rsp[7] & 0xFFFFFFC0)));
    }

    public static class Response {
        public byte param;
        public byte[] data;
    }

    public static enum SlotStatus {
        Active,
        Inactive,
        Missing;

    }
}

