/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.android;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.LinkedList;

public class CcidInfo {
    private int ccidVersion;
    private int maxSlotIndex;
    private EnumSet<Protocol> protocols;
    private int defaultClock;
    private int maxClock;
    private int numClockSupported;
    private int defaultDataRate;
    private int maxDataRate;
    private int numDataRatesSupported;
    private int maxIFSD;
    private EnumSet<Mechanical> mechanicals;
    private EnumSet<Feature> features;
    private int maxCCIDMessageLength;
    private int classGetResponse;
    private int classEnvelope;
    private EnumSet<PINSupport> pinSupports;
    private int maxCCIDBusySlots;

    public CcidInfo(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb = bb.order(ByteOrder.LITTLE_ENDIAN);
        int i = -1;
        while (bb.hasRemaining()) {
            byte len = bb.get();
            byte type = bb.get();
            if (type == 4) {
                if (len != 9) {
                    throw new IllegalArgumentException("Invalid Interface descriptor (wrong length)");
                }
                i = bb.getShort();
                bb.position(bb.position() + len - 4);
                continue;
            }
            if (type == 33) {
                if (len != 54) {
                    throw new IllegalArgumentException("Invalid Smart Card Device descriptor (wrong length)");
                }
                this.ccidVersion = bb.getShort();
                this.maxSlotIndex = bb.get();
                bb.get();
                int pData = bb.getInt();
                LinkedList<Protocol> pList = new LinkedList<Protocol>();
                if ((pData & 1) == 1) {
                    pList.add(Protocol.T0);
                }
                if ((pData & 2) == 2) {
                    pList.add(Protocol.T1);
                }
                this.protocols = pList.isEmpty() ? EnumSet.noneOf(Protocol.class) : EnumSet.copyOf(pList);
                this.defaultClock = bb.getInt();
                this.maxClock = bb.getInt();
                this.numClockSupported = bb.get();
                this.defaultDataRate = bb.getInt();
                this.maxDataRate = bb.getInt();
                this.numDataRatesSupported = bb.get();
                this.maxIFSD = bb.getInt();
                bb.getInt();
                int mData = bb.getInt();
                LinkedList<Mechanical> mList = new LinkedList<Mechanical>();
                if ((mData & 1) == 1) {
                    mList.add(Mechanical.Accept);
                }
                if ((mData & 2) == 2) {
                    mList.add(Mechanical.Ejection);
                }
                if ((mData & 4) == 4) {
                    mList.add(Mechanical.Capture);
                }
                if ((mData & 8) == 8) {
                    mList.add(Mechanical.LockUnlock);
                }
                this.mechanicals = mList.isEmpty() ? EnumSet.noneOf(Mechanical.class) : EnumSet.copyOf(mList);
                int fData = bb.getInt();
                LinkedList<Feature> fList = new LinkedList<Feature>();
                if ((fData & 2) == 2) {
                    fList.add(Feature.AutoParamConfigViaATR);
                }
                if ((fData & 4) == 4) {
                    fList.add(Feature.AutoActivationOnInsert);
                }
                if ((fData & 8) == 8) {
                    fList.add(Feature.AutoVoltageSelection);
                }
                if ((fData & 0x10) == 16) {
                    fList.add(Feature.AutoClockChange);
                }
                if ((fData & 0x20) == 32) {
                    fList.add(Feature.AutoDataRateChange);
                }
                if ((fData & 0x40) == 64) {
                    fList.add(Feature.AutoParamNego);
                }
                if ((fData & 0x80) == 128) {
                    fList.add(Feature.AutoPPS);
                }
                if ((fData & 0x100) == 256) {
                    fList.add(Feature.CanStopClock);
                }
                if ((fData & 0x200) == 512) {
                    fList.add(Feature.NADAccepted);
                }
                if ((fData & 0x400) == 1024) {
                    fList.add(Feature.AutoIFSDExchange);
                }
                if ((fData & 0x10000) == 65536) {
                    fList.add(Feature.TPDU);
                }
                if ((fData & 0x20000) == 131072) {
                    fList.add(Feature.ShortAPDU);
                }
                if ((fData & 0x40000) == 262144) {
                    fList.add(Feature.ShortAndExtendedAPDU);
                }
                if ((fData & 0x100000) == 0x100000) {
                    fList.add(Feature.WakeOnCardAction);
                }
                this.features = fList.isEmpty() ? EnumSet.noneOf(Feature.class) : EnumSet.copyOf(fList);
                this.maxCCIDMessageLength = bb.getInt();
                this.classGetResponse = bb.get();
                this.classEnvelope = bb.get();
                bb.get();
                bb.get();
                byte psData = bb.get();
                LinkedList<PINSupport> psList = new LinkedList<PINSupport>();
                if ((psData & 1) == 1) {
                    psList.add(PINSupport.Verification);
                }
                if ((psData & 2) == 2) {
                    psList.add(PINSupport.Modification);
                }
                this.pinSupports = psList.isEmpty() ? EnumSet.noneOf(PINSupport.class) : EnumSet.copyOf(psList);
                this.maxCCIDBusySlots = bb.get();
                continue;
            }
            bb.position(bb.position() + len - 2);
        }
    }

    public int getCcidVersion() {
        return this.ccidVersion;
    }

    public int getMaxSlotIndex() {
        return this.maxSlotIndex;
    }

    public EnumSet<Protocol> getProtocols() {
        return this.protocols;
    }

    public int getDefaultClock() {
        return this.defaultClock;
    }

    public int getMaxClock() {
        return this.maxClock;
    }

    public int getNumClockSupported() {
        return this.numClockSupported;
    }

    public int getDefaultDataRate() {
        return this.defaultDataRate;
    }

    public int getMaxDataRate() {
        return this.maxDataRate;
    }

    public int getNumDataRatesSupported() {
        return this.numDataRatesSupported;
    }

    public int getMaxIFSD() {
        return this.maxIFSD;
    }

    public EnumSet<Mechanical> getMechanicals() {
        return this.mechanicals;
    }

    public EnumSet<Feature> getFeatures() {
        return this.features;
    }

    public int getMaxCCIDMessageLength() {
        return this.maxCCIDMessageLength;
    }

    public int getClassGetResponse() {
        return this.classGetResponse;
    }

    public int getClassEnvelope() {
        return this.classEnvelope;
    }

    public EnumSet<PINSupport> getPinSupports() {
        return this.pinSupports;
    }

    public int getMaxCCIDBusySlots() {
        return this.maxCCIDBusySlots;
    }

    public static enum PINSupport {
        Verification,
        Modification;

    }

    public static enum Feature {
        AutoParamConfigViaATR,
        AutoActivationOnInsert,
        AutoVoltageSelection,
        AutoClockChange,
        AutoDataRateChange,
        AutoParamNego,
        AutoPPS,
        CanStopClock,
        NADAccepted,
        AutoIFSDExchange,
        TPDU,
        ShortAPDU,
        ShortAndExtendedAPDU,
        WakeOnCardAction;

    }

    public static enum Mechanical {
        Accept,
        Ejection,
        Capture,
        LockUnlock;

    }

    public static enum Protocol {
        T0,
        T1;

    }
}

