/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.android;

import kz.gamma.crypto.pcsc.android.CommandAPDU;

public class CommandAPDUEX {
    private static byte usbCmd = (byte)111;
    private static byte usbRsp = (byte)-128;
    private static boolean waitIcc = true;
    private byte[] apduPacket = null;
    private CommandAPDU apdu = null;

    public CommandAPDUEX(CommandAPDU apdu, boolean isSupportTAPDU) {
        if (isSupportTAPDU) {
            this.apduPacket = new byte[apdu.getBytes().length + 4];
            this.apduPacket[0] = 0;
            this.apduPacket[1] = 64;
            this.apduPacket[2] = (byte)apdu.getBytes().length;
            System.arraycopy(apdu.getBytes(), 0, this.apduPacket, 3, apdu.getBytes().length);
            this.apduPacket[this.apduPacket.length - 1] = 0;
            for (int i = 0; i < this.apduPacket.length - 1; ++i) {
                int n = this.apduPacket.length - 1;
                this.apduPacket[n] = (byte)(this.apduPacket[n] ^ this.apduPacket[i]);
            }
        } else {
            this.apduPacket = apdu.getBytes();
        }
    }

    public CommandAPDUEX(byte[] apdu) {
        this(new CommandAPDU(apdu), true);
    }

    public CommandAPDUEX(byte[] apdu, boolean isSupportTAPDU) {
        this(new CommandAPDU(apdu), isSupportTAPDU);
    }

    public CommandAPDUEX(int cla, int ins, int p1, int p2, byte[] data) {
        this(new CommandAPDU(cla, ins, p1, p2, data), true);
    }

    public CommandAPDUEX(int cla, int ins, int p1, int p2, byte[] data, boolean isSupportTAPDU) {
        this(new CommandAPDU(cla, ins, p1, p2, data), isSupportTAPDU);
    }

    public CommandAPDUEX(int cla, int ins, int p1, int p2, boolean isSupportTAPDU) {
        this(new CommandAPDU(cla, ins, p1, p2), isSupportTAPDU);
    }

    public CommandAPDUEX(int cla, int ins, int p1, int p2) {
        this(new CommandAPDU(cla, ins, p1, p2), true);
    }

    public byte getUsbCmd() {
        return usbCmd;
    }

    public byte getUsbRsp() {
        return usbRsp;
    }

    public boolean isWaitIcc() {
        return waitIcc;
    }

    public byte[] getApduPacket() {
        return this.apduPacket;
    }
}

