/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.android;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import java.util.HashMap;
import kz.gamma.crypto.pcsc.android.CardException;
import kz.gamma.crypto.pcsc.android.CardTerminals;
import kz.gamma.crypto.pcsc.android.CcidInfo;

public class TerminalFactory {
    private static TerminalFactory defaultTerminal = null;
    private CardTerminals terminals = new CardTerminals();
    private CcidInfo ccidInfo;

    private TerminalFactory() {
    }

    public static TerminalFactory getDefault() {
        if (defaultTerminal == null) {
            defaultTerminal = new TerminalFactory();
        }
        return defaultTerminal;
    }

    public void initTerminal(UsbDeviceConnection usbConnection, UsbEndpoint usbOut, UsbEndpoint usbIn, UsbEndpoint usbInterrupt) {
        this.terminals.addTerminal(usbConnection, usbOut, usbIn, usbInterrupt);
    }

    public CardTerminals terminals() throws CardException {
        if (this.terminals == null) {
            throw new CardException("terminals not initialize");
        }
        return this.terminals;
    }

    public void initTerminal(UsbManager usbManager) {
        HashMap deviceList = usbManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            this.initTerminal(usbManager, device);
        }
    }

    public void initTerminal(UsbManager usbManager, UsbDevice usbDevice) {
        if (this.isCCIDCompliant(usbDevice)) {
            UsbDeviceConnection connection;
            UsbInterface usbInterface = null;
            for (int i = 0; i < usbDevice.getInterfaceCount(); ++i) {
                UsbInterface usbIf = usbDevice.getInterface(i);
                if (usbIf.getInterfaceClass() != 11) continue;
                usbInterface = usbIf;
                break;
            }
            if (usbInterface != null && (connection = usbManager.openDevice(usbDevice)) != null) {
                UsbEndpoint usbOut = null;
                UsbEndpoint usbIn = null;
                UsbEndpoint usbInterrupt = null;
                connection.claimInterface(usbInterface, true);
                for (int i = 0; i < usbInterface.getEndpointCount(); ++i) {
                    UsbEndpoint usbEp = usbInterface.getEndpoint(i);
                    if (usbEp.getDirection() == 128 && usbEp.getType() == 3) {
                        usbInterrupt = usbEp;
                    }
                    if (usbEp.getDirection() == 0 && usbEp.getType() == 2) {
                        usbOut = usbEp;
                    }
                    if (usbEp.getDirection() != 128 || usbEp.getType() != 2) continue;
                    usbIn = usbEp;
                }
                this.terminals.addTerminal(connection, usbOut, usbIn, usbInterrupt);
            }
        }
    }

    public void freeTerminal(UsbManager usbManager, UsbDevice usbDevice) {
        this.terminals.delTerminal();
    }

    private boolean isCCIDCompliant(UsbDevice usbDevice) {
        if (usbDevice.getDeviceClass() == 11) {
            return true;
        }
        if (usbDevice.getDeviceClass() == 0) {
            for (int i = 0; i < usbDevice.getInterfaceCount(); ++i) {
                if (usbDevice.getInterface(i).getInterfaceClass() != 11) continue;
                return true;
            }
        }
        return false;
    }
}

