/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.etoken;

import java.util.Arrays;
import java.util.List;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.pcsc.ResponceCard;
import kz.gamma.crypto.pcsc.android.Card;
import kz.gamma.crypto.pcsc.android.CardChannel;
import kz.gamma.crypto.pcsc.android.CardException;
import kz.gamma.crypto.pcsc.android.CardTerminal;
import kz.gamma.crypto.pcsc.android.CommandAPDU;
import kz.gamma.crypto.pcsc.android.ResponseAPDU;
import kz.gamma.crypto.pcsc.android.TerminalFactory;

public class TokenGammaJavaToken {
    public static final byte CLA = -128;
    public static final byte PIN_OPERATION = 16;
    public static final byte P1_PIN_CHANGE_PIN = 16;
    public static final byte P1_PIN_VERIFY_PIN = 32;
    public static final byte P1_VERIFY_PARAM = 81;
    public static final byte KEY_OPERATION = 17;
    public static final byte P1_CREATE_KEY = 32;
    public static final byte P1_EXPORT_PUB_KEY = 33;
    public static final byte P1_EXPORT_KEY_ALG_ID = 35;
    public static final byte P1_EXPORT_KEY_1 = 36;
    public static final byte P1_EXPORT_SIGN_1 = 37;
    public static final byte OBJECT_OPERATION = 18;
    public static final byte P1_OBJECT_NAME_BY_ID = 33;
    public static final byte P1_OBJECT_COUNT = 34;
    public static final byte P1_DELETE_OBJECT = 48;
    public static final byte P1_INSTALL_CERT = 64;
    public static final byte P1_RETURN_CERT = 65;
    public static final byte P1_COPY_CERT_TO_CONT = 66;
    public static final byte P1_COPY_CERT_FROM_CONT = 67;
    public static final byte P1_IS_ELEMENT_EXISTS = 68;
    public static final byte CRYPTO_OPERATION = 20;
    public static final byte P1_SIGN = 16;
    public static final byte P1_VERIFY = 80;
    public static final byte P1_CREATE_GOST_HASH = -127;
    public static final byte P1_UPDATE_GOST_HASH = -126;
    public static final byte P1_FINAL_GOST_HASH = -125;
    public static final byte STATUS_OPERATION = 21;
    public static final byte P1_RESET_STATUS = 32;
    public static final byte P1_GET_STATUS = 16;
    private ResponseAPDU respApdu = null;
    private CommandAPDU capdu = null;
    private Card sc = null;
    private CardChannel ch = null;
    private TerminalFactory factory = TerminalFactory.getDefault();
    private CardTerminal terminal = null;
    private String atr;

    public TokenGammaJavaToken(String reader) throws CardException {
        List<CardTerminal> terminals = this.factory.terminals().listTerminals(reader);
        this.terminal = terminals.get(0);
        this.sc = this.terminal.connect("T=1");
        this.atr = UtilCM.array2hex(this.sc.getATR().getBytes());
        this.ch = this.sc.getBasicChannel();
    }

    public ResponceCard selectApplet() throws CardException {
        byte[] selectApplet = new byte[]{0, -92, 4, 0, 10, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0};
        this.capdu = new CommandAPDU(selectApplet);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard verifyPin(String pin) throws CardException {
        byte[] apdu = new byte[pin.length() + 5];
        apdu[0] = -128;
        apdu[1] = 16;
        apdu[2] = 32;
        apdu[3] = 0;
        apdu[4] = (byte)pin.length();
        System.arraycopy(pin.getBytes(), 0, apdu, 5, pin.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard changePin(String pinOld, String pinNew) throws CardException {
        byte[] apdu = new byte[pinOld.length() + pinNew.length() + 7];
        apdu[0] = -128;
        apdu[1] = 16;
        apdu[2] = 16;
        apdu[3] = 0;
        apdu[4] = (byte)(pinOld.length() + pinNew.length() + 2);
        apdu[5] = (byte)pinOld.length();
        apdu[6] = (byte)pinNew.length();
        System.arraycopy(pinOld.getBytes(), 0, apdu, 7, pinOld.getBytes().length);
        System.arraycopy(pinNew.getBytes(), 0, apdu, 7 + pinOld.length(), pinNew.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard createKey(String name, byte type) throws CardException {
        byte[] key = new byte[64];
        byte[] apdu = new byte[name.length() + 8];
        apdu[0] = -128;
        apdu[1] = 17;
        apdu[2] = 32;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 3);
        apdu[5] = type;
        apdu[6] = (byte)((short)name.length() >> 8);
        apdu[7] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 8, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() == 36864) {
            System.arraycopy(this.respApdu.getData(), 0, key, 0, 32);
            apdu[2] = 36;
            this.capdu = new CommandAPDU(apdu);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                System.arraycopy(this.respApdu.getData(), 0, key, 32, 32);
            }
        }
        return new ResponceCard(this.respApdu.getSW(), key);
    }

    public ResponceCard deleteObject(String name) throws CardException {
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 48;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard getObjectCount() throws CardException {
        byte[] apdu = new byte[]{-128, 18, 34, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard getObjectName(short id) throws CardException {
        byte[] apdu = new byte[]{-128, 18, 33, 0, 2, (byte)(id >> 8), (byte)(id & 0xFF)};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard getStatus() throws CardException {
        byte[] apdu = new byte[]{-128, 21, 16, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard resetCard() throws CardException {
        byte[] apdu = new byte[]{-128, 21, 32, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard signature(String name, byte[] data) throws CardException {
        byte[] sign = new byte[64];
        byte[] apdu = new byte[name.length() + data.length + 7];
        apdu[0] = -128;
        apdu[1] = 20;
        apdu[2] = 16;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + data.length + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        System.arraycopy(data, 0, apdu, 7 + name.length(), data.length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() == 36864) {
            System.arraycopy(this.respApdu.getData(), 0, sign, 0, 32);
            apdu = new byte[]{-128, 17, 37, 0, 1, 0};
            this.capdu = new CommandAPDU(apdu);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                System.arraycopy(this.respApdu.getData(), 0, sign, 32, 32);
            }
        }
        return new ResponceCard(this.respApdu.getSW(), sign);
    }

    public ResponceCard getPublicKey(String name) throws CardException {
        byte[] key = new byte[64];
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 17;
        apdu[2] = 33;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() == 36864) {
            System.arraycopy(this.respApdu.getData(), 0, key, 0, 32);
            apdu[2] = 36;
            this.capdu = new CommandAPDU(apdu);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                System.arraycopy(this.respApdu.getData(), 0, key, 32, 32);
            }
        }
        return new ResponceCard(this.respApdu.getSW(), key);
    }

    public ResponceCard getKeyAlgID(String name) throws CardException {
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 17;
        apdu[2] = 35;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public boolean isObjectExists(String name, short type) throws CardException {
        boolean ret = false;
        byte[] apdu = new byte[name.length() + 9];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 68;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 4);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        apdu[name.length() + 7] = (byte)(type >> 8);
        apdu[name.length() + 8] = (byte)(type & 0xFF);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() == 36864) {
            ret = true;
        }
        return ret;
    }

    private ResponceCard copyCertToContainer(byte[] certBlob) throws CardException {
        byte[] apdu = new byte[]{-128, 18, 64, 0, 4, 0, 0, (byte)(certBlob.length >> 8), (byte)(certBlob.length >> 8 & 0xFF)};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() == 36864) {
            int part = 32;
            for (int curr = 0; curr < certBlob.length; curr += part) {
                if (curr + part > certBlob.length) {
                    part = certBlob.length - curr;
                }
                apdu = new byte[part + 7];
                apdu[0] = -128;
                apdu[1] = 18;
                apdu[2] = 64;
                apdu[3] = 0;
                apdu[4] = (byte)(part + 2);
                apdu[5] = (byte)(part >> 8);
                apdu[6] = (byte)(part & 0xFF);
                System.arraycopy(certBlob, curr, apdu, 7, part);
                this.capdu = new CommandAPDU(apdu);
                this.respApdu = this.ch.transmit(this.capdu);
                if (this.respApdu.getSW() == 36864) continue;
            }
        }
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard setCertificate(String name, byte[] certBlob) throws CardException {
        byte[] apdu;
        boolean crt = false;
        ResponceCard responceCard = this.copyCertToContainer(certBlob);
        if (responceCard.getRetCode() != 36864) {
            return responceCard;
        }
        for (int i = 0; i < 5; ++i) {
            apdu = new byte[]{-128, 18, 65, 0, 2, 0, 0};
            this.capdu = new CommandAPDU(apdu);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                short certSz = UtilCM.byteToShort(this.respApdu.getData(), 0, 1);
                if (certSz != certBlob.length) {
                    responceCard = this.copyCertToContainer(certBlob);
                    if (responceCard.getRetCode() == 36864) continue;
                    return responceCard;
                }
                apdu = new byte[]{-128, 18, 65, 0, 4, 0, 32, 0, 0};
                this.capdu = new CommandAPDU(apdu);
                this.respApdu = this.ch.transmit(this.capdu);
                if (this.respApdu.getSW() == 36864) {
                    byte[] dt = this.respApdu.getData();
                    for (int j = 0; j < dt.length; ++j) {
                        if (dt[j] == certBlob[j] || (responceCard = this.copyCertToContainer(certBlob)).getRetCode() == 36864) continue;
                        return responceCard;
                    }
                }
            }
            crt = true;
            break;
        }
        if (crt) {
            apdu = new byte[name.length() + 7];
            apdu[0] = -128;
            apdu[1] = 18;
            apdu[2] = 66;
            apdu[3] = 0;
            apdu[4] = (byte)(name.length() + 2);
            apdu[5] = (byte)(name.length() >> 8);
            apdu[6] = (byte)(name.length() & 0xFF);
            System.arraycopy(name.getBytes(), 0, apdu, 7, name.length());
            this.capdu = new CommandAPDU(apdu);
            this.respApdu = this.ch.transmit(this.capdu);
        }
        return new ResponceCard(this.respApdu.getSW());
    }

    private ResponceCard copyCertFromContainer(String name) throws CardException {
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 67;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard getCertificate(String name) throws CardException {
        int retryCount = 5;
        byte[] cert = null;
        byte[] apdu = null;
        ResponceCard responceCard = this.copyCertFromContainer(name);
        if (responceCard.getRetCode() == 36864) {
            apdu = new byte[]{-128, 18, 65, 0, 2, 0, 0};
            this.capdu = new CommandAPDU(apdu);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                int certSz = UtilCM.byteToShort(this.respApdu.getData(), 0, 1);
                int curr = 0;
                int part = 32;
                cert = new byte[certSz];
                apdu = new byte[9];
                apdu[0] = -128;
                apdu[1] = 18;
                apdu[2] = 65;
                apdu[3] = 0;
                apdu[4] = 4;
                while (curr < certSz) {
                    if (curr + part > certSz) {
                        part = certSz - curr;
                    }
                    apdu[5] = (byte)(part >> 8);
                    apdu[6] = (byte)(part & 0xFF);
                    apdu[7] = (byte)(curr >> 8);
                    apdu[8] = (byte)(curr & 0xFF);
                    this.capdu = new CommandAPDU(apdu);
                    this.respApdu = this.ch.transmit(this.capdu);
                    if (this.respApdu.getSW() != 36864) break;
                    byte[] nullArray = new byte[this.respApdu.getData().length];
                    if (Arrays.equals(this.respApdu.getData(), nullArray) && retryCount > 0) {
                        responceCard = this.copyCertFromContainer(name);
                        if (responceCard.getRetCode() == 36864) {
                            --retryCount;
                            continue;
                        }
                        throw new RuntimeException("Cannot copy certificate from container");
                    }
                    if (Arrays.equals(this.respApdu.getData(), nullArray) && retryCount == 0) {
                        throw new RuntimeException("Cannot get certificate");
                    }
                    System.arraycopy(this.respApdu.getData(), 0, cert, curr, part);
                    curr += part;
                }
            }
        }
        return new ResponceCard(this.respApdu.getSW(), cert == null ? this.respApdu.getData() : cert);
    }

    public ResponceCard verifySign(byte[] key, byte[] hash, byte[] sign, byte type) throws CardException {
        byte[] apdu = new byte[37];
        apdu[0] = -128;
        apdu[1] = 20;
        apdu[2] = 81;
        apdu[3] = 1;
        apdu[4] = 32;
        System.arraycopy(hash, 0, apdu, 5, 32);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            return new ResponceCard(this.respApdu.getSW());
        }
        apdu[3] = 2;
        System.arraycopy(sign, 0, apdu, 5, 32);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            return new ResponceCard(this.respApdu.getSW());
        }
        apdu[3] = 3;
        System.arraycopy(sign, 32, apdu, 5, 32);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            return new ResponceCard(this.respApdu.getSW());
        }
        apdu[3] = 4;
        System.arraycopy(key, 0, apdu, 5, 32);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            return new ResponceCard(this.respApdu.getSW());
        }
        apdu[3] = 5;
        System.arraycopy(key, 32, apdu, 5, 32);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            return new ResponceCard(this.respApdu.getSW());
        }
        apdu = new byte[]{-128, 20, 80, 0, 2, type, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard createHash() throws CardException {
        byte[] apdu = new byte[]{-128, 20, -127, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard updateHash(byte[] data) throws CardException {
        int i = 0;
        int sz = 0;
        while (i < data.length) {
            sz = data.length > i + 32 ? 32 : data.length - i;
            byte[] apdu = new byte[sz + 7];
            apdu[0] = -128;
            apdu[1] = 20;
            apdu[2] = -126;
            apdu[3] = 0;
            apdu[4] = (byte)(sz + 2);
            apdu[5] = (byte)(sz >> 8);
            apdu[6] = (byte)(sz & 0xFF);
            System.arraycopy(data, i, apdu, 7, sz);
            this.capdu = new CommandAPDU(apdu);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) continue;
        }
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard finalHash() throws CardException {
        byte[] apdu = new byte[]{-128, 20, -125, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }
}

