/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.idcard;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kz.gamma.crypto.pcsc.android.Card;
import kz.gamma.crypto.pcsc.android.CardChannel;
import kz.gamma.crypto.pcsc.android.CardTerminal;
import kz.gamma.crypto.pcsc.android.CommandAPDU;
import kz.gamma.crypto.pcsc.android.ResponseAPDU;
import kz.gamma.crypto.pcsc.android.TerminalFactory;

public class IdCard {
    private Map<String, CardChannel> cards = new TreeMap<String, CardChannel>();

    public IdCard() {
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            List<CardTerminal> cardTerminals = factory.terminals().listTerminals("");
            for (CardTerminal cardTerminal : cardTerminals) {
                CardTerminal terminal = cardTerminal;
                if (!terminal.isCardPresent()) continue;
                Card sc = terminal.connect("*");
                CardChannel cardChannel = sc.getBasicChannel();
                byte[] select = new byte[]{0, -92, 2, 12, 2, 3, 1};
                byte[] next = new byte[]{0, -64, 0, 0, 0};
                CommandAPDU capdu = new CommandAPDU(select);
                ResponseAPDU respApdu = cardChannel.transmit(capdu);
                if (respApdu.getSW() == 36864) {
                    this.cards.put(terminal.getName(), cardChannel);
                    continue;
                }
                if (respApdu.getSW1() == 97) {
                    capdu = new CommandAPDU(next);
                    respApdu = cardChannel.transmit(capdu);
                    if (respApdu.getSW() == 36864) {
                        this.cards.put(terminal.getName(), cardChannel);
                        continue;
                    }
                    System.err.println(terminal.getName() + " error: " + respApdu.getSW());
                    continue;
                }
                System.err.println(terminal.getName() + " error: " + respApdu.getSW());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map getCards() {
        return this.cards;
    }

    public void disconnect() {
    }
}

