/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.jacarta;

import java.util.List;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.pcsc.ResponceCard;
import kz.gamma.crypto.pcsc.android.Card;
import kz.gamma.crypto.pcsc.android.CardChannel;
import kz.gamma.crypto.pcsc.android.CardException;
import kz.gamma.crypto.pcsc.android.CardTerminal;
import kz.gamma.crypto.pcsc.android.CommandAPDU;
import kz.gamma.crypto.pcsc.android.ResponseAPDU;
import kz.gamma.crypto.pcsc.android.TerminalFactory;

public class TokenGammaJaCarta {
    private static final byte CLA = -128;
    private static final byte PIN_OPERATION = 16;
    private static final byte P1_PIN_Change = 32;
    private static final byte P1_PIN_Verify = 33;
    private static final byte P1_PIN_VerifyAdminPIN = 34;
    private static final byte P1_PIN_ChangeAdminPIN = 35;
    private static final byte P1_PIN_ResetPINCounter = 36;
    private static final byte KEY_OPERATION = 17;
    private static final byte P1_CreateKey = 32;
    private static final byte P1_ExportPubKey = 33;
    private static final byte P1_ExportKeyAlgID = 34;
    private static final byte P1_CreateRSAKey = 35;
    private static final byte OBJECT_OPERATION = 18;
    private static final byte P1_CreateObject = 32;
    private static final byte P1_ObjectNameById = 33;
    private static final byte P1_ObjectCount = 34;
    private static final byte P1_DeleteObject = 35;
    private static final byte P1_IsElementExists = 36;
    private static final byte P1_ExportRSAPubKey = 37;
    private static final byte P1_FormatToken = 38;
    private static final byte P1_InstallCertNew = 39;
    private static final byte P1_ReturnCertNew = 40;
    public static final byte P1_CreateAttrib = 41;
    public static final byte P1_ReadAttrib = 48;
    private static final byte CRYPTO_OPERATION = 20;
    private static final byte P1_Sign = 32;
    private static final byte P1_Verify = 33;
    private static final byte P1_MakeDH = 34;
    private static final byte P1_cryptRSA = 35;
    private static final byte P2_encryptRSA = 36;
    private static final byte P2_decryptRSA = 37;
    private static final byte P2_encryptRSASSL = 38;
    private static final byte P2_decryptRSASSL = 39;
    private static final byte P1_createGostHash = 40;
    private static final byte P1_updateGostHash = 41;
    private static final byte P1_finalGostHash = 48;
    public static final byte STATUS_OPERATION = 21;
    public static final byte P1_ResetStatus = 32;
    public static final byte P1_GetStatus = 33;
    public static final byte P1_GetError = 34;
    private ResponseAPDU respApdu = null;
    private CommandAPDU capdu = null;
    private Card sc = null;
    private CardChannel ch = null;
    private TerminalFactory factory = TerminalFactory.getDefault();
    private CardTerminal terminal = null;
    private String atr;

    public TokenGammaJaCarta(String reader) throws CardException {
        List<CardTerminal> terminals = this.factory.terminals().listTerminals(reader);
        this.terminal = terminals.get(0);
        this.sc = this.terminal.connect("T=1");
        this.atr = UtilCM.array2hex(this.sc.getATR().getBytes());
        this.ch = this.sc.getBasicChannel();
    }

    public ResponceCard selectApplet() throws CardException {
        byte[] selectApplet = new byte[]{0, -92, 4, 0, 12, -96, 0, 103, 97, 109, 109, 97, 116, 101, 99, 104, 0};
        this.capdu = new CommandAPDU(selectApplet);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard verifyPin(String pin) throws CardException {
        byte[] apdu = new byte[pin.length() + 5];
        apdu[0] = -128;
        apdu[1] = 16;
        apdu[2] = 33;
        apdu[3] = 0;
        apdu[4] = (byte)pin.length();
        System.arraycopy(pin.getBytes(), 0, apdu, 5, pin.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard changePin(String pinOld, String pinNew) throws CardException {
        byte[] apdu = new byte[pinOld.length() + pinNew.length() + 7];
        apdu[0] = -128;
        apdu[1] = 16;
        apdu[2] = 32;
        apdu[3] = 0;
        apdu[4] = (byte)(pinOld.length() + pinNew.length() + 2);
        apdu[5] = (byte)pinOld.length();
        apdu[6] = (byte)pinNew.length();
        System.arraycopy(pinOld.getBytes(), 0, apdu, 7, pinOld.getBytes().length);
        System.arraycopy(pinNew.getBytes(), 0, apdu, 7 + pinOld.length(), pinNew.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard createKey(String name, byte type) throws CardException {
        byte[] apdu = new byte[name.length() + 8];
        apdu[0] = -128;
        apdu[1] = 17;
        apdu[2] = 32;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 3);
        apdu[5] = type;
        apdu[6] = (byte)((short)name.length() >> 8);
        apdu[7] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 8, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard deleteObject(String name) throws CardException {
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 35;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard getObjectCount() throws CardException {
        byte[] apdu = new byte[]{-128, 18, 34, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard getObjectName(short id) throws CardException {
        byte[] apdu = new byte[]{-128, 18, 33, 0, 2, (byte)(id >> 8), (byte)(id & 0xFF)};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard getStatus() throws CardException {
        byte[] apdu = new byte[]{-128, 21, 33, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard resetCard() throws CardException {
        byte[] apdu = new byte[]{-128, 21, 32, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard signature(String name, byte[] data) throws CardException {
        byte[] apdu = new byte[name.length() + data.length + 7];
        apdu[0] = -128;
        apdu[1] = 20;
        apdu[2] = 32;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + data.length + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        System.arraycopy(data, 0, apdu, 7 + name.length(), data.length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard logData() throws CardException {
        byte[] apdu = new byte[]{-128, 21, 34, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard getPublicKey(String name) throws CardException {
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 17;
        apdu[2] = 33;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard getKeyAlgID(String name) throws CardException {
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 17;
        apdu[2] = 34;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public boolean isObjectExists(String name, short type) throws CardException {
        boolean ret = false;
        byte[] apdu = new byte[name.length() + 9];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 36;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 4);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        apdu[name.length() + 7] = (byte)(type >> 8);
        apdu[name.length() + 8] = (byte)(type & 0xFF);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() == 36864) {
            ret = true;
        }
        return ret;
    }

    public ResponceCard setCertificate(String name, byte[] certBlob) throws CardException {
        byte[] apdu = new byte[certBlob.length + 11 + name.length()];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 39;
        apdu[3] = 0;
        if (certBlob.length + name.length() + 4 > 256) {
            apdu[4] = 0;
            apdu[5] = (byte)((short)certBlob.length + 4 + name.length() >> 8);
            apdu[6] = (byte)((short)certBlob.length + 4 + name.length() & 0xFF);
            apdu[7] = (byte)((short)certBlob.length >> 8);
            apdu[8] = (byte)((short)certBlob.length & 0xFF);
            apdu[9] = (byte)((short)name.length() >> 8);
            apdu[10] = (byte)((short)name.length() & 0xFF);
            System.arraycopy(name.getBytes(), 0, apdu, 11, name.getBytes().length);
            System.arraycopy(certBlob, 0, apdu, 11 + name.length(), certBlob.length);
        } else {
            apdu[4] = (byte)(certBlob.length + name.length() + 4);
            apdu[5] = (byte)((short)certBlob.length >> 8);
            apdu[6] = (byte)((short)certBlob.length & 0xFF);
            apdu[7] = (byte)((short)name.length() >> 8);
            apdu[8] = (byte)((short)name.length() & 0xFF);
            System.arraycopy(name.getBytes(), 0, apdu, 9, name.getBytes().length);
            System.arraycopy(certBlob, 0, apdu, 9 + name.length(), certBlob.length);
        }
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard getCertificate(String name) throws CardException {
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 40;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard verifySign(byte[] key, byte[] hash, byte[] sign, byte type) throws CardException {
        byte[] apdu = new byte[key.length + hash.length + sign.length + 6];
        apdu[0] = -128;
        apdu[1] = 20;
        apdu[2] = 33;
        apdu[3] = 0;
        apdu[4] = (byte)(key.length + hash.length + sign.length + 1);
        apdu[5] = type;
        System.arraycopy(key, 0, apdu, 6, key.length);
        System.arraycopy(hash, 0, apdu, key.length + 6, hash.length);
        System.arraycopy(sign, 0, apdu, key.length + hash.length + 6, sign.length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard createHash() throws CardException {
        byte[] apdu = new byte[]{-128, 20, 40, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard updateHash(byte[] data) throws CardException {
        int maxBlockSize = 16384;
        if (data.length > maxBlockSize) {
            throw new RuntimeException("Max block size: " + maxBlockSize + " bytes");
        }
        byte[] apdu = data.length > 250 && data.length <= maxBlockSize ? new byte[data.length + 7] : new byte[data.length + 5];
        apdu[0] = -128;
        apdu[1] = 20;
        apdu[2] = 41;
        apdu[3] = 0;
        if (data.length > 250) {
            apdu[4] = 0;
            apdu[5] = (byte)((short)data.length >> 8);
            apdu[6] = (byte)((short)data.length & 0xFF);
            System.arraycopy(data, 0, apdu, 7, data.length);
        } else {
            apdu[4] = (byte)data.length;
            System.arraycopy(data, 0, apdu, 5, data.length);
        }
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard finalHash() throws CardException {
        byte[] apdu = new byte[]{-128, 20, 48, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard makeDH(String name, byte[] key, byte[] ukm) throws CardException {
        byte[] apdu = new byte[name.length() + key.length + ukm.length + 7];
        apdu[0] = -128;
        apdu[1] = 20;
        apdu[2] = 34;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + key.length + ukm.length + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        System.arraycopy(ukm, 0, apdu, name.length() + 7, ukm.length);
        System.arraycopy(key, 0, apdu, name.length() + 7 + ukm.length, key.length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard generateRSAKey(String name, short size, byte algID) throws CardException {
        byte[] apdu = new byte[name.length() + 10];
        apdu[0] = -128;
        apdu[1] = 17;
        apdu[2] = 35;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 5);
        apdu[5] = (byte)(size >> 8);
        apdu[6] = (byte)(size & 0xFF);
        apdu[7] = algID;
        apdu[8] = (byte)((short)name.length() >> 8);
        apdu[9] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 10, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard exportRSAKey(String name) throws CardException {
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 37;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard signRSA(String name, byte[] data) throws CardException {
        byte[] apdu = null;
        int indx = 0;
        apdu = data.length + name.length() + 9 >= 256 ? new byte[name.length() + data.length + 11] : new byte[name.length() + data.length + 9];
        apdu[indx] = -128;
        apdu[++indx] = 20;
        apdu[++indx] = 35;
        apdu[++indx] = 36;
        ++indx;
        if (data.length + name.length() + 9 < 256) {
            apdu[indx] = (byte)(name.length() + data.length + 4);
            ++indx;
        } else {
            apdu[indx] = 0;
            apdu[++indx] = (byte)((short)name.length() + data.length + 4 >> 8);
            apdu[++indx] = (byte)((short)name.length() + data.length + 4 & 0xFF);
            ++indx;
        }
        apdu[indx] = (byte)((short)name.length() >> 8);
        apdu[++indx] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, ++indx, name.getBytes().length);
        apdu[indx += name.length()] = (byte)((short)data.length >> 8);
        apdu[++indx] = (byte)((short)data.length & 0xFF);
        System.arraycopy(data, 0, apdu, ++indx, data.length);
        indx += data.length;
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard getError() throws CardException {
        byte[] apdu = new byte[]{-128, 21, 34, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard setAttribute(String name, byte[] attr) throws CardException {
        byte[] apdu = new byte[name.length() + attr.length + 9];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 41;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + attr.length + 4);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        apdu[(short)name.length() + 7] = (byte)((short)attr.length >> 8);
        apdu[(short)name.length() + 8] = (byte)((short)attr.length & 0xFF);
        System.arraycopy(attr, 0, apdu, name.length() + 9, attr.length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard getAttribute(String name) throws CardException {
        byte[] apdu = new byte[name.length() + 7];
        apdu[0] = -128;
        apdu[1] = 18;
        apdu[2] = 48;
        apdu[3] = 0;
        apdu[4] = (byte)(name.length() + 2);
        apdu[5] = (byte)((short)name.length() >> 8);
        apdu[6] = (byte)((short)name.length() & 0xFF);
        System.arraycopy(name.getBytes(), 0, apdu, 7, name.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard verifyAdminPin(String pin) throws CardException {
        byte[] apdu = new byte[pin.length() + 5];
        apdu[0] = -128;
        apdu[1] = 16;
        apdu[2] = 34;
        apdu[3] = 0;
        apdu[4] = (byte)pin.length();
        System.arraycopy(pin.getBytes(), 0, apdu, 5, pin.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard changeAdminPin(String pinOld, String pinNew) throws CardException {
        byte[] apdu = new byte[pinOld.length() + pinNew.length() + 7];
        apdu[0] = -128;
        apdu[1] = 16;
        apdu[2] = 35;
        apdu[3] = 0;
        apdu[4] = (byte)(pinOld.length() + pinNew.length() + 2);
        apdu[5] = (byte)pinOld.length();
        apdu[6] = (byte)pinNew.length();
        System.arraycopy(pinOld.getBytes(), 0, apdu, 7, pinOld.getBytes().length);
        System.arraycopy(pinNew.getBytes(), 0, apdu, 7 + pinOld.length(), pinNew.getBytes().length);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard resetPINCounter() throws CardException {
        byte[] apdu = new byte[]{-128, 16, 36, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard formatToken() throws CardException {
        byte[] apdu = new byte[]{-128, 18, 38, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public void disconnect() throws CardException {
    }
}

