/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.kztoken;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class KzTokenMapKeyFile {
    private byte[] header = new byte[]{1, 0, 0, 16};
    private LinkedHashMap<String, byte[]> elements = new LinkedHashMap();

    public KzTokenMapKeyFile() {
    }

    public KzTokenMapKeyFile(byte[] data) {
        this.addElements(data);
    }

    public byte getIdElement(String name) {
        byte ret = 0;
        if (this.isNameExists(name)) {
            ret = this.elements.get(name)[0];
        }
        return ret;
    }

    public int getElemetCount() {
        return this.elements.size();
    }

    public boolean isNameExists(String name) {
        return this.elements.containsKey(name);
    }

    public byte[] getElementsBuffer() {
        byte[] ret = null;
        LinkedHashMap<byte[], Integer> bytes = new LinkedHashMap<byte[], Integer>();
        Iterator<String> item = this.elements.keySet().iterator();
        bytes.put(this.header, this.header.length);
        int size = this.header.length;
        while (item.hasNext()) {
            byte[] nullTerm = new byte[]{0};
            String tmp = item.next();
            bytes.put(this.elements.get(tmp), 1);
            bytes.put(tmp.getBytes(), tmp.length());
            bytes.put(nullTerm, 1);
            size = size + 2 + tmp.length();
        }
        ret = new byte[size];
        int index = 0;
        for (Map.Entry entry : bytes.entrySet()) {
            System.arraycopy(entry.getKey(), 0, ret, index, (Integer)entry.getValue());
            index += ((Integer)entry.getValue()).intValue();
        }
        return ret;
    }

    public Byte getUniqueElement() {
        Byte ret = 1;
        Object[] ids = this.elements.values().toArray();
        for (int i = 1; i < 250; ++i) {
            boolean found = false;
            ret = (byte)i;
            for (int j = 0; j < ids.length; ++j) {
                if (((byte[])ids[j])[0] != ret) continue;
                found = true;
                break;
            }
            if (!found) break;
        }
        return ret;
    }

    public void addElements(byte[] data) {
        byte[] num = null;
        int ln = 4;
        this.elements.clear();
        while (ln < data.length) {
            num = new byte[]{data[ln]};
            String tmp = "";
            if (num[0] < 1) break;
            for (int i = ln + 1; i < data.length; ++i) {
                if (data[i] != 0) continue;
                tmp = new String(data, ln + 1, i - ln - 1);
                ln = i + 1;
                break;
            }
            if (tmp.isEmpty()) continue;
            this.elements.put(tmp, num);
        }
    }

    public void addElement(String name, Byte id) {
        byte[] el = new byte[]{id};
        this.elements.put(name, el);
    }

    public void delElement(String name) {
        this.elements.remove(name);
    }

    public Object[] getNamesElement() {
        return this.elements.keySet().toArray();
    }

    public void clear() {
        this.elements.clear();
    }
}

