/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.signers;

import kz.gamma.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gamma.core.GammaGOST3410PublicKey;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.CipherParameters;
import kz.gamma.crypto.DSA;
import kz.gamma.crypto.params.GammaParameters;
import kz.gamma.crypto.pcsc.ResponceCard;
import kz.gamma.crypto.pcsc.android.CardException;
import kz.gamma.crypto.pcsc.jacarta.TokenGammaJaCarta;
import kz.gamma.crypto.pcsc.kztoken.TokenKzToken;
import kz.gamma.crypto.pcsc.safenet.TokenSafeNet;
import kz.gamma.jce.exception.JCEHardwareException;
import kz.gamma.jce.provider.JCEECPrivateKey;
import kz.gamma.jce.provider.JCEHsmPkcs11PrivateKey;
import kz.gamma.jce.provider.JCEJaCartaPrivateKey;
import kz.gamma.jce.provider.JCEKAZTokenPrivateKey;
import kz.gamma.jce.provider.JCESafeNetPrivateKey;
import kz.gamma.jce.provider.ProviderAlgs;
import kz.gamma.pkcs11.jna.PKCS11Utils;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class ECGOST3410Signer
implements DSA {
    private static final boolean IS_DEBUG = false;
    private GammaParameters keyParam;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (param instanceof GammaParameters) {
            this.keyParam = (GammaParameters)param;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generateSignature(byte[] message) {
        byte[] rsign = null;
        Number hHash = 0;
        if (this.keyParam.getPrivKey() instanceof JCEECPrivateKey) {
            try {
                hHash = TumarCspFunctions.cpCreateHash(this.keyParam.getCSPHandle(), this.keyParam.gethashAlgID(), 0, 0);
                TumarCspFunctions.cpSetHashParam(this.keyParam.getCSPHandle(), hHash, 2, message, 0);
                rsign = TumarCspFunctions.cpSignHashData(this.keyParam.getCSPHandle(), hHash, this.keyParam.getCSPkeyType(), "", 0);
            }
            finally {
                if (hHash.longValue() != 0L) {
                    TumarCspFunctions.cpDestroyHash(this.keyParam.getCSPHandle(), hHash);
                }
            }
        } else {
            ResponceCard responceCard = null;
            byte[] rHash = message;
            if (this.keyParam.getPrivKey() instanceof JCEJaCartaPrivateKey) {
                JCEJaCartaPrivateKey privKeyJacarta = (JCEJaCartaPrivateKey)this.keyParam.getPrivKey();
                TokenGammaJaCarta tokenGammaJaCarta = privKeyJacarta.getToken();
                try {
                    responceCard = tokenGammaJaCarta.signature(privKeyJacarta.getName(), rHash);
                    if (responceCard.getRetCode() == 27904) {
                        responceCard = tokenGammaJaCarta.selectApplet();
                        if (responceCard.getRetCode() != 36864) {
                            throw new JCEHardwareException("Signature error applet not available");
                        }
                        responceCard = tokenGammaJaCarta.verifyPin(privKeyJacarta.getPassword());
                        if (responceCard.getRetCode() != 36864) {
                            throw new JCEHardwareException("Signature error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                        }
                        responceCard = tokenGammaJaCarta.signature(privKeyJacarta.getName(), rHash);
                    } else if (responceCard.getRetCode() == 25620) {
                        responceCard = tokenGammaJaCarta.verifyPin(privKeyJacarta.getPassword());
                        if (responceCard.getRetCode() != 36864) {
                            throw new JCEHardwareException("Signature error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                        }
                        responceCard = tokenGammaJaCarta.signature(privKeyJacarta.getName(), rHash);
                    }
                    if (responceCard.getRetCode() != 36864) {
                        throw new JCEHardwareException("Signature error [" + Integer.toString(responceCard.getRetCode()) + "]");
                    }
                    rsign = UtilCM.reverseParts(responceCard.getData(), 0);
                }
                catch (CardException e) {
                    throw new JCEHardwareException("Signature error " + e.getMessage());
                }
            } else if (this.keyParam.getPrivKey() instanceof JCESafeNetPrivateKey) {
                JCESafeNetPrivateKey privKeySafeNet = (JCESafeNetPrivateKey)this.keyParam.getPrivKey();
                TokenSafeNet tokenSafeNet = privKeySafeNet.getToken();
                try {
                    responceCard = tokenSafeNet.signature(privKeySafeNet.getName(), rHash);
                    if (responceCard.getRetCode() == 27904) {
                        responceCard = tokenSafeNet.selectAplet();
                        if (responceCard.getRetCode() != 36864) {
                            throw new JCEHardwareException("Signature error applet not available");
                        }
                        responceCard = tokenSafeNet.verifyPin(privKeySafeNet.getPassword());
                        if (responceCard.getRetCode() != 36864) {
                            throw new JCEHardwareException("Signature error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                        }
                        responceCard = tokenSafeNet.signature(privKeySafeNet.getName(), rHash);
                    } else if (responceCard.getRetCode() == 25620) {
                        responceCard = tokenSafeNet.verifyPin(privKeySafeNet.getPassword());
                        if (responceCard.getRetCode() != 36864) {
                            throw new JCEHardwareException("Signature error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                        }
                        responceCard = tokenSafeNet.signature(privKeySafeNet.getName(), rHash);
                    }
                    if (responceCard.getRetCode() != 36864) {
                        throw new JCEHardwareException("Signature error [" + Integer.toString(responceCard.getRetCode()) + "]");
                    }
                    rsign = responceCard.getData();
                }
                catch (CardException e) {
                    throw new JCEHardwareException("Signature error " + e.getMessage());
                }
            } else if (this.keyParam.getPrivKey() instanceof JCEKAZTokenPrivateKey) {
                JCEKAZTokenPrivateKey privKeyKazToken = (JCEKAZTokenPrivateKey)this.keyParam.getPrivKey();
                TokenKzToken tokenKzToken = privKeyKazToken.getToken();
                try {
                    responceCard = tokenKzToken.signature(privKeyKazToken.getIdKey(), rHash);
                    if (responceCard.getRetCode() == 25620) {
                        responceCard = tokenKzToken.verifyPin((byte)2, privKeyKazToken.getPassword());
                        if (responceCard.getRetCode() != 36864) {
                            throw new JCEHardwareException("Signature error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                        }
                        responceCard = tokenKzToken.signature(privKeyKazToken.getIdKey(), rHash);
                    }
                    if (responceCard.getRetCode() != 36864) {
                        throw new JCEHardwareException("Signature error [" + Integer.toString(responceCard.getRetCode()) + "]");
                    }
                    rsign = responceCard.getData();
                }
                catch (CardException e) {
                    throw new JCEHardwareException("Signature error " + e.getMessage());
                }
            } else if (this.keyParam.getPrivKey() instanceof JCEHsmPkcs11PrivateKey) {
                JCEHsmPkcs11PrivateKey privateKey = (JCEHsmPkcs11PrivateKey)this.keyParam.getPrivKey();
                try {
                    if (privateKey.isSynchronized()) {
                        Object tokenKzToken = privateKey.getSyncObject();
                        synchronized (tokenKzToken) {
                            rsign = PKCS11Utils.sign(privateKey.getSession(), privateKey.getPrivateKey(), message, privateKey.getMechanismId(), privateKey.getPublicKeyLen());
                        }
                    }
                    rsign = PKCS11Utils.sign(privateKey.getSession(), privateKey.getPrivateKey(), message, privateKey.getMechanismId(), privateKey.getPublicKeyLen());
                }
                catch (Exception e) {
                    throw new JCEHardwareException("Signature error " + e.getMessage());
                }
            } else {
                throw new JCEHardwareException("Unknown private key ");
            }
        }
        return rsign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifySignature(byte[] message, byte[] sign) {
        boolean retCode = false;
        Number hProvLocal = 0;
        Number hPubKey = 0;
        Number hHash = 0;
        try {
            hProvLocal = TumarCspFunctions.cpAcquireContext("", -268435456);
            byte[] publicKey = CryptoProObjectIdentifiers.gostR3410_12_512.getId().equals(this.keyParam.getPublicKeyAlg()) ? GammaGOST3410PublicKey.convertToGammaPublicKey(this.keyParam.getPublicKey(), ProviderAlgs.EC_512_1024_GOST_34_10_2012_A.alg) : this.keyParam.getPublicKey();
            hPubKey = TumarCspFunctions.cpImportKey(hProvLocal, publicKey, publicKey.length, 0, 0);
            hHash = TumarCspFunctions.cpCreateHash(hProvLocal, this.keyParam.gethashAlgID(), 0, 0);
            TumarCspFunctions.cpSetHashParam(hProvLocal, hHash, 2, message, 0);
            int res = TumarCspFunctions.cpVerifySignature(hProvLocal, hHash, sign, sign.length, hPubKey, "", 0);
            if (res != 0) {
                retCode = true;
            }
        }
        catch (Exception e) {
            retCode = false;
        }
        finally {
            if (hPubKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hProvLocal, hPubKey);
            }
            if (hHash.longValue() != 0L) {
                TumarCspFunctions.cpDestroyHash(hProvLocal, hHash);
            }
            if (hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
            }
        }
        return retCode;
    }
}

