/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.dvcs;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.DEREnumerated;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERPrintableString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cms.Attribute;
import kz.gamma.asn1.cms.AttributeTable;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.DigestInfo;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.cms.CMSProcessableByteArray;
import kz.gamma.cms.CMSSignedData;
import kz.gamma.cms.CMSSignedDataGenerator;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.dvcs.SrvType;
import kz.gamma.jce.provider.GammaTechProvider;

public class DvcsHelper {
    private static DvcsHelper instance;
    public static final int DATA_STRUCTURE_MESSAGE_INFO = 0;
    public static final int DATA_STUCTURE_OCTET_STRING = 1;

    private DvcsHelper() {
    }

    public static DvcsHelper getInstance() {
        if (instance == null) {
            instance = new DvcsHelper();
        }
        return instance;
    }

    public byte[] createDvcsRequestBody(String registeredID, String requestPolicy, byte[] cms, AlgorithmIdentifier hashAlgId, byte[] hash, byte[] transactionId) {
        if (transactionId.length > 4) {
            throw new IllegalArgumentException("Max size of transactionId is 4");
        }
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        ASN1EncodableVector secondVector = new ASN1EncodableVector();
        secondVector.add(new DEREnumerated(SrvType.VSD.getNumber()));
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        secondVector.add(new DERInteger(nonce.intValue()));
        secondVector.add(new DERGeneralizedTime(new Date()));
        if (registeredID != null && registeredID.trim().length() > 0) {
            DERObjectIdentifier objectIdentifier = new DERObjectIdentifier(registeredID);
            DERTaggedObject taggedObjectDn = new DERTaggedObject(false, 8, objectIdentifier.getDERObject());
            secondVector.add(new DERTaggedObject(true, 0, taggedObjectDn));
        }
        if (requestPolicy != null && requestPolicy.trim().length() > 0) {
            secondVector.add(new DERTaggedObject(true, 1, new DERObjectIdentifier(requestPolicy)));
        }
        rootVector.add(new DERSequence(secondVector));
        ASN1EncodableVector messageInfoVector = new ASN1EncodableVector();
        messageInfoVector.add(new DEROctetString(cms));
        DigestInfo digestInfo = new DigestInfo(hashAlgId, hash);
        DERSet digestInfos = new DERSet(digestInfo);
        messageInfoVector.add(digestInfos);
        DERTaggedObject taggedObject = new DERTaggedObject(false, 1, new DERSequence(messageInfoVector));
        rootVector.add(taggedObject);
        ASN1EncodableVector fourthVector = new ASN1EncodableVector();
        DERTaggedObject taggedObjectTid = new DERTaggedObject(true, 0, new DERInteger(transactionId));
        fourthVector.add(new DERObjectIdentifier("1.2.643.2.21.1.1.2.1.3.2"));
        fourthVector.add(taggedObjectTid);
        DERTaggedObject taggedObjectTidOid = new DERTaggedObject(false, 0, new DERSequence(fourthVector));
        rootVector.add(taggedObjectTidOid);
        return new DERSequence(rootVector).getDEREncoded();
    }

    public byte[] createDvcsRequestBody(String registeredID, String requestPolicy, byte[] cms, AlgorithmIdentifier hashAlgId, byte[] hash, byte[] transactionId, int requestDataType) {
        if (transactionId.length > 4) {
            throw new IllegalArgumentException("Max size of transactionId is 4");
        }
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        ASN1EncodableVector secondVector = new ASN1EncodableVector();
        secondVector.add(new DEREnumerated(SrvType.VSD.getNumber()));
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        secondVector.add(new DERInteger(nonce.intValue()));
        secondVector.add(new DERGeneralizedTime(new Date()));
        if (registeredID != null && registeredID.trim().length() > 0) {
            DERObjectIdentifier objectIdentifier = new DERObjectIdentifier(registeredID);
            DERTaggedObject taggedObjectDn = new DERTaggedObject(false, 8, objectIdentifier.getDERObject());
            secondVector.add(new DERTaggedObject(true, 0, taggedObjectDn));
        }
        if (requestPolicy != null && requestPolicy.trim().length() > 0) {
            secondVector.add(new DERTaggedObject(true, 1, new DERObjectIdentifier(requestPolicy)));
        }
        rootVector.add(new DERSequence(secondVector));
        if (requestDataType == 0) {
            ASN1EncodableVector messageInfoVector = new ASN1EncodableVector();
            messageInfoVector.add(new DEROctetString(cms));
            DigestInfo digestInfo = new DigestInfo(hashAlgId, hash);
            DERSet digestInfos = new DERSet(digestInfo);
            messageInfoVector.add(digestInfos);
            DERTaggedObject taggedObject = new DERTaggedObject(false, 1, new DERSequence(messageInfoVector));
            rootVector.add(taggedObject);
        } else if (requestDataType == 1) {
            rootVector.add(new DEROctetString(cms));
        } else {
            throw new RuntimeException("Unsupported type of DVCSRequest::data");
        }
        ASN1EncodableVector fourthVector = new ASN1EncodableVector();
        DERTaggedObject taggedObjectTid = new DERTaggedObject(true, 0, new DERInteger(transactionId));
        fourthVector.add(new DERObjectIdentifier("1.2.643.2.21.1.1.2.1.3.2"));
        fourthVector.add(taggedObjectTid);
        DERTaggedObject taggedObjectTidOid = new DERTaggedObject(false, 0, new DERSequence(fourthVector));
        rootVector.add(taggedObjectTidOid);
        return new DERSequence(rootVector).getDEREncoded();
    }

    public byte[] signDvcsRequestBody(PrivateKey privateKey, X509Certificate signerCertificate, byte[] data, String digestName, String digestOID) {
        try {
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            ASN1EncodableVector attr = new ASN1EncodableVector();
            MessageDigest messageDigest = MessageDigest.getInstance(digestName);
            messageDigest.reset();
            byte[] hash = messageDigest.digest(data);
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.3"), new DERSet(new DERObjectIdentifier("1.2.840.113549.1.9.16.1.7"))));
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.5"), new DERSet(new DERGeneralizedTime(new Date()))));
            X509Name x509name = new X509Name(true, signerCertificate.getSubjectDN().getName());
            String descStr = x509name.toString();
            byte[] descr = new byte[descStr.length() + 1];
            System.arraycopy(descStr.getBytes(), 0, descr, 0, descStr.length());
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.13"), new DERSet(new DERPrintableString(descr))));
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.4"), new DERSet(new DEROctetString(hash))));
            AttributeTable attributeTable = new AttributeTable(attr);
            gen.addSigner(privateKey, signerCertificate, digestOID, attributeTable, null);
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            list.add(signerCertificate);
            CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(list), GammaTechProvider.PROVIDER_NAME);
            gen.addCertificatesAndCRLs(store);
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            CMSSignedData signedData = gen.generate("1.2.840.113549.1.9.16.1.7", content, true, GammaTechProvider.PROVIDER_NAME, false);
            return signedData.getEncoded();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeCryptoException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c \u0442\u0435\u043b\u043e DVCS \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
    }
}

