/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.dvcs;

import java.io.FilterInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERBitString;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREnumerated;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.DERUTF8String;
import kz.gamma.asn1.cmp.PKIFailureInfo;
import kz.gamma.asn1.dvcs.DVCSRequestInformation;
import kz.gamma.asn1.x509.GeneralName;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.dvcs.DvcsInfo;

public class DvcsParser {
    public Map parseRequest(byte[] request) {
        ASN1InputStream in = null;
        FilterInputStream dVCSRequestDataStream = null;
        HashMap<String, String> resultMap = null;
        try {
            in = new ASN1InputStream(request);
            resultMap = new HashMap<String, String>();
            DERSequence asnBody = (DERSequence)in.readObject();
            Enumeration objects = asnBody.getObjects();
            while (objects.hasMoreElements()) {
                DERSequence sequence1;
                DERObjectIdentifier objectIdentifier1;
                DERTaggedObject taggedObject1;
                Object element = objects.nextElement();
                if (!(element instanceof DERTaggedObject) || (taggedObject1 = (DERTaggedObject)element).getTagNo() != 0 || !(objectIdentifier1 = (DERObjectIdentifier)(sequence1 = (DERSequence)((DERSequence)taggedObject1.getObjectParser(2, true)).getObjectAt(2)).getObjectAt(0)).getId().equals("1.2.840.113549.1.9.16.1.7")) continue;
                DERTaggedObject taggedObject2 = (DERTaggedObject)sequence1.getObjectAt(1);
                byte[] dVCSRequestData = ((DEROctetString)taggedObject2.getObject()).getOctets();
                dVCSRequestDataStream = new ASN1InputStream(dVCSRequestData);
                DERSequence dVCSRequestDataSequence = (DERSequence)((ASN1InputStream)dVCSRequestDataStream).readObject();
                DERSequence dvcsReqInfo = (DERSequence)dVCSRequestDataSequence.getObjectAt(0);
                DVCSRequestInformation dvcsRequestInformation = DVCSRequestInformation.getInstance(dvcsReqInfo);
                resultMap.put("service", dvcsRequestInformation.getService().getValue().toString());
                if (dvcsRequestInformation.getNonce() != null) {
                    resultMap.put("nonce", dvcsRequestInformation.getNonce().toString(10));
                }
                if (dVCSRequestDataSequence.size() <= 2) continue;
                DERTaggedObject taggedObject = (DERTaggedObject)dVCSRequestDataSequence.getObjectAt(2);
                GeneralName transactionIdentifier = GeneralName.getInstance(taggedObject);
                if (transactionIdentifier.getTagNo() != 0) {
                    throw new RuntimeException("Illegal transaction identifier");
                }
                DERSequence sequence = (DERSequence)transactionIdentifier.getName();
                DERTaggedObject taggedObject3 = (DERTaggedObject)sequence.getObjectAt(1);
                DERInteger integer = (DERInteger)taggedObject3.getObject();
                resultMap.put("transactionIdentifier", integer.getPositiveValue().toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeCryptoException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u0430\u0440\u0441\u0438\u043d\u0433 DVCS-\u0437\u0430\u043f\u0440\u043e\u0441\u0430 (" + e.getMessage() + ")");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dVCSRequestDataStream != null) {
                try {
                    dVCSRequestDataStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return resultMap;
    }

    public Map parseResponse(byte[] response) {
        FilterInputStream in = null;
        HashMap<String, Object> resultMap = null;
        try {
            resultMap = new HashMap<String, Object>();
            in = new ASN1InputStream(response);
            DERSequence asnBody = (DERSequence)((ASN1InputStream)in).readObject();
            Enumeration data = asnBody.getObjects();
            while (data.hasMoreElements()) {
                DERInteger integer1;
                DERSequence sequence1;
                DERObjectIdentifier objectIdentifier;
                DERTaggedObject taggedObject1;
                Object element = data.nextElement();
                if (!(element instanceof DERTaggedObject) || (taggedObject1 = (DERTaggedObject)element).getTagNo() != 0 || !(objectIdentifier = (DERObjectIdentifier)(sequence1 = (DERSequence)((DERSequence)taggedObject1.getObjectParser(2, true)).getObjectAt(2)).getObjectAt(0)).getId().equals("1.2.840.113549.1.9.16.1.8")) continue;
                DERTaggedObject taggedObject2 = (DERTaggedObject)sequence1.getObjectAt(1);
                byte[] dvcsRespInfoBytes = ((DEROctetString)taggedObject2.getObject()).getOctets();
                ASN1InputStream dvcsRespInfoStream = new ASN1InputStream(dvcsRespInfoBytes);
                DERObject element2 = dvcsRespInfoStream.readObject();
                if (element2 instanceof DERSequence) {
                    DERSequence dvcsRespInfo = (DERSequence)element2;
                    DERSequence sequence2 = (DERSequence)dvcsRespInfo.getObjectAt(0);
                    DEREnumerated enumerated = (DEREnumerated)sequence2.getObjectAt(0);
                    int serviceInt = enumerated.getValue().intValue();
                    String service = DvcsInfo.serviceCodeToName(serviceInt);
                    resultMap.put("dVCSResponseData", "dvCertInfo");
                    resultMap.put("service", service);
                    integer1 = (DERInteger)dvcsRespInfo.getObjectAt(2);
                    String serialNumber = String.valueOf(integer1.getValue().longValue());
                    resultMap.put("serialNumber", serialNumber);
                    DEREncodable encodable1 = dvcsRespInfo.getObjectAt(3);
                    if (encodable1 instanceof DERGeneralizedTime) {
                        DERGeneralizedTime generalizedTime1 = (DERGeneralizedTime)dvcsRespInfo.getObjectAt(3);
                        SimpleDateFormat sdfFull = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
                        String responseTime = sdfFull.format(generalizedTime1.getDate());
                        resultMap.put("responseTime", responseTime);
                    } else {
                        resultMap.put("responseTime", "unknown");
                    }
                    DERTaggedObject taggedObject3 = (DERTaggedObject)dvcsRespInfo.getObjectAt(4);
                    DERSequence sequence3 = (DERSequence)taggedObject3.getObject();
                    Enumeration objects = sequence3.getObjects();
                    while (objects.hasMoreElements()) {
                        Object object = objects.nextElement();
                        if (object instanceof DERInteger) {
                            DERInteger integer2 = (DERInteger)object;
                            String status = DvcsInfo.codeToStatus(integer2.getValue().intValue());
                            resultMap.put("status", status);
                            continue;
                        }
                        if (object instanceof DERSequence) {
                            DERSequence sequence4 = (DERSequence)object;
                            DERUTF8String utf8string = (DERUTF8String)sequence4.getObjectAt(0);
                            String statusString = utf8string.getString();
                            resultMap.put("statusString", statusString);
                            continue;
                        }
                        if (!(object instanceof DERBitString)) continue;
                        DERBitString bitString = (DERBitString)object;
                        PKIFailureInfo failInfo = new PKIFailureInfo(bitString);
                        resultMap.put("failInfo", failInfo.intValue());
                    }
                    continue;
                }
                if (!(element2 instanceof DERTaggedObject)) continue;
                DERTaggedObject taggedObject4 = (DERTaggedObject)element2;
                DERSequence sequence5 = (DERSequence)taggedObject4.getObject();
                if (!taggedObject4.isExplicit()) {
                    if (sequence5.size() == 2) {
                        DERTaggedObject taggedObject5 = (DERTaggedObject)sequence5.getObjectAt(1);
                        DERSequence sequence8 = (DERSequence)taggedObject5.getObject();
                        DERTaggedObject taggedObject6 = (DERTaggedObject)sequence8.getObjectAt(1);
                        integer1 = (DERInteger)taggedObject6.getObject();
                        String transactionIdentifier = integer1.getPositiveValue().toString();
                        resultMap.put("transactionIdentifier", transactionIdentifier);
                    } else {
                        resultMap.put("transactionIdentifier", "");
                    }
                    sequence5 = (DERSequence)sequence5.getObjectAt(0);
                } else {
                    resultMap.put("transactionIdentifier", "");
                }
                Enumeration objects = sequence5.getObjects();
                while (objects.hasMoreElements()) {
                    Object object = objects.nextElement();
                    if (object instanceof DERInteger) {
                        DERInteger integer3 = (DERInteger)object;
                        String status = DvcsInfo.codeToStatus(integer3.getValue().intValue());
                        resultMap.put("dVCSResponseData", "dvErrorNote");
                        resultMap.put("status", status);
                        continue;
                    }
                    if (object instanceof DERSequence) {
                        DERSequence sequence7 = (DERSequence)object;
                        DERUTF8String utf8string2 = (DERUTF8String)sequence7.getObjectAt(0);
                        String statusString = utf8string2.getString();
                        resultMap.put("statusString", statusString);
                        continue;
                    }
                    if (!(object instanceof DERBitString)) continue;
                    DERBitString bitString = (DERBitString)object;
                    PKIFailureInfo failInfo = new PKIFailureInfo(bitString);
                    resultMap.put("failInfo", failInfo.intValue());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeCryptoException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u0430\u0440\u0441\u0438\u043d\u0433 DVCS-\u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438 (" + e.getMessage() + ")");
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeCryptoException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u0430\u0440\u0441\u0438\u043d\u0433 DVCS-\u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438 (" + e.getMessage() + ")");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return resultMap;
    }
}

