/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.dvcs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.crypto.RuntimeCryptoException;

public class PkcsParser {
    public List<byte[]> getCertificates(byte[] pkcs7) {
        ASN1InputStream in = null;
        ArrayList<byte[]> list = null;
        try {
            in = new ASN1InputStream(pkcs7);
            DERSequence asnBody = (DERSequence)in.readObject();
            Enumeration data = asnBody.getObjects();
            while (data.hasMoreElements()) {
                DEREncodable derEncodableCerts;
                DERTaggedObject taggedObject1;
                Object element = data.nextElement();
                if (!(element instanceof DERTaggedObject) || (taggedObject1 = (DERTaggedObject)element).getTagNo() != 0 || ((DERSequence)taggedObject1.getObject()).size() <= 3 || !((derEncodableCerts = ((DERSequence)taggedObject1.getObject()).getObjectAt(3)) instanceof DERTaggedObject)) continue;
                DERTaggedObject derTaggedObjectCerts = (DERTaggedObject)derEncodableCerts;
                DERSequence certs = (DERSequence)derTaggedObjectCerts.getObject();
                list = new ArrayList<byte[]>();
                if (certs.size() <= 0) continue;
                if (!derTaggedObjectCerts.isExplicit()) {
                    for (int i = 0; i < certs.size(); ++i) {
                        list.add(certs.getObjectAt(i).getDERObject().getDEREncoded());
                    }
                    continue;
                }
                list.add(certs.getDEREncoded());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeCryptoException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u0432\u043b\u0435\u0447\u044c \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u044b \u0438\u0437 PKCS#7 (" + e.getMessage() + ")");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }
}

