/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.gdms;

import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.core.UtilCM;
import kz.gamma.core.file.FileHelper;
import kz.gamma.core.network.RequestSender;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.tumarcsp.CertificateFieldsResolver;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.x509.X509InstanceGetter;

public class GdmsKeysProducer {
    private FileHelper fileHelper = new FileHelper();
    private String directoryPath = null;
    private String country = null;
    private String organization = null;
    private String commonName = null;
    private String caCertificatePath = null;
    private String caUrl = null;
    private String raProfile = null;
    private byte[] caCertificateAsBytes = null;
    private X509Certificate caCertificate = null;
    private X509Name caSubject = null;
    private X509Name userSubject = null;
    private X509InstanceGetter instanceGetter = new X509InstanceGetter();
    private List<byte[]> issuedCertificates = null;

    private void init(String[] args) {
        GammaTechProvider gammaTechProvider = new GammaTechProvider();
        Security.addProvider(gammaTechProvider);
        if (args.length < 7) {
            throw new IllegalArgumentException("Arguments count must be equals 7");
        }
        this.directoryPath = args[0];
        this.country = args[1];
        this.organization = args[2];
        this.commonName = args[3];
        this.caCertificatePath = args[4];
        this.caUrl = args[5];
        this.raProfile = ProfileParams.getProfileName(args[6], true);
        try {
            String[] fileNames;
            for (String fileName : fileNames = new String[]{this.directoryPath + "/MGD00001.bin", this.directoryPath + "/CA", this.directoryPath + "/LOCAL", this.directoryPath + "/MY", this.directoryPath + "/ROOT"}) {
                if (!this.fileHelper.isFileExists(fileName).booleanValue() || this.fileHelper.deleteData(fileName)) continue;
                throw new Exception("Cannot delete file or directory \"" + fileName + "\"");
            }
            this.caCertificateAsBytes = this.fileHelper.loadData(this.caCertificatePath);
            this.caCertificate = this.instanceGetter.getX509CertificateInstance(this.caCertificateAsBytes);
            this.caSubject = new X509Name(true, this.caCertificate.getSubjectDN().getName());
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("File system initialization was failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> createPkcs10Requests() {
        Number hProv = 0;
        Number hExchKey = 0;
        Number hSignKey = 0;
        try {
            TumarCspFunctions.cpSetProvParam(0, 61, null, 0);
            hProv = TumarCspFunctions.cpAcquireContext("", -268435456);
            String url = TumarCspFunctions.cpCreateUrl("MGD00001", "file", "MGD00001", "", this.directoryPath, "bin", 43571, 43571, hProv);
            if (hProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProv, 0);
            }
            hProv = TumarCspFunctions.cpAcquireContext(url, 0x2000008);
            hExchKey = TumarCspFunctions.cpGetUserKey(hProv, 1);
            hSignKey = TumarCspFunctions.cpGetUserKey(hProv, 2);
            this.userSubject = this.formDn(this.country, this.organization, this.commonName);
            byte[] dnBytes = null;
            try {
                dnBytes = this.userSubject.getEncoded();
            }
            catch (IOException e) {
                throw new RuntimeCryptoException("Cannot get user DN in ASN format");
            }
            ArrayList<byte[]> pkcs10List = new ArrayList<byte[]>();
            byte[] request = TumarCspFunctions.cpExportKeyData(hProv, hExchKey, dnBytes, 51, 131072);
            if (request == null) {
                throw new RuntimeCryptoException("Cannot create PKCS#10 for exchange key");
            }
            pkcs10List.add(request);
            request = TumarCspFunctions.cpExportKeyData(hProv, hSignKey, dnBytes, 51, 131072);
            if (request == null) {
                throw new RuntimeCryptoException("Cannot create PKCS#10 for sign key");
            }
            pkcs10List.add(request);
            ArrayList<byte[]> arrayList = pkcs10List;
            return arrayList;
        }
        finally {
            if (hExchKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hProv, hExchKey);
            }
            if (hSignKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hProv, hSignKey);
            }
            if (hProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProv, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> createPkcs7Requests(List<byte[]> pkcs10Requests) {
        Number hProv = 0;
        Number hSignKey = 0;
        Number hHash = 0;
        try {
            TumarCspFunctions.cpSetProvParam(0, 61, null, 0);
            hProv = TumarCspFunctions.cpAcquireContext(this.raProfile, 64);
            hSignKey = TumarCspFunctions.cpGetUserKey(hProv, 2);
            byte[] raSignCert = TumarCspFunctions.cpGetKeyParamData(hProv, hSignKey, 26, 0);
            ArrayList<byte[]> pkcs7List = new ArrayList<byte[]>();
            byte[] request = null;
            for (int i = 0; i < pkcs10Requests.size(); ++i) {
                hHash = TumarCspFunctions.cpCreateHash(hProv, 32797, 0, 0);
                TumarCspFunctions.cpHashData(hProv, hHash, pkcs10Requests.get(i), pkcs10Requests.get(i).length, 0);
                TumarCspFunctions.cpSetHashParam(hProv, hHash, 35, raSignCert, 0);
                TumarCspFunctions.cpSetHashParam(hProv, hHash, 28, UtilCM.intToByte(pkcs10Requests.get(i).length, LibraryWrapper.SUN_CPU_ENDIAN), 0);
                TumarCspFunctions.cpSetHashParam(hProv, hHash, 29, pkcs10Requests.get(i), 0);
                request = TumarCspFunctions.cpSignHashData(hProv, hHash, 2, null, 524288);
                if (request == null) {
                    if (i == 0) {
                        throw new RuntimeCryptoException("Cannot create PKCS#7 for exchange key");
                    }
                    throw new RuntimeCryptoException("Cannot create PKCS#7 for sign key");
                }
                pkcs7List.add(request);
                if (hHash.longValue() == 0L) continue;
                TumarCspFunctions.cpDestroyHash(hProv, hHash);
                hHash = 0;
            }
            ArrayList<byte[]> arrayList = pkcs7List;
            return arrayList;
        }
        finally {
            if (hHash.longValue() != 0L) {
                TumarCspFunctions.cpDestroyHash(hProv, hHash);
            }
            if (hSignKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hProv, hSignKey);
            }
            if (hProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProv, 0);
            }
        }
    }

    private List<byte[]> sendRequests(List<byte[]> pkcs7Requests) {
        ArrayList<byte[]> certificateList = new ArrayList<byte[]>();
        for (int i = 0; i < pkcs7Requests.size(); ++i) {
            byte[] response = RequestSender.sendRequest(this.caUrl, pkcs7Requests.get(i));
            if (response == null) {
                if (i == 0) {
                    throw new RuntimeCryptoException("Cannot get server response for exchange key");
                }
                throw new RuntimeCryptoException("Cannot get server response for sign key");
            }
            try {
                ASN1InputStream in = new ASN1InputStream(response);
                DERSequence asnBody = (DERSequence)in.readObject();
                Enumeration objects = asnBody.getObjects();
                while (objects.hasMoreElements()) {
                    Object element = objects.nextElement();
                    if (!(element instanceof DERTaggedObject)) continue;
                    DERTaggedObject taggedObject = (DERTaggedObject)element;
                    DERTaggedObject taggedObject2 = (DERTaggedObject)DERSequence.getInstance(taggedObject, true).getObjectAt(3);
                    DERSequence certificate = (DERSequence)DERSequence.getInstance(taggedObject2, true);
                    certificateList.add(certificate.getDEREncoded());
                }
                continue;
            }
            catch (IOException e) {
                throw new RuntimeCryptoException("Cannot read server response");
            }
        }
        return certificateList;
    }

    private ASN1EncodableVector createCommon(String cn) {
        DERGeneralizedTime time = new DERGeneralizedTime(new Date());
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        ASN1EncodableVector cnSequence = new ASN1EncodableVector();
        DEROctetString cnDescription = new DEROctetString("cn".getBytes());
        cnSequence.add(cnDescription);
        DERSet cnSet = new DERSet(new DEROctetString(cn.getBytes()));
        cnSequence.add(cnSet);
        rootVector.add(new DERSequence(cnSequence));
        ASN1EncodableVector timeCreateSequence = new ASN1EncodableVector();
        DEROctetString timeCreateDescription = new DEROctetString("timeCreate".getBytes());
        timeCreateSequence.add(timeCreateDescription);
        DERSet timeCreateSet = new DERSet(new DEROctetString(time.getTimeString().getBytes()));
        timeCreateSequence.add(timeCreateSet);
        rootVector.add(new DERSequence(timeCreateSequence));
        ASN1EncodableVector timeModifySequence = new ASN1EncodableVector();
        DEROctetString timeModifyDescription = new DEROctetString("timeModify".getBytes());
        timeModifySequence.add(timeModifyDescription);
        DERSet timeModifySet = new DERSet(new DEROctetString(time.getTimeString().getBytes()));
        timeModifySequence.add(timeModifySet);
        rootVector.add(new DERSequence(timeModifySequence));
        return rootVector;
    }

    private void createFirstNodes() {
        ASN1EncodableVector rootVector = this.createCommon("");
        ASN1EncodableVector ownerSequence = new ASN1EncodableVector();
        DEROctetString ownerDescription = new DEROctetString("owner".getBytes());
        ownerSequence.add(ownerDescription);
        DERSet ownerSet = new DERSet(new DEROctetString(this.userSubject.toString().getBytes()));
        ownerSequence.add(ownerSet);
        rootVector.add(new DERSequence(ownerSequence));
        byte[] resultBytes = new DERSequence(rootVector).getDEREncoded();
        this.fileHelper.saveData(resultBytes, this.directoryPath + "/CA/CA");
        this.fileHelper.saveData(resultBytes, this.directoryPath + "/MY/MY");
        this.fileHelper.saveData(resultBytes, this.directoryPath + "/ROOT/ROOT");
    }

    private void createSecondNodes() {
        ASN1EncodableVector rootVector = this.createCommon(this.country);
        byte[] resultBytes = new DERSequence(rootVector).getDEREncoded();
        this.fileHelper.saveData(resultBytes, this.directoryPath + "/MY/MY." + this.country);
        rootVector = this.createCommon(this.caSubject.getValues(X509Name.C).firstElement().toString());
        resultBytes = new DERSequence(rootVector).getDEREncoded();
        this.fileHelper.saveData(resultBytes, this.directoryPath + "/ROOT/ROOT." + this.caSubject.getValues(X509Name.C).firstElement().toString());
    }

    private void createThirdNodes() {
        ASN1EncodableVector rootVector = this.createCommon(this.organization);
        byte[] resultBytes = new DERSequence(rootVector).getDEREncoded();
        this.fileHelper.saveData(resultBytes, this.directoryPath + "/MY/MY." + this.country + "." + this.organization);
        rootVector = this.createCommon(this.caSubject.getValues(X509Name.O).firstElement().toString());
        resultBytes = new DERSequence(rootVector).getDEREncoded();
        this.fileHelper.saveData(resultBytes, this.directoryPath + "/ROOT/ROOT." + this.caSubject.getValues(X509Name.C).firstElement().toString() + "." + this.caSubject.getValues(X509Name.O).firstElement().toString());
    }

    private void createFourthNodes(List<byte[]> certificates) {
        byte[] resultBytes = this.createFourthMyNode(this.country, certificates);
        this.fileHelper.saveData(resultBytes, this.directoryPath + "/MY/MY." + this.country + "." + this.organization + "." + this.commonName);
        resultBytes = this.createFourthRootNode();
        this.fileHelper.saveData(resultBytes, this.directoryPath + "/ROOT/ROOT." + this.caSubject.getValues(X509Name.C).firstElement().toString() + "." + this.caSubject.getValues(X509Name.O).firstElement().toString() + "." + this.caSubject.getValues(X509Name.CN).firstElement().toString());
    }

    private byte[] createFourthMyNode(String cn, List<byte[]> certificates) {
        X509Certificate userExchX509cert = null;
        X509Certificate userSignX509cert = null;
        try {
            X509InstanceGetter x509InstanceGetter = new X509InstanceGetter();
            userExchX509cert = x509InstanceGetter.getX509CertificateInstance(certificates.get(0));
            userSignX509cert = x509InstanceGetter.getX509CertificateInstance(certificates.get(1));
        }
        catch (CertificateException e) {
            throw new RuntimeException("Error load certificate", e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Error load certificate. Provider not found", e);
        }
        ASN1EncodableVector rootVector = this.createCommon(cn);
        ASN1EncodableVector certificateSequence = new ASN1EncodableVector();
        DEROctetString certificateDescription = new DEROctetString("userCertificate".getBytes());
        certificateSequence.add(certificateDescription);
        ArrayList<DEREncodable> certificateList = new ArrayList<DEREncodable>();
        certificateList.add(new DEROctetString(certificates.get(0)));
        certificateList.add(new DEROctetString(certificates.get(1)));
        DERSet userCertificateSet = new DERSet(certificateList, false);
        certificateSequence.add(userCertificateSet);
        rootVector.add(new DERSequence(certificateSequence));
        ASN1EncodableVector serialNumberSequence = new ASN1EncodableVector();
        DEROctetString serialNumberDescription = new DEROctetString("serialNumber".getBytes());
        serialNumberSequence.add(serialNumberDescription);
        CertificateFieldsResolver certificateFieldsResolver = new CertificateFieldsResolver();
        ArrayList<DEREncodable> serialNumberList = new ArrayList<DEREncodable>();
        byte[] serialNumber = (byte[])certificateFieldsResolver.getSerialNumber(userExchX509cert, (Integer)1);
        serialNumberList.add(new DEROctetString(serialNumber));
        serialNumber = (byte[])certificateFieldsResolver.getSerialNumber(userSignX509cert, (Integer)1);
        serialNumberList.add(new DEROctetString(serialNumber));
        DERSet userSerialNumberSet = new DERSet(serialNumberList, false);
        serialNumberSequence.add(userSerialNumberSet);
        rootVector.add(new DERSequence(serialNumberSequence));
        ASN1EncodableVector validityFromSequence = new ASN1EncodableVector();
        DEROctetString validityFromDescription = new DEROctetString("validityFrom".getBytes());
        validityFromSequence.add(validityFromDescription);
        ArrayList<DEREncodable> validityFromList = new ArrayList<DEREncodable>();
        DERGeneralizedTime validityFrom = new DERGeneralizedTime(userExchX509cert.getNotBefore());
        validityFromList.add(new DEROctetString(validityFrom.getTimeString().getBytes()));
        validityFrom = new DERGeneralizedTime(userSignX509cert.getNotBefore());
        validityFromList.add(new DEROctetString(validityFrom.getTimeString().getBytes()));
        DERSet validityFromSet = new DERSet(validityFromList, false);
        validityFromSequence.add(validityFromSet);
        rootVector.add(new DERSequence(validityFromSequence));
        ASN1EncodableVector validityToSequence = new ASN1EncodableVector();
        DEROctetString validityToDescription = new DEROctetString("validityTo".getBytes());
        validityToSequence.add(validityToDescription);
        ArrayList<DEREncodable> validityToList = new ArrayList<DEREncodable>();
        DERGeneralizedTime validityTo = new DERGeneralizedTime(userExchX509cert.getNotAfter());
        validityToList.add(new DEROctetString(validityTo.getTimeString().getBytes()));
        validityTo = new DERGeneralizedTime(userSignX509cert.getNotAfter());
        validityToList.add(new DEROctetString(validityTo.getTimeString().getBytes()));
        DERSet validityToSet = new DERSet(validityToList, false);
        validityToSequence.add(validityToSet);
        rootVector.add(new DERSequence(validityToSequence));
        ASN1EncodableVector keyOIDSequence = new ASN1EncodableVector();
        DEROctetString keyOIDDescription = new DEROctetString("keyOID".getBytes());
        keyOIDSequence.add(keyOIDDescription);
        ArrayList<DEREncodable> keyOIDList = new ArrayList<DEREncodable>();
        keyOIDList.add(new DEROctetString(userExchX509cert.getPublicKey().getAlgorithm().getBytes()));
        keyOIDList.add(new DEROctetString(userSignX509cert.getPublicKey().getAlgorithm().getBytes()));
        DERSet keyOIDSet = new DERSet(keyOIDList, false);
        keyOIDSequence.add(keyOIDSet);
        rootVector.add(new DERSequence(keyOIDSequence));
        return new DERSequence(rootVector).getDEREncoded();
    }

    private byte[] createFourthRootNode() {
        ASN1EncodableVector rootVector = this.createCommon(this.caSubject.getValues(X509Name.CN).firstElement().toString());
        ASN1EncodableVector certificateSequence = new ASN1EncodableVector();
        DEROctetString certificateDescription = new DEROctetString("CACertificate".getBytes());
        certificateSequence.add(certificateDescription);
        DERSet certificateSet = new DERSet(new DEROctetString(this.caCertificateAsBytes));
        certificateSequence.add(certificateSet);
        rootVector.add(new DERSequence(certificateSequence));
        ASN1EncodableVector serialNumberSequence = new ASN1EncodableVector();
        DEROctetString serialNumberDescription = new DEROctetString("serialNumber".getBytes());
        serialNumberSequence.add(serialNumberDescription);
        CertificateFieldsResolver certificateFieldsResolver = new CertificateFieldsResolver();
        byte[] serialNumber = (byte[])certificateFieldsResolver.getSerialNumber(this.caCertificate, (Integer)1);
        DERSet serialNumberSet = new DERSet(new DEROctetString(serialNumber));
        serialNumberSequence.add(serialNumberSet);
        rootVector.add(new DERSequence(serialNumberSequence));
        ASN1EncodableVector validityFromSequence = new ASN1EncodableVector();
        DEROctetString validityFromDescription = new DEROctetString("validityFrom".getBytes());
        validityFromSequence.add(validityFromDescription);
        DERGeneralizedTime validityFrom = new DERGeneralizedTime(this.caCertificate.getNotBefore());
        DERSet validityFromSet = new DERSet(new DEROctetString(validityFrom.getTimeString().getBytes()));
        validityFromSequence.add(validityFromSet);
        rootVector.add(new DERSequence(validityFromSequence));
        ASN1EncodableVector validityToSequence = new ASN1EncodableVector();
        DEROctetString validityToDescription = new DEROctetString("validityTo".getBytes());
        validityToSequence.add(validityToDescription);
        DERGeneralizedTime validityTo = new DERGeneralizedTime(this.caCertificate.getNotAfter());
        DERSet validityToSet = new DERSet(new DEROctetString(validityTo.getTimeString().getBytes()));
        validityToSequence.add(validityToSet);
        rootVector.add(new DERSequence(validityToSequence));
        ASN1EncodableVector keyOIDSequence = new ASN1EncodableVector();
        DEROctetString keyOIDDescription = new DEROctetString("keyOID".getBytes());
        keyOIDSequence.add(keyOIDDescription);
        DERSet keyOIDSet = new DERSet(new DEROctetString(this.caCertificate.getPublicKey().getAlgorithm().getBytes()));
        keyOIDSequence.add(keyOIDSet);
        rootVector.add(new DERSequence(keyOIDSequence));
        return new DERSequence(rootVector).getDEREncoded();
    }

    private X509Name formDn(String c, String o, String cn) {
        Hashtable<DERObjectIdentifier, String> attributes = new Hashtable<DERObjectIdentifier, String>();
        attributes.put(X509Name.C, c);
        attributes.put(X509Name.O, o);
        attributes.put(X509Name.CN, cn);
        Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
        vector.add(X509Name.C);
        vector.add(X509Name.O);
        vector.add(X509Name.CN);
        return new X509Name(vector, attributes);
    }

    public void process(String[] args) {
        this.init(args);
        List<byte[]> pkcs10Requests = this.createPkcs10Requests();
        List<byte[]> pkcs7Requests = this.createPkcs7Requests(pkcs10Requests);
        this.issuedCertificates = this.sendRequests(pkcs7Requests);
        this.createFirstNodes();
        this.createSecondNodes();
        this.createThirdNodes();
        this.createFourthNodes(this.issuedCertificates);
    }

    public List<byte[]> getIssuedCertificates() {
        return this.issuedCertificates;
    }
}

