/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hsm;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import kz.gamma.core.UtilCM;
import kz.gamma.hsm.CkSlotInfo;
import kz.gamma.hsm.CkTokenInfo;
import kz.gamma.hsm.PKCS11WrapperException;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.LibraryWrapper;

public class PKCS11Wrapper {
    private static final int SUN_ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model").equals("32") ? 32 : 64;
    private static boolean jniPkcs11LibraryLoaded = false;
    private static final int HANDLE_SIZE = SUN_ARCH_DATA_MODEL / 8;
    public static final int CKF_LIBRARY_CANT_CREATE_OS_THREADS = 1;
    public static final int CKF_OS_LOCKING_OK = 2;
    public static final int CKF_RW_SESSION = 2;
    public static final int CKF_SERIAL_SESSION = 4;
    public static final int CKU_SO = 0;
    public static final int CKU_USER = 1;
    public static final int CKU_CONTEXT_SPECIFIC = 2;
    public static final int CKO_DATA = 0;
    public static final int CKO_CERTIFICATE = 1;
    public static final int CKO_PUBLIC_KEY = 2;
    public static final int CKO_PRIVATE_KEY = 3;
    public static final int CKO_SECRET_KEY = 4;
    public static final int CKO_HW_FEATURE = 5;
    public static final int CKO_DOMAIN_PARAMETERS = 6;
    public static final int CKO_MECHANISM = 7;
    public static final int CKK_VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int CKA_VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int CKM_VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int CKK_CERTEX_DEFINED = -1912602624;
    public static final int CKK_CERTEX_GOST_28147_89 = -1912602623;
    public static final int CKK_CERTEX_RDS = -1912602622;
    public static final int CKA_CERTEX_DEFINED = -1912602624;
    public static final int CKA_CERTEX_RDS_TYPE = -1912602607;
    public static final int CKM_CERTEX_DEFINED = -1912602624;
    public static final int CKM_CERTEX_GOST_28147_89_KEY_GEN = -1912602624;
    public static final int CKM_CERTEX_GOST_28147_89 = -1912602623;
    public static final int CKM_CERTEX_GOST_28147_89_MAC = -1912602622;
    public static final int CKM_CERTEX_GOSTR3411 = -1912602614;
    public static final int CKM_CERTEX_GOSTR3410_2001_KEY_PAIR_GEN = -1912602613;
    public static final int CKM_CERTEX_GOSTR3410_2001 = -1912602612;
    public static final int CKM_CERTEX_GOSTR3411_94_GOSTR3410_2001 = -1912602611;
    public static final int CKM_CERTEX_DES_X919_MAC = -1912602620;
    public static final int CKM_CERTEX_DES_X919_MAC_GENERAL = -1912602619;
    public static final int CALG_GR3410EC_A = 21;
    public static final int CALG_GR3410EC_B = 22;
    public static final int CALG_GR3410EC_C = 23;
    public static final int CKM_CERTEX_GOSTR3411_2012_32 = -1912602608;
    public static final int CKM_CERTEX_GOSTR3411_2012_64 = -1912602607;
    public static final int CKM_CERTEX_GOSTR3410_2012_KEY_PAIR_GEN = -1912602606;
    public static final int CKM_CERTEX_GOSTR3410_2012 = -1912602605;
    public static final int CKM_CERTEX_GOSTR3411_GOSTR3410_2012 = -1912602604;
    public static final int CKM_CERTEX_GOSTR3411_2012_GOSTR3410_2001 = -1912602603;
    public static final int CKM_CALG_GR3410EC_512_A = 36;
    public static final int CKM_CALG_GR3410EC_512_B = 37;
    public static final int CKK_GENERIC_SECRET = 16;
    public static final int CKK_DES3 = 21;
    public static final int CKM_DES3_KEY_GEN = 305;
    public static final int CKM_DES3_CBC_ENCRYPT_DATA = 4355;

    private static native int C_Initialize(int var0);

    public void c_Initialize(int flags) {
        int result = PKCS11Wrapper.C_Initialize(flags);
        if (result != 0) {
            throw new PKCS11WrapperException("C_Initialize error", result);
        }
    }

    private static native int C_Finalize();

    public void c_Finalize() {
        int result = PKCS11Wrapper.C_Finalize();
        if (result != 0) {
            throw new PKCS11WrapperException("C_Finalize error", result);
        }
    }

    private static native int C_GetSlotList(boolean var0, long[] var1, byte[] var2);

    public Map<Object, Object> c_GetSlotList(boolean tokenPresent) {
        long[] pSlotList = new long[32];
        Number pulCountNumber = null;
        byte[] pulCount = null;
        if (HANDLE_SIZE == 4) {
            pulCountNumber = new Integer(0);
            pulCount = UtilCM.intToByte(pulCountNumber.intValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        } else {
            pulCountNumber = new Long(0L);
            pulCount = UtilCM.longToByte(pulCountNumber.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        }
        int result = PKCS11Wrapper.C_GetSlotList(tokenPresent, pSlotList, pulCount);
        if (result != 0) {
            throw new PKCS11WrapperException("C_GetSlotList error", result);
        }
        long[] pSlotListResult = null;
        if (HANDLE_SIZE == 4) {
            pulCountNumber = UtilCM.byteToInt(pulCount, 0, LibraryWrapper.SUN_CPU_ENDIAN);
            pSlotListResult = new long[pulCountNumber.intValue()];
            System.arraycopy(pSlotList, 0, pSlotListResult, 0, pulCountNumber.intValue());
        } else {
            pulCountNumber = UtilCM.byteToLong(pulCount, 0, LibraryWrapper.SUN_CPU_ENDIAN);
            pSlotListResult = new long[pulCountNumber.intValue()];
            System.arraycopy(pSlotList, 0, pSlotListResult, 0, pulCountNumber.intValue());
        }
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        resultMap.put("pSlotList", pSlotListResult);
        return resultMap;
    }

    private static native int C_GetSlotInfo(int var0, CkSlotInfo var1);

    public void c_GetSlotInfo(int slotID, CkSlotInfo pInfo) {
        int result = PKCS11Wrapper.C_GetSlotInfo(slotID, pInfo);
        if (result != 0) {
            throw new PKCS11WrapperException("C_GetSlotInfo error", result);
        }
    }

    private static native int C_GetTokenInfo(int var0, CkTokenInfo var1);

    public void c_GetTokenInfo(int slotID, CkTokenInfo pInfo) {
        int result = PKCS11Wrapper.C_GetTokenInfo(slotID, pInfo);
        if (result != 0) {
            throw new PKCS11WrapperException("c_GetTokenInfo error", result);
        }
    }

    private static native int C_OpenSession(int var0, int var1, byte[] var2);

    public Map<Object, Object> c_OpenSession(int slotID, int flags) {
        byte[] phSessionBytes = new byte[HANDLE_SIZE];
        int result = PKCS11Wrapper.C_OpenSession(slotID, flags, phSessionBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_OpenSession error", result);
        }
        Number phSession = null;
        phSession = HANDLE_SIZE == 4 ? (Number)UtilCM.byteToInt(phSessionBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN) : (Number)UtilCM.byteToLong(phSessionBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN);
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        resultMap.put("phSession", phSession);
        return resultMap;
    }

    private static native int C_CloseSession(byte[] var0);

    public void c_CloseSession(Number hSession) {
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCS11Wrapper.C_CloseSession(hSessionBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_CloseSession error", result);
        }
    }

    private static native int C_GetSessionInfo(byte[] var0, long[] var1);

    public Map<Object, Object> c_GetSessionInfo(Number session) {
        long[] pinfo;
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(session.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(session.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCS11Wrapper.C_GetSessionInfo(hSessionBytes, pinfo = new long[4]);
        if (result != 0) {
            throw new PKCS11WrapperException("C_GetSessionInfo error", result);
        }
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        resultMap.put("result", result);
        resultMap.put("slotID", pinfo[0]);
        resultMap.put("state", pinfo[1]);
        resultMap.put("flags", pinfo[2]);
        resultMap.put("ulDeviceError", pinfo[3]);
        return resultMap;
    }

    private static native int C_Login(byte[] var0, int var1, byte[] var2, int var3);

    public void c_Login(Number hSession, int userType, String pPin) {
        byte[] pPinBytes = null;
        try {
            pPinBytes = pPin.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCS11Wrapper.C_Login(hSessionBytes, userType, pPinBytes, pPinBytes.length);
        if (result != 0) {
            throw new PKCS11WrapperException("C_Login error", result);
        }
    }

    private static native int C_Logout(byte[] var0);

    public void c_Logout(Number hSession) {
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCS11Wrapper.C_Logout(hSessionBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_Logout error", result);
        }
    }

    private static native int C_DestroyObject(byte[] var0, byte[] var1);

    public void c_DestroyObject(Number hSession, Number hObject) {
        byte[] hSessionBytes = null;
        byte[] hObjectBytes = null;
        if (HANDLE_SIZE == 4) {
            hSessionBytes = UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN);
            hObjectBytes = UtilCM.intToByte(hObject.intValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        } else {
            hSessionBytes = UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
            hObjectBytes = UtilCM.longToByte(hObject.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        }
        int result = PKCS11Wrapper.C_DestroyObject(hSessionBytes, hObjectBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_DestroyObject error", result);
        }
    }

    private static native int C_FindObjectsInit(byte[] var0, int var1, boolean var2, byte[] var3);

    public void c_FindObjectsInit(Number hSession, int ckaClass, boolean ckaPrivate, String ckaLabelValue) {
        byte[] ckaLabelValueBytes = null;
        try {
            ckaLabelValueBytes = DataConverter.getNullTerminatedArray(ckaLabelValue.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCS11Wrapper.C_FindObjectsInit(hSessionBytes, ckaClass, ckaPrivate, ckaLabelValueBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_FindObjectsInit error", result);
        }
    }

    private static native int C_FindObjects(byte[] var0, byte[] var1);

    public Map<Object, Object> c_FindObjects(Number hSession) {
        byte[] phObjectBytes;
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCS11Wrapper.C_FindObjects(hSessionBytes, phObjectBytes = new byte[HANDLE_SIZE]);
        if (result != 0) {
            throw new PKCS11WrapperException("C_FindObjects error", result);
        }
        Number phObject = null;
        phObject = HANDLE_SIZE == 4 ? (Number)UtilCM.byteToInt(phObjectBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN) : (Number)UtilCM.byteToLong(phObjectBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN);
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        resultMap.put("phObject", phObject);
        return resultMap;
    }

    private static native int C_FindObjectsFinal(byte[] var0);

    public void c_FindObjectsFinal(Number hSession) {
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCS11Wrapper.C_FindObjectsFinal(hSessionBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_FindObjectsFinal error", result);
        }
    }

    private static native int C_SignInit(byte[] var0, int var1, byte[] var2);

    public void c_SignInit(Number hSession, int mechanism, Number hKey) {
        byte[] hSessionBytes = null;
        byte[] hKeyBytes = null;
        if (HANDLE_SIZE == 4) {
            hSessionBytes = UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN);
            hKeyBytes = UtilCM.intToByte(hKey.intValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        } else {
            hSessionBytes = UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
            hKeyBytes = UtilCM.longToByte(hKey.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        }
        int result = PKCS11Wrapper.C_SignInit(hSessionBytes, mechanism, hKeyBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_SignInit error", result);
        }
    }

    private static native int C_Sign(byte[] var0, byte[] var1, int var2, byte[] var3, byte[] var4);

    public Map<Object, Object> c_Sign(Number hSession, byte[] pData) {
        Long pulSignatureLenLong;
        byte[] pulSignatureLen;
        byte[] pSignature;
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCS11Wrapper.C_Sign(hSessionBytes, pData, pData.length, pSignature = new byte[1024], pulSignatureLen = UtilCM.longToByte(pulSignatureLenLong = Long.valueOf(1024L), LibraryWrapper.SUN_CPU_ENDIAN));
        if (result != 0) {
            throw new PKCS11WrapperException("C_Sign error", result);
        }
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        pulSignatureLenLong = UtilCM.byteToLong(pulSignatureLen, 0, LibraryWrapper.SUN_CPU_ENDIAN);
        pSignature = UtilCM.copyByte(pSignature, 0, pulSignatureLenLong.intValue());
        resultMap.put("pSignature", pSignature);
        return resultMap;
    }

    private static native int C_VerifyInit(byte[] var0, int var1, byte[] var2);

    public void c_VerifyInit(Number hSession, int mechanism, Number hKey) {
        byte[] hSessionBytes = null;
        byte[] hKeyBytes = null;
        if (HANDLE_SIZE == 4) {
            hSessionBytes = UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN);
            hKeyBytes = UtilCM.intToByte(hKey.intValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        } else {
            hSessionBytes = UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
            hKeyBytes = UtilCM.longToByte(hKey.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        }
        int result = PKCS11Wrapper.C_VerifyInit(hSessionBytes, mechanism, hKeyBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_VerifyInit error", result);
        }
    }

    private static native int C_Verify(byte[] var0, byte[] var1, int var2, byte[] var3, int var4);

    public void c_Verify(Number hSession, byte[] pData, byte[] pSignature) {
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCS11Wrapper.C_Verify(hSessionBytes, pData, pData.length, pSignature, pSignature.length);
        if (result != 0) {
            throw new PKCS11WrapperException("C_Verify error", result);
        }
    }

    private static native int C_GenerateKey(byte[] var0, int var1, byte[] var2, int var3, byte[] var4);

    public Map<Object, Object> c_GenerateKey(Number hSession, int mechanism, String ckaLabelValue, int ckaKeyTypeValue) {
        byte[] ckaLabelValueBytes = null;
        try {
            ckaLabelValueBytes = DataConverter.getNullTerminatedArray(ckaLabelValue.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hSessionBytes = null;
        hSessionBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        byte[] phKeyBytes = new byte[HANDLE_SIZE];
        int result = PKCS11Wrapper.C_GenerateKey(hSessionBytes, mechanism, ckaLabelValueBytes, ckaKeyTypeValue, phKeyBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_GenerateKey error", result);
        }
        Number phKey = null;
        phKey = HANDLE_SIZE == 4 ? (Number)UtilCM.byteToInt(phKeyBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN) : (Number)UtilCM.byteToLong(phKeyBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN);
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        resultMap.put("phKey", phKey);
        return resultMap;
    }

    private static native int rcsp_ConnectInfo(int var0, byte[] var1, byte[] var2, byte[] var3);

    public Map<Object, Object> c_rcsp_ConnectInfo(int ind) {
        byte[] phOrder = new byte[4];
        byte[] phHost = new byte[520];
        byte[] phPort = new byte[4];
        int result = PKCS11Wrapper.rcsp_ConnectInfo(ind, phOrder, phHost, phPort);
        if (result != 0) {
            throw new PKCS11WrapperException("rcsp_ConnectInfo error", result);
        }
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        resultMap.put("order", UtilCM.byteToInt(phOrder, 0, LibraryWrapper.SUN_CPU_ENDIAN));
        resultMap.put("host", DataConverter.byteArrayToString(phHost));
        resultMap.put("port", UtilCM.byteToInt(phPort, 0, LibraryWrapper.SUN_CPU_ENDIAN));
        return resultMap;
    }

    private static native int C_DeriveKey(byte[] var0, int var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    public Map<Object, Object> c_DeriveKey(Number hSession, int mechanism, Number hBaseKey, String ckaLabelValue, int ckaKeyTypeValue) {
        byte[] ckaLabelValueBytes = null;
        try {
            ckaLabelValueBytes = DataConverter.getNullTerminatedArray(ckaLabelValue.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hSessionBytes = null;
        byte[] hBaseKeyBytes = null;
        if (HANDLE_SIZE == 4) {
            hSessionBytes = UtilCM.intToByte(hSession.intValue(), LibraryWrapper.SUN_CPU_ENDIAN);
            hBaseKeyBytes = UtilCM.intToByte(hBaseKey.intValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        } else {
            hSessionBytes = UtilCM.longToByte(hSession.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
            hBaseKeyBytes = UtilCM.longToByte(hBaseKey.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        }
        byte[] phKeyBytes = new byte[HANDLE_SIZE];
        int result = PKCS11Wrapper.C_DeriveKey(hSessionBytes, mechanism, hBaseKeyBytes, ckaLabelValueBytes, ckaKeyTypeValue, phKeyBytes);
        if (result != 0) {
            throw new PKCS11WrapperException("C_DeriveKey error", result);
        }
        Number phKey = null;
        phKey = HANDLE_SIZE == 4 ? (Number)UtilCM.byteToInt(phKeyBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN) : (Number)UtilCM.byteToLong(phKeyBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN);
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        resultMap.put("phKey", phKey);
        return resultMap;
    }

    public static synchronized void initialize(Map librariesNames) {
        String jniPkcs11LibraryName = null;
        jniPkcs11LibraryName = SUN_ARCH_DATA_MODEL == 32 ? (String)librariesNames.get("jniPkcs11LibraryPath32bit") : (String)librariesNames.get("jniPkcs11LibraryPath64bit");
        if (!jniPkcs11LibraryLoaded) {
            System.load(jniPkcs11LibraryName);
            System.out.println("JNI PKCS11 library succesfully loaded");
            jniPkcs11LibraryLoaded = true;
        } else {
            System.out.println("JNI library already loaded");
        }
    }

    public static synchronized void deinitialize() {
    }
}

