/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hsm;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import kz.gamma.core.UtilCM;
import kz.gamma.hsm.PKCSWrapperException;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.LibraryWrapper;

public class PKCSWrapper {
    private static final int SUN_ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model").equals("32") ? 32 : 64;
    private static boolean jniLibraryLoaded = false;
    private static boolean pkcsLibraryLoaded = false;
    private static final int HANDLE_SIZE = SUN_ARCH_DATA_MODEL / 8;

    private static native int pkcsOpenContext(byte[] var0, byte[] var1, int var2, int var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    private static native int pkcsOpenContextEx(byte[] var0, int var1, int var2, int var3, byte[] var4, int var5, byte[] var6, int var7);

    public Map pkcsOpenContextEx(int ulSlotNumber, int keyAlg, int keySize, byte[] pPin, String pContainer, int dwFlags) {
        byte[] pContainerBytes = null;
        byte[] pPinBytes = null;
        try {
            pContainerBytes = DataConverter.getNullTerminatedArray(pContainer.getBytes("ASCII"));
            pPinBytes = DataConverter.getNullTerminatedArray(pPin);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] phProvBytes = new byte[HANDLE_SIZE];
        int result = PKCSWrapper.pkcsOpenContextEx(phProvBytes, ulSlotNumber, keyAlg, keySize, pPinBytes, pPinBytes.length - 1, pContainerBytes, dwFlags);
        if (result != 0) {
            throw new PKCSWrapperException("pkcsOpenContextEx error", result);
        }
        Number phProv = null;
        phProv = HANDLE_SIZE == 4 ? (Number)UtilCM.byteToInt(phProvBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN) : (Number)UtilCM.byteToLong(phProvBytes, 0, LibraryWrapper.SUN_CPU_ENDIAN);
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("phProv", (Integer)phProv);
        return resultMap;
    }

    private static native int pkcsCloseContext(byte[] var0);

    public Map pkcsCloseContext(Number phProv) {
        byte[] phProvBytes = null;
        phProvBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(phProv.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(phProv.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCSWrapper.pkcsCloseContext(phProvBytes);
        if (result != 0) {
            throw new PKCSWrapperException("pkcsCloseContext error", result);
        }
        return null;
    }

    private static native int pkcsCloseContextEx(byte[] var0, int var1);

    public Map pkcsCloseContextEx(Number phProv, int dwFlags) {
        byte[] phProvBytes = null;
        phProvBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(phProv.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(phProv.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCSWrapper.pkcsCloseContextEx(phProvBytes, dwFlags);
        if (result != 0) {
            throw new PKCSWrapperException("pkcsCloseContextEx error", result);
        }
        return null;
    }

    private static native int pkcsExportPublicKey(byte[] var0, byte[] var1, byte[] var2);

    public Map pkcsExportPublicKey(Number phProv) {
        Long blobSizeLong;
        byte[] blobSize;
        byte[] keyBlob;
        byte[] phProvBytes = null;
        phProvBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(phProv.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(phProv.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCSWrapper.pkcsExportPublicKey(phProvBytes, keyBlob = new byte[256], blobSize = UtilCM.longToByte(blobSizeLong = Long.valueOf(256L), LibraryWrapper.SUN_CPU_ENDIAN));
        if (result != 0) {
            throw new PKCSWrapperException("pkcsExportPublicKey error", result);
        }
        HashMap<String, byte[]> resultMap = new HashMap<String, byte[]>();
        blobSizeLong = UtilCM.byteToLong(blobSize, 0, LibraryWrapper.SUN_CPU_ENDIAN);
        keyBlob = UtilCM.copyByte(keyBlob, 0, blobSizeLong.intValue());
        resultMap.put("keyBlob", keyBlob);
        return resultMap;
    }

    private static native int pkcsGetSecurityToken(byte[] var0, byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5);

    public Map pkcsGetSecurityToken(Number phProv, String pContainer, String pPassword, int dwFlags) {
        byte[] pContainerBytes = null;
        byte[] pPasswordBytes = null;
        try {
            pContainerBytes = DataConverter.getNullTerminatedArray(pContainer.getBytes("ASCII"));
            pPasswordBytes = DataConverter.getNullTerminatedArray(pPassword.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] phProvBytes = null;
        phProvBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(phProv.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(phProv.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        byte[] tokenBlob = new byte[1024];
        Long blobSizeLong = 1024L;
        byte[] blobSize = UtilCM.longToByte(blobSizeLong, LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCSWrapper.pkcsGetSecurityToken(phProvBytes, pContainerBytes, pPasswordBytes, dwFlags, tokenBlob, blobSize);
        if (result != 0) {
            throw new PKCSWrapperException("pkcsGetSecurityToken error", result);
        }
        HashMap<String, byte[]> resultMap = new HashMap<String, byte[]>();
        blobSizeLong = UtilCM.byteToLong(blobSize, 0, LibraryWrapper.SUN_CPU_ENDIAN);
        tokenBlob = UtilCM.copyByte(tokenBlob, 0, blobSizeLong.intValue());
        resultMap.put("tokenBlob", tokenBlob);
        return resultMap;
    }

    private static native int pkcsSetSecurityToken(byte[] var0, byte[] var1, byte[] var2, byte[] var3, int var4);

    public Map pkcsSetSecurityToken(Number phProv, String pContainer, String pPassword, byte[] tokenBlob) {
        byte[] pContainerBytes = null;
        byte[] pPasswordBytes = null;
        try {
            pContainerBytes = DataConverter.getNullTerminatedArray(pContainer.getBytes("ASCII"));
            pPasswordBytes = DataConverter.getNullTerminatedArray(pPassword.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] phProvBytes = null;
        phProvBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(phProv.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(phProv.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCSWrapper.pkcsSetSecurityToken(phProvBytes, pContainerBytes, pPasswordBytes, tokenBlob, tokenBlob.length);
        if (result != 0) {
            throw new PKCSWrapperException("pkcsSetSecurityToken error", result);
        }
        return null;
    }

    private static native int pkcsSetSign(byte[] var0, int var1, boolean var2, byte[] var3, int var4, byte[] var5, byte[] var6);

    private static native int pkcsSetSignHash(byte[] var0, byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5);

    public Map pkcsSetSignHash(Number phProv, String hashOID, byte[] hashData) {
        byte[] hashOIDBytes = null;
        try {
            hashOIDBytes = DataConverter.getNullTerminatedArray(hashOID.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] phProvBytes = null;
        phProvBytes = HANDLE_SIZE == 4 ? UtilCM.intToByte(phProv.intValue(), LibraryWrapper.SUN_CPU_ENDIAN) : UtilCM.longToByte(phProv.longValue(), LibraryWrapper.SUN_CPU_ENDIAN);
        byte[] strSig = new byte[512];
        Long sigSizeLong = 512L;
        byte[] sigSize = UtilCM.longToByte(sigSizeLong, LibraryWrapper.SUN_CPU_ENDIAN);
        int result = PKCSWrapper.pkcsSetSignHash(phProvBytes, hashOIDBytes, hashData, hashData.length, strSig, sigSize);
        if (result != 0) {
            throw new PKCSWrapperException("pkcsSetSignHash error", result);
        }
        HashMap<String, byte[]> resultMap = new HashMap<String, byte[]>();
        sigSizeLong = UtilCM.byteToLong(sigSize, 0, LibraryWrapper.SUN_CPU_ENDIAN);
        strSig = UtilCM.copyByte(strSig, 0, sigSizeLong.intValue());
        resultMap.put("strSig", strSig);
        return resultMap;
    }

    private static native int pkcsLoadLib(byte[] var0);

    public static synchronized void initialize(Map librariesNames) {
        String jniLibraryName = null;
        String pkcsLibraryName = null;
        if (SUN_ARCH_DATA_MODEL == 32) {
            jniLibraryName = (String)librariesNames.get("jniLibraryPath32bit");
            pkcsLibraryName = (String)librariesNames.get("pkcsLibraryPath32bit");
        } else {
            jniLibraryName = (String)librariesNames.get("jniLibraryPath64bit");
            pkcsLibraryName = (String)librariesNames.get("pkcsLibraryPath64bit");
        }
        if (!jniLibraryLoaded) {
            System.load(jniLibraryName);
            System.out.println("JNI library succesfully loaded");
            jniLibraryLoaded = true;
        } else {
            System.out.println("JNI library already loaded");
        }
        if (!pkcsLibraryLoaded) {
            byte[] pLibNameBytes = null;
            try {
                pLibNameBytes = DataConverter.getNullTerminatedArray(pkcsLibraryName.getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            int result = PKCSWrapper.pkcsLoadLib(pLibNameBytes);
            if (result != 0) {
                throw new PKCSWrapperException("PKCS library not loaded", result);
            }
            pkcsLibraryLoaded = true;
            System.out.println("PKCS library succesfully loaded");
        } else {
            System.out.println("PKCS library already loaded");
        }
    }

    private static native void pkcsUnloadLib();

    public static synchronized void deinitialize() {
        if (pkcsLibraryLoaded) {
            PKCSWrapper.pkcsUnloadLib();
            pkcsLibraryLoaded = false;
            System.out.println("PKCS library succesfully unloaded");
        } else {
            System.out.println("PKCS library not loaded");
        }
    }
}

