/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hsm.crypto.software;

import java.math.BigInteger;
import kz.gamma.core.UtilCM;
import kz.gamma.hsm.crypto.software.SignatureVerifier;
import kz.gamma.hsm.crypto.software.ec.ECAlgorithms;
import kz.gamma.hsm.crypto.software.ec.ECConstants;
import kz.gamma.hsm.crypto.software.ec.ECCurve;
import kz.gamma.hsm.crypto.software.ec.ECFieldElement;
import kz.gamma.hsm.crypto.software.ec.ECPoint;
import kz.gamma.hsm.crypto.software.param.ECDomainParameters;
import kz.gamma.hsm.crypto.software.param.ECElipticCurveParametr;
import kz.gamma.hsm.crypto.software.param.ECPublicKeyParameters;

public class GostSignatureVerifier
extends SignatureVerifier {
    private boolean verifyGost(byte[] publicKey, byte[] hash, byte[] sign) {
        boolean ret = false;
        try {
            publicKey = UtilCM.reverseParts(publicKey, 0);
            hash = UtilCM.inverseCopyByte(hash, 0, 32);
            sign = UtilCM.reverseParts(sign, 0);
            byte[] px = UtilCM.copyByte(publicKey, 0, publicKey.length / 2);
            byte[] py = UtilCM.copyByte(publicKey, publicKey.length / 2, publicKey.length / 2);
            byte[] rx = UtilCM.copyByte(sign, 0, sign.length / 2);
            byte[] ry = UtilCM.copyByte(sign, sign.length / 2, sign.length / 2);
            BigInteger mod_p = new BigInteger(1, ECElipticCurveParametr.param_a_p);
            ECCurve.Fp curve = new ECCurve.Fp(mod_p, new BigInteger(1, ECElipticCurveParametr.param_a_a), new BigInteger(1, ECElipticCurveParametr.param_a_b));
            ECDomainParameters params = new ECDomainParameters(curve, new ECPoint.Fp(curve, new ECFieldElement.Fp(mod_p, new BigInteger(1, ECElipticCurveParametr.param_a_x)), new ECFieldElement.Fp(mod_p, new BigInteger(1, ECElipticCurveParametr.param_a_y))), new BigInteger(1, ECElipticCurveParametr.param_a_q));
            ECPublicKeyParameters pubKey = new ECPublicKeyParameters(new ECPoint.Fp(curve, new ECFieldElement.Fp(mod_p, new BigInteger(1, px)), new ECFieldElement.Fp(mod_p, new BigInteger(1, py))), params);
            BigInteger r = new BigInteger(1, rx);
            BigInteger s = new BigInteger(1, ry);
            BigInteger e = new BigInteger(1, hash);
            BigInteger n = pubKey.getParameters().getN();
            if (r.compareTo(ECConstants.ONE) < 0 || r.compareTo(n) >= 0) {
                throw new Exception("Sign not verify");
            }
            if (s.compareTo(ECConstants.ONE) < 0 || s.compareTo(n) >= 0) {
                throw new Exception("Sign not verify");
            }
            BigInteger v = e.modInverse(n);
            BigInteger z1 = s.multiply(v).mod(n);
            BigInteger z2 = n.subtract(r).multiply(v).mod(n);
            ECPoint G = pubKey.getParameters().getG();
            ECPoint Q = pubKey.getQ();
            ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, z1, Q, z2);
            BigInteger R = point.getX().toBigInteger().mod(n);
            BigInteger S = point.getY().toBigInteger().mod(n);
            ret = R.equals(r);
        }
        catch (Exception e) {
            throw new RuntimeException("Error on GOST signature verifying: " + e.getMessage());
        }
        return ret;
    }

    private boolean verifyVariants(byte[] publicKey, byte[] hash, byte[] sign) {
        return this.verifyGost(publicKey, hash, sign);
    }

    @Override
    public boolean verify(byte[] publicKey, byte[] hash, byte[] sign) {
        return this.verifyVariants(publicKey, hash, sign);
    }
}

