/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hsm.crypto.software;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.x509.DigestInfo;
import kz.gamma.hsm.crypto.software.SignatureVerifier;

public class RsaSignatureVerifier
extends SignatureVerifier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyRsa(byte[] publicKey, byte[] hash, byte[] sign) {
        boolean bl;
        block10: {
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, pubKey);
            byte[] decryptedSignature = cipher.doFinal(sign);
            ASN1InputStream in = null;
            try {
                in = new ASN1InputStream(decryptedSignature);
                DERObject asnBody = in.readObject();
                DigestInfo digestInfo = DigestInfo.getInstance(asnBody);
                bl = Arrays.equals(hash, digestInfo.getDigest());
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error on RSA signature verifying: " + e.getMessage());
                }
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    @Override
    public boolean verify(byte[] publicKey, byte[] hash, byte[] sign) {
        return this.verifyRsa(publicKey, hash, sign);
    }
}

