/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import kz.gamma.core.UtilCM;

public class JCEECPublicKey
implements ECPublicKey {
    private String algorithm = "";
    private byte[] pubKey = null;

    public JCEECPublicKey(byte[] pbKey, String OID) {
        this.pubKey = UtilCM.copyByte(pbKey, 0, pbKey.length);
        this.algorithm = OID;
    }

    @Deprecated
    public JCEECPublicKey(String algorithm, byte[] pubKey) {
        this.algorithm = algorithm;
        this.pubKey = pubKey;
    }

    @Override
    public ECPoint getW() {
        return null;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return this.pubKey;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.getParamsFix21422();
    }

    private ECParameterSpec getParamsFix21422() {
        BigInteger p = new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839");
        ECFieldFp ecFieldFp = new ECFieldFp(p);
        BigInteger a = new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16);
        BigInteger b = new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(ecFieldFp, a, b);
        BigInteger x = new BigInteger("110282003749548856476348533541186204577905061504881242240149511594420911");
        BigInteger y = new BigInteger("869078407435509378747351873793058868500210384946040694651368759217025454");
        ECPoint g = new ECPoint(x, y);
        BigInteger n = new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307");
        ECParameterSpec ecParameterSpec = new ECParameterSpec(ellipticCurve, g, n, 1);
        return ecParameterSpec;
    }

    public String toString() {
        return "JCEECPublicKey{algorithm='" + this.algorithm + '\'' + ", pubKey=" + (this.pubKey == null ? null : UtilCM.array2hex(this.pubKey)) + '}';
    }
}

