/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.BufferedBlockCipher;
import kz.gamma.crypto.chiper.GOST28147Engine;
import kz.gamma.crypto.mode.CFBBlockCipher;
import kz.gamma.crypto.params.KeyParameter;
import kz.gamma.crypto.params.ParametersWithIV;
import kz.gamma.crypto.params.ParametersWithSBox;
import kz.gamma.crypto.pcsc.ResponceCard;
import kz.gamma.crypto.pcsc.android.CardException;
import kz.gamma.crypto.pcsc.safenet.TokenSafeNet;
import kz.gamma.jce.exception.JCEHardwareException;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.util.Arrays;

public class JCESafeNetPrivateKey
implements ECPrivateKey {
    private TokenSafeNet token;
    private int algId;
    private String password;
    private String name;
    private byte[] sesKey = null;
    private byte[] iv = null;

    public JCESafeNetPrivateKey(TokenSafeNet token, String name, int algId, String password) {
        this.token = token;
        this.algId = algId;
        this.password = password;
        this.name = name;
    }

    public byte[] getDHBlob(byte[] certBlob) {
        byte[] ret = null;
        Number hProv = 0;
        Number hHash = 0;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "GAMMA");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBlob));
            byte[] pubKey = UtilCM.copyByte(cert.getPublicKey().getEncoded(), 16, cert.getPublicKey().getEncoded().length - 16);
            pubKey = UtilCM.reverseParts(pubKey, 0);
            ResponceCard responceCard = this.token.genRandom(8);
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Error gen random [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
            byte[] ukm = responceCard.getData();
            ukm = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
            responceCard = this.token.makeDH(this.name, pubKey, ukm);
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Error gen random [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
            byte[] dh = UtilCM.reverseParts(responceCard.getData(), 0);
            byte[] dhKey = new byte[32];
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 32; ++j) {
                    int n = j;
                    dhKey[n] = (byte)(dhKey[n] ^ dh[j + i * 32]);
                }
            }
            responceCard = this.token.genRandom(32);
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Error gen random [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
            this.sesKey = responceCard.getData();
            if (this.sesKey.length > 32) {
                this.sesKey = UtilCM.copyByte(this.sesKey, 0, 32);
            }
            hProv = TumarCspFunctions.cpAcquireContext("", -268435456, 0);
            hHash = TumarCspFunctions.cpCreateHash(hProv, 32797, 0, 0);
            TumarCspFunctions.cpHashData(hProv, hHash, this.sesKey, this.sesKey.length, 0);
            byte[] localsesKey = TumarCspFunctions.cpGetHashParamData(hProv, hHash, 2, 0);
            TumarCspFunctions.cpDestroyHash(hProv, hHash);
            byte[] pad1 = new byte[64];
            byte[] pad2 = new byte[64];
            for (int i = 0; i < 64; ++i) {
                pad1[i] = (byte)(0x36 ^ (i < 32 ? localsesKey[i] : 0));
                pad2[i] = (byte)(0x5C ^ (i < 32 ? localsesKey[i] : 0));
            }
            hHash = TumarCspFunctions.cpCreateHash(hProv, 32797, 0, 0);
            TumarCspFunctions.cpHashData(hProv, hHash, pad1, pad1.length, 0);
            localsesKey = TumarCspFunctions.cpGetHashParamData(hProv, hHash, 2, 0);
            TumarCspFunctions.cpDestroyHash(hProv, hHash);
            hHash = TumarCspFunctions.cpCreateHash(hProv, 32797, 0, 0);
            TumarCspFunctions.cpHashData(hProv, hHash, pad2, pad2.length, 0);
            byte[] localsesKey2 = TumarCspFunctions.cpGetHashParamData(hProv, hHash, 2, 0);
            localsesKey = UtilCM.concat(localsesKey, localsesKey2);
            TumarCspFunctions.cpDestroyHash(hProv, hHash);
            TumarCspFunctions.cpReleaseContext(hProv, 0);
            byte[] keyPad = new byte[32];
            Arrays.fill(keyPad, (byte)0);
            dhKey = UtilCM.concat(dhKey, keyPad);
            KeyParameter keyParameter = new KeyParameter(dhKey);
            ParametersWithSBox sBox = new ParametersWithSBox(keyParameter, GOST28147Engine.getSBox("D-G"));
            responceCard = this.token.genRandom(8);
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Error gen random [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
            this.iv = responceCard.getData();
            ParametersWithIV secKeyParam = new ParametersWithIV(sBox, this.iv);
            BufferedBlockCipher blockCipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
            blockCipher.reset();
            blockCipher.init(true, secKeyParam);
            byte[] bufiv = new byte[this.iv.length];
            blockCipher.processBytes(this.iv, 0, this.iv.length, bufiv, 0);
            byte[] buf = new byte[localsesKey.length];
            blockCipher.processBytes(localsesKey, 0, localsesKey.length, buf, 0);
            byte[] h1 = new byte[]{1, 2, 0, 0, 31, 104, 4, 0, 31, 104, 0, 0, 48, 89, 2, 1, 4, 4, 8};
            byte[] h2 = new byte[]{4, 8};
            byte[] h3 = new byte[]{4, 64};
            byte[] simpleBlob = UtilCM.concat(h1, UtilCM.copyByte(this.iv, 0, 8));
            simpleBlob = UtilCM.concat(simpleBlob, h2);
            simpleBlob = UtilCM.concat(simpleBlob, UtilCM.copyByte(bufiv, 0, 8));
            simpleBlob = UtilCM.concat(simpleBlob, h3);
            ret = UtilCM.concat(simpleBlob, UtilCM.copyByte(buf, 0, 64));
        }
        catch (CardException e) {
            throw new JCEHardwareException("DH key generate error " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new JCEHardwareException(e);
        }
        catch (NoSuchProviderException e) {
            throw new JCEHardwareException(e);
        }
        return ret;
    }

    public TokenSafeNet getToken() {
        return this.token;
    }

    public int getAlgId() {
        return this.algId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getSesKey() {
        return this.sesKey;
    }

    public byte[] getIv() {
        return this.iv;
    }

    @Override
    public BigInteger getS() {
        return null;
    }

    @Override
    public String getAlgorithm() {
        return "ECGAMMAKEY";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return new byte[0];
    }

    @Override
    public ECParameterSpec getParams() {
        return null;
    }
}

