/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import kz.gamma.jce.exception.CSPException;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.ErrorResolver;
import kz.gamma.tumarcsp.KeyParams;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;

public abstract class JDKKeyStore
extends KeyStoreSpi {
    protected String profile = null;
    protected String url = null;
    protected String pass = null;
    protected Number hProv = 0;
    protected KeyParams kps = null;
    protected CSPUtil util = new CSPUtil();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Private key not found. Alias is null or empty. Alias: " + alias);
        }
        try {
            Key key = (Key)this.kps.getPrivateKeyList()[this.kps.getIndexSN(alias)];
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Certificate not found. Alias - " + alias);
        }
        try {
            Certificate[] chain = new Certificate[2];
            chain[0] = (Certificate)this.kps.getCertificateList()[this.kps.getIndexSN(alias)];
            X509Certificate caCert = (X509Certificate)this.kps.getCaCertificateList()[this.kps.getIndexSN(alias)];
            chain[1] = caCert;
            return chain;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Object[] cert = this.kps.getCertificateList();
        try {
            return (Certificate)cert[this.kps.getIndexSN(alias)];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Object[] time = this.kps.getCreateTimeList();
        try {
            return (Date)time[this.kps.getIndexSN(alias)];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        Number hKey = 0;
        try {
            block8: {
                int keySpec = 2;
                try {
                    hKey = TumarCspFunctions.cpGetUserKey(this.hProv, keySpec);
                }
                catch (CSPException ex) {
                    if (ex.errorRes.getError() != -2146893811) break block8;
                    keySpec = 1;
                    hKey = TumarCspFunctions.cpGetUserKey(this.hProv, keySpec);
                }
            }
            try {
                TumarCspFunctions.cpSetKeyParam(this.hProv, hKey, 26, cert.getEncoded(), 0);
            }
            catch (CertificateEncodingException e) {
                throw new KeyStoreException("Certificate to container not imported", e);
            }
        }
        finally {
            if (hKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.hProv, hKey);
            }
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.kps.getObjectParam();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return false;
    }

    @Override
    public int engineSize() {
        return this.kps.getLength();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        new Throwable("Method is not implemented");
    }

    protected boolean loadUrlOrProfile(String urlParam, String profileParam, String password, Boolean usePasswordFromConf) {
        this.url = urlParam == null ? "" : urlParam.trim();
        profileParam = ProfileParams.getProfileName(profileParam, true);
        this.profile = profileParam == null ? "" : profileParam.trim();
        this.pass = password == null ? "" : password.trim();
        this.hProv = 0;
        if (usePasswordFromConf.booleanValue() && this.pass.length() == 0 && this.profile.length() != 0) {
            this.verifyForBta();
            try {
                this.hProv = TumarCspFunctions.cpAcquireContext(this.profile, 64);
            }
            catch (Throwable t) {
                this.hProv = 0;
            }
        }
        if (this.hProv.longValue() == 0L) {
            try {
                Number hProvLocal = TumarCspFunctions.cpAcquireContext("", -268435456);
                this.url = this.url.length() == 0 ? TumarCspFunctions.cpUrlToNewUrl(this.profile, this.pass, 0, hProvLocal) : (this.profile.length() == 0 ? TumarCspFunctions.cpUrlToNewUrl(this.url, this.pass, 0, hProvLocal) : "");
                if (hProvLocal.longValue() != 0L) {
                    TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
                }
                this.hProv = TumarCspFunctions.cpAcquireContext(this.url, 64);
            }
            catch (Throwable t) {
                this.hProv = 0;
                throw new RuntimeException("Keys loading error. Possible cause: password is incorrect.");
            }
        }
        return true;
    }

    private void verifyForBta() {
        Number hProvLocal = 0;
        try {
            hProvLocal = TumarCspFunctions.cpAcquireContext("", -268435456);
            String urlLocal = TumarCspFunctions.cpUrlToNewUrl(this.profile, "", 1, hProvLocal);
            byte[] profileDev = TumarCspFunctions.cpGetDataFromUrl(hProvLocal, urlLocal, 3);
            byte[] profilePass = TumarCspFunctions.cpGetDataFromUrl(hProvLocal, urlLocal, 0);
            String profileDevString = null;
            String profilePassString = null;
            try {
                profileDevString = new String(profileDev, "Cp1251");
                profilePassString = new String(profilePass, "Cp1251");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (profilePassString.length() == 0 && (profileDevString.equals("kztoken") || profileDevString.equals("idcard"))) {
                throw new Exception("Password length must be more than 0 symbols for kztoken/idcard");
            }
            if (profilePassString.length() > 0 && (profileDevString.equals("kztoken") || profileDevString.equals("idcard"))) {
                this.hProv = TumarCspFunctions.cpAcquireContext(this.profile, 64);
            }
        }
        catch (Throwable t) {
            throw new CSPException(new ErrorResolver(this.hProv), "Password length must be more than 0 symbols for kztoken/idcard. Error load profile ");
        }
        finally {
            if (hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
            }
        }
    }
}

