/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import kz.gamma.jce.provider.JCEECPrivateKey;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.KeyParams;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.tumarcsp.params.StoreObjectParam;
import kz.gamma.x509.X509InstanceGetter;

public class JDKKeyStoreEx
extends KeyStoreSpi {
    private ProfileParams prm = null;
    private CSPUtil util = new CSPUtil();

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            this.prm = new ProfileParams();
        }
        catch (NoSuchProviderException e) {
            throw new IOException("Error list profile. " + e.getMessage());
        }
        catch (ParseException e) {
            throw new IOException("Error list profile. " + e.getMessage());
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyParams kps = null;
        int keySpec = 2;
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Alias cannot be null and must be longer than 1 symbol");
        }
        StoreObjectParam tmp = null;
        Enumeration en = KeyParams.makeEnumeration(this.prm.lst.toArray());
        while (en.hasMoreElements()) {
            tmp = (StoreObjectParam)en.nextElement();
            if (!alias.equalsIgnoreCase(tmp.getSn())) continue;
            kps = this.prm.profileList.get(tmp.getProfile());
            break;
        }
        if (kps == null) {
            return null;
        }
        JCEECPrivateKey privKey = null;
        Object[] algID = kps.getKeyAlgIDList();
        try {
            keySpec = this.util.getTypeKey((Integer)algID[kps.getIndexSN(alias)]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Number hProvKey = 0;
        if (tmp != null) {
            hProvKey = TumarCspFunctions.cpAcquireContext(tmp.getFullProfile(), 64);
        }
        Number hKey = TumarCspFunctions.cpGetUserKey(hProvKey, keySpec);
        if (tmp != null) {
            privKey = new JCEECPrivateKey(tmp.getFullProfile(), hProvKey, hKey);
        }
        return privKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Number hProvKey = 0;
        Number hKey = 0;
        try {
            byte[] ca;
            if (alias == null || alias.trim().equals("")) {
                throw new IllegalArgumentException("Certificate not found. Alias - " + alias);
            }
            X509Certificate caCert = null;
            int keySpec = 2;
            KeyParams kps = null;
            Certificate[] chain = null;
            StoreObjectParam tmp = null;
            Enumeration en = KeyParams.makeEnumeration(this.prm.lst.toArray());
            while (en.hasMoreElements()) {
                tmp = (StoreObjectParam)en.nextElement();
                if (!alias.equalsIgnoreCase(tmp.getSn())) continue;
                kps = this.prm.profileList.get(tmp.getProfile());
                break;
            }
            Object[] cert = new Object[]{};
            if (kps != null) {
                cert = kps.getCertificateList();
            }
            Object[] algID = kps.getKeyAlgIDList();
            try {
                keySpec = this.util.getTypeKey((Integer)algID[kps.getIndexSN(alias)]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (tmp != null) {
                hProvKey = TumarCspFunctions.cpAcquireContext(tmp.getFullProfile(), 64);
            }
            if ((ca = TumarCspFunctions.cpGetKeyParamData(hProvKey, hKey = TumarCspFunctions.cpGetUserKey(hProvKey, keySpec), 68, 0)) != null) {
                try {
                    X509InstanceGetter x509InstanceGetter = new X509InstanceGetter();
                    caCert = x509InstanceGetter.getX509CertificateInstance(ca);
                }
                catch (CertificateException e) {
                    throw new RuntimeException("Error load certificate", e);
                }
                catch (NoSuchProviderException e) {
                    throw new RuntimeException("Error load certificate. Provider not found", e);
                }
            }
            chain = new Certificate[2];
            try {
                chain[0] = (Certificate)cert[kps.getIndexSN(alias)];
            }
            catch (Exception e) {
                e.printStackTrace();
                chain[0] = null;
            }
            chain[1] = caCert;
            Certificate[] certificateArray = chain;
            return certificateArray;
        }
        finally {
            if (hKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hProvKey, hKey);
            }
            if (hProvKey.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvKey, 0);
            }
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Certificate not found alias - " + alias);
        }
        KeyParams kps = null;
        Enumeration en = KeyParams.makeEnumeration(this.prm.lst.toArray());
        while (en.hasMoreElements()) {
            StoreObjectParam tmp = (StoreObjectParam)en.nextElement();
            if (!alias.equalsIgnoreCase(tmp.getSn())) continue;
            kps = this.prm.profileList.get(tmp.getProfile());
            break;
        }
        Object[] cert = kps.getCertificateList();
        try {
            return (Certificate)cert[kps.getIndexSN(alias)];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
    }

    @Override
    public Enumeration<String> engineAliases() {
        return KeyParams.makeEnumeration(this.prm.lst.toArray());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return false;
    }

    @Override
    public int engineSize() {
        return 0;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        new Throwable("Method is not implemented");
    }
}

