/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import kz.gamma.core.UtilCM;
import kz.gamma.core.archive.GzipArchiver;
import kz.gamma.crypto.pcsc.ResponceCard;
import kz.gamma.crypto.pcsc.android.CardException;
import kz.gamma.crypto.pcsc.kztoken.KzTokenMapKeyFile;
import kz.gamma.crypto.pcsc.kztoken.TokenKzToken;
import kz.gamma.jce.exception.JCEHardwareException;
import kz.gamma.jce.provider.JCEKAZTokenPrivateKey;

public class JDKKeyStoreKAZToken
extends KeyStoreSpi {
    private TokenKzToken token;
    private String pass;
    private String readerName;
    KzTokenMapKeyFile mapKeyFile = new KzTokenMapKeyFile();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        ResponceCard responceCard = null;
        JCEKAZTokenPrivateKey ret = null;
        try {
            byte keyAlgID;
            if (alias == null || alias.trim().equals("")) {
                throw new IllegalArgumentException("Private key not found. Alias is null or empty. Alias: " + alias);
            }
            String localPass = password == null || password.length == 0 ? this.pass : new String(password);
            responceCard = this.token.verifyPin((byte)2, localPass);
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Engine get key error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
            if (!this.token.isObjectExists(this.mapKeyFile.getIdElement(alias), (short)0)) {
                throw new JCEHardwareException("Engine get key not found");
            }
            byte alg = keyAlgID = this.token.getKeyAlgID(this.mapKeyFile.getIdElement(alias));
            ret = new JCEKAZTokenPrivateKey(this.token, alias, alg, localPass, this.mapKeyFile);
        }
        catch (CardException cardException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        ResponceCard responceCard = null;
        LinkedList<Certificate> lst = new LinkedList<Certificate>();
        try {
            byte[] blob;
            if (alias == null || alias.trim().equals("")) {
                throw new IllegalArgumentException("Certificate not found. Alias - " + alias);
            }
            responceCard = this.token.getCertificate(this.mapKeyFile.getIdElement(alias));
            if (responceCard.getRetCode() == 25620) {
                responceCard = this.token.verifyPin((byte)2, this.pass);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Engine get certificate error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                responceCard = this.token.getCertificate(this.mapKeyFile.getIdElement(alias));
            }
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Engine get certificate error [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
            byte[] certBodyBlob = responceCard.getData();
            if (UtilCM.getCertificateBlob(certBodyBlob) == null) {
                GzipArchiver gzipArchiver = new GzipArchiver();
                certBodyBlob = gzipArchiver.ungzip(certBodyBlob);
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "GAMMA");
            Certificate cert = cf.generateCertificate(new ByteArrayInputStream(certBodyBlob));
            lst.add(cert);
            responceCard = this.token.getCertificate(this.mapKeyFile.getIdElement("CAcrt"));
            if (responceCard.getRetCode() == 36864 && (blob = UtilCM.getCertificateBlob(certBodyBlob = responceCard.getData())) == null) {
                GzipArchiver gzipArchiver = new GzipArchiver();
                certBodyBlob = gzipArchiver.ungzip(certBodyBlob);
                List<Certificate> certs = UtilCM.getCertificatesBlob(certBodyBlob);
                lst.addAll(certs);
            }
        }
        catch (CardException e) {
            e.printStackTrace();
            throw new JCEHardwareException("Engine get certificate error connect reader [" + this.readerName + "], " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new JCEHardwareException("Engine get certificate error parse certificate " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new JCEHardwareException("Engine get certificate error not found provider " + e.getMessage());
        }
        Certificate[] chain = new X509Certificate[lst.size()];
        for (int i = 0; i < lst.size(); ++i) {
            chain[i] = (Certificate)lst.get(i);
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        ResponceCard responceCard = null;
        Certificate cert = null;
        try {
            if (alias == null || alias.trim().equals("")) {
                throw new IllegalArgumentException("Certificate not found. Alias - " + alias);
            }
            responceCard = this.token.getCertificate(this.mapKeyFile.getIdElement(alias));
            if (responceCard.getRetCode() == 25620) {
                responceCard = this.token.verifyPin((byte)2, this.pass);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Engine get certificate error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                responceCard = this.token.getCertificate(this.mapKeyFile.getIdElement(alias));
            }
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Engine get certificate error [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
            byte[] certBodyBlob = responceCard.getData();
            if (UtilCM.getCertificateBlob(certBodyBlob) == null) {
                GzipArchiver gzipArchiver = new GzipArchiver();
                certBodyBlob = gzipArchiver.ungzip(certBodyBlob);
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "GAMMA");
            cert = cf.generateCertificate(new ByteArrayInputStream(certBodyBlob));
        }
        catch (CardException e) {
            throw new JCEHardwareException("Engine get certificate error connect reader [" + this.readerName + "], " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new JCEHardwareException("Engine get certificate error parse certificate " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new JCEHardwareException("Engine get certificate error not found provider " + e.getMessage());
        }
        return cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        ResponceCard responceCard = null;
        try {
            if (this.token.isObjectExists(this.mapKeyFile.getIdElement(alias), (short)2)) {
                throw new JCEHardwareException("Set certificate error object exists");
            }
            if (!((X509Certificate)cert).getKeyUsage()[5] && !this.token.isObjectExists(this.mapKeyFile.getIdElement(alias), (short)0)) {
                throw new JCEHardwareException("Set certificate error key not found [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
            responceCard = this.token.setCertificate(this.mapKeyFile.getIdElement(alias), cert.getEncoded());
            if (responceCard.getRetCode() == 25620) {
                responceCard = this.token.verifyPin((byte)2, this.pass);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Set certificate error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                responceCard = this.token.setCertificate(this.mapKeyFile.getIdElement(alias), cert.getEncoded());
            }
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Set certificate error [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException("Set certificate error connect reader [" + this.readerName + "], " + e.getMessage());
        }
        catch (CertificateEncodingException e) {
            throw new JCEHardwareException("Set certificate error encoding certificate, " + e.getMessage());
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        ResponceCard responceCard = null;
        try {
            if (!this.mapKeyFile.isNameExists(alias)) {
                throw new IllegalArgumentException("Engine delete entry key not found: " + alias);
            }
            responceCard = this.token.delObject(this.mapKeyFile.getIdElement(alias));
            if (responceCard.getRetCode() == 25620) {
                responceCard = this.token.verifyPin((byte)2, this.pass);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Engine delete entry error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                responceCard = this.token.delObject(this.mapKeyFile.getIdElement(alias));
            }
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Engine delete entry error del object [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
            this.mapKeyFile.delElement(alias);
            responceCard = this.token.writeContainer(this.mapKeyFile.getElementsBuffer());
            if (responceCard.getRetCode() != 36864) {
                throw new JCEHardwareException("Engine delete entry error write container [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException("Engine delete entry error connect reader [" + this.readerName + "], " + e.getMessage());
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        Object[] obj = this.mapKeyFile.getNamesElement();
        String[] aliases = new String[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            aliases[i] = (String)obj[i];
        }
        final String[] finalAliases = aliases;
        return new Enumeration(){
            int size;
            int cursor;
            {
                this.size = Array.getLength(finalAliases);
            }

            @Override
            public boolean hasMoreElements() {
                return this.cursor < this.size;
            }

            public Object nextElement() {
                return Array.get(finalAliases, this.cursor++);
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        Object responceCard = null;
        boolean isAlias = false;
        try {
            isAlias = this.token.isObjectExists(this.mapKeyFile.getIdElement(alias), (short)0) || this.token.isObjectExists(this.mapKeyFile.getIdElement(alias), (short)2);
        }
        catch (CardException e) {
            throw new JCEHardwareException("engine is alias error connect reader [" + this.readerName + "], " + e.getMessage());
        }
        return isAlias;
    }

    @Override
    public int engineSize() {
        return this.mapKeyFile.getNamesElement().length;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Object responceCard = null;
        boolean isKey = false;
        try {
            isKey = this.token.isObjectExists(this.mapKeyFile.getIdElement(alias), (short)0);
        }
        catch (CardException e) {
            throw new JCEHardwareException("engine is key error connect reader [" + this.readerName + "], " + e.getMessage());
        }
        return isKey;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        boolean isCert = false;
        try {
            isCert = this.token.isObjectExists(this.mapKeyFile.getIdElement(alias), (short)2);
        }
        catch (CardException e) {
            throw new JCEHardwareException("engine is certificate error connect reader [" + this.readerName + "], " + e.getMessage());
        }
        return isCert;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        new Throwable("Method is not implemented");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        byte[] blob = new byte[stream.available()];
        int sz = stream.read(blob);
        this.readerName = new String(blob, 0, sz, "Cp1251");
        this.pass = new String(password);
        try {
            this.token = new TokenKzToken(this.readerName);
            this.mapKeyFile.clear();
            ResponceCard responceCard = this.token.isContainer();
            if (responceCard.getRetCode() == 36864) {
                responceCard = this.token.readContainer();
                if (responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(responceCard.getRetCode()));
                }
                this.mapKeyFile.addElements(responceCard.getData());
            }
            if (this.pass.length() != 0 && (responceCard = this.token.verifyPin((byte)2, this.pass)).getRetCode() != 36864) {
                throw new JCEHardwareException("Key load error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException("Key load error connect reader [" + this.readerName + "], " + e.getMessage());
        }
    }
}

