/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import kz.gamma.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.crypto.pcsc.CreatePublicKeyHelper;
import kz.gamma.crypto.pcsc.ResponceCard;
import kz.gamma.crypto.pcsc.android.CardException;
import kz.gamma.crypto.pcsc.etoken.TokenGammaJavaToken;
import kz.gamma.crypto.pcsc.jacarta.TokenGammaJaCarta;
import kz.gamma.crypto.pcsc.kztoken.KzTokenMapKeyFile;
import kz.gamma.crypto.pcsc.kztoken.TokenKzToken;
import kz.gamma.crypto.pcsc.safenet.TokenSafeNet;
import kz.gamma.jce.exception.JCEHardwareException;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.jce.provider.JCEECPublicKey;
import kz.gamma.jce.provider.JCEJaCartaPrivateKey;
import kz.gamma.jce.provider.JCEKAZTokenPrivateKey;
import kz.gamma.jce.provider.JCESafeNetPrivateKey;
import kz.gamma.jce.provider.JCEeTokenPrivateKey;
import kz.gamma.jce.provider.JDKKeyPairGenerator;

public class JDKTokenKeyPairGenerator
extends KeyPairGenerator {
    protected JDKTokenKeyPairGenerator(String algorithm) {
        super(algorithm);
    }

    public static class KAZTokenGenerator
    extends JDKKeyPairGenerator {
        private String readerName;
        private String nameKey;
        private String password;
        private boolean initialized = false;
        private boolean isKZOID = false;
        private int alg = 0;

        public KAZTokenGenerator() {
            super("ECGOST34310");
        }

        public KAZTokenGenerator(String algorithm) {
            super(algorithm);
        }

        public void setReaderName(String readerName, String nameKey, String password) {
            this.readerName = readerName;
            this.nameKey = nameKey;
            this.password = password == null ? "" : password.trim();
            this.initialized = true;
        }

        public void setParametr(int alg, boolean isKZOID) {
            this.alg = alg;
            this.isKZOID = isKZOID;
        }

        @Override
        public KeyPair generateKeyPair() {
            String keyOID;
            int keyAlgID = 1;
            TokenKzToken token = null;
            KeyPair ret = null;
            if (!this.initialized) {
                throw new JCEHardwareException("Key Pair Generator not initialized. Reader not found");
            }
            if (this.password.length() == 0) {
                throw new JCEHardwareException("Key Pair Generator not initialized. password not found");
            }
            if (this.alg == 1) {
                keyAlgID = 1;
                keyOID = this.isKZOID ? KZObjectIndentifiers.GOST_34_310_KEY_A.getId() : GammaTechProvider.getAlgUtil().getOID(43578);
            } else if (this.alg == 2) {
                keyAlgID = 4;
                if (this.isKZOID) {
                    throw new JCEHardwareException("Algorithm not supported");
                }
                keyOID = GammaTechProvider.getAlgUtil().getOID(41029);
            } else {
                throw new JCEHardwareException("Unknown algorithm type: " + this.alg);
            }
            try {
                KzTokenMapKeyFile mapKeyFile = new KzTokenMapKeyFile();
                token = new TokenKzToken(this.readerName);
                ResponceCard responceCard = token.verifyPin((byte)2, this.password);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                mapKeyFile.clear();
                responceCard = token.isContainer();
                if (responceCard.getRetCode() == 36864) {
                    responceCard = token.readContainer();
                    if (responceCard.getRetCode() != 36864) {
                        throw new CardException(Integer.toString(responceCard.getRetCode()));
                    }
                    mapKeyFile.addElements(responceCard.getData());
                }
                byte newId = mapKeyFile.getUniqueElement();
                mapKeyFile.addElement(this.nameKey, newId);
                responceCard = token.writeContainer(mapKeyFile.getElementsBuffer());
                if (responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(responceCard.getRetCode()));
                }
                responceCard = token.genKeyPair(keyAlgID, newId);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error generate key [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                ret = new KeyPair(new JCEECPublicKey(CreatePublicKeyHelper.getBlob(this.alg, this.isKZOID, responceCard.getData()), keyOID), new JCEKAZTokenPrivateKey(token, this.nameKey, this.alg, this.password, mapKeyFile));
            }
            catch (CardException e) {
                throw new JCEHardwareException("Key Pair Generator error connect reader [" + this.readerName + "], " + e.getMessage());
            }
            return ret;
        }
    }

    public static class SafeNetGenerator
    extends JDKKeyPairGenerator {
        private String readerName;
        private String nameKey;
        private String password;
        private boolean initialized = false;
        private boolean isKZOID = false;
        private int alg = 0;

        public SafeNetGenerator() {
            super("ECGOST34310");
        }

        public SafeNetGenerator(String algorithm) {
            super(algorithm);
        }

        public void setReaderName(String readerName, String nameKey, String password) {
            this.readerName = readerName;
            this.nameKey = nameKey;
            this.password = password == null ? "" : password.trim();
            this.initialized = true;
        }

        public void setParametr(int alg, boolean isKZOID) {
            this.alg = alg;
            this.isKZOID = isKZOID;
        }

        @Override
        public KeyPair generateKeyPair() {
            String keyOID;
            byte keyAlgID = 1;
            TokenSafeNet tokenSafeNet = null;
            KeyPair ret = null;
            if (!this.initialized) {
                throw new JCEHardwareException("Key Pair Generator not initialized. Reader not found");
            }
            if (this.password.length() == 0) {
                throw new JCEHardwareException("Key Pair Generator not initialized. password not found");
            }
            if (this.alg == 1) {
                keyAlgID = 1;
                keyOID = this.isKZOID ? KZObjectIndentifiers.GOST_34_310_KEY_A.getId() : GammaTechProvider.getAlgUtil().getOID(43578);
            } else if (this.alg == 2) {
                keyAlgID = 4;
                if (this.isKZOID) {
                    throw new JCEHardwareException("Algorithm not supported");
                }
                keyOID = GammaTechProvider.getAlgUtil().getOID(41029);
            } else {
                throw new JCEHardwareException("Unknown algorithm type: " + this.alg);
            }
            try {
                tokenSafeNet = new TokenSafeNet(this.readerName);
                ResponceCard responceCard = tokenSafeNet.selectAplet();
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error applet not available");
                }
                responceCard = tokenSafeNet.verifyPin(this.password);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                responceCard = tokenSafeNet.createKey(this.nameKey, keyAlgID);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error generate key [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                ret = new KeyPair(new JCEECPublicKey(CreatePublicKeyHelper.getBlob(this.alg, this.isKZOID, responceCard.getData()), keyOID), new JCESafeNetPrivateKey(tokenSafeNet, this.nameKey, this.alg, this.password));
            }
            catch (CardException e) {
                throw new JCEHardwareException("Key Pair Generator error connect reader [" + this.readerName + "], " + e.getMessage());
            }
            return ret;
        }
    }

    public static class eTokenGenerator
    extends JDKKeyPairGenerator {
        private String readerName;
        private String nameKey;
        private String password;
        private boolean initialized = false;
        private boolean isKZOID = false;
        private int alg = 0;

        protected eTokenGenerator(String algorithm) {
            super(algorithm);
        }

        public void setReaderName(String readerName, String nameKey, String password) {
            this.readerName = readerName;
            this.nameKey = nameKey;
            this.password = password == null ? "" : password.trim();
            this.initialized = true;
        }

        public void setParametr(int alg, boolean isKZOID) {
            this.alg = alg;
            this.isKZOID = isKZOID;
        }

        @Override
        public KeyPair generateKeyPair() {
            String keyOID;
            byte keyAlgID = 1;
            TokenGammaJavaToken tokenGammaJavaToken = null;
            KeyPair ret = null;
            if (!this.initialized) {
                throw new JCEHardwareException("Key Pair Generator not initialized. Reader not found");
            }
            if (this.password.length() == 0) {
                throw new JCEHardwareException("Key Pair Generator not initialized. password not found");
            }
            if (this.alg == 1) {
                keyAlgID = 1;
                keyOID = this.isKZOID ? KZObjectIndentifiers.GOST_34_310_KEY_A.getId() : GammaTechProvider.getAlgUtil().getOID(43578);
            } else if (this.alg == 2) {
                keyAlgID = 4;
                if (this.isKZOID) {
                    throw new JCEHardwareException("Algorithm not supported");
                }
                keyOID = GammaTechProvider.getAlgUtil().getOID(41029);
            } else {
                throw new JCEHardwareException("Unknown algorithm type: " + this.alg);
            }
            try {
                tokenGammaJavaToken = new TokenGammaJavaToken(this.readerName);
                ResponceCard responceCard = tokenGammaJavaToken.selectApplet();
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error applet not available");
                }
                responceCard = tokenGammaJavaToken.verifyPin(this.password);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                responceCard = tokenGammaJavaToken.createKey(this.nameKey, keyAlgID);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error generate key [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                ret = new KeyPair(new JCEECPublicKey(CreatePublicKeyHelper.getBlob(this.alg, this.isKZOID, responceCard.getData()), keyOID), new JCEeTokenPrivateKey(tokenGammaJavaToken, this.alg, this.password));
            }
            catch (CardException e) {
                throw new JCEHardwareException("Key Pair Generator error connect reader [" + this.readerName + "], " + e.getMessage());
            }
            return ret;
        }
    }

    public static class JaCartaGenerator
    extends JDKKeyPairGenerator {
        private String readerName;
        private String nameKey;
        private String password;
        private boolean initialized = false;
        private boolean isKZOID = false;
        private int alg = 0;

        public JaCartaGenerator() {
            super("ECGOST34310");
        }

        public JaCartaGenerator(String algorithm) {
            super(algorithm);
        }

        public void setReaderName(String readerName, String nameKey, String password) {
            this.readerName = readerName;
            this.nameKey = nameKey;
            this.password = password == null ? "" : password.trim();
            this.initialized = true;
        }

        public void setParametr(int alg, boolean isKZOID) {
            this.alg = alg;
            this.isKZOID = isKZOID;
        }

        @Override
        public KeyPair generateKeyPair() {
            String keyOID;
            byte keyAlgID = 1;
            TokenGammaJaCarta tokenGammaJaCarta = null;
            KeyPair ret = null;
            if (!this.initialized) {
                throw new JCEHardwareException("Key Pair Generator not initialized. Reader not found");
            }
            if (this.password.length() == 0) {
                throw new JCEHardwareException("Key Pair Generator not initialized. password not found");
            }
            if (this.alg == 1) {
                keyAlgID = 1;
                keyOID = this.isKZOID ? KZObjectIndentifiers.GOST_34_310_KEY_A.getId() : GammaTechProvider.getAlgUtil().getOID(43578);
            } else if (this.alg == 2) {
                keyAlgID = 4;
                if (this.isKZOID) {
                    throw new JCEHardwareException("Algorithm not supported");
                }
                keyOID = GammaTechProvider.getAlgUtil().getOID(41029);
            } else {
                throw new JCEHardwareException("Unknown algorithm type: " + this.alg);
            }
            try {
                tokenGammaJaCarta = new TokenGammaJaCarta(this.readerName);
                ResponceCard responceCard = tokenGammaJaCarta.selectApplet();
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error applet not available");
                }
                responceCard = tokenGammaJaCarta.verifyPin(this.password);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error password not correct [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                responceCard = tokenGammaJaCarta.createKey(this.nameKey, keyAlgID);
                if (responceCard.getRetCode() != 36864) {
                    throw new JCEHardwareException("Key Pair Generator error generate key [" + Integer.toString(responceCard.getRetCode()) + "]");
                }
                ret = new KeyPair(new JCEECPublicKey(CreatePublicKeyHelper.getBlob(this.alg, this.isKZOID, responceCard.getData()), keyOID), new JCEJaCartaPrivateKey(tokenGammaJaCarta, this.nameKey, this.alg, this.password));
            }
            catch (CardException e) {
                throw new JCEHardwareException("Key Pair Generator error connect reader [" + this.readerName + "], " + e.getMessage());
            }
            return ret;
        }
    }
}

