/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.AlgorithmParameterSpec;
import kz.gamma.core.UtilCM;
import kz.gamma.jce.exception.JCEException;
import kz.gamma.jce.provider.PKCS11AlgorithmParameterSpec;
import kz.gamma.jce.provider.PKCS11PrivateKey;
import kz.gamma.jce.provider.PKCS11PublicKey;
import kz.gamma.pkcs11.jna.CK_ATTRIBUTE;
import kz.gamma.pkcs11.jna.CK_MECHANISM;
import kz.gamma.pkcs11.jna.PKCS11Utils;
import kz.gamma.pkcs11.jna.Pkcs11JnaWrapper;

public class PKCS11KeyPairGenerator
extends KeyPairGenerator {
    private char[] pass;
    private String keyLabel;
    private int keySize;
    private boolean isKeyExchange;
    private long session;

    protected PKCS11KeyPairGenerator(String algorithm) {
        super(algorithm);
    }

    public PKCS11KeyPairGenerator() {
        super("RSA");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof PKCS11AlgorithmParameterSpec)) {
            throw new IllegalArgumentException("Wrong params");
        }
        this.pass = ((PKCS11AlgorithmParameterSpec)params).getPass();
        this.keyLabel = ((PKCS11AlgorithmParameterSpec)params).getKeyLabel();
        this.keySize = ((PKCS11AlgorithmParameterSpec)params).getKeySize();
        this.isKeyExchange = ((PKCS11AlgorithmParameterSpec)params).isKeyExchange();
        this.session = PKCS11Utils.connect(this.pass);
    }

    @Override
    public KeyPair generateKeyPair() {
        try {
            if (PKCS11Utils.isEntryExists(this.session, this.keyLabel, 3L)) {
                throw new JCEException("key already exists");
            }
            byte[] keyId = UtilCM.makeIDKey();
            CK_MECHANISM ckmRSAKeyGenMech = new CK_MECHANISM(0L);
            CK_ATTRIBUTE[] publicKeyTemplates = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(9);
            publicKeyTemplates[0].setAttr((Long)0L, 2L);
            publicKeyTemplates[1].setAttr((Long)3L, this.keyLabel);
            publicKeyTemplates[2].setAttr((Long)258L, keyId);
            publicKeyTemplates[3].setAttr((Long)1L, true);
            publicKeyTemplates[4].setAttr((Long)260L, this.isKeyExchange);
            publicKeyTemplates[5].setAttr((Long)266L, true);
            publicKeyTemplates[6].setAttr((Long)2L, false);
            publicKeyTemplates[7].setAttr((Long)289L, this.keySize);
            publicKeyTemplates[8].setAttr((Long)290L, PKCS11Utils.publicExponent);
            CK_ATTRIBUTE[] privateKeyTemplates = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(7);
            privateKeyTemplates[0].setAttr((Long)0L, 3L);
            privateKeyTemplates[1].setAttr((Long)3L, this.keyLabel);
            privateKeyTemplates[2].setAttr((Long)258L, keyId);
            privateKeyTemplates[3].setAttr((Long)261L, this.isKeyExchange);
            privateKeyTemplates[4].setAttr((Long)264L, true);
            privateKeyTemplates[5].setAttr((Long)1L, true);
            privateKeyTemplates[6].setAttr((Long)2L, true);
            long[] hKeys = Pkcs11JnaWrapper.C_GenerateKeyPair(this.session, ckmRSAKeyGenMech, publicKeyTemplates, privateKeyTemplates);
            byte[] publicKeyValue = PKCS11Utils.getPublicKeyValue(this.session, hKeys[0]);
            KeyPair ret = new KeyPair(new PKCS11PublicKey(publicKeyValue), new PKCS11PrivateKey(this.keyLabel, this.pass, publicKeyValue.length));
            return ret;
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    protected void finalize() {
        PKCS11Utils.closeSession(this.session);
    }
}

