/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.X509CertificateStructure;
import kz.gamma.jce.exception.JCEException;
import kz.gamma.jce.provider.PKCS11PrivateKey;
import kz.gamma.pkcs11.jna.CK_ATTRIBUTE;
import kz.gamma.pkcs11.jna.PKCS11Utils;
import kz.gamma.pkcs11.jna.Pkcs11Exception;
import kz.gamma.pkcs11.jna.Pkcs11JnaWrapper;

public class PKCS11KeyStore
extends KeyStoreSpi {
    private char[] pass;
    private long session;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Private key not found. Alias is null or empty. Alias: " + alias);
        }
        if (password != null && password.length > 0 && !Arrays.equals(password, this.pass)) {
            throw new IllegalArgumentException("The password is different from the password passed during initialization");
        }
        return new PKCS11PrivateKey(alias, this.pass, PKCS11Utils.getPublicKeyLength(this.session, alias));
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return new Certificate[0];
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Certificate not found. Alias - " + alias);
        }
        byte[] certBodyBlob = null;
        try {
            CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(2);
            attributes[0].setAttr((Long)0L, 1L);
            attributes[1].setAttr((Long)3L, alias);
            Pkcs11JnaWrapper.C_FindObjectsInit(this.session, attributes);
            long[] objects = Pkcs11JnaWrapper.C_FindObjects(this.session, 1);
            Pkcs11JnaWrapper.C_FindObjectsFinal(this.session);
            if (objects != null && objects.length > 0) {
                CK_ATTRIBUTE[] certAttr = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
                certAttr[0].setAttr(17L);
                Pkcs11JnaWrapper.C_GetAttributeValue(this.session, objects[0], certAttr);
                if (certAttr[0].pValue == null) {
                    throw new Exception("CKA_VALUE was not found");
                }
                certBodyBlob = certAttr[0].getByteArray();
            }
            if (certBodyBlob == null) {
                return null;
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "GAMMA");
            Certificate cert = cf.generateCertificate(new ByteArrayInputStream(certBodyBlob));
            return cert;
        }
        catch (Exception e) {
            throw new JCEException("engineGetCertificate error: " + e.getMessage());
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Alias is null or empty. Alias: " + alias);
        }
        if (this.engineIsCertificateEntry(alias)) {
            throw new JCEException("certificate already exists");
        }
        if (!this.engineIsKeyEntry(alias)) {
            throw new JCEException("key not found");
        }
        try {
            this.setCertificate(this.session, alias, cert.getEncoded());
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Private key not found. Alias is null or empty. Alias: " + alias);
        }
        try {
            PKCS11KeyStore.deleteKey(this.session, alias);
        }
        catch (Exception e) {
            throw new JCEException("engine error: " + e.getMessage());
        }
    }

    public static void deleteKey(long p11_session, String name) throws Exception {
        try {
            int i;
            CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(2);
            attributes[0].setAttr((Long)0L, 3L);
            attributes[1].setAttr((Long)3L, name);
            Pkcs11JnaWrapper.C_FindObjectsInit(p11_session, attributes);
            long[] objects = Pkcs11JnaWrapper.C_FindObjects(p11_session, 64);
            Pkcs11JnaWrapper.C_FindObjectsFinal(p11_session);
            byte[] ckaId = null;
            if (objects != null && objects.length > 0) {
                CK_ATTRIBUTE[] secretKeyAttr = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
                secretKeyAttr[0].setAttr(258L);
                Pkcs11JnaWrapper.C_GetAttributeValue(p11_session, objects[0], secretKeyAttr);
                if (secretKeyAttr[0].pValue == null) {
                    throw new Exception("CKA_ID for '" + name + "' was not found");
                }
                ckaId = secretKeyAttr[0].getByteArray();
                Pkcs11JnaWrapper.C_DestroyObject(p11_session, objects[0]);
            }
            CK_ATTRIBUTE[] ck_attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(2);
            ck_attributes[0].setAttr((Long)0L, 2L);
            ck_attributes[1].setAttr((Long)3L, name);
            Pkcs11JnaWrapper.C_FindObjectsInit(p11_session, ck_attributes);
            objects = Pkcs11JnaWrapper.C_FindObjects(p11_session, 64);
            Pkcs11JnaWrapper.C_FindObjectsFinal(p11_session);
            if (objects != null) {
                for (i = 0; i < objects.length; ++i) {
                    Pkcs11JnaWrapper.C_DestroyObject(p11_session, objects[i]);
                }
            }
            if (ckaId != null) {
                ck_attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(3);
                ck_attributes[0].setAttr((Long)0L, 1L);
                ck_attributes[1].setAttr((Long)3L, name);
                ck_attributes[2].setAttr((Long)258L, ckaId);
                Pkcs11JnaWrapper.C_FindObjectsInit(p11_session, ck_attributes);
                objects = Pkcs11JnaWrapper.C_FindObjects(p11_session, 64);
                Pkcs11JnaWrapper.C_FindObjectsFinal(p11_session);
                if (objects != null) {
                    for (i = 0; i < objects.length; ++i) {
                        Pkcs11JnaWrapper.C_DestroyObject(p11_session, objects[i]);
                    }
                }
            }
        }
        catch (Pkcs11Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
            attributes[0].setAttr((Long)0L, 3L);
            Pkcs11JnaWrapper.C_FindObjectsInit(this.session, attributes);
            long[] objects = Pkcs11JnaWrapper.C_FindObjects(this.session, 64);
            Pkcs11JnaWrapper.C_FindObjectsFinal(this.session);
            if (objects != null) {
                for (int i = 0; i < objects.length; ++i) {
                    CK_ATTRIBUTE[] secretKeyAttr = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
                    secretKeyAttr[0].setAttr(3L);
                    try {
                        Pkcs11JnaWrapper.C_GetAttributeValue(this.session, objects[i], secretKeyAttr);
                        if (secretKeyAttr[0].pValue == null) {
                            throw new Exception("CKA_LABEL was not found");
                        }
                        String name = secretKeyAttr[0].getString();
                        aliases.add(name);
                        continue;
                    }
                    catch (Pkcs11Exception e) {
                        if (e.getErrorCode() == -2130706431L) continue;
                        throw e;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new JCEException("engineAliases error: " + e.getMessage());
        }
        return Collections.enumeration(aliases);
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return PKCS11Utils.isEntryExists(this.session, alias, 3L);
    }

    @Override
    public int engineSize() {
        return this.getPrivateKeyCount();
    }

    private int getPrivateKeyCount() {
        try {
            CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
            attributes[0].setAttr((Long)0L, 3L);
            Pkcs11JnaWrapper.C_FindObjectsInit(this.session, attributes);
            long[] objects = Pkcs11JnaWrapper.C_FindObjects(this.session, 1);
            Pkcs11JnaWrapper.C_FindObjectsFinal(this.session);
            if (objects != null) {
                return objects.length;
            }
            return 0;
        }
        catch (Exception e) {
            throw new JCEException("engine error: " + e.getMessage());
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return PKCS11Utils.isEntryExists(this.session, alias, 3L);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return PKCS11Utils.isEntryExists(this.session, alias, 1L);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.session = PKCS11Utils.connect(password);
        this.pass = password;
    }

    public void setCertificate(long p11_session, String alias, byte[] cert) {
        byte[] ckaId;
        try {
            CK_ATTRIBUTE[] secretKeyAttr;
            CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(2);
            attributes[0].setAttr((Long)0L, 3L);
            attributes[1].setAttr((Long)3L, alias);
            Pkcs11JnaWrapper.C_FindObjectsInit(this.session, attributes);
            long[] objects = Pkcs11JnaWrapper.C_FindObjects(this.session, 1);
            Pkcs11JnaWrapper.C_FindObjectsFinal(this.session);
            if (objects != null && objects.length > 0) {
                secretKeyAttr = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
                secretKeyAttr[0].setAttr(258L);
                Pkcs11JnaWrapper.C_GetAttributeValue(this.session, objects[0], secretKeyAttr);
                if (secretKeyAttr[0].pValue == null) {
                    throw new Exception("CKA_ID was not found");
                }
            } else {
                throw new JCEException("engine error: private key not found");
            }
            ckaId = secretKeyAttr[0].getByteArray();
        }
        catch (Exception e) {
            throw new JCEException("engine error: " + e.getMessage());
        }
        try {
            ASN1InputStream in = new ASN1InputStream(cert);
            DERSequence crtBlob = (DERSequence)in.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(crtBlob);
            CK_ATTRIBUTE[] certAttributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(9);
            certAttributes[0].setAttr((Long)0L, 1L);
            certAttributes[1].setAttr((Long)3L, alias);
            certAttributes[2].setAttr((Long)258L, ckaId);
            certAttributes[3].setAttr((Long)1L, true);
            certAttributes[4].setAttr((Long)128L, 0L);
            certAttributes[5].setAttr((Long)257L, x509CertificateStructure.getSubject().getDEREncoded());
            certAttributes[6].setAttr((Long)129L, x509CertificateStructure.getIssuer().getDEREncoded());
            certAttributes[7].setAttr((Long)130L, x509CertificateStructure.getSerialNumber().getDEREncoded());
            certAttributes[8].setAttr((Long)17L, cert);
            Pkcs11JnaWrapper.C_CreateObject(p11_session, certAttributes);
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    protected void finalize() {
        PKCS11Utils.closeSession(this.session);
    }
}

