/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.security.MessageDigest;
import kz.gamma.jce.exception.JCEException;
import kz.gamma.pkcs11.jna.PKCS11Utils;
import kz.gamma.pkcs11.jna.Pkcs11JnaWrapper;

public class PKCS11MessageDigest
extends MessageDigest {
    private long session;

    public PKCS11MessageDigest() {
        super("SHA256");
    }

    protected PKCS11MessageDigest(String algorithm) {
        super(algorithm);
    }

    @Override
    protected void engineUpdate(byte input) {
        try {
            Pkcs11JnaWrapper.C_DigestUpdate(this.session, new byte[]{input});
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        try {
            byte[] dataPart = new byte[len];
            System.arraycopy(input, offset, dataPart, 0, len);
            Pkcs11JnaWrapper.C_DigestUpdate(this.session, dataPart);
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    @Override
    protected byte[] engineDigest() {
        try {
            return Pkcs11JnaWrapper.C_DigestFinal(this.session, 32);
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    @Override
    protected void engineReset() {
        try {
            this.session = PKCS11Utils.connect(null);
            Pkcs11JnaWrapper.C_DigestInit(this.session, 592L);
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    protected void finalize() {
        PKCS11Utils.closeSession(this.session);
    }
}

