/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import kz.gamma.jce.exception.JCEException;
import kz.gamma.jce.provider.PKCS11PrivateKey;
import kz.gamma.pkcs11.jna.PKCS11Utils;
import kz.gamma.pkcs11.jna.Pkcs11JnaWrapper;

public class PKCS11Signature
extends Signature {
    private boolean isSign;
    private long session;
    private int publicKeyLength;
    private long tempPublicKeyId = 0L;

    public PKCS11Signature() {
        super("RSA");
    }

    protected PKCS11Signature(String algorithm) {
        super(algorithm);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            this.session = PKCS11Utils.connect(null);
            byte[] publicKeyValue = publicKey.getEncoded();
            long publicKeyId = PKCS11Utils.getPublicKey(this.session, publicKeyValue);
            if (publicKeyId == 0L) {
                this.removeTempPublicKey();
                this.tempPublicKeyId = publicKeyId = PKCS11Utils.createPublicKey(this.session, publicKeyValue);
            }
            Pkcs11JnaWrapper.C_VerifyInit(this.session, 64L, publicKeyId);
            this.isSign = false;
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof PKCS11PrivateKey)) {
            throw new IllegalArgumentException("wrong privateKey");
        }
        try {
            this.session = PKCS11Utils.connect(((PKCS11PrivateKey)privateKey).getPassword());
            this.publicKeyLength = ((PKCS11PrivateKey)privateKey).getPublicKeyLength();
            long privateKeyId = PKCS11Utils.getPrivateKeyId(this.session, ((PKCS11PrivateKey)privateKey).getName());
            Pkcs11JnaWrapper.C_SignInit(this.session, 64L, privateKeyId);
            this.isSign = true;
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        try {
            if (this.isSign) {
                Pkcs11JnaWrapper.C_SignUpdate(this.session, new byte[]{b});
            } else {
                Pkcs11JnaWrapper.C_VerifyUpdate(this.session, new byte[]{b});
            }
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        try {
            byte[] dataPart = new byte[len];
            System.arraycopy(b, off, dataPart, 0, len);
            if (this.isSign) {
                Pkcs11JnaWrapper.C_SignUpdate(this.session, dataPart);
            } else {
                Pkcs11JnaWrapper.C_VerifyUpdate(this.session, dataPart);
            }
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            if (!this.isSign) {
                throw new JCEException("Operation not initialized");
            }
            return Pkcs11JnaWrapper.C_SignFinal(this.session, this.publicKeyLength);
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        try {
            if (this.isSign) {
                throw new JCEException("Operation not initialized");
            }
            boolean bl = Pkcs11JnaWrapper.C_VerifyFinal(this.session, sigBytes);
            return bl;
        }
        catch (Exception e) {
            throw new JCEException(e);
        }
        finally {
            this.removeTempPublicKey();
        }
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    private void removeTempPublicKey() {
        if (this.tempPublicKeyId != 0L) {
            try {
                Pkcs11JnaWrapper.C_DestroyObject(this.session, this.tempPublicKeyId);
                this.tempPublicKeyId = 0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() {
        this.removeTempPublicKey();
        PKCS11Utils.closeSession(this.session);
    }
}

