/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.security.cert.CertPathValidatorException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DERIA5String;
import kz.gamma.asn1.x509.GeneralName;
import kz.gamma.asn1.x509.GeneralSubtree;
import kz.gamma.util.Arrays;
import kz.gamma.util.Strings;

public class PKIXNameConstraints {
    private Set excludedSubtreesDN = new HashSet();
    private Set excludedSubtreesDNS = new HashSet();
    private Set excludedSubtreesEmail = new HashSet();
    private Set excludedSubtreesURI = new HashSet();
    private Set excludedSubtreesIP = new HashSet();
    private Set permittedSubtreesDN;
    private Set permittedSubtreesDNS;
    private Set permittedSubtreesEmail;
    private Set permittedSubtreesURI;
    private Set permittedSubtreesIP;

    private static boolean withinDNSubtree(ASN1Sequence dns, ASN1Sequence subtree) {
        if (subtree.size() < 1) {
            return false;
        }
        if (subtree.size() > dns.size()) {
            return false;
        }
        for (int j = subtree.size() - 1; j >= 0; --j) {
            if (subtree.getObjectAt(j).equals(dns.getObjectAt(j))) continue;
            return false;
        }
        return true;
    }

    public void checkPermittedDN(ASN1Sequence dns) throws CertPathValidatorException {
        this.checkPermittedDN(this.permittedSubtreesDN, dns);
    }

    public void checkExcludedDN(ASN1Sequence dns) throws CertPathValidatorException {
        this.checkExcludedDN(this.excludedSubtreesDN, dns);
    }

    private void checkPermittedDN(Set permitted, ASN1Sequence dns) throws CertPathValidatorException {
        if (permitted == null) {
            return;
        }
        for (ASN1Sequence subtree : permitted) {
            if (!PKIXNameConstraints.withinDNSubtree(dns, subtree)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkExcludedDN(Set excluded, ASN1Sequence dns) throws CertPathValidatorException {
        if (excluded.isEmpty()) {
            return;
        }
        for (ASN1Sequence subtree : excluded) {
            if (!PKIXNameConstraints.withinDNSubtree(dns, subtree)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private Set intersectDN(Set permitted, ASN1Sequence dn) {
        HashSet<ASN1Sequence> intersect = new HashSet<ASN1Sequence>();
        if (permitted == null) {
            if (dn == null) {
                return intersect;
            }
            intersect.add(dn);
            return intersect;
        }
        for (ASN1Sequence subtree : permitted) {
            if (PKIXNameConstraints.withinDNSubtree(dn, subtree)) {
                intersect.add(dn);
                continue;
            }
            if (!PKIXNameConstraints.withinDNSubtree(subtree, dn)) continue;
            intersect.add(subtree);
        }
        return intersect;
    }

    private Set unionDN(Set excluded, ASN1Sequence dn) {
        if (excluded.isEmpty()) {
            if (dn == null) {
                return excluded;
            }
            excluded.add(dn);
            return excluded;
        }
        HashSet<ASN1Sequence> intersect = new HashSet<ASN1Sequence>();
        for (ASN1Sequence subtree : excluded) {
            if (PKIXNameConstraints.withinDNSubtree(dn, subtree)) {
                intersect.add(subtree);
                continue;
            }
            if (PKIXNameConstraints.withinDNSubtree(subtree, dn)) {
                intersect.add(dn);
                continue;
            }
            intersect.add(subtree);
            intersect.add(dn);
        }
        return intersect;
    }

    private Set intersectEmail(Set permitted, String email) {
        HashSet<String> intersect = new HashSet<String>();
        if (permitted == null) {
            if (email == null) {
                return intersect;
            }
            intersect.add(email);
            return intersect;
        }
        for (String _permitted : permitted) {
            this.intersectEmail(email, _permitted, intersect);
        }
        return intersect;
    }

    private Set unionEmail(Set excluded, String email) {
        if (excluded.isEmpty()) {
            if (email == null) {
                return excluded;
            }
            excluded.add(email);
            return excluded;
        }
        HashSet union = new HashSet();
        for (String _excluded : excluded) {
            this.unionEmail(_excluded, email, union);
        }
        return union;
    }

    private Set intersectIP(Set permitted, byte[] ip) {
        HashSet<byte[]> intersect = new HashSet<byte[]>();
        if (permitted == null) {
            if (ip == null) {
                return intersect;
            }
            intersect.add(ip);
            return intersect;
        }
        for (byte[] _permitted : permitted) {
            intersect.addAll(this.intersectIPRange(_permitted, ip));
        }
        return intersect;
    }

    private Set unionIP(Set excluded, byte[] ip) {
        if (excluded.isEmpty()) {
            if (ip == null) {
                return excluded;
            }
            excluded.add(ip);
            return excluded;
        }
        HashSet union = new HashSet();
        for (byte[] _excluded : excluded) {
            union.addAll(this.unionIPRange(_excluded, ip));
        }
        return union;
    }

    private Set unionIPRange(byte[] ipWithSubmask1, byte[] ipWithSubmask2) {
        HashSet<byte[]> set = new HashSet<byte[]>();
        if (Arrays.areEqual(ipWithSubmask1, ipWithSubmask2)) {
            set.add(ipWithSubmask1);
        } else {
            set.add(ipWithSubmask1);
            set.add(ipWithSubmask2);
        }
        return set;
    }

    private Set intersectIPRange(byte[] ipWithSubmask1, byte[] ipWithSubmask2) {
        if (ipWithSubmask1.length != ipWithSubmask2.length) {
            return Collections.EMPTY_SET;
        }
        byte[][] temp = this.extractIPsAndSubnetMasks(ipWithSubmask1, ipWithSubmask2);
        byte[] ip1 = temp[0];
        byte[] subnetmask1 = temp[1];
        byte[] ip2 = temp[2];
        byte[] subnetmask2 = temp[3];
        byte[][] minMax = this.minMaxIPs(ip1, subnetmask1, ip2, subnetmask2);
        byte[] max = PKIXNameConstraints.min(minMax[1], minMax[3]);
        byte[] min = PKIXNameConstraints.max(minMax[0], minMax[2]);
        if (PKIXNameConstraints.compareTo(min, max) == 1) {
            return Collections.EMPTY_SET;
        }
        byte[] ip = PKIXNameConstraints.or(minMax[0], minMax[2]);
        byte[] subnetmask = PKIXNameConstraints.or(subnetmask1, subnetmask2);
        return Collections.singleton(this.ipWithSubnetMask(ip, subnetmask));
    }

    private byte[] ipWithSubnetMask(byte[] ip, byte[] subnetMask) {
        int ipLength = ip.length;
        byte[] temp = new byte[ipLength * 2];
        System.arraycopy(ip, 0, temp, 0, ipLength);
        System.arraycopy(subnetMask, 0, temp, ipLength, ipLength);
        return temp;
    }

    private byte[][] extractIPsAndSubnetMasks(byte[] ipWithSubmask1, byte[] ipWithSubmask2) {
        int ipLength = ipWithSubmask1.length / 2;
        byte[] ip1 = new byte[ipLength];
        byte[] subnetmask1 = new byte[ipLength];
        System.arraycopy(ipWithSubmask1, 0, ip1, 0, ipLength);
        System.arraycopy(ipWithSubmask1, ipLength, subnetmask1, 0, ipLength);
        byte[] ip2 = new byte[ipLength];
        byte[] subnetmask2 = new byte[ipLength];
        System.arraycopy(ipWithSubmask2, 0, ip2, 0, ipLength);
        System.arraycopy(ipWithSubmask2, ipLength, subnetmask2, 0, ipLength);
        return new byte[][]{ip1, subnetmask1, ip2, subnetmask2};
    }

    private byte[][] minMaxIPs(byte[] ip1, byte[] subnetmask1, byte[] ip2, byte[] subnetmask2) {
        int ipLength = ip1.length;
        byte[] min1 = new byte[ipLength];
        byte[] max1 = new byte[ipLength];
        byte[] min2 = new byte[ipLength];
        byte[] max2 = new byte[ipLength];
        for (int i = 0; i < ipLength; ++i) {
            min1[i] = (byte)(ip1[i] & subnetmask1[i]);
            max1[i] = (byte)(ip1[i] & subnetmask1[i] | ~subnetmask1[i]);
            min2[i] = (byte)(ip2[i] & subnetmask2[i]);
            max2[i] = (byte)(ip2[i] & subnetmask2[i] | ~subnetmask2[i]);
        }
        return new byte[][]{min1, max1, min2, max2};
    }

    private void checkPermittedEmail(Set permitted, String email) throws CertPathValidatorException {
        if (permitted == null) {
            return;
        }
        for (String str : permitted) {
            if (!this.emailIsConstrained(email, str)) continue;
            return;
        }
        if (email.length() == 0 && permitted.size() == 0) {
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree.");
    }

    private void checkExcludedEmail(Set excluded, String email) throws CertPathValidatorException {
        if (excluded.isEmpty()) {
            return;
        }
        for (String str : excluded) {
            if (!this.emailIsConstrained(email, str)) continue;
            throw new CertPathValidatorException("Email address is from an excluded subtree.");
        }
    }

    private void checkPermittedIP(Set permitted, byte[] ip) throws CertPathValidatorException {
        if (permitted == null) {
            return;
        }
        for (byte[] ipWithSubnet : permitted) {
            if (!this.isIPConstrained(ip, ipWithSubnet)) continue;
            return;
        }
        if (ip.length == 0 && permitted.size() == 0) {
            return;
        }
        throw new CertPathValidatorException("IP is not from a permitted subtree.");
    }

    private void checkExcludedIP(Set excluded, byte[] ip) throws CertPathValidatorException {
        if (excluded.isEmpty()) {
            return;
        }
        for (byte[] ipWithSubnet : excluded) {
            if (!this.isIPConstrained(ip, ipWithSubnet)) continue;
            throw new CertPathValidatorException("IP is from an excluded subtree.");
        }
    }

    private boolean isIPConstrained(byte[] ip, byte[] constraint) {
        int ipLength = ip.length;
        if (ipLength != constraint.length / 2) {
            return false;
        }
        byte[] subnetMask = new byte[ipLength];
        System.arraycopy(constraint, ipLength, subnetMask, 0, ipLength);
        byte[] permittedSubnetAddress = new byte[ipLength];
        byte[] ipSubnetAddress = new byte[ipLength];
        for (int i = 0; i < ipLength; ++i) {
            permittedSubnetAddress[i] = (byte)(constraint[i] & subnetMask[i]);
            ipSubnetAddress[i] = (byte)(ip[i] & subnetMask[i]);
        }
        return Arrays.areEqual(permittedSubnetAddress, ipSubnetAddress);
    }

    private boolean emailIsConstrained(String email, String constraint) {
        String sub = email.substring(email.indexOf(64) + 1);
        return constraint.indexOf(64) != -1 ? email.equalsIgnoreCase(constraint) : (constraint.charAt(0) != '.' ? sub.equalsIgnoreCase(constraint) : this.withinDomain(sub, constraint));
    }

    private boolean withinDomain(String testDomain, String domain) {
        String tempDomain = domain;
        if (tempDomain.startsWith(".")) {
            tempDomain = tempDomain.substring(1);
        }
        String[] domainParts = Strings.split(tempDomain, '.');
        String[] testDomainParts = Strings.split(testDomain, '.');
        if (testDomainParts.length <= domainParts.length) {
            return false;
        }
        int d = testDomainParts.length - domainParts.length;
        for (int i = -1; i < domainParts.length; ++i) {
            if (!(i == -1 ? testDomainParts[i + d].equals("") : !domainParts[i].equalsIgnoreCase(testDomainParts[i + d]))) continue;
            return false;
        }
        return true;
    }

    private void checkPermittedDNS(Set permitted, String dns) throws CertPathValidatorException {
        if (permitted == null) {
            return;
        }
        for (String str : permitted) {
            if (!this.withinDomain(dns, str) && !dns.equalsIgnoreCase(str)) continue;
            return;
        }
        if (dns.length() == 0 && permitted.size() == 0) {
            return;
        }
        throw new CertPathValidatorException("DNS is not from a permitted subtree.");
    }

    private void checkExcludedDNS(Set excluded, String dns) throws CertPathValidatorException {
        if (excluded.isEmpty()) {
            return;
        }
        for (String str : excluded) {
            if (!this.withinDomain(dns, str) && !dns.equalsIgnoreCase(str)) continue;
            throw new CertPathValidatorException("DNS is from an excluded subtree.");
        }
    }

    private void unionEmail(String email1, String email2, Set union) {
        if (email1.indexOf(64) != -1) {
            String _sub = email1.substring(email1.indexOf(64) + 1);
            if (email2.indexOf(64) != -1) {
                if (email1.equalsIgnoreCase(email2)) {
                    union.add(email1);
                } else {
                    union.add(email1);
                    union.add(email2);
                }
            } else if (email2.startsWith(".")) {
                if (this.withinDomain(_sub, email2)) {
                    union.add(email2);
                } else {
                    union.add(email1);
                    union.add(email2);
                }
            } else if (_sub.equalsIgnoreCase(email2)) {
                union.add(email2);
            } else {
                union.add(email1);
                union.add(email2);
            }
        } else if (email1.startsWith(".")) {
            if (email2.indexOf(64) != -1) {
                String _sub = email2.substring(email1.indexOf(64) + 1);
                if (this.withinDomain(_sub, email1)) {
                    union.add(email1);
                } else {
                    union.add(email1);
                    union.add(email2);
                }
            } else if (email2.startsWith(".")) {
                if (this.withinDomain(email1, email2) || email1.equalsIgnoreCase(email2)) {
                    union.add(email2);
                } else if (this.withinDomain(email2, email1)) {
                    union.add(email1);
                } else {
                    union.add(email1);
                    union.add(email2);
                }
            } else if (this.withinDomain(email2, email1)) {
                union.add(email1);
            } else {
                union.add(email1);
                union.add(email2);
            }
        } else if (email2.indexOf(64) != -1) {
            String _sub = email2.substring(email1.indexOf(64) + 1);
            if (_sub.equalsIgnoreCase(email1)) {
                union.add(email1);
            } else {
                union.add(email1);
                union.add(email2);
            }
        } else if (email2.startsWith(".")) {
            if (this.withinDomain(email1, email2)) {
                union.add(email2);
            } else {
                union.add(email1);
                union.add(email2);
            }
        } else if (email1.equalsIgnoreCase(email2)) {
            union.add(email1);
        } else {
            union.add(email1);
            union.add(email2);
        }
    }

    private void unionURI(String email1, String email2, Set union) {
        if (email1.indexOf(64) != -1) {
            String _sub = email1.substring(email1.indexOf(64) + 1);
            if (email2.indexOf(64) != -1) {
                if (email1.equalsIgnoreCase(email2)) {
                    union.add(email1);
                } else {
                    union.add(email1);
                    union.add(email2);
                }
            } else if (email2.startsWith(".")) {
                if (this.withinDomain(_sub, email2)) {
                    union.add(email2);
                } else {
                    union.add(email1);
                    union.add(email2);
                }
            } else if (_sub.equalsIgnoreCase(email2)) {
                union.add(email2);
            } else {
                union.add(email1);
                union.add(email2);
            }
        } else if (email1.startsWith(".")) {
            if (email2.indexOf(64) != -1) {
                String _sub = email2.substring(email1.indexOf(64) + 1);
                if (this.withinDomain(_sub, email1)) {
                    union.add(email1);
                } else {
                    union.add(email1);
                    union.add(email2);
                }
            } else if (email2.startsWith(".")) {
                if (this.withinDomain(email1, email2) || email1.equalsIgnoreCase(email2)) {
                    union.add(email2);
                } else if (this.withinDomain(email2, email1)) {
                    union.add(email1);
                } else {
                    union.add(email1);
                    union.add(email2);
                }
            } else if (this.withinDomain(email2, email1)) {
                union.add(email1);
            } else {
                union.add(email1);
                union.add(email2);
            }
        } else if (email2.indexOf(64) != -1) {
            String _sub = email2.substring(email1.indexOf(64) + 1);
            if (_sub.equalsIgnoreCase(email1)) {
                union.add(email1);
            } else {
                union.add(email1);
                union.add(email2);
            }
        } else if (email2.startsWith(".")) {
            if (this.withinDomain(email1, email2)) {
                union.add(email2);
            } else {
                union.add(email1);
                union.add(email2);
            }
        } else if (email1.equalsIgnoreCase(email2)) {
            union.add(email1);
        } else {
            union.add(email1);
            union.add(email2);
        }
    }

    private Set intersectDNS(Set permitted, String dns) {
        HashSet<String> intersect = new HashSet<String>();
        if (permitted == null) {
            if (dns == null) {
                return intersect;
            }
            intersect.add(dns);
            return intersect;
        }
        for (String _permitted : permitted) {
            if (this.withinDomain(_permitted, dns)) {
                intersect.add(_permitted);
                continue;
            }
            if (!this.withinDomain(dns, _permitted)) continue;
            intersect.add(dns);
        }
        return intersect;
    }

    protected Set unionDNS(Set excluded, String dns) {
        if (excluded.isEmpty()) {
            if (dns == null) {
                return excluded;
            }
            excluded.add(dns);
            return excluded;
        }
        HashSet<String> union = new HashSet<String>();
        for (String _permitted : excluded) {
            if (this.withinDomain(_permitted, dns)) {
                union.add(dns);
                continue;
            }
            if (this.withinDomain(dns, _permitted)) {
                union.add(_permitted);
                continue;
            }
            union.add(_permitted);
            union.add(dns);
        }
        return union;
    }

    private void intersectEmail(String email1, String email2, Set intersect) {
        if (email1.indexOf(64) != -1) {
            String _sub = email1.substring(email1.indexOf(64) + 1);
            if (email2.indexOf(64) != -1) {
                if (email1.equalsIgnoreCase(email2)) {
                    intersect.add(email1);
                }
            } else if (email2.startsWith(".")) {
                if (this.withinDomain(_sub, email2)) {
                    intersect.add(email1);
                }
            } else if (_sub.equalsIgnoreCase(email2)) {
                intersect.add(email1);
            }
        } else if (email1.startsWith(".")) {
            if (email2.indexOf(64) != -1) {
                String _sub = email2.substring(email1.indexOf(64) + 1);
                if (this.withinDomain(_sub, email1)) {
                    intersect.add(email2);
                }
            } else if (email2.startsWith(".")) {
                if (this.withinDomain(email1, email2) || email1.equalsIgnoreCase(email2)) {
                    intersect.add(email1);
                } else if (this.withinDomain(email2, email1)) {
                    intersect.add(email2);
                }
            } else if (this.withinDomain(email2, email1)) {
                intersect.add(email2);
            }
        } else if (email2.indexOf(64) != -1) {
            String _sub = email2.substring(email2.indexOf(64) + 1);
            if (_sub.equalsIgnoreCase(email1)) {
                intersect.add(email2);
            }
        } else if (email2.startsWith(".")) {
            if (this.withinDomain(email1, email2)) {
                intersect.add(email1);
            }
        } else if (email1.equalsIgnoreCase(email2)) {
            intersect.add(email1);
        }
    }

    private void checkExcludedURI(Set excluded, String uri) throws CertPathValidatorException {
        if (excluded.isEmpty()) {
            return;
        }
        for (String str : excluded) {
            if (!this.isUriConstrained(uri, str)) continue;
            throw new CertPathValidatorException("URI is from an excluded subtree.");
        }
    }

    private Set intersectURI(Set permitted, String uri) {
        HashSet<String> intersect = new HashSet<String>();
        if (permitted == null) {
            if (uri == null) {
                return intersect;
            }
            intersect.add(uri);
            return intersect;
        }
        for (String _permitted : permitted) {
            this.intersectURI(_permitted, uri, intersect);
        }
        return intersect;
    }

    private Set unionURI(Set excluded, String uri) {
        if (excluded.isEmpty()) {
            if (uri == null) {
                return excluded;
            }
            excluded.add(uri);
            return excluded;
        }
        HashSet union = new HashSet();
        for (String _excluded : excluded) {
            this.unionURI(_excluded, uri, union);
        }
        return union;
    }

    private void intersectURI(String email1, String email2, Set intersect) {
        if (email1.indexOf(64) != -1) {
            String _sub = email1.substring(email1.indexOf(64) + 1);
            if (email2.indexOf(64) != -1) {
                if (email1.equalsIgnoreCase(email2)) {
                    intersect.add(email1);
                }
            } else if (email2.startsWith(".")) {
                if (this.withinDomain(_sub, email2)) {
                    intersect.add(email1);
                }
            } else if (_sub.equalsIgnoreCase(email2)) {
                intersect.add(email1);
            }
        } else if (email1.startsWith(".")) {
            if (email2.indexOf(64) != -1) {
                String _sub = email2.substring(email1.indexOf(64) + 1);
                if (this.withinDomain(_sub, email1)) {
                    intersect.add(email2);
                }
            } else if (email2.startsWith(".")) {
                if (this.withinDomain(email1, email2) || email1.equalsIgnoreCase(email2)) {
                    intersect.add(email1);
                } else if (this.withinDomain(email2, email1)) {
                    intersect.add(email2);
                }
            } else if (this.withinDomain(email2, email1)) {
                intersect.add(email2);
            }
        } else if (email2.indexOf(64) != -1) {
            String _sub = email2.substring(email2.indexOf(64) + 1);
            if (_sub.equalsIgnoreCase(email1)) {
                intersect.add(email2);
            }
        } else if (email2.startsWith(".")) {
            if (this.withinDomain(email1, email2)) {
                intersect.add(email1);
            }
        } else if (email1.equalsIgnoreCase(email2)) {
            intersect.add(email1);
        }
    }

    private void checkPermittedURI(Set permitted, String uri) throws CertPathValidatorException {
        if (permitted == null) {
            return;
        }
        for (String str : permitted) {
            if (!this.isUriConstrained(uri, str)) continue;
            return;
        }
        if (uri.length() == 0 && permitted.size() == 0) {
            return;
        }
        throw new CertPathValidatorException("URI is not from a permitted subtree.");
    }

    private boolean isUriConstrained(String uri, String constraint) {
        String host = PKIXNameConstraints.extractHostFromURL(uri);
        return !constraint.startsWith(".") ? host.equalsIgnoreCase(constraint) : this.withinDomain(host, constraint);
    }

    private static String extractHostFromURL(String url) {
        String sub = url.substring(url.indexOf(58) + 1);
        if (sub.indexOf("//") != -1) {
            sub = sub.substring(sub.indexOf("//") + 2);
        }
        if (sub.lastIndexOf(58) != -1) {
            sub = sub.substring(0, sub.lastIndexOf(58));
        }
        sub = sub.substring(sub.indexOf(58) + 1);
        if ((sub = sub.substring(sub.indexOf(64) + 1)).indexOf(47) != -1) {
            sub = sub.substring(0, sub.indexOf(47));
        }
        return sub;
    }

    public void checkPermitted(GeneralName name) throws CertPathValidatorException {
        switch (name.getTagNo()) {
            case 1: {
                this.checkPermittedEmail(this.permittedSubtreesEmail, this.extractNameAsString(name));
                break;
            }
            case 2: {
                this.checkPermittedDNS(this.permittedSubtreesDNS, DERIA5String.getInstance(name.getName()).getString());
                break;
            }
            case 4: {
                this.checkPermittedDN(ASN1Sequence.getInstance(name.getName().getDERObject()));
                break;
            }
            case 6: {
                this.checkPermittedURI(this.permittedSubtreesURI, DERIA5String.getInstance(name.getName()).getString());
                break;
            }
            case 7: {
                byte[] ip = ASN1OctetString.getInstance(name.getName()).getOctets();
                this.checkPermittedIP(this.permittedSubtreesIP, ip);
            }
        }
    }

    public void checkExcluded(GeneralName name) throws CertPathValidatorException {
        switch (name.getTagNo()) {
            case 1: {
                this.checkExcludedEmail(this.excludedSubtreesEmail, this.extractNameAsString(name));
                break;
            }
            case 2: {
                this.checkExcludedDNS(this.excludedSubtreesDNS, DERIA5String.getInstance(name.getName()).getString());
                break;
            }
            case 4: {
                this.checkExcludedDN(ASN1Sequence.getInstance(name.getName().getDERObject()));
                break;
            }
            case 6: {
                this.checkExcludedURI(this.excludedSubtreesURI, DERIA5String.getInstance(name.getName()).getString());
                break;
            }
            case 7: {
                byte[] ip = ASN1OctetString.getInstance(name.getName()).getOctets();
                this.checkExcludedIP(this.excludedSubtreesIP, ip);
            }
        }
    }

    public void intersectPermittedSubtree(GeneralSubtree subtree) {
        GeneralName name = subtree.getBase();
        switch (name.getTagNo()) {
            case 1: {
                this.permittedSubtreesEmail = this.intersectEmail(this.permittedSubtreesEmail, this.extractNameAsString(name));
                break;
            }
            case 2: {
                this.permittedSubtreesDNS = this.intersectDNS(this.permittedSubtreesDNS, DERIA5String.getInstance(name.getName()).getString());
                break;
            }
            case 4: {
                this.permittedSubtreesDN = this.intersectDN(this.permittedSubtreesDN, ASN1Sequence.getInstance(name.getName().getDERObject()));
                break;
            }
            case 6: {
                this.permittedSubtreesURI = this.intersectURI(this.permittedSubtreesURI, DERIA5String.getInstance(name.getName()).getString());
                break;
            }
            case 7: {
                byte[] ip = ASN1OctetString.getInstance(name.getName()).getOctets();
                this.permittedSubtreesIP = this.intersectIP(this.permittedSubtreesIP, ip);
            }
        }
    }

    private String extractNameAsString(GeneralName name) {
        return DERIA5String.getInstance(name.getName()).getString();
    }

    public void addExcludedSubtree(GeneralSubtree subtree) {
        GeneralName base = subtree.getBase();
        switch (base.getTagNo()) {
            case 1: {
                this.excludedSubtreesEmail = this.unionEmail(this.excludedSubtreesEmail, DERIA5String.getInstance(base.getName()).getString());
                break;
            }
            case 2: {
                this.excludedSubtreesDNS = this.unionDNS(this.excludedSubtreesDNS, DERIA5String.getInstance(base.getName()).getString());
                break;
            }
            case 4: {
                this.excludedSubtreesDN = this.unionDN(this.excludedSubtreesDN, (ASN1Sequence)base.getName().getDERObject());
                break;
            }
            case 6: {
                this.excludedSubtreesURI = this.unionURI(this.excludedSubtreesURI, DERIA5String.getInstance(base.getName()).getString());
                break;
            }
            case 7: {
                this.excludedSubtreesIP = this.unionIP(this.excludedSubtreesIP, ASN1OctetString.getInstance(base.getName()).getOctets());
            }
        }
    }

    private static byte[] max(byte[] ip1, byte[] ip2) {
        for (int i = 0; i < ip1.length; ++i) {
            if ((ip1[i] & 0xFFFF) <= (ip2[i] & 0xFFFF)) continue;
            return ip1;
        }
        return ip2;
    }

    private static byte[] min(byte[] ip1, byte[] ip2) {
        for (int i = 0; i < ip1.length; ++i) {
            if ((ip1[i] & 0xFFFF) >= (ip2[i] & 0xFFFF)) continue;
            return ip1;
        }
        return ip2;
    }

    private static int compareTo(byte[] ip1, byte[] ip2) {
        if (Arrays.areEqual(ip1, ip2)) {
            return 0;
        }
        if (Arrays.areEqual(PKIXNameConstraints.max(ip1, ip2), ip1)) {
            return 1;
        }
        return -1;
    }

    private static byte[] or(byte[] ip1, byte[] ip2) {
        byte[] temp = new byte[ip1.length];
        for (int i = 0; i < ip1.length; ++i) {
            temp[i] = (byte)(ip1[i] | ip2[i]);
        }
        return temp;
    }

    public int hashCode() {
        return this.hashCollection(this.excludedSubtreesDN) + this.hashCollection(this.excludedSubtreesDNS) + this.hashCollection(this.excludedSubtreesEmail) + this.hashCollection(this.excludedSubtreesIP) + this.hashCollection(this.excludedSubtreesURI) + this.hashCollection(this.permittedSubtreesDN) + this.hashCollection(this.permittedSubtreesDNS) + this.hashCollection(this.permittedSubtreesEmail) + this.hashCollection(this.permittedSubtreesIP) + this.hashCollection(this.permittedSubtreesURI);
    }

    private int hashCollection(Collection coll) {
        if (coll == null) {
            return 0;
        }
        int hash = 0;
        for (Object o : coll) {
            if (o instanceof byte[]) {
                hash += Arrays.hashCode((byte[])o);
                continue;
            }
            hash += o.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PKIXNameConstraints)) {
            return false;
        }
        PKIXNameConstraints constraints = (PKIXNameConstraints)o;
        return this.collectionsAreEqual(constraints.excludedSubtreesDN, this.excludedSubtreesDN) && this.collectionsAreEqual(constraints.excludedSubtreesDNS, this.excludedSubtreesDNS) && this.collectionsAreEqual(constraints.excludedSubtreesEmail, this.excludedSubtreesEmail) && this.collectionsAreEqual(constraints.excludedSubtreesIP, this.excludedSubtreesIP) && this.collectionsAreEqual(constraints.excludedSubtreesURI, this.excludedSubtreesURI) && this.collectionsAreEqual(constraints.permittedSubtreesDN, this.permittedSubtreesDN) && this.collectionsAreEqual(constraints.permittedSubtreesDNS, this.permittedSubtreesDNS) && this.collectionsAreEqual(constraints.permittedSubtreesEmail, this.permittedSubtreesEmail) && this.collectionsAreEqual(constraints.permittedSubtreesIP, this.permittedSubtreesIP) && this.collectionsAreEqual(constraints.permittedSubtreesURI, this.permittedSubtreesURI);
    }

    private boolean collectionsAreEqual(Collection coll1, Collection coll2) {
        if (coll1 == coll2) {
            return true;
        }
        if (coll1 == null || coll2 == null) {
            return false;
        }
        if (coll1.size() != coll2.size()) {
            return false;
        }
        for (Object a : coll1) {
            Iterator it2 = coll2.iterator();
            boolean found = false;
            while (it2.hasNext()) {
                Object b = it2.next();
                if (!this.equals(a, b)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.areEqual((byte[])o1, (byte[])o2);
        }
        return o1.equals(o2);
    }

    private String stringifyIP(byte[] ip) {
        int i;
        String temp = "";
        for (i = 0; i < ip.length / 2; ++i) {
            temp = temp + Integer.toString(ip[i] & 0xFF) + ".";
        }
        temp = temp.substring(0, temp.length() - 1);
        temp = temp + "/";
        for (i = ip.length / 2; i < ip.length; ++i) {
            temp = temp + Integer.toString(ip[i] & 0xFF) + ".";
        }
        temp = temp.substring(0, temp.length() - 1);
        return temp;
    }

    private String stringifyIPCollection(Set ips) {
        String temp = "";
        temp = temp + "[";
        Iterator it = ips.iterator();
        while (it.hasNext()) {
            temp = temp + this.stringifyIP((byte[])it.next()) + ",";
        }
        if (temp.length() > 1) {
            temp = temp.substring(0, temp.length() - 1);
        }
        temp = temp + "]";
        return temp;
    }

    public String toString() {
        String temp = "";
        temp = temp + "permitted:\n";
        if (this.permittedSubtreesDN != null) {
            temp = temp + "DN:\n";
            temp = temp + this.permittedSubtreesDN.toString() + "\n";
        }
        if (this.permittedSubtreesDNS != null) {
            temp = temp + "DNS:\n";
            temp = temp + this.permittedSubtreesDNS.toString() + "\n";
        }
        if (this.permittedSubtreesEmail != null) {
            temp = temp + "Email:\n";
            temp = temp + this.permittedSubtreesEmail.toString() + "\n";
        }
        if (this.permittedSubtreesURI != null) {
            temp = temp + "URI:\n";
            temp = temp + this.permittedSubtreesURI.toString() + "\n";
        }
        if (this.permittedSubtreesIP != null) {
            temp = temp + "IP:\n";
            temp = temp + this.stringifyIPCollection(this.permittedSubtreesIP) + "\n";
        }
        temp = temp + "excluded:\n";
        if (!this.excludedSubtreesDN.isEmpty()) {
            temp = temp + "DN:\n";
            temp = temp + this.excludedSubtreesDN.toString() + "\n";
        }
        if (!this.excludedSubtreesDNS.isEmpty()) {
            temp = temp + "DNS:\n";
            temp = temp + this.excludedSubtreesDNS.toString() + "\n";
        }
        if (!this.excludedSubtreesEmail.isEmpty()) {
            temp = temp + "Email:\n";
            temp = temp + this.excludedSubtreesEmail.toString() + "\n";
        }
        if (!this.excludedSubtreesURI.isEmpty()) {
            temp = temp + "URI:\n";
            temp = temp + this.excludedSubtreesURI.toString() + "\n";
        }
        if (!this.excludedSubtreesIP.isEmpty()) {
            temp = temp + "IP:\n";
            temp = temp + this.stringifyIPCollection(this.excludedSubtreesIP) + "\n";
        }
        return temp;
    }
}

