/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.util.Hashtable;
import java.util.Map;
import java.util.stream.Collectors;
import kz.gamma.core.UtilCM;
import kz.gamma.tumarcsp.AlgParamUtil;

public enum ProviderAlgs {
    EC_256_512_GOST_34_310_2004_kz_A("1.2.398.3.10.1.1.1.1.1", "EC 256/512 (GOST 34.310-2004/kz A)", 10810),
    EC_256_512_GOST_34_310_2004_kz_B("1.2.398.3.10.1.1.1.1.2", "EC 256/512 (GOST 34.310-2004/kz B)", 10816),
    EC_256_512_GOST_34_310_2004_kz_C("1.2.398.3.10.1.1.1.1.3", "EC 256/512 (GOST 34.310-2004/kz C)", 10817),
    EC_256_512_GOST_34_310_2015_kz_A("1.2.398.3.10.1.1.2.1.1", "EC 256/512 (GOST 34.310-2015/kz A)", 10826),
    EC_512_1024_GOST_34_10_2015_kz_A("1.2.398.3.10.1.1.2.2.1", "EC 512/1024(GOST 34.10-2015/kz A)", 10828),
    EC_384_768_FIPS_PUB_180_2("1.3.6.1.4.1.6801.1.5.10", "EC 384/768 (FIPS PUB 180-2)", 43580),
    EC_521_1042_FIPS_PUB_180_2("1.3.6.1.4.1.6801.1.5.11", "EC 521/1042(FIPS PUB 180-2)", 43581),
    EC_160_320("1.3.6.1.4.1.6801.1.5.12", "EC 160/320 ", 43582),
    EC_192_384_FIPS_PUB_180_2("1.3.6.1.4.1.6801.1.5.13", "EC 192/384 (FIPS PUB 180-2)", 43583),
    EC_256_512_GOST_34_310_2004_B("1.3.6.1.4.1.6801.1.5.14", "EC 256/512 (GOST 34.310-2004 B)", 43584),
    EC_256_512_GOST_34_310_2004_C("1.3.6.1.4.1.6801.1.5.15", "EC 256/512 (GOST 34.310-2004 C)", 43585),
    EC_224_448_FIPS_PUB_180_2("1.3.6.1.4.1.6801.1.5.16", "EC 224/448 (FIPS PUB 180-2)", 43593),
    EC_512_1024_GOST_34_10_2012_A("1.3.6.1.4.1.6801.1.5.17", "EC 512/1024(GOST 34.10-2012 A)", 43596),
    EC_512_1024_GOST_34_10_2012_B("1.3.6.1.4.1.6801.1.5.18", "EC 512/1024(GOST 34.10-2012 B)", 43597),
    RSA_1536("1.3.6.1.4.1.6801.1.5.21", "RSA 1536", 42065),
    RSA_2048("1.3.6.1.4.1.6801.1.5.22", "RSA 2048", 42066),
    RSA_3072("1.3.6.1.4.1.6801.1.5.23", "RSA 3072", 42067),
    RSA_4096("1.3.6.1.4.1.6801.1.5.24", "RSA 4096", 42068),
    EC_256_512_GOST_34_310_2004_A("1.3.6.1.4.1.6801.1.5.8", "EC 256/512 (GOST 34.310-2004 A)", 43578),
    EC_256_512_FIPS_PUB_180_2("1.3.6.1.4.1.6801.1.5.9", "EC 256/512 (FIPS PUB 180-2)", 43579),
    EC_384_768_FIPS_PUB_180_2_Xch("1.3.6.1.4.1.6801.1.8.10", "EC 384/768 (FIPS PUB 180-2/Xch)", 41031),
    EC_512_1024_GOST_34_10_12_A_Xhc("1.3.6.1.4.1.6801.1.8.11", "EC 512/1024(GOST 34.10-12 A/Xhc)", 41038),
    EC_512_1024_GOST_34_10_12_B_Xhc("1.3.6.1.4.1.6801.1.8.12", "EC 512/1024(GOST 34.10-12 B/Xhc)", 41039),
    EC_256_512_GOST_34_310_2004_B_Xch("1.3.6.1.4.1.6801.1.8.14", "EC 256/512 (GOST 34.310-2004 B/Xch)", 41030),
    EC_521_1042_FIPS_PUB_180_2_Xch("1.3.6.1.4.1.6801.1.8.15", "EC 521/1042(FIPS PUB 180-2/Xch)", 41032),
    RSA_1536_Xch("1.3.6.1.4.1.6801.1.8.21", "RSA 1536 (Xch)", 41041),
    RSA_2048_Xch("1.3.6.1.4.1.6801.1.8.22", "RSA 2048 (Xch)", 41042),
    RSA_3072_Xch("1.3.6.1.4.1.6801.1.8.23", "RSA 3072 (Xch)", 41043),
    RSA_4096_Xch("1.3.6.1.4.1.6801.1.8.24", "RSA 4096 (Xch)", 41044),
    EC_256_512_GOST_34_310_2004_A_Xch("1.3.6.1.4.1.6801.1.8.8", "EC 256/512 (GOST 34.310-2004 A/Xch)", 41029),
    EC_256_512_FIPS_PUB_180_2_Xch("1.3.6.1.4.1.6801.1.8.9", "EC 256/512 (FIPS PUB 180-2/Xch)", 41033);

    public final String oid;
    public final String name;
    public final int alg;

    private ProviderAlgs(String oid, String name, int alg) {
        this.oid = oid;
        this.name = name;
        this.alg = alg;
    }

    public static void printAlgs(AlgParamUtil algUtil) {
        for (String key : algUtil.getAlgKey().keySet().stream().sorted().collect(Collectors.toList())) {
            int alg = algUtil.getAlgKey().get(key);
            byte[] algBytes = UtilCM.shortToByte((short)alg, 1);
            String fullName = ProviderAlgs.getKeyByValue(algUtil.getAlgKeyName(), key);
            String name = fullName.replaceAll("\\(", "_");
            name = name.replaceAll("\\)", "_");
            name = name.replaceAll(" ", "_");
            name = name.replaceAll("/", "_");
            name = name.replaceAll("\\-", "_");
            name = name.replaceAll("\\.", "_");
            name = name.replaceAll("__", "_");
            name = name.replaceAll("_$", "");
            System.out.println(name + "(\"" + key + "\", \"" + fullName + "\", 0x" + UtilCM.array2hex(algBytes) + "),");
        }
    }

    private static String getKeyByValue(Hashtable<String, String> hashtable, String value) {
        for (Map.Entry<String, String> o : hashtable.entrySet()) {
            if (!o.getValue().equals(value)) continue;
            return o.getKey();
        }
        return null;
    }
}

