/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.x509.BasicConstraints;
import kz.gamma.asn1.x509.CRLDistPoint;
import kz.gamma.asn1.x509.DistributionPoint;
import kz.gamma.asn1.x509.DistributionPointName;
import kz.gamma.asn1.x509.GeneralName;
import kz.gamma.asn1.x509.GeneralNames;
import kz.gamma.asn1.x509.IssuingDistributionPoint;
import kz.gamma.asn1.x509.TargetInformation;
import kz.gamma.asn1.x509.X509Extensions;
import kz.gamma.jce.exception.ExtCertPathValidatorException;
import kz.gamma.jce.provider.AnnotatedException;
import kz.gamma.jce.provider.CertPathValidatorUtilities;
import kz.gamma.jce.provider.CertStatus;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.jce.provider.ReasonsMask;
import kz.gamma.x509.ExtendedPKIXBuilderParameters;
import kz.gamma.x509.ExtendedPKIXParameters;
import kz.gamma.x509.PKIXAttrCertChecker;
import kz.gamma.x509.X509AttributeCertificate;
import kz.gamma.x509.X509CRLStoreSelector;
import kz.gamma.x509.X509CertStoreSelector;

class RFC3281CertPathUtilities
extends CertPathValidatorUtilities {
    private static final String TARGET_INFORMATION = X509Extensions.TargetInformation.getId();
    private static final String NO_REV_AVAIL = X509Extensions.NoRevAvail.getId();
    private static final String AUTHORITY_INFO_ACCESS = X509Extensions.AuthorityInfoAccess.getId();

    RFC3281CertPathUtilities() {
    }

    protected static void processAttrCert7(X509AttributeCertificate attrCert, CertPath certPath, CertPath holderCertPath, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        Set<String> set = attrCert.getCriticalExtensionOIDs();
        if (set.contains(TARGET_INFORMATION)) {
            try {
                TargetInformation.getInstance(CertPathValidatorUtilities.getExtensionValue(attrCert, TARGET_INFORMATION));
            }
            catch (AnnotatedException e) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", e);
            }
            catch (IllegalArgumentException e) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", e);
            }
        }
        set.remove(TARGET_INFORMATION);
        Iterator it = pkixParams.getAttrCertCheckers().iterator();
        while (it.hasNext()) {
            ((PKIXAttrCertChecker)it.next()).check(attrCert, certPath, holderCertPath, set);
        }
        if (!set.isEmpty()) {
            throw new CertPathValidatorException("Attribute certificate contains unsupported critical extensions: " + set);
        }
    }

    protected static void checkCRLs(X509AttributeCertificate attrCert, ExtendedPKIXParameters paramsPKIX, X509Certificate issuerCert, Date validDate) throws CertPathValidatorException {
        if (paramsPKIX.isRevocationEnabled()) {
            if (attrCert.getExtensionValue(NO_REV_AVAIL) == null) {
                ExtendedPKIXParameters paramsPKIXClone;
                CRLDistPoint crldp = null;
                try {
                    crldp = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(attrCert, CRL_DISTRIBUTION_POINTS));
                }
                catch (AnnotatedException e) {
                    throw new CertPathValidatorException("CRL distribution point extension could not be read.", e);
                }
                try {
                    CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(crldp, paramsPKIX);
                }
                catch (AnnotatedException e) {
                    throw new CertPathValidatorException("No additional CRL locations could be decoded from CRL distribution point extension.", e);
                }
                CertStatus certStatus = new CertStatus();
                ReasonsMask reasonsMask = new ReasonsMask();
                AnnotatedException lastException = null;
                boolean validCrlFound = false;
                if (crldp != null) {
                    DistributionPoint[] dps = null;
                    try {
                        dps = crldp.getDistributionPoints();
                    }
                    catch (Exception e) {
                        throw new ExtCertPathValidatorException("Distribution points could not be read.", e);
                    }
                    try {
                        for (int i = 0; i < dps.length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i) {
                            paramsPKIXClone = (ExtendedPKIXParameters)paramsPKIX.clone();
                            RFC3281CertPathUtilities.checkCRL(dps[i], attrCert, paramsPKIXClone, validDate, issuerCert, certStatus, reasonsMask);
                            validCrlFound = true;
                        }
                    }
                    catch (AnnotatedException e) {
                        lastException = new AnnotatedException("No valid CRL for distribution point found.", e);
                    }
                }
                if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
                    try {
                        DERObject issuer = null;
                        try {
                            issuer = new ASN1InputStream(((X500Principal)attrCert.getIssuer().getPrincipals()[0]).getEncoded()).readObject();
                        }
                        catch (Exception e) {
                            throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", e);
                        }
                        DistributionPoint dp = new DistributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, issuer))), null, null);
                        paramsPKIXClone = (ExtendedPKIXParameters)paramsPKIX.clone();
                        RFC3281CertPathUtilities.checkCRL(dp, attrCert, paramsPKIXClone, validDate, issuerCert, certStatus, reasonsMask);
                        validCrlFound = true;
                    }
                    catch (AnnotatedException e) {
                        lastException = new AnnotatedException("No valid CRL for distribution point found.", e);
                    }
                }
                if (!validCrlFound) {
                    throw new ExtCertPathValidatorException("No valid CRL found.", lastException);
                }
                if (certStatus.getCertStatus() != 11) {
                    String message = "Attribute certificate revocation after " + certStatus.getRevocationDate();
                    message = message + ", reason: " + crlReasons[certStatus.getCertStatus()];
                    throw new CertPathValidatorException(message);
                }
                if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
                    certStatus.setCertStatus(12);
                }
                if (certStatus.getCertStatus() == 12) {
                    throw new CertPathValidatorException("Attribute certificate status could not be determined.");
                }
            } else if (attrCert.getExtensionValue(CRL_DISTRIBUTION_POINTS) != null || attrCert.getExtensionValue(AUTHORITY_INFO_ACCESS) != null) {
                throw new CertPathValidatorException("No rev avail extension is set, but also an AC revocation pointer.");
            }
        }
    }

    protected static void additionalChecks(X509AttributeCertificate attrCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        for (String oid : pkixParams.getProhibitedACAttributes()) {
            if (attrCert.getAttributes(oid) == null) continue;
            throw new CertPathValidatorException("Attribute certificate contains prohibited attribute: " + oid + ".");
        }
        for (String oid : pkixParams.getNecessaryACAttributes()) {
            if (attrCert.getAttributes(oid) != null) continue;
            throw new CertPathValidatorException("Attribute certificate does not contain necessary attribute: " + oid + ".");
        }
    }

    protected static void processAttrCert5(X509AttributeCertificate attrCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        try {
            attrCert.checkValidity(CertPathValidatorUtilities.getValidDate(pkixParams));
        }
        catch (CertificateExpiredException e) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", e);
        }
    }

    protected static void processAttrCert4(X509Certificate acIssuerCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        Set set = pkixParams.getTrustedACIssuers();
        boolean trusted = false;
        for (TrustAnchor anchor : set) {
            if (!acIssuerCert.getSubjectX500Principal().getName("RFC2253").equals(anchor.getCAName()) && !acIssuerCert.equals(anchor.getTrustedCert())) continue;
            trusted = true;
        }
        if (!trusted) {
            throw new CertPathValidatorException("Attribute certificate issuer is not directly trusted.");
        }
    }

    protected static void processAttrCert3(X509Certificate acIssuerCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        if (acIssuerCert.getKeyUsage() != null && !acIssuerCert.getKeyUsage()[0] && !acIssuerCert.getKeyUsage()[1]) {
            throw new CertPathValidatorException("Attribute certificate issuer public key cannot be used to validate digital signatures.");
        }
        if (acIssuerCert.getBasicConstraints() != -1) {
            throw new CertPathValidatorException("Attribute certificate issuer is also a public key certificate issuer.");
        }
    }

    protected static CertPathValidatorResult processAttrCert2(CertPath certPath, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        CertPathValidator validator = null;
        try {
            validator = CertPathValidator.getInstance("PKIX", GammaTechProvider.PROVIDER_NAME);
        }
        catch (NoSuchProviderException e) {
            throw new ExtCertPathValidatorException("Support class could not be created.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExtCertPathValidatorException("Support class could not be created.", e);
        }
        try {
            return validator.validate(certPath, pkixParams);
        }
        catch (CertPathValidatorException e) {
            throw new ExtCertPathValidatorException("Certification path for issuer certificate of attribute certificate could not be validated.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected static CertPath processAttrCert1(X509AttributeCertificate attrCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        int i;
        Principal[] principals;
        X509CertStoreSelector selector;
        CertPathBuilderResult result = null;
        HashSet holderPKCs = new HashSet();
        if (attrCert.getHolder().getIssuer() != null) {
            selector = new X509CertStoreSelector();
            selector.setSerialNumber(attrCert.getHolder().getSerialNumber());
            principals = attrCert.getHolder().getIssuer();
            for (i = 0; i < principals.length; ++i) {
                try {
                    if (principals[i] instanceof X500Principal) {
                        selector.setIssuer(((X500Principal)principals[i]).getEncoded());
                    }
                    holderPKCs.addAll(CertPathValidatorUtilities.findCertificates(selector, pkixParams.getStores()));
                    continue;
                }
                catch (AnnotatedException e) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", e);
                }
                catch (IOException e) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", e);
                }
            }
            if (holderPKCs.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in base certificate ID for attribute certificate cannot be found.");
            }
        }
        if (attrCert.getHolder().getEntityNames() != null) {
            selector = new X509CertStoreSelector();
            principals = attrCert.getHolder().getEntityNames();
            for (i = 0; i < principals.length; ++i) {
                try {
                    if (principals[i] instanceof X500Principal) {
                        selector.setIssuer(((X500Principal)principals[i]).getEncoded());
                    }
                    holderPKCs.addAll(CertPathValidatorUtilities.findCertificates(selector, pkixParams.getStores()));
                    continue;
                }
                catch (AnnotatedException e) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", e);
                }
                catch (IOException e) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", e);
                }
            }
            if (holderPKCs.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in entity name for attribute certificate cannot be found.");
            }
        }
        ExtendedPKIXBuilderParameters params = (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance(pkixParams);
        ExtCertPathValidatorException lastException = null;
        Iterator it = holderPKCs.iterator();
        while (it.hasNext()) {
            X509CertStoreSelector selector2 = new X509CertStoreSelector();
            selector2.setCertificate((X509Certificate)it.next());
            params.setTargetConstraints(selector2);
            CertPathBuilder builder = null;
            try {
                builder = CertPathBuilder.getInstance("PKIX", GammaTechProvider.PROVIDER_NAME);
            }
            catch (NoSuchProviderException e) {
                throw new ExtCertPathValidatorException("Support class could not be created.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ExtCertPathValidatorException("Support class could not be created.", e);
            }
            try {
                result = builder.build(ExtendedPKIXBuilderParameters.getInstance(params));
            }
            catch (CertPathBuilderException e) {
                lastException = new ExtCertPathValidatorException("Certification path for public key certificate of attribute certificate could not be build.", e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return result.getCertPath();
    }

    private static void checkCRL(DistributionPoint dp, X509AttributeCertificate attrCert, ExtendedPKIXParameters paramsPKIX, Date validDate, X509Certificate issuerCert, CertStatus certStatus, ReasonsMask reasonMask) throws AnnotatedException {
        if (attrCert.getExtensionValue(X509Extensions.NoRevAvail.getId()) != null) {
            return;
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (validDate.getTime() > currentDate.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Set crls = CertPathValidatorUtilities.getCompleteCRLs(dp, attrCert, currentDate, paramsPKIX);
        boolean validCrlFound = false;
        AnnotatedException lastException = null;
        Iterator crl_iter = crls.iterator();
        while (crl_iter.hasNext() && certStatus.getCertStatus() == 11 && !reasonMask.isAllReasons()) {
            try {
                X509CRL crl = (X509CRL)crl_iter.next();
                ReasonsMask interimReasonsMask = RFC3281CertPathUtilities.processCRLD(crl, dp);
                if (!interimReasonsMask.hasNewReasons(reasonMask)) continue;
                Set keys = RFC3281CertPathUtilities.processCRLF(crl, attrCert, null, null, paramsPKIX);
                PublicKey key = RFC3281CertPathUtilities.processCRLG(crl, keys);
                X509CRL deltaCRL = null;
                if (paramsPKIX.isUseDeltasEnabled()) {
                    Set deltaCRLs = CertPathValidatorUtilities.getDeltaCRLs(currentDate, paramsPKIX, crl);
                    deltaCRL = RFC3281CertPathUtilities.processCRLH(deltaCRLs, key);
                }
                if (paramsPKIX.getValidityModel() != 1 && attrCert.getNotAfter().getTime() < crl.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3281CertPathUtilities.processCRLB1(dp, attrCert, crl);
                RFC3281CertPathUtilities.processCRLB2(dp, attrCert, crl);
                RFC3281CertPathUtilities.processCRLC(deltaCRL, crl, paramsPKIX);
                RFC3281CertPathUtilities.processCRLI(validDate, deltaCRL, attrCert.getSerialNumber(), certStatus, paramsPKIX);
                RFC3281CertPathUtilities.processCRLJ(validDate, crl, attrCert.getSerialNumber(), certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonMask.addReasons(interimReasonsMask);
                validCrlFound = true;
            }
            catch (AnnotatedException e) {
                lastException = e;
            }
        }
        if (!validCrlFound) {
            throw lastException;
        }
    }

    protected static void processCRLB2(DistributionPoint dp, Object cert, X509CRL crl) throws AnnotatedException {
        IssuingDistributionPoint idp = null;
        try {
            idp = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(crl, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception e) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", e);
        }
        if (idp != null && idp.getDistributionPoint() != null) {
            int j;
            DistributionPointName dpName = IssuingDistributionPoint.getInstance(idp).getDistributionPoint();
            ArrayList<byte[]> names = new ArrayList<byte[]>();
            if (dpName.getType() == 0) {
                GeneralName[] genNames = GeneralNames.getInstance(dpName.getName()).getNames();
                for (int j2 = 0; j2 < genNames.length; ++j2) {
                    names.add(genNames[j2].getDEREncoded());
                }
            }
            boolean matches = false;
            if (dp.getDistributionPoint() != null) {
                dpName = dp.getDistributionPoint();
                if (dpName.getType() == 0) {
                    GeneralName[] genNames = GeneralNames.getInstance(dpName.getName()).getNames();
                    for (j = 0; j < genNames.length; ++j) {
                        if (!names.contains(genNames[j])) continue;
                        matches = true;
                        break;
                    }
                }
                if (!matches) {
                    throw new AnnotatedException("None of the names in the CRL issuing distribution point matches one of the names in a distributionPoint field of the certificate CRL distribution point.");
                }
            } else {
                if (dp.getCRLIssuer() == null) {
                    throw new AnnotatedException("Either the cRLIssuer or the distributionPoint field must be contained in DistributionPoint.");
                }
                GeneralName[] genNames = dp.getCRLIssuer().getNames();
                for (j = 0; j < genNames.length; ++j) {
                    if (!names.contains(genNames[j])) continue;
                    matches = true;
                    break;
                }
                if (!matches) {
                    throw new AnnotatedException("None of the names in the CRL issuing distribution point matches one of the names in a cRLIssuer field of the certificate CRL distribution point.");
                }
            }
            BasicConstraints bc = null;
            try {
                bc = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue((X509Extension)cert, BASIC_CONSTRAINTS));
            }
            catch (Exception e) {
                throw new AnnotatedException("Basic constraints extension could not be decoded.", e);
            }
            if (cert instanceof X509Certificate) {
                if (idp.onlyContainsUserCerts() && bc != null && bc.isCA()) {
                    throw new AnnotatedException("CA Cert CRL only contains user certificates.");
                }
                if (idp.onlyContainsCACerts() && (bc == null || !bc.isCA())) {
                    throw new AnnotatedException("End CRL only contains CA certificates.");
                }
            }
            if (idp.onlyContainsAttributeCerts()) {
                throw new AnnotatedException("onlyContainsAttributeCerts boolean is asserted.");
            }
        }
    }

    protected static void processCRLB1(DistributionPoint dp, Object cert, X509CRL crl) throws AnnotatedException {
        DERObject idp = CertPathValidatorUtilities.getExtensionValue(crl, ISSUING_DISTRIBUTION_POINT);
        boolean isIndirect = false;
        if (idp != null && IssuingDistributionPoint.getInstance(idp).isIndirectCRL()) {
            isIndirect = true;
        }
        byte[] issuerBytes = CertPathValidatorUtilities.getIssuerPrincipal(crl).getEncoded();
        boolean matchIssuer = false;
        if (dp.getCRLIssuer() != null) {
            GeneralName[] genNames = dp.getCRLIssuer().getNames();
            for (int j = 0; j < genNames.length; ++j) {
                if (genNames[j].getTagNo() != 4) continue;
                try {
                    if (!genNames[j].getName().getDERObject().getEncoded().equals(issuerBytes)) continue;
                    matchIssuer = true;
                    continue;
                }
                catch (IOException e) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", e);
                }
            }
            if (matchIssuer && !isIndirect) {
                throw new AnnotatedException("Distribution point contains cRLIssuer field but CRL is not indirect.");
            }
            if (!matchIssuer) {
                throw new AnnotatedException("CRL issuer of CRL does not match CRL issuer of distribution point.");
            }
        } else if (CertPathValidatorUtilities.getIssuerPrincipal(crl).equals(CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert))) {
            matchIssuer = true;
        }
        if (!matchIssuer) {
            throw new AnnotatedException("Cannot find matching CRL issuer for certificate.");
        }
    }

    protected static ReasonsMask processCRLD(X509CRL crl, DistributionPoint dp) throws AnnotatedException {
        IssuingDistributionPoint idp = null;
        try {
            idp = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(crl, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception e) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", e);
        }
        if (idp != null && idp.getOnlySomeReasons() != null && dp.getReasons() != null) {
            return new ReasonsMask(dp.getReasons().intValue()).intersect(new ReasonsMask(idp.getOnlySomeReasons().intValue()));
        }
        if ((idp == null || idp.getOnlySomeReasons() == null) && dp.getReasons() == null) {
            return ReasonsMask.allReasons;
        }
        return (dp.getReasons() == null ? ReasonsMask.allReasons : new ReasonsMask(dp.getReasons().intValue())).intersect(idp == null ? ReasonsMask.allReasons : new ReasonsMask(idp.getOnlySomeReasons().intValue()));
    }

    protected static Set processCRLF(X509CRL crl, Object cert, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, ExtendedPKIXParameters paramsPKIX) throws AnnotatedException {
        X509CertStoreSelector selector = new X509CertStoreSelector();
        try {
            selector.setSubject(CertPathValidatorUtilities.getIssuerPrincipal(crl).getEncoded());
        }
        catch (IOException e) {
            throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate for CRL could not be set.", e);
        }
        Collection coll = null;
        try {
            coll = CertPathValidatorUtilities.findCertificates(selector, paramsPKIX.getStores());
            coll = CertPathValidatorUtilities.findCertificates(selector, paramsPKIX.getAddionalStores());
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Issuer certificate for CRL cannot be searched.", e);
        }
        if (defaultCRLSignCert != null) {
            coll.add(defaultCRLSignCert);
        }
        Iterator cert_it = coll.iterator();
        HashSet<X509Certificate> validCerts = new HashSet<X509Certificate>();
        while (cert_it.hasNext()) {
            X509Certificate signingCert = (X509Certificate)cert_it.next();
            if (CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).equals(signingCert.getSubjectX500Principal()) && signingCert.getPublicKey().equals(defaultCRLSignKey)) {
                validCerts.add(signingCert);
                continue;
            }
            try {
                CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", GammaTechProvider.PROVIDER_NAME);
                selector = new X509CertStoreSelector();
                selector.setCertificate(signingCert);
                ExtendedPKIXBuilderParameters params = (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance(paramsPKIX);
                params.setTargetConstraints(selector);
                HashSet<Object> excluded = new HashSet<Object>();
                excluded.add(cert);
                params.setExcludedCerts(excluded);
                builder.build(params);
                validCerts.add(signingCert);
            }
            catch (Exception builder) {}
        }
        HashSet<PublicKey> checkKeys = new HashSet<PublicKey>();
        if (defaultCRLSignCert == null && defaultCRLSignKey != null) {
            checkKeys.add(defaultCRLSignKey);
        }
        AnnotatedException lastException = null;
        for (X509Certificate signCert : validCerts) {
            boolean[] keyusage = signCert.getKeyUsage();
            if (!(keyusage == null || keyusage.length >= 7 && keyusage[6])) {
                lastException = new AnnotatedException("Issuer certificate key usage extension does not permit CRL signing.");
                continue;
            }
            checkKeys.add(signCert.getPublicKey());
        }
        if (checkKeys.isEmpty() && lastException == null) {
            throw new AnnotatedException("Cannot find a valid issuer certificate.");
        }
        if (checkKeys.isEmpty() && lastException != null) {
            throw lastException;
        }
        return checkKeys;
    }

    protected static PublicKey processCRLG(X509CRL crl, Set keys) throws AnnotatedException {
        Exception lastException = null;
        try {
            Iterator it = keys.iterator();
            if (it.hasNext()) {
                PublicKey key = (PublicKey)it.next();
                crl.verify(key);
                return key;
            }
        }
        catch (Exception e) {
            lastException = e;
        }
        throw new AnnotatedException("Cannot verify CRL.", lastException);
    }

    protected static X509CRL processCRLH(Set deltacrls, PublicKey key) throws AnnotatedException {
        Exception lastException = null;
        try {
            Iterator it = deltacrls.iterator();
            if (it.hasNext()) {
                X509CRL crl = (X509CRL)it.next();
                crl.verify(key);
                return crl;
            }
        }
        catch (Exception e) {
            lastException = e;
        }
        throw new AnnotatedException("Cannot verify delta CRL.", lastException);
    }

    protected static Set processCRLA1i(Date currentDate, ExtendedPKIXParameters paramsPKIX, X509Certificate cert, X509CRL crl) throws AnnotatedException {
        HashSet set = new HashSet();
        if (paramsPKIX.isUseDeltasEnabled()) {
            CRLDistPoint freshestCRL = null;
            try {
                freshestCRL = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, FRESHEST_CRL));
            }
            catch (AnnotatedException e) {
                throw new AnnotatedException("Freshest CRL extension could not be decoded from certificate.", e);
            }
            if (freshestCRL == null) {
                try {
                    freshestCRL = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(crl, FRESHEST_CRL));
                }
                catch (AnnotatedException e) {
                    throw new AnnotatedException("Freshest CRL extension could not be decoded from CRL.", e);
                }
            }
            if (freshestCRL != null) {
                try {
                    CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(freshestCRL, paramsPKIX);
                }
                catch (AnnotatedException e) {
                    throw new AnnotatedException("No new delta CRL locations could be added from Freshest CRL extension.", e);
                }
                try {
                    set.addAll(CertPathValidatorUtilities.getDeltaCRLs(currentDate, paramsPKIX, crl));
                }
                catch (AnnotatedException e) {
                    throw new AnnotatedException("Exception obtaining delta CRLs.", e);
                }
            }
        }
        return set;
    }

    protected static Set[] processCRLA1ii(Date currentDate, ExtendedPKIXParameters paramsPKIX, X509Certificate cert, X509CRL crl) throws AnnotatedException {
        HashSet completeSet = new HashSet();
        HashSet deltaSet = new HashSet();
        X509CRLStoreSelector crlselect = new X509CRLStoreSelector();
        crlselect.setCertificateChecking(cert);
        crlselect.setCompleteCRLEnabled(true);
        crlselect.setDateAndTime(currentDate);
        try {
            crlselect.addIssuerName(crl.getIssuerX500Principal().getEncoded());
        }
        catch (IOException e) {
            throw new AnnotatedException("Cannot extract issuer from CRL." + e, e);
        }
        try {
            completeSet.addAll(CertPathValidatorUtilities.findCRLs(crlselect, paramsPKIX.getAddionalStores()));
            completeSet.addAll(CertPathValidatorUtilities.findCRLs(crlselect, paramsPKIX.getStores()));
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Exception obtaining complete CRLs.", e);
        }
        if (paramsPKIX.isUseDeltasEnabled()) {
            try {
                deltaSet.addAll(CertPathValidatorUtilities.getDeltaCRLs(currentDate, paramsPKIX, crl));
            }
            catch (AnnotatedException e) {
                throw new AnnotatedException("Exception obtaining delta CRLs.", e);
            }
        }
        return new Set[]{completeSet, deltaSet};
    }

    protected static void processCRLC(X509CRL deltaCRL, X509CRL completeCRL, ExtendedPKIXParameters pkixParams) throws AnnotatedException {
        IssuingDistributionPoint completeidp = null;
        try {
            completeidp = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(completeCRL, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception e) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", e);
        }
        if (pkixParams.isUseDeltasEnabled()) {
            if (!deltaCRL.getIssuerX500Principal().equals(completeCRL.getIssuerX500Principal())) {
                throw new AnnotatedException("Complete CRL issuer does not match delta CRL issuer.");
            }
            if (completeidp != null) {
                IssuingDistributionPoint deltaidp = null;
                try {
                    deltaidp = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(deltaCRL, ISSUING_DISTRIBUTION_POINT));
                }
                catch (Exception e) {
                    throw new AnnotatedException("Issuing distribution point extension from delta CRL could not be decoded.", e);
                }
                boolean match = false;
                if (completeidp == null) {
                    if (deltaidp == null) {
                        match = true;
                    }
                } else if (completeidp.equals(deltaidp)) {
                    match = true;
                }
                if (!match) {
                    throw new AnnotatedException("Issuing distribution point extension from delta CRL and complete CRL does not match.");
                }
            }
            DERObject completeKeyIdentifier = null;
            try {
                completeKeyIdentifier = CertPathValidatorUtilities.getExtensionValue(deltaCRL, AUTHORITY_KEY_IDENTIFIER);
            }
            catch (AnnotatedException e) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from complete CRL.", e);
            }
            DERObject deltaKeyIdentifier = null;
            try {
                deltaKeyIdentifier = CertPathValidatorUtilities.getExtensionValue(deltaCRL, AUTHORITY_KEY_IDENTIFIER);
            }
            catch (AnnotatedException e) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from delta CRL.", e);
            }
            if (!completeKeyIdentifier.equals(deltaKeyIdentifier)) {
                throw new AnnotatedException("Delta CRL authority key identifier does not match complete CRL authority key identifier.");
            }
        }
    }

    protected static void processCRLI(Date validDate, X509CRL deltacrl, BigInteger serialNumber, CertStatus certStatus, ExtendedPKIXParameters pkixParams) throws AnnotatedException {
        if (pkixParams.isUseDeltasEnabled()) {
            CertPathValidatorUtilities.getCertStatus(validDate, deltacrl, serialNumber, certStatus);
        }
    }

    protected static void processCRLJ(Date validDate, X509CRL completecrl, BigInteger serialNumber, CertStatus certStatus) throws AnnotatedException {
        CertPathValidatorUtilities.getCertStatus(validDate, completecrl, serialNumber, certStatus);
    }

    private static void checkCRL(DistributionPoint dp, ExtendedPKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, CertStatus certStatus, ReasonsMask reasonMask, List certPathCerts) throws AnnotatedException {
        Date currentDate = new Date(System.currentTimeMillis());
        if (validDate.getTime() > currentDate.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Set crls = CertPathValidatorUtilities.getCompleteCRLs(dp, cert, currentDate, paramsPKIX);
        boolean validCrlFound = false;
        AnnotatedException lastException = null;
        Iterator crl_iter = crls.iterator();
        while (crl_iter.hasNext() && certStatus.getCertStatus() == 11 && !reasonMask.isAllReasons()) {
            try {
                X509CRL crl = (X509CRL)crl_iter.next();
                ReasonsMask interimReasonsMask = RFC3281CertPathUtilities.processCRLD(crl, dp);
                if (!interimReasonsMask.hasNewReasons(reasonMask)) continue;
                Set keys = RFC3281CertPathUtilities.processCRLF(crl, cert, defaultCRLSignCert, defaultCRLSignKey, paramsPKIX);
                PublicKey key = RFC3281CertPathUtilities.processCRLG(crl, keys);
                X509CRL deltaCRL = null;
                if (paramsPKIX.isUseDeltasEnabled()) {
                    Set deltaCRLs = CertPathValidatorUtilities.getDeltaCRLs(currentDate, paramsPKIX, crl);
                    deltaCRL = RFC3281CertPathUtilities.processCRLH(deltaCRLs, key);
                }
                if (paramsPKIX.getValidityModel() != 1 && cert.getNotAfter().getTime() < crl.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3281CertPathUtilities.processCRLB1(dp, cert, crl);
                RFC3281CertPathUtilities.processCRLB2(dp, cert, crl);
                RFC3281CertPathUtilities.processCRLC(deltaCRL, crl, paramsPKIX);
                RFC3281CertPathUtilities.processCRLI(validDate, deltaCRL, cert.getSerialNumber(), certStatus, paramsPKIX);
                RFC3281CertPathUtilities.processCRLJ(validDate, crl, cert.getSerialNumber(), certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonMask.addReasons(interimReasonsMask);
                validCrlFound = true;
            }
            catch (AnnotatedException e) {
                lastException = e;
            }
        }
        if (!validCrlFound) {
            throw lastException;
        }
    }

    private static void checkCRLs(ExtendedPKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey, List certPathCerts) throws AnnotatedException {
        ExtendedPKIXParameters paramsPKIXClone;
        AnnotatedException lastException = null;
        CRLDistPoint crldp = null;
        try {
            crldp = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, CRL_DISTRIBUTION_POINTS));
        }
        catch (Exception e) {
            throw new AnnotatedException("CRL distribution point extension could not be read.", e);
        }
        try {
            CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(crldp, paramsPKIX);
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("No additional CRL locations could be decoded from CRL distribution point extension.", e);
        }
        CertStatus certStatus = new CertStatus();
        ReasonsMask reasonsMask = new ReasonsMask();
        boolean validCrlFound = false;
        if (crldp != null) {
            DistributionPoint[] dps = null;
            try {
                dps = crldp.getDistributionPoints();
            }
            catch (Exception e) {
                throw new AnnotatedException("Distribution points could not be read.", e);
            }
            try {
                for (int i = 0; i < dps.length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i) {
                    paramsPKIXClone = (ExtendedPKIXParameters)paramsPKIX.clone();
                    RFC3281CertPathUtilities.checkCRL(dps[i], paramsPKIXClone, cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts);
                    validCrlFound = true;
                }
            }
            catch (AnnotatedException e) {
                lastException = new AnnotatedException("No valid CRL for distribution point found.", e);
            }
        }
        if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                DERObject issuer = null;
                try {
                    issuer = new ASN1InputStream(CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).getEncoded()).readObject();
                }
                catch (Exception e) {
                    throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", e);
                }
                DistributionPoint dp = new DistributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, issuer))), null, null);
                paramsPKIXClone = (ExtendedPKIXParameters)paramsPKIX.clone();
                RFC3281CertPathUtilities.checkCRL(dp, paramsPKIXClone, cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts);
                validCrlFound = true;
            }
            catch (AnnotatedException e) {
                lastException = new AnnotatedException("No valid CRL for distribution point found.", e);
            }
        }
        if (!validCrlFound) {
            throw new AnnotatedException("No valid CRL found.", lastException);
        }
        if (certStatus.getCertStatus() != 11) {
            String message = "Certificate revocation after " + certStatus.getRevocationDate();
            message = message + ", reason: " + crlReasons[certStatus.getCertStatus()];
            throw new AnnotatedException(message);
        }
        if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
            certStatus.setCertStatus(12);
        }
        if (certStatus.getCertStatus() == 12) {
            throw new AnnotatedException("Certificate status could not be determined.");
        }
    }
}

