/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1OutputStream;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROutputStream;
import kz.gamma.asn1.x509.CertificateList;
import kz.gamma.asn1.x509.IssuingDistributionPoint;
import kz.gamma.asn1.x509.TBSCertList;
import kz.gamma.asn1.x509.X509Extension;
import kz.gamma.asn1.x509.X509Extensions;
import kz.gamma.jce.X509Principal;
import kz.gamma.jce.provider.ExtCRLException;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.jce.provider.X509CRLEntryObject;
import kz.gamma.jce.provider.X509SignatureUtil;
import kz.gamma.x509.extension.X509ExtensionUtil;

public class X509CRLObject
extends X509CRL {
    private CertificateList c;
    private String sigAlgName;
    private byte[] sigAlgParams;
    private boolean isIndirect;

    public X509CRLObject(CertificateList c) throws CRLException {
        this.c = c;
        try {
            this.sigAlgName = X509SignatureUtil.getSignatureName(c.getSignatureAlgorithm());
            this.sigAlgParams = (byte[])(c.getSignatureAlgorithm().getParameters() != null ? ((ASN1Encodable)c.getSignatureAlgorithm().getParameters()).getDEREncoded() : null);
            this.isIndirect = this.isIndirectCRL();
        }
        catch (Exception e) {
            throw new CRLException("CRL contents invalid: " + e);
        }
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        if (this.getVersion() == 2) {
            HashSet<String> set = new HashSet<String>();
            X509Extensions extensions = this.c.getTBSCertList().getExtensions();
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
            return set;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        X509Extension ext;
        X509Extensions exts = this.c.getTBSCertList().getExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            try {
                return ext.getValue().getEncoded();
            }
            catch (Exception e) {
                throw new IllegalStateException("error parsing " + e.toString());
            }
        }
        return null;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this.c);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new CRLException(e.toString());
        }
    }

    @Override
    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, GammaTechProvider.PROVIDER_NAME);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertList().getSignature())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        Signature sig = Signature.getInstance(this.getSigAlgName(), sigProvider);
        sig.initVerify(key);
        sig.update(this.getTBSCertList());
        if (!sig.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public int getVersion() {
        return this.c.getVersion();
    }

    @Override
    public Principal getIssuerDN() {
        return new X509Principal(this.c.getIssuer());
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(this.c.getIssuer());
            return new X500Principal(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getThisUpdate() {
        return this.c.getThisUpdate().getDate();
    }

    @Override
    public Date getNextUpdate() {
        if (this.c.getNextUpdate() != null) {
            return this.c.getNextUpdate().getDate();
        }
        return null;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        TBSCertList.CRLEntry[] certs = this.c.getRevokedCertificates();
        if (certs != null) {
            X500Principal previousCertificateIssuer = this.getIssuerX500Principal();
            for (int i = 0; i < certs.length; ++i) {
                X509CRLEntryObject crlentry = new X509CRLEntryObject(certs[i], this.isIndirect, previousCertificateIssuer);
                previousCertificateIssuer = crlentry.getCertificateIssuer();
                if (!crlentry.getSerialNumber().equals(serialNumber)) continue;
                return crlentry;
            }
        }
        return null;
    }

    public Set getRevokedCertificates() {
        TBSCertList.CRLEntry[] certs = this.c.getRevokedCertificates();
        if (certs != null) {
            HashSet<X509CRLEntryObject> set = new HashSet<X509CRLEntryObject>();
            X500Principal previousCertificateIssuer = this.getIssuerX500Principal();
            for (int i = 0; i < certs.length; ++i) {
                X509CRLEntryObject crlentry = new X509CRLEntryObject(certs[i], this.isIndirect, previousCertificateIssuer);
                set.add(crlentry);
                previousCertificateIssuer = crlentry.getCertificateIssuer();
            }
            return set;
        }
        return null;
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.c.getTBSCertList().getEncoded("DER");
        }
        catch (IOException e) {
            throw new CRLException(e.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.c.getSignature().getBytes();
    }

    @Override
    public String getSigAlgName() {
        return this.sigAlgName;
    }

    @Override
    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getObjectId().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.sigAlgParams != null) {
            byte[] tmp = new byte[this.sigAlgParams.length];
            System.arraycopy(this.sigAlgParams, 0, tmp, 0, tmp.length);
            return tmp;
        }
        return null;
    }

    @Override
    public String toString() {
        return "X.509 CRL";
    }

    @Override
    public boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509")) {
            throw new RuntimeException("X.509 CRL used with non X.509 Cert");
        }
        TBSCertList.CRLEntry[] certs = this.c.getRevokedCertificates();
        if (certs != null) {
            BigInteger serial = ((X509Certificate)cert).getSerialNumber();
            for (int i = 0; i < certs.length; ++i) {
                if (!certs[i].getUserCertificate().getValue().equals(serial)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIndirectCRL() throws CRLException {
        byte[] idp = this.getExtensionValue(X509Extensions.IssuingDistributionPoint.getId());
        boolean isIndirect = false;
        try {
            if (idp != null) {
                isIndirect = IssuingDistributionPoint.getInstance(X509ExtensionUtil.fromExtensionValue(idp)).isIndirectCRL();
            }
        }
        catch (IOException e) {
            throw new ExtCRLException("Exception reading IssuingDistributionPoint", e);
        }
        return isIndirect;
    }
}

