/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.pkcs11.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import kz.gamma.pkcs11.jna.Pkcs11JnaWrapper;
import kz.gamma.pkcs11.jna.Pkcs11Structure;
import kz.gamma.pkcs11.jna.Utils;
import kz.gamma.tumarcsp.DataConverter;

public class CK_ATTRIBUTE
extends Pkcs11Structure {
    public NativeLong type;
    public Pointer pValue;
    public NativeLong ulValueLen;

    public CK_ATTRIBUTE() {
    }

    public CK_ATTRIBUTE(Long type, Long value) {
        this.setAttr(new NativeLong(type), new NativeLong(value));
    }

    public CK_ATTRIBUTE(NativeLong type, Pointer pVal, NativeLong ulValLen) {
        this.setAttr(type, pVal, ulValLen);
    }

    public CK_ATTRIBUTE(NativeLong type, NativeLong value) {
        this.setAttr(type, value);
    }

    public CK_ATTRIBUTE(NativeLong type, byte[] value) {
        this.setAttr(type, value);
    }

    public CK_ATTRIBUTE(NativeLong type, boolean value) {
        this.setAttr(type, value);
    }

    public CK_ATTRIBUTE(NativeLong type, String value) {
        this.setAttr(type, value);
    }

    public void setAttr(NativeLong type, Pointer pVal, NativeLong ulValLen) {
        this.type = type;
        this.pValue = pVal;
        this.ulValueLen = ulValLen;
    }

    public void setAttr(NativeLong type, NativeLong value) {
        this.type = type;
        this.pValue = new Memory(NativeLong.SIZE);
        this.pValue.setNativeLong(0L, value);
        this.ulValueLen = new NativeLong((long)NativeLong.SIZE);
    }

    public void setAttr(Long type, Long value) {
        this.type = new NativeLong(type);
        this.pValue = new Memory(NativeLong.SIZE);
        this.pValue.setNativeLong(0L, new NativeLong(value));
        this.ulValueLen = new NativeLong((long)NativeLong.SIZE);
    }

    public void setAttr(Long type, byte[] value) {
        this.type = new NativeLong(type);
        this.pValue = Utils.getPointerFromData(value);
        this.ulValueLen = new NativeLong((long)value.length);
    }

    public void setAttr(Long type, String value) {
        this.setAttr(type, value, Pkcs11JnaWrapper.useNullTerminate);
    }

    public void setAttr(Long type, String value, boolean useNullTerminate) {
        this.type = new NativeLong(type);
        byte[] data = value.getBytes();
        if (useNullTerminate) {
            data = DataConverter.getNullTerminatedArray(data);
        }
        this.pValue = Utils.getPointerFromData(data);
        this.ulValueLen = new NativeLong((long)data.length);
    }

    public void setAttr(Long type, boolean value) {
        this.type = new NativeLong(type);
        this.pValue = new Memory(1L);
        this.pValue.setByte(0L, value ? (byte)1 : 0);
        this.ulValueLen = new NativeLong(1L);
    }

    public void setAttr(Long type, int value) {
        this.type = new NativeLong(type);
        this.pValue = new Memory(NativeLong.SIZE);
        this.pValue.setNativeLong(0L, new NativeLong((long)value));
        this.ulValueLen = new NativeLong((long)NativeLong.SIZE);
    }

    public void setAttr(Long type) {
        this.type = new NativeLong(type);
    }

    @Override
    public void allocateMemory() {
        this.pValue = new Memory(this.ulValueLen.intValue());
    }

    public void setAttr(NativeLong type, byte[] value) {
        this.type = type;
        this.pValue = new Memory(value.length);
        this.pValue.write(0L, value, 0, value.length);
        this.ulValueLen = new NativeLong((long)value.length);
    }

    public void setAttr(NativeLong type, boolean value) {
        this.type = type;
        this.pValue = new Memory(Native.getNativeSize(Byte.TYPE));
        this.pValue.setByte(0L, (byte)(value ? 1 : 0));
        this.ulValueLen = new NativeLong((long)Native.getNativeSize(Byte.TYPE));
    }

    public void setAttr(NativeLong type, String value) {
        this.type = type;
        this.pValue = new Memory(value.length() + 1);
        this.pValue.setString(0L, value);
        this.ulValueLen = new NativeLong((long)(value.length() + 1));
    }

    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("type", "pValue", "ulValueLen");
    }

    public long getLong() {
        if (this.ulValueLen.intValue() == 4) {
            return this.pValue.getInt(0L);
        }
        throw new RuntimeException("Not a Long: " + this.pValue.getClass().getName());
    }

    public int getInt() {
        if (this.ulValueLen.intValue() == 4) {
            return this.pValue.getInt(0L);
        }
        throw new RuntimeException("Not a Int: " + this.pValue.getClass().getName());
    }

    public boolean getBoolean() {
        if (this.ulValueLen.intValue() == 1) {
            return this.pValue.getByte(0L) != 0;
        }
        throw new RuntimeException("Not a Boolean: " + this.pValue.getClass().getName());
    }

    public String getString() {
        return this.pValue.getString(0L);
    }

    public byte[] getByteArray() {
        return this.pValue.getByteArray(0L, this.ulValueLen.intValue());
    }

    public static class ByReference
    extends CK_ATTRIBUTE
    implements Structure.ByReference {
    }
}

