/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.pkcs11.jna;

import kz.gamma.jce.exception.JCEException;
import kz.gamma.pkcs11.jna.CK_ATTRIBUTE;
import kz.gamma.pkcs11.jna.Pkcs11Exception;
import kz.gamma.pkcs11.jna.Pkcs11JnaWrapper;
import kz.gamma.pkcs11.jna.SlotInfo;
import kz.gamma.pkcs11.jna.TokenInfo;

public class PKCS11Utils {
    private static boolean useNullTerminate = true;
    public static byte[] publicExponent = new byte[]{1, 0, 1};

    public static void setHsmParams() {
        useNullTerminate = false;
    }

    public static long openSession(long slot) {
        long session = Pkcs11JnaWrapper.C_OpenSession(slot, 6L, null, null);
        return session;
    }

    public static void closeSession(long session) {
        try {
            if (session != 0L) {
                Pkcs11JnaWrapper.C_CloseSession(session);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void login(long session, char[] password) {
        try {
            Pkcs11JnaWrapper.C_Login(session, 1L, password);
        }
        catch (Pkcs11Exception e) {
            if (e.getErrorCode() == 256L) {
                Pkcs11JnaWrapper.C_Logout(session);
                Pkcs11JnaWrapper.C_Login(session, 1L, password);
            }
            throw e;
        }
    }

    public static void logout(long session) {
        try {
            Pkcs11JnaWrapper.C_Logout(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long connect(char[] password) {
        String tokenLabel = Pkcs11JnaWrapper.getTokenLabel();
        Long slot = null;
        try {
            long[] slotList;
            for (long localSlot : slotList = Pkcs11JnaWrapper.C_GetSlotList(true)) {
                TokenInfo tokenInfo;
                SlotInfo ckSlotInfo = Pkcs11JnaWrapper.C_GetSlotInfo(localSlot);
                if (!ckSlotInfo.isTokenPresent() || !tokenLabel.equals((tokenInfo = Pkcs11JnaWrapper.C_GetTokenInfo(localSlot)).getLabel().trim())) continue;
                slot = localSlot;
                break;
            }
        }
        catch (Pkcs11Exception e) {
            e.printStackTrace();
        }
        if (slot == null) {
            throw new JCEException("Token isn't present");
        }
        long session = 0L;
        try {
            session = PKCS11Utils.openSession(slot);
            if (password != null) {
                PKCS11Utils.login(session, password);
            }
            return session;
        }
        catch (Exception e) {
            if (session != 0L) {
                PKCS11Utils.closeSession(session);
            }
            throw e;
        }
    }

    public static byte[] getPublicKeyValue(long session, long hPublicKey) {
        try {
            CK_ATTRIBUTE[] vals2 = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
            vals2[0].setAttr(288L);
            Pkcs11JnaWrapper.C_GetAttributeValue(session, hPublicKey, vals2);
            byte[] publicKeyValue = vals2[0].getByteArray();
            return publicKeyValue;
        }
        catch (Exception e) {
            throw new JCEException("getPublicKeyValue error", e);
        }
    }

    public static byte[] getGostPublicKeyValue(long session, long hPublicKey) {
        try {
            CK_ATTRIBUTE[] vals2 = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
            vals2[0].setAttr(17L);
            Pkcs11JnaWrapper.C_GetAttributeValue(session, hPublicKey, vals2);
            byte[] publicKeyValue = vals2[0].getByteArray();
            return publicKeyValue;
        }
        catch (Exception e) {
            throw new JCEException("getGostPublicKeyValue error", e);
        }
    }

    public static int getKeyAlg(long session, long hPublicKey) {
        try {
            CK_ATTRIBUTE[] vals2 = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
            vals2[0].setAttr(2382364689L);
            Pkcs11JnaWrapper.C_GetAttributeValue(session, hPublicKey, vals2);
            return vals2[0].getInt();
        }
        catch (Exception e) {
            throw new JCEException("getKeyAlg error", e);
        }
    }

    public static boolean isEntryExists(long session, String alias, long objectType) {
        if (alias == null || alias.trim().equals("")) {
            return false;
        }
        try {
            CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(2);
            attributes[0].setAttr((Long)0L, objectType);
            attributes[1].setAttr((Long)3L, alias);
            Pkcs11JnaWrapper.C_FindObjectsInit(session, attributes);
            long[] objects = Pkcs11JnaWrapper.C_FindObjects(session, 1);
            Pkcs11JnaWrapper.C_FindObjectsFinal(session);
            return objects != null && objects.length > 0;
        }
        catch (Exception e) {
            throw new JCEException("engine error: " + e.getMessage(), e);
        }
    }

    public static long getPrivateKeyId(long session, String alias) {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("wrong alias: " + alias);
        }
        try {
            CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(2);
            attributes[0].setAttr((Long)0L, 3L);
            attributes[1].setAttr(3L, alias, useNullTerminate);
            Pkcs11JnaWrapper.C_FindObjectsInit(session, attributes);
            long[] objects = Pkcs11JnaWrapper.C_FindObjects(session, 1);
            Pkcs11JnaWrapper.C_FindObjectsFinal(session);
            if (objects != null && objects.length > 0) {
                return objects[0];
            }
            throw new JCEException("private key was not found: " + alias);
        }
        catch (Exception e) {
            throw new JCEException("engine error: " + e.getMessage(), e);
        }
    }

    public static int getPublicKeyLength(long session, String alias) {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("wrong alias: " + alias);
        }
        try {
            CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(2);
            attributes[0].setAttr((Long)0L, 2L);
            attributes[1].setAttr(3L, alias, useNullTerminate);
            Pkcs11JnaWrapper.C_FindObjectsInit(session, attributes);
            long[] objects = Pkcs11JnaWrapper.C_FindObjects(session, 1);
            Pkcs11JnaWrapper.C_FindObjectsFinal(session);
            if (objects != null && objects.length > 0) {
                CK_ATTRIBUTE[] certAttr = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(1);
                certAttr[0].setAttr(289L);
                Pkcs11JnaWrapper.C_GetAttributeValue(session, objects[0], certAttr);
                if (certAttr[0].pValue == null) {
                    throw new Exception("CKA_MODULUS_BITS was not found");
                }
                return certAttr[0].getInt() / 8;
            }
            throw new JCEException("public key was not found: " + alias);
        }
        catch (Pkcs11Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new JCEException("engine error: " + e.getMessage(), e);
        }
    }

    public static long getPublicKey(long session, byte[] publicKeyValue) throws Pkcs11Exception {
        CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(2);
        attributes[0].setAttr((Long)0L, 2L);
        attributes[1].setAttr((Long)288L, publicKeyValue);
        Pkcs11JnaWrapper.C_FindObjectsInit(session, attributes);
        long[] objects = Pkcs11JnaWrapper.C_FindObjects(session, 1);
        Pkcs11JnaWrapper.C_FindObjectsFinal(session);
        if (objects != null && objects.length > 0) {
            return objects[0];
        }
        return 0L;
    }

    public static long getPublicKey(long session, String keyLabel) throws Pkcs11Exception {
        CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(2);
        attributes[0].setAttr((Long)0L, 2L);
        attributes[1].setAttr(3L, keyLabel, useNullTerminate);
        Pkcs11JnaWrapper.C_FindObjectsInit(session, attributes);
        long[] objects = Pkcs11JnaWrapper.C_FindObjects(session, 1);
        Pkcs11JnaWrapper.C_FindObjectsFinal(session);
        if (objects != null && objects.length > 0) {
            return objects[0];
        }
        return 0L;
    }

    public static long createPublicKey(long session, byte[] publicKeyValue) throws Pkcs11Exception {
        CK_ATTRIBUTE[] publicKeyTemplates = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(8);
        publicKeyTemplates[0].setAttr((Long)0L, 2L);
        publicKeyTemplates[1].setAttr((Long)3L, "temp");
        publicKeyTemplates[2].setAttr((Long)288L, publicKeyValue);
        publicKeyTemplates[3].setAttr((Long)1L, true);
        publicKeyTemplates[4].setAttr((Long)260L, false);
        publicKeyTemplates[5].setAttr((Long)290L, publicExponent);
        publicKeyTemplates[6].setAttr((Long)256L, 0L);
        publicKeyTemplates[7].setAttr((Long)262L, true);
        long publicKeyId = Pkcs11JnaWrapper.C_CreateObject(session, publicKeyTemplates);
        return publicKeyId;
    }

    public static byte[] sign(long session, long privateKeyId, byte[] data, long mechanismId, int publicKeyLen) throws Exception {
        Pkcs11JnaWrapper.C_SignInit(session, mechanismId, privateKeyId);
        return Pkcs11JnaWrapper.C_Sign(session, data, publicKeyLen);
    }

    public static boolean verify(long session, long privateKeyId, byte[] data, long mechanismId, byte[] sign) throws Exception {
        Pkcs11JnaWrapper.C_VerifyInit(session, mechanismId, privateKeyId);
        return Pkcs11JnaWrapper.C_Verify(session, data, sign);
    }
}

