/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.pkcs11.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.ptr.NativeLongByReference;
import java.util.HashMap;
import kz.gamma.core.UtilCM;
import kz.gamma.pkcs11.jna.CK_ATTRIBUTE;
import kz.gamma.pkcs11.jna.CK_C_INITIALIZE_ARGS;
import kz.gamma.pkcs11.jna.CK_MECHANISM;
import kz.gamma.pkcs11.jna.CK_SLOT_INFO;
import kz.gamma.pkcs11.jna.CK_TOKEN_INFO;
import kz.gamma.pkcs11.jna.Pkcs11;
import kz.gamma.pkcs11.jna.Pkcs11Exception;
import kz.gamma.pkcs11.jna.SlotInfo;
import kz.gamma.pkcs11.jna.TokenInfo;

public class Pkcs11JnaWrapper {
    private static final int AES_BLOCK_LENGTH_BYTES = 16;
    private static final boolean DEFAULT_USE_NULL_TERMINATE = true;
    static boolean useNullTerminate;
    private static Pkcs11 instance;
    private static String tokenLabel;
    private static CK_C_INITIALIZE_ARGS initArgs;

    public static String getTokenLabel() {
        return tokenLabel;
    }

    static Pkcs11 getInstance(String libName) {
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        int flag = Platform.isWindows() ? 0 : 1;
        options.put("open-flags", flag);
        Pkcs11 instance = Native.load(libName, Pkcs11.class, options);
        return instance;
    }

    public static void initialize(String libraryName, String tokenLabel) throws Pkcs11Exception {
        Pkcs11JnaWrapper.initialize(libraryName, tokenLabel, null);
    }

    public static void initialize(String libraryName, String tokenLabel, boolean useNullTerminate) throws Pkcs11Exception {
        Pkcs11JnaWrapper.initialize(libraryName, tokenLabel, null, useNullTerminate);
    }

    public static void initialize(String libraryName, String tokenLabel, CK_C_INITIALIZE_ARGS initArgs) {
        Pkcs11JnaWrapper.initialize(libraryName, tokenLabel, initArgs, true);
    }

    public static void reset() {
        try {
            instance.C_Finalize(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Pkcs11JnaWrapper.checkResult(instance.C_Initialize(initArgs));
    }

    public static void initialize(String libraryName, String tokenLabel, CK_C_INITIALIZE_ARGS initArgs, boolean useNullTerminate) throws Pkcs11Exception {
        if (libraryName == null || libraryName.length() == 0) {
            throw new IllegalArgumentException("Incorrect library name:" + libraryName);
        }
        if (tokenLabel == null || tokenLabel.length() == 0) {
            throw new IllegalArgumentException("Incorrect token label:" + tokenLabel);
        }
        instance = Pkcs11JnaWrapper.getInstance(libraryName);
        Pkcs11JnaWrapper.tokenLabel = tokenLabel;
        Pkcs11JnaWrapper.checkResult(instance.C_Initialize(initArgs));
        Pkcs11JnaWrapper.useNullTerminate = useNullTerminate;
        Pkcs11JnaWrapper.initArgs = initArgs;
    }

    public static long[] C_GetSlotList(boolean tokenPresent) throws Pkcs11Exception {
        NativeLongByReference count = new NativeLongByReference();
        Pkcs11JnaWrapper.checkResult(instance.C_GetSlotList(tokenPresent ? (byte)1 : 0, null, count));
        int countValue = count.getValue().intValue();
        Number[] list = new NativeLong[countValue];
        Pkcs11JnaWrapper.checkResult(instance.C_GetSlotList(tokenPresent ? (byte)1 : 0, (NativeLong[])list, count));
        return Pkcs11JnaWrapper.getLongArray(list);
    }

    public static SlotInfo C_GetSlotInfo(long slotID) throws Pkcs11Exception {
        CK_SLOT_INFO.ByReference slotInfo = new CK_SLOT_INFO.ByReference();
        Pkcs11JnaWrapper.checkResult(instance.C_GetSlotInfo(new NativeLong(slotID), slotInfo));
        return new SlotInfo(slotInfo);
    }

    public static TokenInfo C_GetTokenInfo(long slotID) throws Pkcs11Exception {
        CK_TOKEN_INFO.ByReference tokenInfo = new CK_TOKEN_INFO.ByReference();
        Pkcs11JnaWrapper.checkResult(instance.C_GetTokenInfo(new NativeLong(slotID), tokenInfo));
        return new TokenInfo(tokenInfo);
    }

    public static long C_OpenSession(long slotID, long flags, Object pApplication, Object Notify) throws Pkcs11Exception {
        NativeLongByReference session = new NativeLongByReference();
        Pkcs11JnaWrapper.checkResult(instance.C_OpenSession(new NativeLong(slotID), new NativeLong(flags), null, null, session));
        return session.getValue().longValue();
    }

    public static void C_CloseSession(long hSession) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_CloseSession(new NativeLong(hSession)));
    }

    public static void close() {
        instance.C_Finalize(null);
    }

    public static void C_Login(long hSession, long userType, char[] pPin) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_Login(new NativeLong(hSession), new NativeLong(userType), new String(pPin).getBytes(), new NativeLong((long)pPin.length)));
    }

    public static void C_InitPIN(long hSession, char[] pPin) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_InitPIN(new NativeLong(hSession), new String(pPin).getBytes(), new NativeLong((long)pPin.length)));
    }

    public static void C_SetPIN(long hSession, char[] oldPin, char[] newPin) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_SetPIN(new NativeLong(hSession), new String(oldPin).getBytes(), new NativeLong((long)oldPin.length), new String(newPin).getBytes(), new NativeLong((long)newPin.length)));
    }

    public static void C_InitToken(long slotID, char[] pin, char[] label) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_InitToken(new NativeLong(slotID), new String(pin).getBytes(), new NativeLong((long)pin.length), new String(label).getBytes()));
    }

    public static void C_Logout(long hSession) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_Logout(new NativeLong(hSession)));
    }

    public static void C_FindObjectsInit(long hSession, CK_ATTRIBUTE[] pTemplate) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_FindObjectsInit(new NativeLong(hSession), pTemplate[0], new NativeLong((long)pTemplate.length)));
    }

    public static long[] C_FindObjects(long hSession, int ulMaxObjectCount) throws Pkcs11Exception {
        Number[] objects = new NativeLong[ulMaxObjectCount];
        NativeLongByReference count = new NativeLongByReference();
        Pkcs11JnaWrapper.checkResult(instance.C_FindObjects(new NativeLong(hSession), (NativeLong[])objects, new NativeLong((long)ulMaxObjectCount), count));
        return Pkcs11JnaWrapper.getLongArray(objects, count.getValue().intValue());
    }

    public static void C_FindObjectsFinal(long hSession) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_FindObjectsFinal(new NativeLong(hSession)));
    }

    public static void C_GetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_GetAttributeValue(new NativeLong(hSession), new NativeLong(hObject), pTemplate[0], new NativeLong((long)pTemplate.length)));
        for (CK_ATTRIBUTE attribute : pTemplate) {
            attribute.allocateMemory();
        }
        Pkcs11JnaWrapper.checkResult(instance.C_GetAttributeValue(new NativeLong(hSession), new NativeLong(hObject), pTemplate[0], new NativeLong((long)pTemplate.length)));
    }

    public static long[] C_GenerateKeyPair(long hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pPublicKeyTemplate, CK_ATTRIBUTE[] pPrivateKeyTemplate) throws Pkcs11Exception {
        NativeLongByReference phPublicKey = new NativeLongByReference();
        NativeLongByReference phPrivateKey = new NativeLongByReference();
        Pkcs11JnaWrapper.checkResult(instance.C_GenerateKeyPair(new NativeLong(hSession), pMechanism, pPublicKeyTemplate[0], new NativeLong((long)pPublicKeyTemplate.length), pPrivateKeyTemplate[0], new NativeLong((long)pPrivateKeyTemplate.length), phPublicKey, phPrivateKey));
        return new long[]{phPublicKey.getValue().longValue(), phPrivateKey.getValue().longValue()};
    }

    public static long C_GenerateKey(long hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pKeyTemplate) throws Pkcs11Exception {
        NativeLongByReference phKey = new NativeLongByReference();
        Pkcs11JnaWrapper.checkResult(instance.C_GenerateKey(new NativeLong(hSession), pMechanism, pKeyTemplate[0], new NativeLong((long)pKeyTemplate.length), phKey));
        return phKey.getValue().longValue();
    }

    public static byte[] C_WrapKey(long hSession, long mechanismId, long hWrappingKey, long hKeyToBeWrapped, int keySize) throws Pkcs11Exception {
        NativeLongByReference phKeySize = new NativeLongByReference();
        phKeySize.setValue(new NativeLong((long)keySize));
        byte[] wrappedKey = new byte[keySize];
        Pkcs11JnaWrapper.checkResult(instance.C_WrapKey(new NativeLong(hSession), new CK_MECHANISM(mechanismId), new NativeLong(hWrappingKey), new NativeLong(hKeyToBeWrapped), wrappedKey, phKeySize));
        return wrappedKey;
    }

    public static long C_UnwrapKey(long hSession, long mechanismId, long hUnwrappingKey, byte[] wrappedKey, CK_ATTRIBUTE[] pKeyTemplate) throws Pkcs11Exception {
        NativeLongByReference phKey = new NativeLongByReference();
        Pkcs11JnaWrapper.checkResult(instance.C_UnwrapKey(new NativeLong(hSession), new CK_MECHANISM(mechanismId), new NativeLong(hUnwrappingKey), wrappedKey, new NativeLong((long)wrappedKey.length), pKeyTemplate[0], new NativeLong((long)pKeyTemplate.length), phKey));
        return phKey.getValue().longValue();
    }

    public static long C_CreateObject(long hSession, CK_ATTRIBUTE[] pTemplate) throws Pkcs11Exception {
        NativeLongByReference phObject = new NativeLongByReference();
        Pkcs11JnaWrapper.checkResult(instance.C_CreateObject(new NativeLong(hSession), pTemplate[0], new NativeLong((long)pTemplate.length), phObject));
        return phObject.getValue().longValue();
    }

    public static void C_DestroyObject(long hSession, long hObject) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_DestroyObject(new NativeLong(hSession), new NativeLong(hObject)));
    }

    public static void C_SignInit(long hSession, long mechanismId, long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_SignInit(new NativeLong(hSession), new CK_MECHANISM(mechanismId), new NativeLong(hKey)));
    }

    public static byte[] C_Sign(long hSession, byte[] dataPart, int publicKeyLength) throws Exception {
        NativeLongByReference signLen = new NativeLongByReference();
        signLen.setValue(new NativeLong((long)publicKeyLength));
        byte[] res = new byte[publicKeyLength];
        Pkcs11JnaWrapper.checkResult(instance.C_Sign(new NativeLong(hSession), dataPart, new NativeLong((long)dataPart.length), res, signLen));
        if (publicKeyLength != signLen.getValue().intValue()) {
            throw new Exception("wrong signature length");
        }
        return res;
    }

    public static void C_SignUpdate(long hSession, byte[] dataPart) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_SignUpdate(new NativeLong(hSession), dataPart, new NativeLong((long)dataPart.length)));
    }

    public static byte[] C_SignFinal(long hSession, int publicKeyLength) throws Exception {
        NativeLongByReference signLen = new NativeLongByReference();
        signLen.setValue(new NativeLong((long)publicKeyLength));
        byte[] res = new byte[publicKeyLength];
        Pkcs11JnaWrapper.checkResult(instance.C_SignFinal(new NativeLong(hSession), res, signLen));
        if (publicKeyLength != signLen.getValue().intValue()) {
            throw new Exception("wrong signature length");
        }
        return res;
    }

    public static void C_VerifyInit(long hSession, long mechanismId, long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_VerifyInit(new NativeLong(hSession), new CK_MECHANISM(mechanismId), new NativeLong(hKey)));
    }

    public static boolean C_Verify(long hSession, byte[] dataPart, byte[] signature) throws Pkcs11Exception {
        NativeLong res = instance.C_Verify(new NativeLong(hSession), dataPart, new NativeLong((long)dataPart.length), signature, new NativeLong((long)signature.length));
        if (res.longValue() == 192L) {
            return false;
        }
        Pkcs11JnaWrapper.checkResult(res);
        return true;
    }

    public static void C_VerifyUpdate(long hSession, byte[] dataPart) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_VerifyUpdate(new NativeLong(hSession), dataPart, new NativeLong((long)dataPart.length)));
    }

    public static boolean C_VerifyFinal(long hSession, byte[] signature) throws Pkcs11Exception {
        NativeLong res = instance.C_VerifyFinal(new NativeLong(hSession), signature, new NativeLong((long)signature.length));
        if (res.longValue() == 192L) {
            return false;
        }
        Pkcs11JnaWrapper.checkResult(res);
        return true;
    }

    public static void C_DigestInit(long hSession, long mechanismId) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_DigestInit(new NativeLong(hSession), new CK_MECHANISM(mechanismId)));
    }

    public static void C_DigestUpdate(long hSession, byte[] dataPart) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_DigestUpdate(new NativeLong(hSession), dataPart, new NativeLong((long)dataPart.length)));
    }

    public static byte[] C_DigestFinal(long hSession, int digestLength) throws Exception {
        NativeLongByReference len = new NativeLongByReference();
        len.setValue(new NativeLong((long)digestLength));
        byte[] digest = new byte[digestLength];
        Pkcs11JnaWrapper.checkResult(instance.C_DigestFinal(new NativeLong(hSession), digest, len));
        return digest;
    }

    public static void C_EncryptInit(long hSession, long mechanismId, long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_EncryptInit(new NativeLong(hSession), new CK_MECHANISM(mechanismId), new NativeLong(hKey)));
    }

    public static void C_EncryptInit(long hSession, CK_MECHANISM mechanism, long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_EncryptInit(new NativeLong(hSession), mechanism, new NativeLong(hKey)));
    }

    public static byte[] C_EncryptUpdate(long hSession, byte[] dataPart) throws Pkcs11Exception {
        NativeLongByReference len = new NativeLongByReference();
        byte[] res = Pkcs11JnaWrapper.getEncryptResultArray(dataPart.length, false);
        len.setValue(new NativeLong((long)res.length));
        Pkcs11JnaWrapper.checkResult(instance.C_EncryptUpdate(new NativeLong(hSession), dataPart, new NativeLong((long)dataPart.length), res, len));
        return Pkcs11JnaWrapper.trimResultArray(res, len.getValue().intValue());
    }

    private static byte[] trimResultArray(byte[] result, int newSize) {
        if (result != null && result.length != newSize && result.length > newSize) {
            return UtilCM.copyByte(result, 0, newSize);
        }
        return result;
    }

    public static byte[] C_EncryptFinal(long hSession) throws Pkcs11Exception {
        NativeLongByReference len = new NativeLongByReference();
        byte[] res = new byte[16];
        len.setValue(new NativeLong((long)res.length));
        Pkcs11JnaWrapper.checkResult(instance.C_EncryptFinal(new NativeLong(hSession), res, len));
        return Pkcs11JnaWrapper.trimResultArray(res, len.getValue().intValue());
    }

    private static byte[] getEncryptResultArray(int inputArrayLength, boolean withPadding) {
        int add;
        int length = withPadding ? (inputArrayLength / 16 + 1) * 16 : inputArrayLength - add + ((add = inputArrayLength % 16) > 0 ? 16 : 0);
        byte[] res = new byte[length];
        return res;
    }

    public static byte[] C_Encrypt(long hSession, byte[] data, boolean withPadding) throws Pkcs11Exception {
        NativeLongByReference len = new NativeLongByReference();
        byte[] res = Pkcs11JnaWrapper.getEncryptResultArray(data.length, withPadding);
        len.setValue(new NativeLong((long)res.length));
        Pkcs11JnaWrapper.checkResult(instance.C_Encrypt(new NativeLong(hSession), data, new NativeLong((long)data.length), res, len));
        return Pkcs11JnaWrapper.trimResultArray(res, len.getValue().intValue());
    }

    public static void C_DecryptInit(long hSession, long mechanismId, long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_DecryptInit(new NativeLong(hSession), new CK_MECHANISM(mechanismId), new NativeLong(hKey)));
    }

    public static void C_DecryptInit(long hSession, CK_MECHANISM mechanism, long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_DecryptInit(new NativeLong(hSession), mechanism, new NativeLong(hKey)));
    }

    public static byte[] C_DecryptUpdate(long hSession, byte[] dataPart) throws Pkcs11Exception {
        NativeLongByReference len = new NativeLongByReference();
        byte[] res = new byte[dataPart.length];
        len.setValue(new NativeLong((long)res.length));
        Pkcs11JnaWrapper.checkResult(instance.C_DecryptUpdate(new NativeLong(hSession), dataPart, new NativeLong((long)dataPart.length), res, len));
        return Pkcs11JnaWrapper.trimResultArray(res, len.getValue().intValue());
    }

    public static byte[] C_DecryptFinal(long hSession) throws Pkcs11Exception {
        NativeLongByReference len = new NativeLongByReference();
        byte[] res = new byte[16];
        len.setValue(new NativeLong((long)res.length));
        Pkcs11JnaWrapper.checkResult(instance.C_DecryptFinal(new NativeLong(hSession), res, len));
        return Pkcs11JnaWrapper.trimResultArray(res, len.getValue().intValue());
    }

    public static byte[] C_Decrypt(long hSession, byte[] data) throws Pkcs11Exception {
        NativeLongByReference len = new NativeLongByReference();
        byte[] res = new byte[data.length];
        len.setValue(new NativeLong((long)res.length));
        Pkcs11JnaWrapper.checkResult(instance.C_Decrypt(new NativeLong(hSession), data, new NativeLong((long)data.length), res, len));
        return Pkcs11JnaWrapper.trimResultArray(res, len.getValue().intValue());
    }

    public static byte[] C_GenerateRandom(long hSession, int length) throws Pkcs11Exception {
        byte[] res = new byte[length];
        Pkcs11JnaWrapper.checkResult(instance.C_GenerateRandom(new NativeLong(hSession), res, new NativeLong((long)length)));
        return res;
    }

    public static void C_SetAttributeValue(long hSession, long hKey, CK_ATTRIBUTE[] pKeyTemplate) throws Pkcs11Exception {
        Pkcs11JnaWrapper.checkResult(instance.C_SetAttributeValue(new NativeLong(hSession), new NativeLong(hKey), pKeyTemplate[0], new NativeLong((long)pKeyTemplate.length)));
    }

    private static void checkResult(NativeLong res) throws Pkcs11Exception {
        if (res.longValue() != 0L) {
            throw new Pkcs11Exception(res.longValue());
        }
    }

    private static long[] getLongArray(Number[] array) {
        long[] longArray = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            longArray[i] = array[i].longValue();
        }
        return longArray;
    }

    private static long[] getLongArray(Number[] array, int count) {
        long[] longArray = new long[count];
        for (int i = 0; i < count; ++i) {
            longArray[i] = array[i].longValue();
        }
        return longArray;
    }
}

