/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.pkcs11.jna;

import java.util.Date;
import kz.gamma.pkcs11.jna.CK_TOKEN_INFO;
import kz.gamma.pkcs11.jna.Utils;
import kz.gamma.pkcs11.jna.Version;

public class TokenInfo
implements Cloneable {
    public static final long EFFECTIVELY_INFINITE = 0L;
    public static final long UNAVAILABLE_INFORMATION = -1L;
    protected String label_;
    protected String manufacturerID_;
    protected String model_;
    protected String serialNumber_;
    protected long maxSessionCount_;
    protected long sessionCount_;
    protected long maxRwSessionCount_;
    protected long rwSessionCount_;
    protected long maxPinLen_;
    protected long minPinLen_;
    protected long totalPublicMemory_;
    protected long freePublicMemory_;
    protected long totalPrivateMemory_;
    protected long freePrivateMemory_;
    protected Version hardwareVersion_;
    protected Version firmwareVersion_;
    protected Date time_;
    protected boolean rng_;
    protected boolean writeProtected_;
    protected boolean loginRequired_;
    protected boolean userPinInitialized_;
    protected boolean restoreKeyNotNeeded_;
    protected boolean clockOnToken_;
    protected boolean protectedAuthenticationPath_;
    protected boolean dualCryptoOperations_;
    protected boolean tokenInitialized_;
    protected boolean secondaryAuthentication_;
    protected boolean userPinCountLow_;
    protected boolean userPinFinalTry_;
    protected boolean userPinLocked_;
    protected boolean userPinToBeChanged_;
    protected boolean soPinCountLow_;
    protected boolean soPinFinalTry_;
    protected boolean soPinLocked_;
    protected boolean soPinToBeChanged_;

    protected TokenInfo(CK_TOKEN_INFO ckTokenInfo) {
        if (ckTokenInfo == null) {
            throw new NullPointerException("Argument \"ckTokenInfo\" must not be null.");
        }
        this.label_ = new String(ckTokenInfo.label);
        this.manufacturerID_ = new String(ckTokenInfo.manufacturerID);
        this.model_ = new String(ckTokenInfo.model);
        this.serialNumber_ = new String(ckTokenInfo.serialNumber);
        this.maxSessionCount_ = ckTokenInfo.ulMaxSessionCount.longValue();
        this.sessionCount_ = ckTokenInfo.ulSessionCount.longValue();
        this.maxRwSessionCount_ = ckTokenInfo.ulMaxRwSessionCount.longValue();
        this.rwSessionCount_ = ckTokenInfo.ulRwSessionCount.longValue();
        this.maxPinLen_ = ckTokenInfo.ulMaxPinLen.longValue();
        this.minPinLen_ = ckTokenInfo.ulMinPinLen.longValue();
        this.totalPublicMemory_ = ckTokenInfo.ulTotalPublicMemory.longValue();
        this.freePublicMemory_ = ckTokenInfo.ulFreePublicMemory.longValue();
        this.totalPrivateMemory_ = ckTokenInfo.ulTotalPrivateMemory.longValue();
        this.freePrivateMemory_ = ckTokenInfo.ulFreePrivateMemory.longValue();
        this.hardwareVersion_ = new Version(ckTokenInfo.hardwareVersion);
        this.firmwareVersion_ = new Version(ckTokenInfo.firmwareVersion);
        this.time_ = Utils.parseTime(new String(ckTokenInfo.utcTime).toCharArray());
        this.rng_ = (ckTokenInfo.flags.longValue() & 1L) != 0L;
        this.writeProtected_ = (ckTokenInfo.flags.longValue() & 2L) != 0L;
        this.loginRequired_ = (ckTokenInfo.flags.longValue() & 4L) != 0L;
        this.userPinInitialized_ = (ckTokenInfo.flags.longValue() & 8L) != 0L;
        this.restoreKeyNotNeeded_ = (ckTokenInfo.flags.longValue() & 0x20L) != 0L;
        this.clockOnToken_ = (ckTokenInfo.flags.longValue() & 0x40L) != 0L;
        this.protectedAuthenticationPath_ = (ckTokenInfo.flags.longValue() & 0x100L) != 0L;
        this.dualCryptoOperations_ = (ckTokenInfo.flags.longValue() & 0x200L) != 0L;
        this.tokenInitialized_ = (ckTokenInfo.flags.longValue() & 0x400L) != 0L;
        this.secondaryAuthentication_ = (ckTokenInfo.flags.longValue() & 0x800L) != 0L;
        this.userPinCountLow_ = (ckTokenInfo.flags.longValue() & 0x10000L) != 0L;
        this.userPinFinalTry_ = (ckTokenInfo.flags.longValue() & 0x20000L) != 0L;
        this.userPinLocked_ = (ckTokenInfo.flags.longValue() & 0x40000L) != 0L;
        this.userPinToBeChanged_ = (ckTokenInfo.flags.longValue() & 0x80000L) != 0L;
        this.soPinCountLow_ = (ckTokenInfo.flags.longValue() & 0x100000L) != 0L;
        this.soPinFinalTry_ = (ckTokenInfo.flags.longValue() & 0x200000L) != 0L;
        this.soPinLocked_ = (ckTokenInfo.flags.longValue() & 0x400000L) != 0L;
        this.soPinToBeChanged_ = (ckTokenInfo.flags.longValue() & 0x800000L) != 0L;
    }

    public Object clone() {
        TokenInfo clone;
        try {
            clone = (TokenInfo)super.clone();
            clone.hardwareVersion_ = (Version)this.hardwareVersion_.clone();
            clone.firmwareVersion_ = (Version)this.firmwareVersion_.clone();
            clone.time_ = new Date(this.time_.getTime());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("An unexpected clone exception occurred.", ex);
        }
        return clone;
    }

    public String getLabel() {
        return this.label_;
    }

    public String getManufacturerID() {
        return this.manufacturerID_;
    }

    public String getModel() {
        return this.model_;
    }

    public String getSerialNumber() {
        return this.serialNumber_;
    }

    public long getMaxSessionCount() {
        return this.maxSessionCount_;
    }

    public long getSessionCount() {
        return this.sessionCount_;
    }

    public long getMaxRwSessionCount() {
        return this.maxRwSessionCount_;
    }

    public long getRwSessionCount() {
        return this.rwSessionCount_;
    }

    public long getMaxPinLen() {
        return this.maxPinLen_;
    }

    public long getMinPinLen() {
        return this.minPinLen_;
    }

    public long getTotalPublicMemory() {
        return this.totalPublicMemory_;
    }

    public long getFreePublicMemory() {
        return this.freePublicMemory_;
    }

    public long getTotalPrivateMemory() {
        return this.totalPrivateMemory_;
    }

    public long getFreePrivateMemory() {
        return this.freePrivateMemory_;
    }

    public Version getHardwareVersion() {
        return this.hardwareVersion_;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion_;
    }

    public Date getTime() {
        return this.time_;
    }

    public boolean isRNG() {
        return this.rng_;
    }

    public boolean isWriteProtected() {
        return this.writeProtected_;
    }

    public boolean isLoginRequired() {
        return this.loginRequired_;
    }

    public boolean isUserPinInitialized() {
        return this.userPinInitialized_;
    }

    public boolean isRestoreKeyNotNeeded() {
        return this.restoreKeyNotNeeded_;
    }

    public boolean isClockOnToken() {
        return this.clockOnToken_;
    }

    public boolean isProtectedAuthenticationPath() {
        return this.protectedAuthenticationPath_;
    }

    public boolean isDualCryptoOperations() {
        return this.dualCryptoOperations_;
    }

    public boolean isTokenInitialized() {
        return this.tokenInitialized_;
    }

    public boolean isSecondaryAuthentication() {
        return this.secondaryAuthentication_;
    }

    public boolean isUserPinCountLow() {
        return this.userPinCountLow_;
    }

    public boolean isUserPinFinalTry() {
        return this.userPinFinalTry_;
    }

    public boolean isUserPinLocked() {
        return this.userPinLocked_;
    }

    public boolean isUserPinToBeChanged() {
        return this.userPinToBeChanged_;
    }

    public boolean isSoPinCountLow() {
        return this.soPinCountLow_;
    }

    public boolean isSoPinFinalTry() {
        return this.soPinFinalTry_;
    }

    public boolean isSoPinLocked() {
        return this.soPinLocked_;
    }

    public boolean isSoPinToBeChanged() {
        return this.soPinToBeChanged_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Label: ");
        buffer.append(this.label_);
        buffer.append(System.lineSeparator());
        buffer.append("Manufacturer ID: ");
        buffer.append(this.manufacturerID_);
        buffer.append(System.lineSeparator());
        buffer.append("Model: ");
        buffer.append(this.model_);
        buffer.append(System.lineSeparator());
        buffer.append("Serial Number: ");
        buffer.append(this.serialNumber_);
        buffer.append(System.lineSeparator());
        buffer.append("Random Number Generator: ");
        buffer.append(this.rng_);
        buffer.append(System.lineSeparator());
        buffer.append("Write protected: ");
        buffer.append(this.writeProtected_);
        buffer.append(System.lineSeparator());
        buffer.append("Login required: ");
        buffer.append(this.loginRequired_);
        buffer.append(System.lineSeparator());
        buffer.append("User PIN initialized: ");
        buffer.append(this.userPinInitialized_);
        buffer.append(System.lineSeparator());
        buffer.append("Restore Key not needed: ");
        buffer.append(this.restoreKeyNotNeeded_);
        buffer.append(System.lineSeparator());
        buffer.append("Clock on Token: ");
        buffer.append(this.clockOnToken_);
        buffer.append(System.lineSeparator());
        buffer.append("Protected Authentication Path: ");
        buffer.append(this.protectedAuthenticationPath_);
        buffer.append(System.lineSeparator());
        buffer.append("Dual Crypto Operations: ");
        buffer.append(this.dualCryptoOperations_);
        buffer.append(System.lineSeparator());
        buffer.append("Token initialized: ");
        buffer.append(this.tokenInitialized_);
        buffer.append(System.lineSeparator());
        buffer.append("Secondary Authentication: ");
        buffer.append(this.secondaryAuthentication_);
        buffer.append(System.lineSeparator());
        buffer.append("User PIN-Count low: ");
        buffer.append(this.userPinCountLow_);
        buffer.append(System.lineSeparator());
        buffer.append("User PIN final Try: ");
        buffer.append(this.userPinFinalTry_);
        buffer.append(System.lineSeparator());
        buffer.append("User PIN locked: ");
        buffer.append(this.userPinLocked_);
        buffer.append(System.lineSeparator());
        buffer.append("User PIN to be changed: ");
        buffer.append(this.userPinToBeChanged_);
        buffer.append(System.lineSeparator());
        buffer.append("Security Officer PIN-Count low: ");
        buffer.append(this.soPinCountLow_);
        buffer.append(System.lineSeparator());
        buffer.append("Security Officer PIN final Try: ");
        buffer.append(this.soPinFinalTry_);
        buffer.append(System.lineSeparator());
        buffer.append("Security Officer PIN locked: ");
        buffer.append(this.soPinLocked_);
        buffer.append(System.lineSeparator());
        buffer.append("Security Officer PIN to be changed: ");
        buffer.append(this.soPinToBeChanged_);
        buffer.append(System.lineSeparator());
        buffer.append("Maximum Session Count: ");
        buffer.append(this.maxSessionCount_ == -1L ? "<Information unavailable>" : (this.maxSessionCount_ == 0L ? "<effectively infinite>" : Long.toString(this.maxSessionCount_)));
        buffer.append(System.lineSeparator());
        buffer.append("Session Count: ");
        buffer.append(this.sessionCount_ == -1L ? "<Information unavailable>" : Long.toString(this.sessionCount_));
        buffer.append(System.lineSeparator());
        buffer.append("Maximum Read/Write Session Count: ");
        buffer.append(this.maxRwSessionCount_ == -1L ? "<Information unavailable>" : (this.maxRwSessionCount_ == 0L ? "<effectively infinite>" : Long.toString(this.maxRwSessionCount_)));
        buffer.append(System.lineSeparator());
        buffer.append("Read/Write Session Count: ");
        buffer.append(this.rwSessionCount_ == -1L ? "<Information unavailable>" : Long.toString(this.rwSessionCount_));
        buffer.append(System.lineSeparator());
        buffer.append("Maximum PIN Length: ");
        buffer.append(this.maxPinLen_);
        buffer.append(System.lineSeparator());
        buffer.append("Minimum PIN Length: ");
        buffer.append(this.minPinLen_);
        buffer.append(System.lineSeparator());
        buffer.append("Total Public Memory: ");
        buffer.append(this.totalPublicMemory_ == -1L ? "<Information unavailable>" : Long.toString(this.totalPublicMemory_));
        buffer.append(System.lineSeparator());
        buffer.append("Free Public Memory: ");
        buffer.append(this.freePublicMemory_ == -1L ? "<Information unavailable>" : Long.toString(this.freePublicMemory_));
        buffer.append(System.lineSeparator());
        buffer.append("Total Private Memory: ");
        buffer.append(this.totalPrivateMemory_ == -1L ? "<Information unavailable>" : Long.toString(this.totalPrivateMemory_));
        buffer.append(System.lineSeparator());
        buffer.append("Free Private Memory: ");
        buffer.append(this.freePrivateMemory_ == -1L ? "<Information unavailable>" : Long.toString(this.freePrivateMemory_));
        buffer.append(System.lineSeparator());
        buffer.append("Hardware Version: ");
        buffer.append(this.hardwareVersion_);
        buffer.append(System.lineSeparator());
        buffer.append("Firmware Version: ");
        buffer.append(this.firmwareVersion_);
        buffer.append(System.lineSeparator());
        buffer.append("Time: ");
        buffer.append(this.time_);
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof TokenInfo) {
            TokenInfo other = (TokenInfo)otherObject;
            equal = this == other || this.label_.equals(other.label_) && this.manufacturerID_.equals(other.manufacturerID_) && this.model_.equals(other.model_) && this.serialNumber_.equals(other.serialNumber_) && this.maxSessionCount_ == other.maxSessionCount_ && this.sessionCount_ == other.sessionCount_ && this.maxRwSessionCount_ == other.maxRwSessionCount_ && this.rwSessionCount_ == other.rwSessionCount_ && this.maxPinLen_ == other.maxPinLen_ && this.minPinLen_ == other.minPinLen_ && this.totalPublicMemory_ == other.totalPublicMemory_ && this.freePublicMemory_ == other.freePublicMemory_ && this.totalPrivateMemory_ == other.totalPrivateMemory_ && this.freePrivateMemory_ == other.freePrivateMemory_ && this.hardwareVersion_.equals(other.hardwareVersion_) && this.firmwareVersion_.equals(other.firmwareVersion_) && this.time_.equals(other.time_) && this.rng_ == other.rng_ && this.writeProtected_ == other.writeProtected_ && this.loginRequired_ == other.loginRequired_ && this.userPinInitialized_ == other.userPinInitialized_ && this.restoreKeyNotNeeded_ == other.restoreKeyNotNeeded_ && this.clockOnToken_ == other.clockOnToken_ && this.protectedAuthenticationPath_ == other.protectedAuthenticationPath_ && this.dualCryptoOperations_ == other.dualCryptoOperations_ && this.tokenInitialized_ == other.tokenInitialized_ && this.secondaryAuthentication_ == other.secondaryAuthentication_ && this.userPinCountLow_ == other.userPinCountLow_ && this.userPinFinalTry_ == other.userPinFinalTry_ && this.userPinLocked_ == other.userPinLocked_ && this.userPinToBeChanged_ == other.userPinToBeChanged_ && this.soPinCountLow_ == other.soPinCountLow_ && this.soPinFinalTry_ == other.soPinFinalTry_ && this.soPinLocked_ == other.soPinLocked_ && this.soPinToBeChanged_ == other.soPinToBeChanged_;
        }
        return equal;
    }

    public int hashCode() {
        return this.label_.hashCode() ^ this.manufacturerID_.hashCode() ^ this.model_.hashCode() ^ this.serialNumber_.hashCode();
    }
}

