/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.pkcs11.jna;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Utils {
    public static Pointer getPointerFromData(byte[] data) {
        Memory pointer = new Memory(data.length);
        pointer.write(0L, data, 0, data.length);
        return pointer;
    }

    public static Date parseTime(char[] timeChars) {
        Date time = null;
        if (timeChars != null && timeChars.length > 2) {
            String timeString = new String(timeChars, 0, timeChars.length - 2);
            try {
                SimpleDateFormat utc = new SimpleDateFormat("yyyyMMddhhmmss");
                utc.setTimeZone(TimeZone.getTimeZone("UTC"));
                time = utc.parse(timeString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return time;
    }

    public static char[] toCharArray(int number, int exactArrayLength) {
        char[] charArray = null;
        String numberString = Integer.toString(number);
        char[] numberChars = numberString.toCharArray();
        if (numberChars.length > exactArrayLength) {
            charArray = new char[exactArrayLength];
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = numberChars[i];
            }
        } else if (numberChars.length < exactArrayLength) {
            charArray = new char[exactArrayLength];
            int offset = exactArrayLength - numberChars.length;
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = i < offset ? 48 : numberChars[i - offset];
            }
        } else {
            charArray = numberChars;
        }
        return charArray;
    }
}

