/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.pkcs11.jna;

import kz.gamma.pkcs11.jna.CK_VERSION;

public class Version
implements Cloneable {
    protected byte major_;
    protected byte minor_;

    protected Version() {
    }

    protected Version(CK_VERSION ckVersion) {
        if (ckVersion == null) {
            throw new NullPointerException("Argument \"ckVersion\" must not be null.");
        }
        this.major_ = ckVersion.major;
        this.minor_ = ckVersion.minor;
    }

    public Object clone() {
        Version clone;
        try {
            clone = (Version)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("An unexpected clone exception occurred.", ex);
        }
        return clone;
    }

    public byte getMajor() {
        return this.major_;
    }

    public byte getMinor() {
        return this.minor_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.major_ & 0xFF);
        buffer.append('.');
        if (this.minor_ < 10) {
            buffer.append('0');
        }
        buffer.append(this.minor_ & 0xFF);
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof Version) {
            Version other = (Version)otherObject;
            equal = this == other || this.major_ == other.major_ && this.minor_ == other.minor_;
        }
        return equal;
    }

    public int hashCode() {
        return this.major_ ^ this.minor_;
    }
}

