/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Array;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import kz.gamma.core.UtilCM;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.jce.provider.JCEECPrivateKey;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.tumarcsp.params.StoreObjectParam;
import kz.gamma.tumarcsp.structure.CNT_PRIVATE_KEY;
import kz.gamma.x509.X509InstanceGetter;

public class KeyParams {
    @Deprecated
    public static final int PK_CREATETIME = 1;
    @Deprecated
    public static final int PK_SZOID = 2;
    @Deprecated
    public static final int PK_SERIALNUM = 3;
    @Deprecated
    public static final int PK_PUBLICKEY = 4;
    @Deprecated
    public static final int PK_CERTIFICATE = 5;
    @Deprecated
    public static final int PK_KEYSTATE = 6;
    @Deprecated
    public static final int PK_KEY_EXP_STATE = 7;
    @Deprecated
    public static final int PK_KEY_ALGID = 8;
    private int length;
    private Number hProv;
    private String pszContainer = "";
    private CSPUtil cspUtil = new CSPUtil();
    private Object[] createTimeList;
    private Object[] szOIDList;
    private Object[] serialNumList;
    private Object[] publicKeyList;
    private Object[] certificateList;
    private Object[] keyStateList;
    private Object[] keyExpStateList;
    private Object[] keyAlgIDList;
    private Object[] caCertificateList;
    private Object[] privateKeyList;

    public KeyParams(Number hProv) throws NoSuchProviderException, CertificateException, ParseException {
        this.hProv = hProv;
        byte[] len = TumarCspFunctions.cpGetProvParamByte(hProv, 47, 1, 0);
        this.length = UtilCM.byteToInt(len, 0, 1);
        byte[] pszContainerBytes = TumarCspFunctions.cpGetProvParamByte(hProv, 6, 0, 0);
        this.pszContainer = new String(pszContainerBytes, 0, DataConverter.getSizeWithoutNulls(pszContainerBytes, 0));
        this.createTimeList = new Object[this.length];
        this.szOIDList = new Object[this.length];
        this.serialNumList = new Object[this.length];
        this.publicKeyList = new Object[this.length];
        this.certificateList = new Object[this.length];
        this.keyStateList = new Object[this.length];
        this.keyExpStateList = new Object[this.length];
        this.keyAlgIDList = new Object[this.length];
        this.caCertificateList = new Object[this.length];
        this.privateKeyList = new Object[this.length];
        int dwFlags = 1;
        for (int i = 0; i < this.length; ++i) {
            CNT_PRIVATE_KEY cntPrivateKey = TumarCspFunctions.cpGetCntPrivateKey(hProv, dwFlags);
            dwFlags = 0;
            this.createTimeList[i] = this.getDate(cntPrivateKey.createTime);
            this.szOIDList[i] = cntPrivateKey.szOID;
            if (cntPrivateKey.getSerialNum() != null && cntPrivateKey.getSerialNum() != null) {
                this.serialNumList[i] = UtilCM.array2hex(cntPrivateKey.getSerialNum()).toUpperCase();
            }
            if (cntPrivateKey.getPublicKey() != null && cntPrivateKey.getPublicKey() != null) {
                this.publicKeyList[i] = UtilCM.array2hex(cntPrivateKey.getPublicKey()).toUpperCase();
            }
            if (cntPrivateKey.getCertificate() != null && cntPrivateKey.getCertificate() != null) {
                X509InstanceGetter x509InstanceGetter = new X509InstanceGetter();
                this.certificateList[i] = x509InstanceGetter.getX509CertificateInstance(cntPrivateKey.getCertificate());
            }
            this.keyStateList[i] = cntPrivateKey.state;
            this.keyExpStateList[i] = cntPrivateKey.exp;
            this.keyAlgIDList[i] = cntPrivateKey.algID;
            this.caCertificateList[i] = this.getCaCertificate((String)this.serialNumList[i]);
            this.privateKeyList[i] = this.getPrivateKey((String)this.serialNumList[i]);
        }
    }

    public Integer getIndexSN(String sn) throws Exception {
        for (int i = 0; i < this.serialNumList.length; ++i) {
            if (!sn.equalsIgnoreCase((String)this.serialNumList[i])) continue;
            return i;
        }
        throw new Exception("Certificate with serial number \"" + sn + "\" not found");
    }

    public Object[] getCreateTimeList() {
        return this.createTimeList;
    }

    public Object[] getSzOIDList() {
        return this.szOIDList;
    }

    public Object[] getSerialNumList() {
        return this.serialNumList;
    }

    public Object[] getPublicKeyList() {
        return this.publicKeyList;
    }

    public Object[] getCertificateList() {
        return this.certificateList;
    }

    public Object[] getKeyStateList() {
        return this.keyStateList;
    }

    public Object[] getKeyExpStateList() {
        return this.keyExpStateList;
    }

    public Object[] getKeyAlgIDList() {
        return this.keyAlgIDList;
    }

    public Object[] getCaCertificateList() {
        return this.caCertificateList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCaCertificate(String alias) {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("CA Certificate not found. Alias is null or empty. Alias: " + alias);
        }
        int keySpec = 2;
        String urlLocal = null;
        Number hProvLocal = 0;
        Number hKey = 0;
        try {
            keySpec = this.cspUtil.getTypeKey((Integer)this.keyAlgIDList[this.getIndexSN(alias)]);
            urlLocal = TumarCspFunctions.cpUrlToNewUrl(this.pszContainer, (String)this.serialNumList[this.getIndexSN(alias)], 1, this.hProv);
            hProvLocal = TumarCspFunctions.cpAcquireContext(urlLocal, 64);
            hKey = TumarCspFunctions.cpGetUserKey(hProvLocal, keySpec);
            byte[] ca = TumarCspFunctions.cpGetKeyParamData(hProvLocal, hKey, 68, 0);
            X509Certificate caCert = null;
            if (ca != null && ca.length > 0) {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509", GammaTechProvider.PROVIDER_NAME);
                    caCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(ca));
                }
                catch (CertificateException e) {
                    throw new RuntimeException("Error load certificate", e);
                }
                catch (NoSuchProviderException e) {
                    throw new RuntimeException("Error load certificate. Provider not found", e);
                }
            }
            X509Certificate x509Certificate = caCert;
            return x509Certificate;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var7_9 = null;
            return var7_9;
        }
        finally {
            if (hKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hProvLocal, hKey);
            }
            if (hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
            }
        }
    }

    public Object[] getPrivateKeyList() {
        return this.privateKeyList;
    }

    public Object getPrivateKey(String alias) {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Private key not found. Alias is null or empty. Alias: " + alias);
        }
        try {
            int keyAlgId = (Integer)this.keyAlgIDList[this.getIndexSN(alias)];
            int keySpec = this.cspUtil.getTypeKey(keyAlgId);
            String urlLocal = TumarCspFunctions.cpUrlToNewUrl(this.pszContainer, (String)this.serialNumList[this.getIndexSN(alias)], 1, this.hProv);
            Number hProvLocal = TumarCspFunctions.cpAcquireContext(urlLocal, 64);
            Number hKey = TumarCspFunctions.cpGetUserKey(hProvLocal, keySpec);
            JCEECPrivateKey privKey = new JCEECPrivateKey(urlLocal, hProvLocal, hKey);
            return privKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public Date getDate(String time) throws ParseException {
        return DateUtils.getInstance().stringToDate(time);
    }

    public static Enumeration makeEnumeration(final Object obj) {
        Class<?> type = obj.getClass();
        if (!type.isArray()) {
            throw new IllegalArgumentException(obj.getClass().toString());
        }
        return new Enumeration(){
            int size;
            int cursor;
            {
                this.size = Array.getLength(obj);
            }

            @Override
            public boolean hasMoreElements() {
                return this.cursor < this.size;
            }

            public Object nextElement() {
                return Array.get(obj, this.cursor++);
            }
        };
    }

    public Enumeration getCreateTime() {
        return KeyParams.makeEnumeration(this.createTimeList);
    }

    public Enumeration getSzOID() {
        return KeyParams.makeEnumeration(this.szOIDList);
    }

    public Enumeration getSerialNum() {
        return KeyParams.makeEnumeration(this.serialNumList);
    }

    public Enumeration getPublicKey() {
        return KeyParams.makeEnumeration(this.publicKeyList);
    }

    public Enumeration getCertificate() {
        return KeyParams.makeEnumeration(this.certificateList);
    }

    public Enumeration getKeyState() {
        return KeyParams.makeEnumeration(this.keyStateList);
    }

    public Enumeration getKeyExpState() {
        return KeyParams.makeEnumeration(this.keyExpStateList);
    }

    public Enumeration getKeyAlgID() {
        return KeyParams.makeEnumeration(this.keyAlgIDList);
    }

    public Enumeration getObjectParam() {
        ArrayList<StoreObjectParam> lst = new ArrayList<StoreObjectParam>();
        for (int i = 0; i < this.length; ++i) {
            StoreObjectParam prm = new StoreObjectParam(this.pszContainer, this, i);
            lst.add(prm);
        }
        return KeyParams.makeEnumeration(lst.toArray());
    }
}

