/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp;

import java.io.File;
import kz.gamma.tumarcsp.LibraryWrapper;

public class LibPathGetter {
    private static boolean isFileExists(String fileName) {
        if (fileName == null) {
            return false;
        }
        File f = new File(fileName);
        return f.exists() && !f.isDirectory();
    }

    public static String getLibPath(String name) {
        String path;
        block17: {
            if (name != null) {
                return name;
            }
            path = null;
            try {
                String osName = System.getProperty("os.name");
                String sunArchDataModel = System.getProperty("sun.arch.data.model");
                sunArchDataModel = sunArchDataModel == null ? "UNKNOWN" : sunArchDataModel;
                osName = osName == null ? "UNKNOWN" : osName.toUpperCase();
                String libraryPath32 = System.getProperty("tumarcsp.32.library.path");
                String libraryPath64 = System.getProperty("tumarcsp.64.library.path");
                String javaVendorUrl = System.getProperty("java.vendor.url");
                javaVendorUrl = javaVendorUrl == null ? "UNKNOWN" : javaVendorUrl.toUpperCase();
                String javaVmName = System.getProperty("java.vm.name");
                javaVmName = javaVmName == null ? "UNKNOWN" : javaVmName.toUpperCase();
                String javaVmVendor = System.getProperty("java.vm.vendor");
                javaVmVendor = javaVmVendor == null ? "UNKNOWN" : javaVmVendor.toUpperCase();
                String javaVendor = System.getProperty("java.vendor");
                javaVendor = javaVendor == null ? "UNKNOWN" : javaVendor.toUpperCase();
                String javaRuntimeName = System.getProperty("java.runtime.name");
                String string = javaRuntimeName = javaRuntimeName == null ? "UNKNOWN" : javaRuntimeName.toUpperCase();
                if (javaVendorUrl.contains("ANDROID") || javaVmName.contains("ANDROID") || javaVmVendor.contains("ANDROID") || javaVendor.contains("ANDROID") || javaRuntimeName.contains("ANDROID")) {
                    path = name == null ? LibraryWrapper.LIBRARY_NAME : name;
                    break block17;
                }
                if (libraryPath32 != null && libraryPath32.trim().length() > 0 && sunArchDataModel.equals("32")) {
                    path = libraryPath32;
                    break block17;
                }
                if (libraryPath64 != null && libraryPath64.trim().length() > 0 && sunArchDataModel.equals("64")) {
                    path = libraryPath64;
                    break block17;
                }
                if (osName.contains("LINUX")) {
                    path = sunArchDataModel.equals("32") ? "/lib/libcptumar_r.so.4.0" : "/lib64/libcptumar_r.so.4.0";
                    break block17;
                }
                if (osName.contains("MAC OS")) {
                    String path1;
                    String[] paths = new String[3];
                    paths[0] = "/Library/TumarCSP/lib/libcptumar_r.4.0.dylib";
                    String userName = System.getProperty("user.name");
                    paths[1] = path1 = String.format("/Users/%s/Library/TumarCSP/lib/libcptumar_r.4.0.dylib", userName);
                    paths[2] = "/usr/lib/libcptumar_r.4.0.dylib";
                    for (String _path : paths) {
                        if (!LibPathGetter.isFileExists(_path)) continue;
                        path = _path;
                        break block17;
                    }
                    break block17;
                }
                if (osName.contains("HP-UX")) {
                    if (sunArchDataModel.equals("32")) {
                        throw new Exception("32 bit library is not supported in HP-UX system");
                    }
                    path = "/usr/lib/libcptumar.4.0_r.sl";
                    break block17;
                }
                if (osName.contains("AIX")) {
                    if (sunArchDataModel.equals("32")) {
                        throw new Exception("32 bit library is not supported in AIX system");
                    }
                    path = "/lib/libcptumar_r.so.4.0";
                    break block17;
                }
                if (osName.contains("SOLARIS") || osName.contains("SUNOS")) {
                    if (sunArchDataModel.equals("32")) {
                        throw new Exception("32 bit library is not supported in SOLARIS, SUNOS systems");
                    }
                    path = "/lib/libcptumar_r.so.4.0";
                    break block17;
                }
                if (osName.contains("WIN")) {
                    path = LibPathGetter.getWinLibPath(sunArchDataModel, false);
                    if (!LibPathGetter.isFileExists(path)) {
                        path = LibPathGetter.getWinLibPath(sunArchDataModel, true);
                    }
                    break block17;
                }
                throw new Exception(osName + " is not supported");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    private static String getWinLibPath(String sunArchDataModel, boolean isHsmVersion) {
        String tumarName;
        String path = null;
        String programFilesPath = System.getenv("ProgramFiles");
        String programFilesX86Path = System.getenv("ProgramFiles(x86)");
        String string = tumarName = isHsmVersion ? "TumarHSM" : "TumarCSP";
        if (sunArchDataModel.equals("32")) {
            String cpTumarPath32 = "\\GammaTech\\" + tumarName + "\\lib\\cptumar.dll";
            if (programFilesPath != null) {
                if (LibPathGetter.isFileExists(programFilesPath + cpTumarPath32)) {
                    path = programFilesPath + cpTumarPath32;
                } else if (programFilesX86Path != null) {
                    path = programFilesX86Path + cpTumarPath32;
                }
            }
        } else {
            String cpTumarPath64 = "\\GammaTech\\" + tumarName + "\\lib64\\cptumar.dll";
            if (programFilesPath != null) {
                if (LibPathGetter.isFileExists(programFilesPath + cpTumarPath64)) {
                    path = programFilesPath + cpTumarPath64;
                } else if (programFilesX86Path != null) {
                    path = programFilesX86Path + cpTumarPath64;
                }
            }
        }
        return path;
    }
}

