/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kz.gamma.core.UtilCM;
import kz.gamma.jce.exception.CSPException;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.ErrorResolver;
import kz.gamma.tumarcsp.LibPathGetter;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.StructUtil;
import kz.gamma.tumarcsp.TumarCSPJNA;
import kz.gamma.tumarcsp.structure.CNT_CERT;
import kz.gamma.tumarcsp.structure.CNT_PRIVATE_KEY;
import kz.gamma.tumarcsp.structure.CONTINFOEX;
import kz.gamma.tumarcsp.structure.CSP_ALG_OBJECT;
import kz.gamma.tumarcsp.structure.KEYSTORAGE_INFO;
import kz.gamma.tumarcsp.structure.PROFILE_URL;
import kz.gamma.tumarcsp.structure.USERLICENCE;

public class TumarCspFunctions {
    public static TumarCSPJNA tumarCSPJNA;
    static final boolean IS_DEBUG = false;
    public static final int ERROR_NO_MORE_ITEMS = 259;
    private static final int TUMAR_MAX_HASH_SIZE_BYTES = 64;
    private static final int TUMAR_MAX_SIGN_SIZE_BYTES = 512;
    private static final int PP_URL_TO_PROF = 64;
    private static final int PP_PROF_TO_URL = 65;
    private static final int PP_ADD_PROFILE = 67;
    public static final int PP_VERSION = 5;
    public static final int CRYPT_VERIFYCONTEXT = -268435456;
    private static final String NTE_NOT_FOUND = "80090011";
    private static int libraryBit;
    private static int CIPHERTEXT_ADDING;

    public static Number cpAcquireContext(String pszContainer, int dwFlags) {
        return TumarCspFunctions.cpAcquireContext(pszContainer, dwFlags, 0);
    }

    public static Number cpAcquireContext(String pszContainer, int dwFlags, Number pVTable) {
        Number hProv;
        TumarCspFunctions.checkLibBit();
        byte[] phProv = TumarCspFunctions.getLongRefArray();
        boolean res = tumarCSPJNA.CPAcquireContext(phProv, pszContainer, dwFlags, new Pointer(pVTable == null ? 0L : pVTable.longValue()));
        if (!res) {
            // empty if block
        }
        if (TumarCspFunctions.isZeroHandle(hProv = TumarCspFunctions.getHandle(phProv)) && dwFlags != 16) {
            throw new CSPException(new ErrorResolver(hProv), "Error load profile ");
        }
        return hProv;
    }

    public static int cpReleaseContext(Number hProv, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        boolean res = tumarCSPJNA.CPReleaseContext(new Pointer(hProv.longValue()), dwFlags);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error release csp context ");
        }
        return 1;
    }

    public static int cpSetProvParam(Number hProv, int dwParam, byte[] pbData, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        pbData = DataConverter.getNullTerminatedArray(pbData);
        boolean res = tumarCSPJNA.CPSetProvParam(new Pointer(hProv.longValue()), dwParam, pbData, dwFlags);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error set provider param (" + dwParam + ") ");
        }
        return 1;
    }

    public static int cpSetKeyParam(Number hProv, Number hKey, int dwParam, byte[] pbData, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        pbData = DataConverter.getNullTerminatedArray(pbData);
        TumarCspFunctions.checkHProvHKey(hProv, hKey);
        boolean res = tumarCSPJNA.CPSetKeyParam(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), dwParam, pbData, dwFlags);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error set key param (" + dwParam + ") ");
        }
        return 1;
    }

    public static byte[] cpGetKeyParamData(Number hProv, Number hKey, int dwParam, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProvHKey(hProv, hKey);
        byte[] dataLen = TumarCspFunctions.getIntRefArray();
        boolean res = tumarCSPJNA.CPGetKeyParam(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), dwParam, null, dataLen, dwFlags);
        if (res) {
            byte[] localData = new byte[StructUtil.byteToInt(dataLen)];
            res = tumarCSPJNA.CPGetKeyParam(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), dwParam, localData, dataLen, dwFlags);
            if (res) {
                byte[] ret = TumarCspFunctions.getCuttedArray(localData, StructUtil.byteToInt(dataLen));
                if (dwParam == 7 || dwParam == 123 || dwParam == 80 || dwParam == 77 || dwParam == 75 || dwParam == 76 || dwParam == 110) {
                    ret = UtilCM.copyByte(ret, 0, ret.length, LibraryWrapper.SUN_CPU_ENDIAN);
                }
                return ret;
            }
        }
        CSPException e = new CSPException(new ErrorResolver(hProv), "Error get key param data (" + dwParam + ") ");
        if (e.errorRes.errorStr.equals(NTE_NOT_FOUND) && (dwParam == 26 || dwParam == 68)) {
            return null;
        }
        throw e;
    }

    public static int cpDestroyKey(Number hProv, Number hKey) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProvHKey(hProv, hKey);
        boolean res = tumarCSPJNA.CPDestroyKey(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()));
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error destroy key ");
        }
        return 1;
    }

    public static byte[] cpExportKeyData(Number hProv, Number hKey, Number hExpKey, int dwBlobType, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        byte[] dataLen = TumarCspFunctions.getIntRefArray();
        boolean res = tumarCSPJNA.CPExportKey(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), new Pointer(hExpKey.longValue()), dwBlobType, dwFlags, null, dataLen);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error export key data ");
        }
        byte[] localData = new byte[StructUtil.byteToInt(dataLen)];
        res = tumarCSPJNA.CPExportKey(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), new Pointer(hExpKey.longValue()), dwBlobType, dwFlags, localData, dataLen);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error export key data ");
        }
        return TumarCspFunctions.getCuttedArray(localData, StructUtil.byteToInt(dataLen));
    }

    public static int cpExportKeyDataSize(Number hProv, Number hKey, Number hExpKey, int dwBlobType, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        byte[] dataLen = StructUtil.intToByte(0);
        boolean res = tumarCSPJNA.CPExportKey(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), new Pointer(hExpKey.longValue()), dwBlobType, dwFlags, null, dataLen);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error export key data ");
        }
        return StructUtil.byteToInt(dataLen);
    }

    public static byte[] cpExportKeyData(Number hProv, Number hKey, byte[] pubKeyData, int dwBlobType, int dwFlags) {
        boolean retCode;
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        pubKeyData = DataConverter.getNullTerminatedArray(pubKeyData);
        int size = 8192;
        byte[] localData = new byte[size];
        byte[] len = TumarCspFunctions.getIntRefArray();
        byte[] dataLen = StructUtil.intToByte(size);
        switch (dwBlobType) {
            case 48: {
                retCode = true;
                break;
            }
            case 49: {
                retCode = tumarCSPJNA.CPGetKeyParam(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), 68, null, len, 0);
                if (StructUtil.byteToInt(len) == 0) {
                    retCode = tumarCSPJNA.CPGetKeyParam(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), 26, localData, dataLen, 0);
                    break;
                }
                retCode = tumarCSPJNA.CPGetKeyParam(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), 69, localData, dataLen, 0);
                break;
            }
            default: {
                retCode = true;
            }
        }
        if (retCode) {
            retCode = tumarCSPJNA.CPExportKey(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), pubKeyData, dwBlobType, dwFlags, localData, dataLen);
        }
        if (retCode) {
            return TumarCspFunctions.getCuttedArray(localData, StructUtil.byteToInt(dataLen));
        }
        throw new CSPException(new ErrorResolver(hProv), "Error export key data ");
    }

    public static byte[] cpExportKeyDataEx(Number hProv, Number hKey, Number hExpKey, int dwBlobType, int dwFlags, int dwSizeBlob) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        byte[] dataLen = StructUtil.intToByte(dwSizeBlob);
        byte[] localData = new byte[dwSizeBlob];
        boolean res = tumarCSPJNA.CPExportKey(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), new Pointer(hExpKey.longValue()), dwBlobType, dwFlags, localData, dataLen);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error export key data ");
        }
        return TumarCspFunctions.getCuttedArray(localData, StructUtil.byteToInt(dataLen));
    }

    public static Number cpGetUserKey(Number hProv, int dwKeySpec) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        byte[] phUserKey = TumarCspFunctions.getLongRefArray();
        boolean res = tumarCSPJNA.CPGetUserKey(new Pointer(hProv.longValue()), dwKeySpec, phUserKey);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error get user key ");
        }
        return TumarCspFunctions.getHandle(phUserKey);
    }

    public static Number cpImportKey(Number hProv, byte[] pbData, int dwDataLen, Number hPubKey, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        byte[] phKey = TumarCspFunctions.getLongRefArray();
        boolean res = tumarCSPJNA.CPImportKey(new Pointer(hProv.longValue()), pbData, dwDataLen, new Pointer(hPubKey.longValue()), dwFlags, phKey);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error import key ");
        }
        return TumarCspFunctions.getHandle(phKey);
    }

    public static Number cpImportKey(Number hProv, byte[] pbData, int dwDataLen, byte[] impKeyData, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        impKeyData = DataConverter.getNullTerminatedArray(impKeyData);
        byte[] phKey = TumarCspFunctions.getLongRefArray();
        boolean res = tumarCSPJNA.CPImportKey(new Pointer(hProv.longValue()), pbData, dwDataLen, impKeyData, dwFlags, phKey);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error import key ");
        }
        return TumarCspFunctions.getHandle(phKey);
    }

    public static Number cpCreateHash(Number hProv, int algId, Number hKey, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        byte[] phHash = TumarCspFunctions.getLongRefArray();
        boolean res = tumarCSPJNA.CPCreateHash(new Pointer(hProv.longValue()), algId, new Pointer(hKey.longValue()), dwFlags, phHash);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error create hash. Algoritm (" + algId + ")");
        }
        return TumarCspFunctions.getHandle(phHash);
    }

    public static int cpDestroyHash(Number hProv, Number hHash) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHHash(hHash);
        boolean res = tumarCSPJNA.CPDestroyHash(new Pointer(hProv.longValue()), new Pointer(hHash.longValue()));
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error destroy hash ");
        }
        return 1;
    }

    public static byte[] cpGetHashParamData(Number hProv, Number hHash, int dwParam, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHHash(hHash);
        byte[] localData = new byte[64];
        byte[] sizeArray = StructUtil.intToByte(64);
        boolean res = tumarCSPJNA.CPGetHashParam(new Pointer(hProv.longValue()), new Pointer(hHash.longValue()), dwParam, localData, sizeArray, dwFlags);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error get hash param data (" + dwParam + ") ");
        }
        return TumarCspFunctions.getCuttedArray(localData, StructUtil.byteToInt(sizeArray));
    }

    public static int cpHashData(Number hProv, Number hHash, byte[] pbData, int dwDataLen, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHHash(hHash);
        boolean res = tumarCSPJNA.CPHashData(new Pointer(hProv.longValue()), new Pointer(hHash.longValue()), pbData, dwDataLen, dwFlags);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error hash data ");
        }
        return 1;
    }

    public static byte[] cpSignHashData(Number hProv, Number hHash, int dwKeySpec, String sDescription, int dwFlags) {
        return TumarCspFunctions.cpSignHashData(hProv, hHash, dwKeySpec, sDescription, dwFlags, 512);
    }

    public static byte[] cpSignHashData(Number hProv, Number hHash, int dwKeySpec, String sDescription, int dwFlags, int size) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHHash(hHash);
        byte[] localData = new byte[size];
        byte[] dataLen = StructUtil.intToByte(size);
        boolean res = tumarCSPJNA.CPSignHash(new Pointer(hProv.longValue()), new Pointer(hHash.longValue()), dwKeySpec, null, dwFlags, localData, dataLen);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error create sign ");
        }
        byte[] ret = TumarCspFunctions.getCuttedArray(localData, StructUtil.byteToInt(dataLen));
        return ret;
    }

    public static int cpVerifySignature(Number hProv, Number hHash, byte[] pbSignature, int dwSigLen, Number hPubKey, String sDescription, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        boolean res = tumarCSPJNA.CPVerifySignature(new Pointer(hProv.longValue()), new Pointer(hHash.longValue()), pbSignature, dwSigLen, new Pointer(hPubKey.longValue()), null, dwFlags);
        if (!res) {
            byte[] pbSignatureBackward = UtilCM.inverseCopyByte(pbSignature, 0, pbSignature.length);
            res = tumarCSPJNA.CPVerifySignature(new Pointer(hProv.longValue()), new Pointer(hHash.longValue()), pbSignatureBackward, dwSigLen, new Pointer(hPubKey.longValue()), null, dwFlags);
        }
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error verify signature ");
        }
        return 1;
    }

    public static Number cpDeriveKey(Number hProv, int algId, Number hHash, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHHash(hHash);
        byte[] phKey = TumarCspFunctions.getLongRefArray();
        boolean res = tumarCSPJNA.CPDeriveKey(new Pointer(hProv.longValue()), algId, new Pointer(hHash.longValue()), dwFlags, phKey);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error derive key. Algorithm(" + algId + ") ");
        }
        return TumarCspFunctions.getHandle(phKey);
    }

    public static Number cpDuplicateKey(Number hProv, Number hKey, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHKey(hKey);
        byte[] phKey = TumarCspFunctions.getLongRefArray();
        boolean res = tumarCSPJNA.CPDuplicateKey(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), null, dwFlags, phKey);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error duplicate key ");
        }
        return TumarCspFunctions.getHandle(phKey);
    }

    public static byte[] cpGenRandom(Number hProv, int dwLen) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        byte[] ret = new byte[dwLen];
        boolean res = tumarCSPJNA.CPGenRandom(new Pointer(hProv.longValue()), dwLen, ret);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error generate random bytes ");
        }
        return ret;
    }

    public static Number cpGenKey(Number hProv, int algId, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        byte[] phKey = TumarCspFunctions.getLongRefArray();
        boolean res = tumarCSPJNA.CPGenKey(new Pointer(hProv.longValue()), algId, dwFlags, phKey);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error generate key. Algorithm(" + algId + ") ");
        }
        return TumarCspFunctions.getHandle(phKey);
    }

    public static byte[] cpDecrypt(Number hProv, Number hKey, Number hHash, int bFinal, int dwFlags, byte[] pbData, int pdwDataLen) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHKey(hKey);
        byte[] dataLen = StructUtil.intToByte(pdwDataLen);
        byte[] dataLocal = (byte[])pbData.clone();
        boolean res = tumarCSPJNA.CPDecrypt(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), new Pointer(hHash.longValue()), bFinal != 0, dwFlags, dataLocal, dataLen);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error Decrypt data ");
        }
        int resLen = StructUtil.byteToInt(dataLen);
        if (resLen == 0) {
            return null;
        }
        return TumarCspFunctions.getCuttedArray(dataLocal, resLen);
    }

    public static byte[] cpEncrypt(Number hProv, Number hKey, Number hHash, int bFinal, int dwFlags, byte[] pbData, int pdwDataLen, int dwBufLen) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHKey(hKey);
        byte[] dataLen = StructUtil.intToByte(pdwDataLen);
        byte[] buf = new byte[dwBufLen += CIPHERTEXT_ADDING + 1];
        System.arraycopy(pbData, 0, buf, 0, pdwDataLen);
        boolean res = tumarCSPJNA.CPEncrypt(new Pointer(hProv.longValue()), new Pointer(hKey.longValue()), new Pointer(hHash.longValue()), bFinal != 0, dwFlags, buf, dataLen, dwBufLen);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error Encrypt data ");
        }
        int resLen = StructUtil.byteToInt(dataLen);
        if (resLen == 0) {
            return null;
        }
        return TumarCspFunctions.getCuttedArray(buf, resLen);
    }

    public static Number cpDuplicateHash(Number hProv, Number hHash, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHHash(hHash);
        byte[] phHash = TumarCspFunctions.getLongRefArray();
        boolean res = tumarCSPJNA.CPDuplicateHash(new Pointer(hProv.longValue()), new Pointer(hHash.longValue()), null, dwFlags, phHash);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error Duplicate Hash ");
        }
        return TumarCspFunctions.getHandle(phHash);
    }

    public static int cpHashSessionKey(Number hProv, Number hHash, Number hKey, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHKey(hKey);
        TumarCspFunctions.checkHHash(hHash);
        boolean res = tumarCSPJNA.CPHashSessionKey(new Pointer(hProv.longValue()), new Pointer(hHash.longValue()), new Pointer(hKey.longValue()), dwFlags);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error hash session key ");
        }
        return 1;
    }

    public static int cpSetHashParam(Number hProv, Number hHash, int dwParam, byte[] pbData, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHHash(hHash);
        pbData = DataConverter.getNullTerminatedArray(pbData);
        boolean res = tumarCSPJNA.CPSetHashParam(new Pointer(hProv.longValue()), new Pointer(hHash.longValue()), dwParam, pbData, dwFlags);
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error set hash param(" + dwParam + ") ");
        }
        return 1;
    }

    public static String cpCreateProfile(String name, String dev, String user, String pass, String param, String cont, int alg_exch, int alg_sign, Number hProv) {
        Integer algCodeSign;
        Integer algCodeExch;
        TumarCspFunctions.checkLibBit();
        String result = null;
        if (GammaTechProvider.getAlgUtil().isCspContainsKzOids().booleanValue()) {
            algCodeExch = alg_exch;
            algCodeSign = alg_sign;
        } else {
            algCodeExch = GammaTechProvider.getAlgUtil().getAlgCode(alg_exch);
            algCodeSign = GammaTechProvider.getAlgUtil().getAlgCode(alg_sign);
        }
        if (TumarCspFunctions.isZeroHandle(hProv)) {
            throw new IllegalArgumentException("Provider not loaded");
        }
        CONTINFOEX continfoex = new CONTINFOEX(name, dev, user, pass, param, cont, algCodeExch, algCodeSign);
        boolean res = tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), 65, continfoex, continfoex.getSize(), 0);
        if (res) {
            String url = StructUtil.getString(continfoex.url);
            PROFILE_URL profileUrl = new PROFILE_URL(name, url);
            if (tumarCSPJNA.CPSetProvParam(new Pointer(hProv.longValue()), 67, profileUrl, 0)) {
                result = url;
            }
        }
        if (result == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error create profile ");
        }
        return result;
    }

    public static void addProfile(String name, String profUrl, Number hProv) {
        TumarCspFunctions.checkLibBit();
        if (TumarCspFunctions.isZeroHandle(hProv)) {
            throw new IllegalArgumentException("Provider not loaded");
        }
        PROFILE_URL profileUrl = new PROFILE_URL(name, profUrl);
        if (tumarCSPJNA.CPSetProvParam(new Pointer(hProv.longValue()), 67, profileUrl, 0)) {
            return;
        }
        throw new CSPException(new ErrorResolver(hProv), "Error create profile ");
    }

    public static String cpCreateUrl(String name, String dev, String user, String pass, String param, String cont, int alg_exch, int alg_sign, Number hProv) {
        Integer algCodeOrAlgIdSign;
        Integer algCodeOrAlgIdExch;
        TumarCspFunctions.checkLibBit();
        if (TumarCspFunctions.isZeroHandle(hProv)) {
            throw new IllegalArgumentException("Provider not loaded");
        }
        String ret = null;
        if (GammaTechProvider.getAlgUtil().isCspContainsKzOids().booleanValue()) {
            algCodeOrAlgIdExch = alg_exch;
            algCodeOrAlgIdSign = alg_sign;
        } else {
            algCodeOrAlgIdExch = GammaTechProvider.getAlgUtil().getAlgCode(alg_exch);
            algCodeOrAlgIdSign = GammaTechProvider.getAlgUtil().getAlgCode(alg_sign);
        }
        CONTINFOEX continfoex = new CONTINFOEX(name, dev, user, pass, param, cont, algCodeOrAlgIdExch, algCodeOrAlgIdSign);
        boolean res = tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), 65, continfoex, continfoex.getSize(), 0);
        if (res) {
            ret = StructUtil.getString(continfoex.url);
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error create url ");
        }
        return ret;
    }

    public static String cpUrlToNewUrl(String url, String param, int type, Number hProv) {
        TumarCspFunctions.checkLibBit();
        TumarCspFunctions.checkHProv(hProv);
        CONTINFOEX continfoex = new CONTINFOEX(url);
        boolean res = tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), 64, continfoex, continfoex.getSize(), 0);
        if (res) {
            switch (type) {
                case 0: {
                    continfoex.setPass(StructUtil.getByteArray(param));
                    break;
                }
                case 1: {
                    continfoex.setSn(UtilCM.hex2array(param));
                    break;
                }
            }
            res = tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), 65, continfoex, continfoex.getSize(), 0);
        }
        if (!res) {
            throw new CSPException(new ErrorResolver(hProv), "Error convert url to new url (" + url + ")");
        }
        return StructUtil.getString(continfoex.url);
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] cpGetProvParamByte(Number hProv, int dwParam, int dwFlags, int dwField) {
        block55: {
            block54: {
                TumarCspFunctions.checkLibBit();
                if (TumarCspFunctions.isZeroHandle(hProv) && dwParam != 55) {
                    throw new IllegalArgumentException("Provider not loaded");
                }
                resData = null;
                if (dwParam != 55) break block54;
                size = Native.getNativeSize(Integer.class);
                dataLen = StructUtil.intToByte(size);
                code = new byte[size];
                res = TumarCspFunctions.tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), dwParam, code, dataLen, 0);
                if (!res) {
                    res = TumarCspFunctions.tumarCSPJNA.CPGetProvParam(new Pointer(0L), dwParam, code, dataLen, 0);
                }
                if (res && StructUtil.byteToInt(dataLen) > 0) {
                    resData = code;
                }
                break block55;
            }
            if (dwParam != 44) ** GOTO lbl31
            keystorageInfo = new KEYSTORAGE_INFO();
            res = TumarCspFunctions.tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), dwParam, keystorageInfo, keystorageInfo.getSize(), dwFlags);
            if (res) {
                switch (dwField) {
                    case 0: {
                        resData = StructUtil.getByteArray(keystorageInfo.name);
                        break;
                    }
                    case 1: {
                        resData = StructUtil.getByteArray(keystorageInfo.altName);
                    }
                }
            } else {
                errorResolver = new ErrorResolver(hProv);
                if (errorResolver.error != 259) {
                    throw new CSPException(errorResolver, "Error CPGetProvParam with PP_ENUM_KEYSTORAGE param");
                }
                return null;
lbl31:
                // 1 sources

                if (dwParam == 52 || dwParam == 51) {
                    cspAlgObject = new CSP_ALG_OBJECT();
                    res = TumarCspFunctions.tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), dwParam, cspAlgObject, cspAlgObject.getSize(), dwFlags);
                    if (res) {
                        switch (dwField) {
                            case 0: {
                                resData = StructUtil.intToByte(cspAlgObject.code);
                                break;
                            }
                            case 1: {
                                resData = StructUtil.intToByte(cspAlgObject.ai);
                                break;
                            }
                            case 2: {
                                resData = StructUtil.intToByte(cspAlgObject.sec_bits);
                                break;
                            }
                            case 3: {
                                resData = StructUtil.intToByte(cspAlgObject.pub_bits);
                                break;
                            }
                            case 4: {
                                resData = StructUtil.getByteArray(cspAlgObject.oid);
                                break;
                            }
                            case 5: {
                                resData = StructUtil.getByteArray(cspAlgObject.name);
                                break;
                            }
                            case 6: {
                                resData = StructUtil.intToByte(cspAlgObject.obj_alg_type);
                                break;
                            }
                            case 7: {
                                resData = StructUtil.intToByte(cspAlgObject.max_level);
                            }
                        }
                    }
                } else if (dwParam == 66) {
                    licence = new USERLICENCE();
                    if (TumarCspFunctions.tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), dwParam, licence, licence.getSize(), dwFlags)) {
                        switch (dwField) {
                            case 0: {
                                resData = StructUtil.getByteArray(licence.User);
                                break;
                            }
                            case 1: {
                                resData = StructUtil.getByteArray(licence.Name);
                                break;
                            }
                            case 2: {
                                resData = StructUtil.getByteArray(licence.Created);
                                break;
                            }
                            case 3: {
                                resData = StructUtil.getByteArray(licence.Expires);
                                break;
                            }
                            case 4: {
                                resData = StructUtil.getByteArray(licence.Level);
                            }
                        }
                    }
                } else if (dwParam == 45) {
                    pKey = new CNT_PRIVATE_KEY();
                    if (TumarCspFunctions.tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), dwParam, pKey, pKey.getSize(), dwFlags)) {
                        switch (dwField) {
                            case 1: {
                                if (pKey.createTime == null) break;
                                resData = StructUtil.getByteArray(pKey.createTime);
                                break;
                            }
                            case 2: {
                                if (pKey.szOID == null) break;
                                resData = StructUtil.getByteArray(pKey.szOID);
                                break;
                            }
                            case 3: {
                                if (pKey.serialNum.cbData <= 0) break;
                                resData = pKey.serialNum.pbData.getByteArray(0L, pKey.serialNum.cbData);
                                break;
                            }
                            case 4: {
                                if (pKey.publicKey.cbData <= 0) break;
                                resData = pKey.publicKey.pbData.getByteArray(0L, pKey.publicKey.cbData);
                                break;
                            }
                            case 5: {
                                if (pKey.certificate.cbData <= 0) break;
                                resData = pKey.certificate.pbData.getByteArray(0L, pKey.certificate.cbData);
                                break;
                            }
                            case 6: {
                                resData = StructUtil.intToByte(pKey.state);
                                break;
                            }
                            case 7: {
                                resData = StructUtil.intToByte(pKey.exp);
                                break;
                            }
                            case 8: {
                                resData = StructUtil.intToByte(pKey.algID);
                            }
                        }
                    }
                } else {
                    dataLen = StructUtil.intToByte(256);
                    pbData = new byte[256];
                    if (TumarCspFunctions.tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), dwParam, pbData, dataLen, dwFlags)) {
                        resData = TumarCspFunctions.getCuttedArray(pbData, StructUtil.byteToInt(dataLen));
                    }
                }
            }
        }
        if (resData != null) ** GOTO lbl124
        if (dwParam != 55) {
            e = new CSPException(new ErrorResolver(hProv), "Error get provider param data (" + dwParam + ") ");
            if (e.errorRes.error != 259 && e.errorRes.error != 0) {
                throw e;
            }
        } else {
            throw new CSPException(new RuntimeException("Error get provider param data (" + dwParam + ") "));
lbl124:
            // 1 sources

            if (dwParam == 55) {
                resData = UtilCM.copyByte(resData, 0, resData.length, LibraryWrapper.SUN_CPU_ENDIAN);
            }
            if (!(dwParam != 52 && dwParam != 51 || dwField != 0 && dwField != 1 && dwField != 2 && dwField != 3 && dwField != 6 && dwField != 7)) {
                resData = UtilCM.copyByte(resData, 0, resData.length, LibraryWrapper.SUN_CPU_ENDIAN);
            }
            if (dwParam == 45 && (dwField == 6 || dwField == 7 || dwField == 8)) {
                resData = UtilCM.copyByte(resData, 0, resData.length, LibraryWrapper.SUN_CPU_ENDIAN);
            }
            if (dwParam == 1 || dwParam == 22 || dwParam == 5 || dwParam == 47) {
                resData = UtilCM.copyByte(resData, 0, resData.length, LibraryWrapper.SUN_CPU_ENDIAN);
            }
        }
        return resData;
    }

    public static List<X509Certificate> getCaCerts(Number hProv) throws CertificateException {
        int dwFlags = 1;
        int dwParam = 73;
        CNT_CERT cert = new CNT_CERT();
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        while (tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), dwParam, cert, cert.getSize(), dwFlags)) {
            if (cert.getCertificate() != null) {
                list.add(CSPUtil.getCertFromByteArray(cert.getCertificate()));
            }
            dwFlags = 2;
        }
        return list;
    }

    public static CNT_PRIVATE_KEY cpGetCntPrivateKey(Number hProv, int dwFlags) {
        TumarCspFunctions.checkLibBit();
        if (TumarCspFunctions.isZeroHandle(hProv)) {
            throw new IllegalArgumentException("Provider not loaded");
        }
        CNT_PRIVATE_KEY pKey = new CNT_PRIVATE_KEY();
        int dwParam = 45;
        if (tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), dwParam, pKey, pKey.getSize(), dwFlags)) {
            return pKey;
        }
        CSPException e = new CSPException(new ErrorResolver(hProv), "Error get provider param data (" + dwParam + ") ");
        if (e.errorRes.error != 259 && e.errorRes.error != 0) {
            throw e;
        }
        return null;
    }

    public static byte[] cpGetTumarCspBuild() {
        TumarCspFunctions.checkLibBit();
        byte[] ret = null;
        byte[] ver = StructUtil.intToByte(0);
        byte[] dw = StructUtil.intToByte(4);
        byte[] phProv = TumarCspFunctions.getLongRefArray();
        tumarCSPJNA.CPAcquireContext(phProv, null, -268435456, new Pointer(0L));
        Number hProv = TumarCspFunctions.getHandle(phProv);
        if (TumarCspFunctions.isZeroHandle(hProv)) {
            throw new CSPException(new ErrorResolver(hProv), "Error load profile ");
        }
        boolean res = tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), 5, ver, dw, 0);
        if (res) {
            int version = StructUtil.byteToInt(ver);
            String result = String.format("%d.%d.%d", version >> 8 & 0xF, version >> 4 & 0xF, version & 0xF);
            ret = StructUtil.getByteArray(result);
        }
        if (ret != null) {
            // empty if block
        }
        return ret;
    }

    public static int cpGetTumarCspBit() {
        TumarCspFunctions.checkLibBit();
        return TumarCspFunctions.getLibraryBit();
    }

    public static byte[] cpGetDataFromUrl(Number hProv, String url, int type) {
        TumarCspFunctions.checkLibBit();
        if (url == null) {
            return null;
        }
        CONTINFOEX continfoex = new CONTINFOEX(url);
        boolean res = tumarCSPJNA.CPGetProvParam(new Pointer(hProv.longValue()), 64, continfoex, continfoex.getSize(), 0);
        byte[] resData = null;
        if (res) {
            switch (type) {
                case 2: {
                    resData = continfoex.name;
                    break;
                }
                case 3: {
                    resData = continfoex.dev;
                    break;
                }
                case 4: {
                    resData = continfoex.user;
                    break;
                }
                case 0: {
                    resData = continfoex.pass;
                    break;
                }
                case 5: {
                    resData = continfoex.param;
                    break;
                }
                case 6: {
                    resData = continfoex.cont;
                    break;
                }
                case 7: {
                    resData = StructUtil.intToByte(continfoex.alg_exch);
                    break;
                }
                case 8: {
                    resData = StructUtil.intToByte(continfoex.alg_sign);
                    break;
                }
                case 1: {
                    resData = continfoex.sn;
                    break;
                }
                case 9: {
                    resData = StructUtil.intToByte(continfoex.sn_size);
                }
            }
        }
        if (resData == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error convert url to new url (" + url + ")");
        }
        if (type == 7 || type == 8 || type == 9) {
            resData = UtilCM.copyByte(resData, 0, resData.length, LibraryWrapper.SUN_CPU_ENDIAN);
        }
        return resData;
    }

    public static void initialize(String name) {
        String libName = LibPathGetter.getLibPath(name);
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        int flag = Platform.isWindows() ? 0 : 1;
        options.put("open-flags", flag);
        tumarCSPJNA = Native.load(libName, TumarCSPJNA.class, options);
        libraryBit = Native.POINTER_SIZE == 8 ? 64 : 32;
    }

    private static Number getHandle(byte[] handle) {
        if (handle == null) {
            return 0;
        }
        return UtilCM.byteToLong(handle, 0, 0);
    }

    private static boolean isZeroHandle(Number handle) {
        return handle.longValue() == 0L;
    }

    public static void checkLibBit() throws RuntimeException {
        if (libraryBit == 0) {
            throw new RuntimeException("CSP library not initialized. Please initialize CSP library (new GammaTechProvider())");
        }
    }

    private static void checkHProv(Number hProv) throws IllegalArgumentException {
        if (TumarCspFunctions.isZeroHandle(hProv)) {
            throw new IllegalArgumentException("Provider not loaded");
        }
    }

    private static void checkHKey(Number hProv) throws IllegalArgumentException {
        if (TumarCspFunctions.isZeroHandle(hProv)) {
            throw new IllegalArgumentException("Key not loaded");
        }
    }

    private static void checkHHash(Number hHash) throws IllegalArgumentException {
        if (TumarCspFunctions.isZeroHandle(hHash)) {
            throw new IllegalArgumentException("Hash not create");
        }
    }

    private static void checkHProvHKey(Number hProv, Number hKey) throws IllegalArgumentException {
        TumarCspFunctions.checkHProv(hProv);
        TumarCspFunctions.checkHKey(hKey);
    }

    private static byte[] getCuttedArray(byte[] bigArray, int normalSize) {
        if (bigArray.length == normalSize) {
            return bigArray;
        }
        return Arrays.copyOf(bigArray, normalSize);
    }

    public static int getLibraryBit() {
        return libraryBit;
    }

    private static byte[] getIntRefArray() {
        return new byte[4];
    }

    private static byte[] getLongRefArray() {
        return new byte[8];
    }

    static {
        libraryBit = 0;
        CIPHERTEXT_ADDING = 32;
    }
}

