/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp.plugin;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class PluginWrapper {
    private static final int SUN_ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model").equals("32") ? 32 : 64;
    private static final int HANDLE_SIZE = SUN_ARCH_DATA_MODEL / 8;

    private static native int tokenOpen(byte[] var0, byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    public Map tokenOpen(String tokenName, String pin, String param, Number hwnd, int flags) {
        byte[] tokenNameBytes = null;
        byte[] pinBytes = null;
        byte[] paramBytes = null;
        try {
            tokenNameBytes = this.privateByteArrayToByteArray(tokenName.getBytes("ASCII"));
            pinBytes = this.privateByteArrayToByteArray(pin.getBytes("ASCII"));
            paramBytes = this.privateByteArrayToByteArray(param.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hwndBytes = new byte[HANDLE_SIZE];
        byte[] hTokBytes = new byte[HANDLE_SIZE];
        int result = PluginWrapper.tokenOpen(tokenNameBytes, pinBytes, paramBytes, hwndBytes, flags, hTokBytes);
        if (result != 0) {
            throw new RuntimeException("tokenOpen error: " + Integer.toHexString(result));
        }
        Number hTok = null;
        hTok = HANDLE_SIZE == 4 ? (Number)this.privateByteToInt(hTokBytes, 0) : (Number)this.privateByteToLong(hTokBytes, 0);
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("hTok", (Integer)hTok);
        return resultMap;
    }

    private static native int tokenKeysCount(byte[] var0, byte[] var1);

    public Map tokenKeysCount(Number hTok) {
        byte[] countBytes = new byte[8];
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenKeysCount(hTokBytes, countBytes);
        if (result != 0) {
            throw new RuntimeException("tokenKeysCount error: " + Integer.toHexString(result));
        }
        Long count = this.privateByteToLong(countBytes, 0);
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        resultMap.put("count", count);
        return resultMap;
    }

    private static native int tokenGetInfo(byte[] var0, byte[][] var1);

    public Map tokenGetInfo(Number hTok) {
        byte[][] pInfo = new byte[20][];
        int[] pInfoSizes = new int[]{32, 32, 16, 16, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 1, 1, 1, 1, 16};
        String[] pInfoNames = new String[]{"label", "manufacturerID", "model", "serialNumber", "flags", "ulMaxSessionCount", "ulSessionCount", "ulMaxRwSessionCount", "ulRwSessionCount", "ulMaxPinLen", "ulMinPinLen", "ulTotalPublicMemory", "ulFreePublicMemory", "ulTotalPrivateMemory", "ulFreePrivateMemory", "hardwareVersion.major", "hardwareVersion.minor", "firmwareVersion.major", "firmwareVersion.minor", "utcTime"};
        for (int i = 0; i < pInfo.length; ++i) {
            pInfo[i] = new byte[pInfoSizes[i]];
        }
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenGetInfo(hTokBytes, pInfo);
        if (result != 0) {
            throw new RuntimeException("tokenGetInfo error: " + Integer.toHexString(result));
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (int i = 0; i < pInfo.length; ++i) {
            if (pInfo[i].length == 8) {
                Long pInfoLong = this.privateByteToLong(pInfo[i], 0);
                resultMap.put(pInfoNames[i], pInfoLong);
                continue;
            }
            if (pInfo[i].length == 1) {
                Byte pInfoByte = pInfo[i][0];
                resultMap.put(pInfoNames[i], pInfoByte);
                continue;
            }
            pInfo[i] = this.privateGetArrayWithoutNulls(pInfo[i], 0);
            String pInfoString = new String(pInfo[i]);
            resultMap.put(pInfoNames[i], pInfoString);
        }
        return resultMap;
    }

    private static native int tokenGetKeyInfo(byte[] var0, int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9, byte[] var10);

    public Map tokenGetKeyInfo(Number hTok, int knum) {
        byte[] label = new byte[64];
        byte[] type = new byte[8];
        byte[] state = new byte[8];
        byte[] oid = new byte[64];
        byte[] gtm = new byte[64];
        byte[] pkey = new byte[1024];
        byte[] pkeySize = new byte[8];
        byte[] crt = new byte[8096];
        byte[] crtSize = new byte[8];
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenGetKeyInfo(hTokBytes, knum, label, type, state, oid, gtm, pkey, pkeySize, crt, crtSize);
        if (result != 0) {
            throw new RuntimeException("tokenGetKeyInfo error: " + Integer.toHexString(result));
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("label", new String(this.privateGetArrayWithoutNulls(label, 0)));
        Long typeLong = this.privateByteToLong(type, 0);
        resultMap.put("type", typeLong);
        Long stateLong = this.privateByteToLong(state, 0);
        resultMap.put("state", stateLong);
        resultMap.put("oid", new String(this.privateGetArrayWithoutNulls(oid, 0)));
        resultMap.put("gtm", new String(this.privateGetArrayWithoutNulls(gtm, 0)));
        Long pkeySizeLong = this.privateByteToLong(pkeySize, 0);
        pkey = this.privateCopyByte(pkey, 0, pkeySizeLong.intValue());
        resultMap.put("pkey", pkey);
        Long crtSizeLong = this.privateByteToLong(crtSize, 0);
        crt = this.privateCopyByte(crt, 0, crtSizeLong.intValue());
        resultMap.put("crt", crt);
        return resultMap;
    }

    private static native int tokenGenKey(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public Map tokenGenKey(Number hTok, String oid) {
        byte[] oidBytes = null;
        try {
            oidBytes = this.privateByteArrayToByteArray(oid.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] pkey = new byte[1024];
        byte[] pkeySize = new byte[8];
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenGenKey(hTokBytes, oidBytes, pkey, pkeySize);
        if (result != 0) {
            throw new RuntimeException("tokenGenKey error: " + Integer.toHexString(result));
        }
        HashMap<String, byte[]> resultMap = new HashMap<String, byte[]>();
        Long pkeySizeLong = this.privateByteToLong(pkeySize, 0);
        pkey = this.privateCopyByte(pkey, 0, pkeySizeLong.intValue());
        resultMap.put("pkey", pkey);
        return resultMap;
    }

    private static native int tokenSetCert(byte[] var0, byte[] var1, byte[] var2, long var3);

    public Map tokenSetCert(Number hTok, String label, byte[] crt) {
        byte[] labelBytes = null;
        try {
            labelBytes = this.privateByteArrayToByteArray(label.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenSetCert(hTokBytes, labelBytes, crt, crt.length);
        if (result != 0) {
            throw new RuntimeException("tokenSetCert error: " + Integer.toHexString(result));
        }
        return null;
    }

    private static native int tokenDelKey(byte[] var0, byte[] var1);

    public Map tokenDelKey(Number hTok, String label) {
        byte[] labelBytes = null;
        try {
            labelBytes = this.privateByteArrayToByteArray(label.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenDelKey(hTokBytes, labelBytes);
        if (result != 0) {
            throw new RuntimeException("tokenDelKey error: " + Integer.toHexString(result));
        }
        return null;
    }

    private static native int tokenDelCert(byte[] var0, byte[] var1);

    public Map tokenDelCert(Number hTok, String label) {
        byte[] labelBytes = null;
        try {
            labelBytes = this.privateByteArrayToByteArray(label.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenDelCert(hTokBytes, labelBytes);
        if (result != 0) {
            throw new RuntimeException("tokenDelCert error: " + Integer.toHexString(result));
        }
        return null;
    }

    private static native int tokenHashData(byte[] var0, int var1, byte[] var2, long var3, byte[] var5, byte[] var6);

    public Map tokenHashData(Number hTok, int algId, byte[] data) {
        byte[] hashSize;
        byte[] hash;
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenHashData(hTokBytes, algId, data, data.length, hash = new byte[64], hashSize = new byte[8]);
        if (result != 0) {
            throw new RuntimeException("tokenHashData error: " + Integer.toHexString(result));
        }
        HashMap<String, byte[]> resultMap = new HashMap<String, byte[]>();
        Long hashSizeLong = this.privateByteToLong(hashSize, 0);
        hash = this.privateCopyByte(hash, 0, hashSizeLong.intValue());
        resultMap.put("hash", hash);
        return resultMap;
    }

    private static native int tokenSignHash(byte[] var0, byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5);

    public Map tokenSignHash(Number hTok, String label, byte[] hash) {
        byte[] labelBytes = null;
        try {
            labelBytes = this.privateByteArrayToByteArray(label.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        byte[] sign = new byte[256];
        byte[] signSize = new byte[8];
        int result = PluginWrapper.tokenSignHash(hTokBytes, labelBytes, hash, hash.length, sign, signSize);
        if (result != 0) {
            throw new RuntimeException("tokenSignHash error: " + Integer.toHexString(result));
        }
        HashMap<String, byte[]> resultMap = new HashMap<String, byte[]>();
        Long signSizeLong = this.privateByteToLong(signSize, 0);
        sign = this.privateCopyByte(sign, 0, signSizeLong.intValue());
        resultMap.put("sign", sign);
        return resultMap;
    }

    private static native int tokenChangePin(byte[] var0, byte[] var1);

    public Map tokenChangePin(Number hTok, String newPin) {
        byte[] newPinBytes = null;
        try {
            newPinBytes = this.privateByteArrayToByteArray(newPin.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert input parameters from String to byte[]");
        }
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenChangePin(hTokBytes, newPinBytes);
        if (result != 0) {
            throw new RuntimeException("tokenChangePin error: " + Integer.toHexString(result));
        }
        return null;
    }

    private static native int tokenClose(byte[] var0);

    public Map tokenClose(Number hTok) {
        byte[] hTokBytes = null;
        hTokBytes = HANDLE_SIZE == 4 ? this.privateIntToByte(hTok.intValue()) : this.privateLongToByte(hTok.longValue());
        int result = PluginWrapper.tokenClose(hTokBytes);
        if (result != 0) {
            throw new RuntimeException("tokenClose error: " + Integer.toHexString(result));
        }
        return null;
    }

    public static synchronized void initialize(Map librariesNames) {
        try {
            String libraryName = null;
            libraryName = SUN_ARCH_DATA_MODEL == 32 ? (String)librariesNames.get("pluginLibraryPath32bit") : (String)librariesNames.get("pluginLibraryPath64bit");
            System.load(libraryName);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private byte[] privateByteArrayToByteArray(byte[] srcByte) {
        if (srcByte == null) {
            return null;
        }
        int srcLength = srcByte.length;
        byte[] result = new byte[srcLength + 1];
        System.arraycopy(srcByte, 0, result, 0, srcLength);
        result[srcLength] = 0;
        return result;
    }

    private byte[] privateGetArrayWithoutNulls(byte[] data, int offset) {
        int size = 0;
        for (int i = offset; i < data.length && data[i] != 0; ++i) {
            ++size;
        }
        return this.privateCopyByte(data, offset, size);
    }

    private byte[] privateCopyByte(byte[] x, int offset, int size) {
        byte[] out = new byte[size];
        System.arraycopy(x, offset, out, 0, size);
        return out;
    }

    private int privateByteToInt(byte[] x, int offset) {
        String endianness = System.getProperty("sun.cpu.endian").toUpperCase();
        if (endianness.equals("LITTLE")) {
            return x[offset++] & 0xFF | (x[offset++] & 0xFF) << 8 | (x[offset++] & 0xFF) << 16 | x[offset++] << 24;
        }
        return x[offset++] << 24 | (x[offset++] & 0xFF) << 16 | (x[offset++] & 0xFF) << 8 | x[offset++] & 0xFF;
    }

    private long privateByteToLong(byte[] x, int offset) {
        String endianness = System.getProperty("sun.cpu.endian").toUpperCase();
        if (endianness.equals("LITTLE")) {
            return x[offset++] & 0xFF | (x[offset++] & 0xFF) << 8 | (x[offset++] & 0xFF) << 16 | (x[offset++] & 0xFF) << 24 | (x[offset++] & 0xFF) << 32 | (x[offset++] & 0xFF) << 40 | (x[offset++] & 0xFF) << 48 | x[offset++] << 56;
        }
        return x[offset++] << 56 | (x[offset++] & 0xFF) << 48 | (x[offset++] & 0xFF) << 40 | (x[offset++] & 0xFF) << 32 | (x[offset++] & 0xFF) << 24 | (x[offset++] & 0xFF) << 16 | (x[offset++] & 0xFF) << 8 | x[offset++] & 0xFF;
    }

    private byte[] privateIntToByte(int x) {
        byte[] out = new byte[4];
        String endianness = System.getProperty("sun.cpu.endian").toUpperCase();
        if (endianness.equals("LITTLE")) {
            out[0] = (byte)x;
            out[1] = (byte)(x >>> 8);
            out[2] = (byte)(x >>> 16);
            out[3] = (byte)(x >>> 24);
            return out;
        }
        out[0] = (byte)(x >>> 24);
        out[1] = (byte)(x >>> 16);
        out[2] = (byte)(x >>> 8);
        out[3] = (byte)x;
        return out;
    }

    private byte[] privateLongToByte(long x) {
        byte[] out = new byte[8];
        String endianness = System.getProperty("sun.cpu.endian").toUpperCase();
        if (endianness.equals("LITTLE")) {
            out[0] = (byte)x;
            out[1] = (byte)(x >>> 8);
            out[2] = (byte)(x >>> 16);
            out[3] = (byte)(x >>> 24);
            out[4] = (byte)(x >>> 32);
            out[5] = (byte)(x >>> 40);
            out[6] = (byte)(x >>> 48);
            out[7] = (byte)(x >>> 56);
            return out;
        }
        out[0] = (byte)(x >>> 56);
        out[1] = (byte)(x >>> 48);
        out[2] = (byte)(x >>> 40);
        out[3] = (byte)(x >>> 32);
        out[4] = (byte)(x >>> 24);
        out[5] = (byte)(x >>> 16);
        out[6] = (byte)(x >>> 8);
        out[7] = (byte)x;
        return out;
    }
}

