/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp.profile;

import kz.gamma.core.file.FileHelper;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class ProfileCreator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createProfile(String name, String dev, String password, String param) throws Exception {
        String ret = "";
        password = password == null ? "" : password.trim();
        String nameLocal = ProfileParams.getProfileName(name.trim(), false);
        if (dev.trim().equals("file")) {
            Boolean isExists = new FileHelper().createFile(param);
            String userAsProfile = nameLocal;
            if (isExists == false) throw new Exception("Cannot create profile \"" + nameLocal + "\" for dev \" " + dev + " \" on path \"" + param + "\"");
            return this.createProfile(nameLocal, dev, userAsProfile, password, param, "bin", 41029, 43578);
        }
        if (dev.trim().equals("artoken")) {
            return this.createProfile(nameLocal, dev, "artoken", password, param, "bin", 41029, 43578);
        }
        if (dev.trim().equals("g-token")) {
            return this.createProfile(nameLocal, dev, "gtoken", password, param, "bin", 41029, 43578);
        }
        if (dev.trim().equals("j-token")) {
            return this.createProfile(nameLocal, dev, "jtoken", password, param, "bin", 41029, 43578);
        }
        if (dev.trim().equals("idcard")) {
            return this.createProfile(nameLocal, dev, "idcard", password, param, "bin", 41029, 43578);
        }
        if (dev.trim().equals("kztoken")) {
            return this.createProfile(nameLocal, dev, "kztoken", password, param, "bin", 41029, 43578);
        }
        if (dev.trim().equals("picard")) {
            return this.createProfile(nameLocal, dev, "picard", password, param, "bin", 41029, 43578);
        }
        if (!dev.trim().equals("etokenpro")) return this.createProfile(nameLocal, dev, "unknown", password, param, "bin", 41029, 43578);
        return this.createProfile(nameLocal, dev, "etokenpro", password, param, "bin", 41029, 43578);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createProfile(String name, String dev, String user, String password, String param, String cont, Integer algExch, Integer algSign) {
        Number hProv = 0;
        try {
            String ret;
            password = password == null ? "" : password.trim();
            String nameLocal = ProfileParams.getProfileName(name.trim(), false);
            int dwFlags = -268435392;
            hProv = TumarCspFunctions.cpAcquireContext("", dwFlags);
            String string = ret = TumarCspFunctions.cpCreateProfile(nameLocal, dev, user, password, param, cont, algExch, algSign, hProv);
            return string;
        }
        finally {
            if (hProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProv, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createUrl(String name, String dev, String user, String password, String param, String cont, Integer algExch, Integer algSign) {
        Number hProv = 0;
        try {
            String ret;
            password = password == null ? "" : password.trim();
            String nameLocal = ProfileParams.getProfileName(name.trim(), false);
            int dwFlags = -268435392;
            hProv = TumarCspFunctions.cpAcquireContext("", dwFlags);
            String string = ret = TumarCspFunctions.cpCreateUrl(nameLocal, dev, user, password, param, cont, algExch, algSign, hProv);
            return string;
        }
        finally {
            if (hProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProv, 0);
            }
        }
    }
}

