/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.vista;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import kz.gamma.core.UtilCM;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.vista.VistaException;
import kz.gamma.vista.VistaSHA1;
import kz.gamma.vista.VistaSha1Context;

public class VistaFile {
    private int headCRC;
    private byte type;
    private byte method;
    private short nameSize;
    private int nameCRC;
    private int attributes;
    private int[] time = new int[2];
    private int[] packSize = new int[2];
    private int[] unPackSize = new int[2];
    private byte[] fileCRC;
    private int reserv;
    private String fileName;
    private byte[] file;
    private byte[] blob;
    private int blobSize;

    public VistaFile(byte[] blob, int curr) throws UnsupportedEncodingException {
        this.blob = blob;
        this.blobSize = 0;
        this.headCRC = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        this.type = blob[this.blobSize + curr];
        ++this.blobSize;
        this.method = blob[this.blobSize + curr];
        ++this.blobSize;
        this.nameSize = UtilCM.byteToShort(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 2;
        this.nameCRC = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        this.attributes = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        this.time[0] = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        this.time[1] = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        this.packSize[0] = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        this.packSize[1] = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        this.unPackSize[0] = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        this.unPackSize[1] = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        this.fileCRC = UtilCM.copyByte(blob, this.blobSize + curr, 20);
        this.blobSize += 20;
        this.reserv = UtilCM.byteToInt(blob, this.blobSize + curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.blobSize += 4;
        if (UtilCM.calcCRC(UtilCM.copyByte(blob, curr + 4, 60)) != this.headCRC) {
            throw new VistaException("Vista message corrupted");
        }
        this.fileName = new String(UtilCM.copyByte(blob, this.blobSize + curr, this.nameSize), "CP1251");
        this.blobSize += this.nameSize;
        if (UtilCM.calcCRC(this.fileName.getBytes("CP1251")) != this.nameCRC) {
            throw new VistaException("Vista message corrupted");
        }
        this.file = UtilCM.copyByte(blob, this.blobSize + curr, this.packSize[0]);
        this.blobSize += this.packSize[0];
    }

    public VistaFile(String fileName, byte[] file, int packSize, int unPackSize, boolean isArch) {
        try {
            this.reserv = 0;
            this.type = 1;
            this.fileName = fileName;
            this.nameCRC = UtilCM.calcCRC(fileName.getBytes("CP1251"));
            this.nameSize = (short)fileName.length();
            this.file = UtilCM.copyByte(file, 0, file.length);
            this.packSize[0] = packSize;
            this.packSize[1] = 0;
            this.unPackSize[0] = unPackSize;
            this.unPackSize[1] = 0;
            this.method = isArch ? (byte)1 : 0;
            this.fileCRC = this.calcFileCRC(file);
            this.attributes = 33279;
        }
        catch (UnsupportedEncodingException e) {
            throw new VistaException(e);
        }
    }

    public VistaFile(byte[] file, boolean isSign) throws UnsupportedEncodingException {
        this.reserv = 0;
        if (isSign) {
            this.fileName = "$$CMSSign$$.cms";
            this.type = (byte)3;
        } else {
            this.fileName = "$$CMSEnvp$$.cms";
            this.type = (byte)2;
        }
        this.nameCRC = UtilCM.calcCRC(this.fileName.getBytes("CP1251"));
        this.nameSize = (short)this.fileName.length();
        this.file = UtilCM.copyByte(file, 0, file.length);
        this.packSize[0] = file.length;
        this.packSize[1] = 0;
        this.unPackSize[0] = file.length;
        this.unPackSize[1] = 0;
        this.method = 0;
        this.fileCRC = this.calcFileCRC(file);
        this.attributes = 33152;
    }

    public int getBlobSize() {
        return 64 + this.fileName.length() + this.file.length;
    }

    public byte[] getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    private byte[] calcFileCRC(byte[] data) {
        VistaSHA1 vistaSHA1 = new VistaSHA1();
        VistaSha1Context sha = new VistaSha1Context();
        byte[] hashData = new byte[20];
        int err = vistaSHA1.SHA1Reset(sha);
        if (err != 0) {
            throw new RuntimeException("Error initialize sha1 hash [" + err + "]");
        }
        err = vistaSHA1.SHA1Input(sha, data, data.length);
        if (err != 0) {
            throw new RuntimeException("Error sha1 hash update [" + err + "]");
        }
        err = vistaSHA1.SHA1Result(sha, hashData);
        if (err != 0) {
            throw new RuntimeException("Error sha1 hash final [" + err + "]");
        }
        return hashData;
    }

    public boolean checkCRC(byte[] data) {
        boolean ret = false;
        try {
            ret = Arrays.equals(this.fileCRC, this.calcFileCRC(data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean isArchFile() {
        return this.method == 1;
    }

    public byte[] getEncoded() {
        try {
            this.blobSize = 64 + this.fileName.length() + this.file.length;
            this.blob = new byte[this.blobSize];
            this.headCRC = 0;
            int sz = 4;
            this.blob[sz] = this.type;
            this.blob[++sz] = this.method;
            System.arraycopy(UtilCM.shortToByte(this.nameSize, LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, ++sz, 2);
            System.arraycopy(UtilCM.intToByte(this.nameCRC, LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, sz += 2, 4);
            System.arraycopy(UtilCM.intToByte(this.attributes, LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(this.time[0], LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(this.time[1], LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(this.packSize[0], LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(this.packSize[1], LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(this.unPackSize[0], LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(this.unPackSize[1], LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, sz += 4, 4);
            System.arraycopy(this.fileCRC, 0, this.blob, sz += 4, 20);
            System.arraycopy(UtilCM.intToByte(this.reserv, LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, sz += 20, 4);
            System.arraycopy(this.fileName.getBytes("CP1251"), 0, this.blob, sz += 4, this.fileName.length());
            System.arraycopy(this.file, 0, this.blob, sz += this.fileName.length(), this.file.length);
            sz += this.file.length;
            this.headCRC = UtilCM.calcCRC(UtilCM.copyByte(this.blob, 4, 60));
            System.arraycopy(UtilCM.intToByte(this.headCRC, LibraryWrapper.SUN_CPU_ENDIAN), 0, this.blob, 0, 4);
        }
        catch (UnsupportedEncodingException e) {
            throw new VistaException(e);
        }
        return this.blob;
    }

    public byte[] getFileCRC() {
        return this.fileCRC;
    }
}

