/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.vista;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.cms.Attribute;
import kz.gamma.asn1.cms.AttributeTable;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSProcessableByteArray;
import kz.gamma.cms.CMSSignedDataGenerator;
import kz.gamma.cms.CMSVistaEnvelopedData;
import kz.gamma.cms.CMSVistaSignedDataGenerator;
import kz.gamma.cms.Pkcs7Data;
import kz.gamma.cms.SignerInformation;
import kz.gamma.core.UtilCM;
import kz.gamma.hash.GOST3411Digest;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.jce.provider.JCEECPrivateKey;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.vista.VistaException;
import kz.gamma.vista.VistaFile;
import kz.gamma.vista.VistaSHA1;
import kz.gamma.vista.VistaSha1Context;
import org.itadaki.bzip2.BZip2InputStream;
import org.itadaki.bzip2.BZip2OutputStream;

public class VistaMessage {
    private byte[] magic;
    private int headCRC;
    private short headSize;
    private short dHeadSize;
    private short fHeadSize;
    private byte hostOS;
    private byte archType;
    private int dCount;
    private int fCount;
    private int time;
    private int memoSize;
    private int memoCRC;
    private int cmsEnvpSize;
    private int cmsSignSize;
    private byte priority;
    private byte reservB;
    private short reservW;
    private byte[] body;
    private byte[] memo;
    private int hSize;
    private static byte[] hbz2 = new byte[]{66, 90, 104, 57, 49, 65, 89, 38, 83, 89};
    private ArrayList<VistaFile> vistaFiles = new ArrayList();
    private CMSVistaEnvelopedData envelopedData;
    private Pkcs7Data cmsSigned;

    public VistaMessage(byte[] body) throws IOException, CMSException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        int curr = 0;
        this.body = body;
        this.magic = UtilCM.copyByte(body, curr, 4);
        curr += 4;
        if (!new String(this.magic).equals("Tbz+")) {
            throw new VistaException("Not vista message");
        }
        this.headCRC = UtilCM.byteToInt(body, curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.headSize = UtilCM.byteToShort(body, curr += 4, LibraryWrapper.SUN_CPU_ENDIAN);
        this.dHeadSize = UtilCM.byteToShort(body, curr += 2, LibraryWrapper.SUN_CPU_ENDIAN);
        this.fHeadSize = UtilCM.byteToShort(body, curr += 2, LibraryWrapper.SUN_CPU_ENDIAN);
        this.hostOS = body[curr += 2];
        this.archType = body[++curr];
        this.dCount = UtilCM.byteToInt(body, ++curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.fCount = UtilCM.byteToInt(body, curr += 4, LibraryWrapper.SUN_CPU_ENDIAN);
        this.time = UtilCM.byteToInt(body, curr += 4, LibraryWrapper.SUN_CPU_ENDIAN);
        this.memoSize = UtilCM.byteToInt(body, curr += 4, LibraryWrapper.SUN_CPU_ENDIAN);
        this.memoCRC = UtilCM.byteToInt(body, curr += 4, LibraryWrapper.SUN_CPU_ENDIAN);
        this.cmsEnvpSize = UtilCM.byteToInt(body, curr += 4, LibraryWrapper.SUN_CPU_ENDIAN);
        this.cmsSignSize = UtilCM.byteToInt(body, curr += 4, LibraryWrapper.SUN_CPU_ENDIAN);
        this.priority = body[curr += 4];
        this.reservB = body[++curr];
        this.reservW = UtilCM.byteToShort(body, ++curr, LibraryWrapper.SUN_CPU_ENDIAN);
        this.hSize = curr += 2;
        if (UtilCM.calcCRC(UtilCM.copyByte(body, 8, this.hSize - 8)) != this.headCRC) {
            throw new VistaException("Vista message corrupted");
        }
        this.memo = UtilCM.copyByte(body, curr, this.memoSize);
        curr += this.memoSize;
        if (UtilCM.calcCRC(UtilCM.copyByte(this.memo, 0, this.memo.length)) != this.memoCRC) {
            throw new VistaException("Vista message corrupted");
        }
        byte[] signedData = null;
        byte[] data = null;
        for (int i = 0; i < this.fCount; ++i) {
            VistaFile vistaFile = new VistaFile(body, curr);
            if (vistaFile.getFileName().equals("$$CMSEnvp$$.cms")) {
                this.envelopedData = new CMSVistaEnvelopedData(vistaFile.getFile());
                curr += vistaFile.getBlobSize();
                continue;
            }
            if (vistaFile.getFileName().equals("$$CMSSign$$.cms")) {
                signedData = vistaFile.getFile();
                curr += vistaFile.getBlobSize();
                continue;
            }
            this.vistaFiles.add(vistaFile);
            curr += vistaFile.getBlobSize();
            data = data == null ? vistaFile.getFile() : UtilCM.concat(data, vistaFile.getFile());
        }
        if (signedData != null) {
            this.cmsSigned = new Pkcs7Data(signedData, data);
        }
    }

    public VistaMessage(String title, byte priority, List<X509Certificate> recipientsCertsList, PrivateKey privateKey) {
        try {
            this.memo = title.getBytes("CP1251");
            this.memoCRC = UtilCM.calcCRC(this.memo);
            this.memoSize = this.memo.length;
            this.priority = priority;
            this.headSize = (short)48;
            this.dHeadSize = (short)24;
            this.fHeadSize = (short)64;
            this.hostOS = (byte)2;
            this.dCount = 0;
            this.fCount = 0;
            this.time = (int)System.currentTimeMillis();
            this.archType = (byte)19;
            this.envelopedData = new CMSVistaEnvelopedData();
            this.envelopedData.genSessionKey((JCEECPrivateKey)privateKey);
            for (X509Certificate recipientCert : recipientsCertsList) {
                this.envelopedData.addKeyRecipient(recipientCert);
            }
            this.reservW = 0;
            this.reservB = 0;
        }
        catch (UnsupportedEncodingException e) {
            throw new VistaException(e);
        }
    }

    public void addVistaFile(String fileName, byte[] blob) {
        boolean isArch = true;
        byte[] data = null;
        byte[] bzip2 = this.compressData(blob);
        if (bzip2 == null) {
            isArch = false;
            data = UtilCM.copyByte(blob, 0, blob.length);
        } else {
            data = UtilCM.copyByte(bzip2, hbz2.length, bzip2.length - hbz2.length);
        }
        byte[] crpData = this.envelopedData.cryptText(data);
        VistaFile vistaFile = new VistaFile(fileName, crpData, data.length, blob.length, isArch);
        this.vistaFiles.add(vistaFile);
        ++this.fCount;
    }

    public boolean verifySign(X509Certificate cert) {
        boolean ret = false;
        try {
            if (!this.isMessageType((byte)2)) {
                throw new VistaException("Message not signed");
            }
            ret = this.cmsSigned.verify(cert);
        }
        catch (Exception e) {
            throw new VistaException(e);
        }
        return ret;
    }

    public SignerInformation getSignerInfo() {
        if (this.isMessageType((byte)2)) {
            return this.cmsSigned.getSignerInformation();
        }
        throw new VistaException("Message not signed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Name getSignSenderName() {
        if (this.isMessageType((byte)2)) {
            FilterInputStream asn1InputStream = null;
            try {
                byte[] name = this.cmsSigned.getAttributeByOid("1.3.6.1.4.1.6801.2.8");
                asn1InputStream = new ASN1InputStream(name);
                X509Name x509Name = new X509Name((ASN1Sequence)((ASN1InputStream)asn1InputStream).readObject());
                return x509Name;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (asn1InputStream != null) {
                    try {
                        asn1InputStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }
        throw new VistaException("Message not signed");
    }

    public int getVistaFileCount() {
        return this.vistaFiles.size();
    }

    public String getVistaFileName(int indx) {
        return this.vistaFiles.get(indx).getFileName();
    }

    public String getTitleMessage() throws UnsupportedEncodingException {
        return new String(this.memo, "CP1251");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] unpackData(byte[] data) {
        byte[] ret = null;
        ByteArrayInputStream bais = null;
        BZip2InputStream bZip2InputStream = null;
        int bytesAll = 0;
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        try {
            if (data.length <= hbz2.length || !Arrays.equals(hbz2, UtilCM.copyByte(data, 0, hbz2.length))) {
                data = UtilCM.concat(hbz2, data);
            }
            bais = new ByteArrayInputStream(data);
            bZip2InputStream = new BZip2InputStream((InputStream)bais, false);
            byte[] decoded = new byte[524288];
            try {
                int bytesRead;
                while ((bytesRead = bZip2InputStream.read(decoded)) != -1) {
                    bytes.add(UtilCM.copyByte(decoded, 0, bytesRead));
                    bytesAll += bytesRead;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
            if (bZip2InputStream != null) {
                try {
                    bZip2InputStream.close();
                }
                catch (IOException e) {}
            }
        }
        ret = new byte[bytesAll];
        int sz = 0;
        for (byte[] aByte : bytes) {
            System.arraycopy(aByte, 0, ret, sz, aByte.length);
            sz += aByte.length;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compressData(byte[] data) {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        BZip2OutputStream bzos = null;
        try {
            int bufferSize = 524288;
            is = new BufferedInputStream(new ByteArrayInputStream(data));
            baos = new ByteArrayOutputStream(bufferSize);
            bzos = new BZip2OutputStream((OutputStream)baos);
            byte[] encoded = new byte[bufferSize];
            int bytesRead = 0;
            while ((bytesRead = is.read(encoded)) != -1) {
                bzos.write(encoded, 0, bytesRead);
            }
            bzos.finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (bzos != null) {
                try {
                    bzos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] getFile(int indx) {
        byte[] ret = null;
        try {
            VistaFile vistaFile = this.vistaFiles.get(indx);
            if (!vistaFile.checkCRC(vistaFile.getFile())) {
                throw new VistaException("File '" + vistaFile.getFileName() + "' is corrupted");
            }
            if (this.isMessageType((byte)1)) {
                throw new VistaException("File encrypted. Use getDecryptedFile");
            }
            ret = vistaFile.getFile();
            if (vistaFile.isArchFile()) {
                ret = this.unpackData(ret);
            }
        }
        catch (Exception e) {
            throw new VistaException("Error decrypt file");
        }
        return ret;
    }

    public byte[] getDecryptedFile(KeyStore store, String pass, X509Certificate exchSenderCert, int indx) {
        byte[] ret = null;
        try {
            VistaFile vistaFile = this.vistaFiles.get(indx);
            if (!vistaFile.checkCRC(vistaFile.getFile())) {
                throw new VistaException("File '" + vistaFile.getFileName() + "' is corrupted");
            }
            if (!this.isMessageType((byte)1)) {
                throw new VistaException("File not encrypted. Use getFile");
            }
            ret = this.envelopedData.decryptText(store, pass, vistaFile.getFile(), exchSenderCert);
            if (vistaFile.isArchFile()) {
                ret = this.unpackData(ret);
            }
        }
        catch (Exception e) {
            throw new VistaException("Error decrypt file");
        }
        return ret;
    }

    public boolean isMessageType(byte type) {
        return (this.archType & type) != 0;
    }

    public byte[] generateVistaMessage(PrivateKey signerKey, X509Certificate signSenderCert, X509Certificate exchSenderCert) {
        byte[] blob = null;
        ByteArrayInputStream bis = null;
        byte[] data = null;
        int flSize = 0;
        try {
            byte[] hash = new byte[32];
            GOST3411Digest gost3411Digest = new GOST3411Digest();
            for (VistaFile vistaFile : this.vistaFiles) {
                flSize += vistaFile.getBlobSize();
                gost3411Digest.update(vistaFile.getFile(), 0, vistaFile.getFile().length);
                if (data == null) {
                    data = vistaFile.getFile();
                    continue;
                }
                data = UtilCM.concat(data, vistaFile.getFile());
            }
            gost3411Digest.doFinal(hash, 0);
            byte[] cmsEnvData = this.envelopedData.generateEnvelopedData(exchSenderCert, false).getDEREncoded();
            VistaFile vsEnvData = new VistaFile(cmsEnvData, false);
            this.cmsEnvpSize = vsEnvData.getBlobSize();
            CMSVistaSignedDataGenerator gen = new CMSVistaSignedDataGenerator();
            ASN1EncodableVector attr = new ASN1EncodableVector();
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.4"), new DERSet(new DEROctetString(hash))));
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.5"), new DERSet(new DERGeneralizedTime(new Date()))));
            attr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.8"), new DERSet(new X509Name(signSenderCert.getSubjectDN().getName()))));
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.3"), new DERSet(new DERObjectIdentifier("1.2.840.113549.1.7.1"))));
            AttributeTable attributeTable = new AttributeTable(attr);
            gen.addSigner(signerKey, signSenderCert, CMSSignedDataGenerator.DIGEST_GOST3411G, attributeTable, null);
            this.fCount += 2;
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            byte[] cmsSignData = gen.generate(content, false, GammaTechProvider.PROVIDER_NAME).getEncoded();
            VistaFile vsSignData = new VistaFile(cmsSignData, true);
            this.cmsSignSize = vsSignData.getBlobSize();
            blob = new byte[48 + this.memo.length + flSize + this.cmsSignSize + this.cmsEnvpSize];
            this.headCRC = 0;
            int sz = 0;
            System.arraycopy("Tbz+".getBytes(), 0, blob, sz, "Tbz+".getBytes().length);
            sz += "Tbz+".getBytes().length;
            System.arraycopy(UtilCM.shortToByte(this.headSize, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, sz += 4, 2);
            System.arraycopy(UtilCM.shortToByte(this.dHeadSize, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, sz += 2, 2);
            System.arraycopy(UtilCM.shortToByte(this.fHeadSize, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, sz += 2, 2);
            blob[sz += 2] = this.hostOS;
            blob[++sz] = this.archType;
            System.arraycopy(UtilCM.intToByte(this.dCount, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, ++sz, 4);
            System.arraycopy(UtilCM.intToByte(this.fCount, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(this.time, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(this.memoSize, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(this.memoCRC, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(cmsEnvData.length, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, sz += 4, 4);
            System.arraycopy(UtilCM.intToByte(cmsSignData.length, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, sz += 4, 4);
            blob[sz += 4] = this.priority;
            blob[++sz] = this.reservB;
            System.arraycopy(UtilCM.shortToByte(this.reservW, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, ++sz, 2);
            this.headCRC = UtilCM.calcCRC(UtilCM.copyByte(blob, 8, 40));
            System.arraycopy(UtilCM.intToByte(this.headCRC, LibraryWrapper.SUN_CPU_ENDIAN), 0, blob, 4, 4);
            System.arraycopy(this.memo, 0, blob, sz += 2, this.memo.length);
            sz += this.memo.length;
            for (VistaFile vistaFile : this.vistaFiles) {
                byte[] vistaFileData = vistaFile.getEncoded();
                System.arraycopy(vistaFileData, 0, blob, sz, vistaFileData.length);
                sz += vistaFileData.length;
            }
            byte[] vsEnvBlob = vsEnvData.getEncoded();
            System.arraycopy(vsEnvBlob, 0, blob, sz, vsEnvBlob.length);
            byte[] vsSignBlob = vsSignData.getEncoded();
            System.arraycopy(vsSignBlob, 0, blob, sz += vsEnvBlob.length, vsSignBlob.length);
            sz += vsSignBlob.length;
        }
        catch (CertificateEncodingException e) {
            throw new VistaException(e);
        }
        catch (IOException e) {
            throw new VistaException(e);
        }
        catch (CertificateException e) {
            throw new VistaException(e);
        }
        catch (CMSException e) {
            throw new VistaException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new VistaException(e);
        }
        catch (NoSuchProviderException e) {
            throw new VistaException(e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return blob;
    }

    public CMSVistaEnvelopedData getEnvelopedData() {
        return this.envelopedData;
    }

    public String getReference() {
        VistaSHA1 vistaSHA1 = new VistaSHA1();
        VistaSha1Context sha = new VistaSha1Context();
        byte[] hashData = new byte[20];
        int err = vistaSHA1.SHA1Reset(sha);
        if (err != 0) {
            throw new RuntimeException("Error initialize sha1 hash [" + err + "]");
        }
        for (VistaFile data : this.vistaFiles) {
            err = vistaSHA1.SHA1Input(sha, data.getFileCRC(), 20);
            if (err == 0) continue;
            throw new RuntimeException("Error sha1 hash update [" + err + "]");
        }
        err = vistaSHA1.SHA1Result(sha, hashData);
        if (err != 0) {
            throw new RuntimeException("Error sha1 hash final [" + err + "]");
        }
        return UtilCM.hash2Ref(hashData);
    }

    public byte getArchType() {
        return this.archType;
    }
}

