/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.vista;

import kz.gamma.vista.VistaSha1Context;

public class VistaSHA1 {
    public static final int SHA1HashSize = 20;
    public static final int shaSuccess = 0;
    public static final int shaNull = 1;
    public static final int shaInputTooLong = 2;
    public static final int shaStateError = 3;

    public static void DigestPrint(byte[] digest) {
        System.out.print("Digest: ");
        for (int i = 0; i < 20; ++i) {
            System.out.printf("%02x", digest[i]);
        }
        System.out.println("\n");
    }

    public int SHA1Reset(VistaSha1Context context) {
        if (context == null) {
            return 1;
        }
        context.Length_Low = 0;
        context.Length_High = 0;
        context.Message_Block_Index = 0;
        context.Intermediate_Hash[0] = 0;
        context.Intermediate_Hash[1] = 0;
        context.Intermediate_Hash[2] = 0;
        context.Intermediate_Hash[3] = 0;
        context.Intermediate_Hash[4] = 0;
        context.Computed = 0;
        context.Corrupted = 0;
        return 0;
    }

    public int SHA1Input(VistaSha1Context context, byte[] message_array, int length) {
        if (length == 0) {
            return 0;
        }
        if (context == null || message_array == null) {
            return 1;
        }
        if (context.Computed != 0) {
            context.Corrupted = 3;
            return 3;
        }
        if (context.Corrupted != 0) {
            return context.Corrupted;
        }
        int index = 0;
        while (length-- > 0 && context.Corrupted == 0) {
            context.Message_Block[context.Message_Block_Index++] = (byte)(message_array[index] & 0xFF);
            context.Length_Low += 8;
            if (context.Length_Low == 0) {
                ++context.Length_High;
                if (context.Length_High == 0) {
                    context.Corrupted = 1;
                }
            }
            if (context.Message_Block_Index == 64) {
                this.SHA1ProcessMessageBlock(context);
            }
            ++index;
        }
        return 0;
    }

    public void SHA1ProcessMessageBlock(VistaSha1Context context) {
        int temp;
        int t;
        int[] K = new int[]{1518500249, 1859775393, -1894007588, -899497514};
        int[] W = new int[80];
        for (t = 0; t < 16; ++t) {
            W[t] = context.Message_Block[t * 4] << 24 & 0xFF000000;
            int n = t;
            W[n] = W[n] | context.Message_Block[t * 4 + 1] << 16 & 0xFF0000;
            int n2 = t;
            W[n2] = W[n2] | context.Message_Block[t * 4 + 2] << 8 & 0xFF00;
            int n3 = t;
            W[n3] = W[n3] | context.Message_Block[t * 4 + 3] & 0xFF;
        }
        for (t = 16; t < 80; ++t) {
            W[t] = VistaSHA1.SHA1CircularShift(1, W[t - 3] ^ W[t - 8] ^ W[t - 14] ^ W[t - 16]);
        }
        int A = context.Intermediate_Hash[0];
        int B = context.Intermediate_Hash[1];
        int C = context.Intermediate_Hash[2];
        int D = context.Intermediate_Hash[3];
        int E = context.Intermediate_Hash[4];
        for (t = 0; t < 20; ++t) {
            temp = VistaSHA1.SHA1CircularShift(5, A) + (B & C | ~B & D) + E + W[t] + K[0];
            E = D;
            D = C;
            C = VistaSHA1.SHA1CircularShift(30, B);
            B = A;
            A = temp;
        }
        for (t = 20; t < 40; ++t) {
            temp = VistaSHA1.SHA1CircularShift(5, A) + (B ^ C ^ D) + E + W[t] + K[1];
            E = D;
            D = C;
            C = VistaSHA1.SHA1CircularShift(30, B);
            B = A;
            A = temp;
        }
        for (t = 40; t < 60; ++t) {
            temp = VistaSHA1.SHA1CircularShift(5, A) + (B & C | B & D | C & D) + E + W[t] + K[2];
            E = D;
            D = C;
            C = VistaSHA1.SHA1CircularShift(30, B);
            B = A;
            A = temp;
        }
        for (t = 60; t < 80; ++t) {
            temp = VistaSHA1.SHA1CircularShift(5, A) + (B ^ C ^ D) + E + W[t] + K[3];
            E = D;
            D = C;
            C = VistaSHA1.SHA1CircularShift(30, B);
            B = A;
            A = temp;
        }
        context.Intermediate_Hash[0] = context.Intermediate_Hash[0] + A;
        context.Intermediate_Hash[1] = context.Intermediate_Hash[1] + B;
        context.Intermediate_Hash[2] = context.Intermediate_Hash[2] + C;
        context.Intermediate_Hash[3] = context.Intermediate_Hash[3] + D;
        context.Intermediate_Hash[4] = context.Intermediate_Hash[4] + E;
        context.Message_Block_Index = 0;
    }

    public static int SHA1CircularShift(int bits, int word) {
        return word << bits | word >>> 32 - bits;
    }

    public int SHA1Result(VistaSha1Context context, byte[] Message_Digest) {
        int i;
        if (context == null || Message_Digest == null) {
            return 1;
        }
        if (context.Corrupted != 0) {
            return context.Corrupted;
        }
        if (context.Computed == 0) {
            this.SHA1PadMessage(context);
            for (i = 0; i < 64; ++i) {
                context.Message_Block[i] = 0;
            }
            context.Length_Low = 0;
            context.Length_High = 0;
            context.Computed = 1;
        }
        for (i = 0; i < 20; ++i) {
            Message_Digest[i] = (byte)(context.Intermediate_Hash[i >>> 2] >>> 8 * (3 - (i & 3)));
        }
        return 0;
    }

    public void SHA1PadMessage(VistaSha1Context context) {
        if (context.Message_Block_Index > 55) {
            context.Message_Block[context.Message_Block_Index++] = -128;
            while (context.Message_Block_Index < 64) {
                context.Message_Block[context.Message_Block_Index++] = 0;
            }
            this.SHA1ProcessMessageBlock(context);
            while (context.Message_Block_Index < 56) {
                context.Message_Block[context.Message_Block_Index++] = 0;
            }
        } else {
            context.Message_Block[context.Message_Block_Index++] = -128;
            while (context.Message_Block_Index < 56) {
                context.Message_Block[context.Message_Block_Index++] = 0;
            }
        }
        context.Message_Block[56] = (byte)(context.Length_High >>> 24 & 0xFF);
        context.Message_Block[57] = (byte)(context.Length_High >>> 16 & 0xFF);
        context.Message_Block[58] = (byte)(context.Length_High >>> 8 & 0xFF);
        context.Message_Block[59] = (byte)(context.Length_High & 0xFF);
        context.Message_Block[60] = (byte)(context.Length_Low >>> 24 & 0xFF);
        context.Message_Block[61] = (byte)(context.Length_Low >>> 16 & 0xFF);
        context.Message_Block[62] = (byte)(context.Length_Low >>> 8 & 0xFF);
        context.Message_Block[63] = (byte)(context.Length_Low & 0xFF);
        this.SHA1ProcessMessageBlock(context);
    }
}

