/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.x509;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gamma.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.asn1.oiw.OIWObjectIdentifiers;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.pkcs.RSASSAPSSparams;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x9.X9ObjectIdentifiers;
import kz.gamma.jce.X509Principal;
import kz.gamma.util.Strings;

class X509Util {
    private static Hashtable algorithms = new Hashtable();
    private static Hashtable params = new Hashtable();
    private static Set noParams = new HashSet();

    X509Util() {
    }

    private static RSASSAPSSparams creatPSSParams(AlgorithmIdentifier hashAlgId, int saltSize) {
        return new RSASSAPSSparams(hashAlgId, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, hashAlgId), new DERInteger(saltSize), new DERInteger(1));
    }

    static DERObjectIdentifier getAlgorithmOID(String algorithmName) {
        if (algorithms.containsKey(algorithmName = Strings.toUpperCase(algorithmName))) {
            return (DERObjectIdentifier)algorithms.get(algorithmName);
        }
        return new DERObjectIdentifier(algorithmName);
    }

    static AlgorithmIdentifier getSigAlgID(DERObjectIdentifier sigOid, String algorithmName) {
        if (noParams.contains(sigOid)) {
            return new AlgorithmIdentifier(sigOid);
        }
        if (params.containsKey(algorithmName = Strings.toUpperCase(algorithmName))) {
            return new AlgorithmIdentifier(sigOid, (DEREncodable)params.get(algorithmName));
        }
        return new AlgorithmIdentifier(sigOid, new DERNull());
    }

    static Iterator getAlgNames() {
        Enumeration e = algorithms.keys();
        ArrayList l = new ArrayList();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l.iterator();
    }

    static Signature getSignatureInstance(String algorithm) throws NoSuchAlgorithmException {
        return Signature.getInstance(algorithm);
    }

    static Signature getSignatureInstance(String algorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (provider != null) {
            return Signature.getInstance(algorithm, provider);
        }
        return Signature.getInstance(algorithm);
    }

    static byte[] calculateSignature(DERObjectIdentifier sigOid, String sigName, PrivateKey key, SecureRandom random, ASN1Encodable object) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (sigOid == null) {
            throw new IllegalStateException("no signature algorithm specified");
        }
        Signature sig = X509Util.getSignatureInstance(sigName);
        if (random != null) {
            sig.initSign(key, random);
        } else {
            sig.initSign(key);
        }
        sig.update(object.getEncoded("DER"));
        return sig.sign();
    }

    static byte[] calculateSignature(DERObjectIdentifier sigOid, String sigName, String provider, PrivateKey key, SecureRandom random, ASN1Encodable object) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (sigOid == null) {
            throw new IllegalStateException("no signature algorithm specified");
        }
        Signature sig = X509Util.getSignatureInstance(sigName, provider);
        if (random != null) {
            sig.initSign(key, random);
        } else {
            sig.initSign(key);
        }
        sig.update(object.getEncoded("DER"));
        return sig.sign();
    }

    static X509Principal convertPrincipal(X500Principal principal) {
        try {
            return new X509Principal(principal.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot convert principal");
        }
    }

    static Implementation getImplementation(String baseName, String algorithm, Provider prov) throws NoSuchAlgorithmException {
        String alias;
        algorithm = Strings.toUpperCase(algorithm);
        while ((alias = prov.getProperty("Alg.Alias." + baseName + "." + algorithm)) != null) {
            algorithm = alias;
        }
        String className = prov.getProperty(baseName + "." + algorithm);
        if (className != null) {
            try {
                ClassLoader clsLoader = prov.getClass().getClassLoader();
                Class<?> cls = clsLoader != null ? clsLoader.loadClass(className) : Class.forName(className);
                return new Implementation(cls.newInstance(), prov);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("algorithm " + algorithm + " in provider " + prov.getName() + " but no class \"" + className + "\" found!");
            }
            catch (Exception e) {
                throw new IllegalStateException("algorithm " + algorithm + " in provider " + prov.getName() + " but class \"" + className + "\" inaccessible!");
            }
        }
        throw new NoSuchAlgorithmException("cannot find implementation " + algorithm + " for provider " + prov.getName());
    }

    static Implementation getImplementation(String baseName, String algorithm) throws NoSuchAlgorithmException {
        Provider[] prov = Security.getProviders();
        for (int i = 0; i != prov.length; ++i) {
            Implementation imp = X509Util.getImplementation(baseName, Strings.toUpperCase(algorithm), prov[i]);
            if (imp != null) {
                return imp;
            }
            try {
                imp = X509Util.getImplementation(baseName, algorithm, prov[i]);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException("cannot find implementation " + algorithm);
    }

    static Provider getProvider(String provider) throws NoSuchProviderException {
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException("Provider " + provider + " not found");
        }
        return prov;
    }

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", PKCSObjectIdentifiers.md2WithRSAEncryption);
        algorithms.put("MD2WITHRSA", PKCSObjectIdentifiers.md2WithRSAEncryption);
        algorithms.put("MD5WITHRSAENCRYPTION", PKCSObjectIdentifiers.md5WithRSAEncryption);
        algorithms.put("MD5WITHRSA", PKCSObjectIdentifiers.md5WithRSAEncryption);
        algorithms.put("SHA1WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algorithms.put("SHA1WITHRSA", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algorithms.put("SHA224WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA224WITHRSA", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA256WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA256WITHRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA384WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA384WITHRSA", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA512WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA512WITHRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA1WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA224WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA256WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA384WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA512WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA1WITHDSA", X9ObjectIdentifiers.id_dsa_with_sha1);
        algorithms.put("DSAWITHSHA1", X9ObjectIdentifiers.id_dsa_with_sha1);
        algorithms.put("SHA1WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("ECDSAWITHSHA1", X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("SHA224WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA224);
        algorithms.put("SHA256WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256);
        algorithms.put("SHA384WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384);
        algorithms.put("SHA512WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512);
        algorithms.put("GOST3411WITHGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3411WITHGOST3410-94", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3411WITHECGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHECGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("ECGOST34310", GammaObjectIndentifiers.gost34310);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA1);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA224);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA256);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA384);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA512);
        noParams.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        AlgorithmIdentifier sha1AlgId = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, new DERNull());
        params.put("SHA1WITHRSAANDMGF1", X509Util.creatPSSParams(sha1AlgId, 20));
    }

    static class Implementation {
        Object engine;
        Provider provider;

        Implementation(Object engine, Provider provider) {
            this.engine = engine;
            this.provider = provider;
        }

        Object getEngine() {
            return this.engine;
        }

        Provider getProvider() {
            return this.provider;
        }
    }
}

