#include <windows.h>
#include <stdio.h>
#include "test_p7_ocsp_tsp.h"

#define TSP_POLICY   "1.2.3"
#define PROFILE "profile://testOcspTsp"
#define DATA2SIGN "1234567890"
#define CERT_FILE "user.cer"
#define TSP_FILE "tsp.bin"
#define OCSP_FILE "ocsp.bin"
#define PKCS7_FILE "pkcs7.bin"
#define SIGNERCERT "signCert.cer"
#define TSP_CERT "tsp.cer"

HINSTANCE hInstCSP = 0;


int LoadTumarCSP()
{
	int ret = 0;
	try
	{
		hInstCSP = LoadLibraryA("cptumar.dll");
		if (hInstCSP == 0)
		{
			ret = GetLastError(); throw ret;
		}
		if ((CPAcquireContext_My = (D_CPAcquireContext)GetProcAddress(hInstCSP, "CPAcquireContext")) == 0) { throw 2; }
		if ((CPGetProvParam_My = (D_CPGetProvParam)GetProcAddress(hInstCSP, "CPGetProvParam")) == 0) { throw 3; }
		if ((CPReleaseContext_My = (D_CPReleaseContext)GetProcAddress(hInstCSP, "CPReleaseContext")) == 0) { throw 4; }
		if ((CPSetProvParam_My = (D_CPSetProvParam)GetProcAddress(hInstCSP, "CPSetProvParam")) == 0) { throw 5; }
		if ((CPDeriveKey_My = (D_CPDeriveKey)GetProcAddress(hInstCSP, "CPDeriveKey")) == 0) { throw 6; }
		if ((CPDestroyKey_My = (D_CPDestroyKey)GetProcAddress(hInstCSP, "CPDestroyKey")) == 0) { throw 7; }
		if ((CPDuplicateKey_My = (D_CPDuplicateKey)GetProcAddress(hInstCSP, "CPDuplicateKey")) == 0) { throw 8; }
		if ((CPExportKey_My = (D_CPExportKey)GetProcAddress(hInstCSP, "CPExportKey")) == 0) { throw 9; }
		if ((CPGenKey_My = (D_CPGenKey)GetProcAddress(hInstCSP, "CPGenKey")) == 0) { throw 10; }
		if ((CPGenRandom_My = (D_CPGenRandom)GetProcAddress(hInstCSP, "CPGenRandom")) == 0) { throw 11; }
		if ((CPGetKeyParam_My = (D_CPGetKeyParam)GetProcAddress(hInstCSP, "CPGetKeyParam")) == 0) { throw 12; }
		if ((CPGetUserKey_My = (D_CPGetUserKey)GetProcAddress(hInstCSP, "CPGetUserKey")) == 0) { throw 13; }
		if ((CPImportKey_My = (D_CPImportKey)GetProcAddress(hInstCSP, "CPImportKey")) == 0) { throw 14; }
		if ((CPSetKeyParam_My = (D_CPSetKeyParam)GetProcAddress(hInstCSP, "CPSetKeyParam")) == 0) { throw 15; }
		if ((CPDecrypt_My = (D_CPDecrypt)GetProcAddress(hInstCSP, "CPDecrypt")) == 0) { throw 16; }
		if ((CPEncrypt_My = (D_CPEncrypt)GetProcAddress(hInstCSP, "CPEncrypt")) == 0) { throw 17; }
		if ((CPCreateHash_My = (D_CPCreateHash)GetProcAddress(hInstCSP, "CPCreateHash")) == 0) { throw 18; }
		if ((CPDestroyHash_My = (D_CPDestroyHash)GetProcAddress(hInstCSP, "CPDestroyHash")) == 0) { throw 19; }
		if ((CPDuplicateHash_My = (D_CPDuplicateHash)GetProcAddress(hInstCSP, "CPDuplicateHash")) == 0) { throw 20; }
		if ((CPGetHashParam_My = (D_CPGetHashParam)GetProcAddress(hInstCSP, "CPGetHashParam")) == 0) { throw 21; }
		if ((CPHashData_My = (D_CPHashData)GetProcAddress(hInstCSP, "CPHashData")) == 0) { throw 22; }
		if ((CPHashSessionKey_My = (D_CPHashSessionKey)GetProcAddress(hInstCSP, "CPHashSessionKey")) == 0) { throw 23; }
		if ((CPSetHashParam_My = (D_CPSetHashParam)GetProcAddress(hInstCSP, "CPSetHashParam")) == 0) { throw 24; }
		if ((CPSignHash_My = (D_CPSignHash)GetProcAddress(hInstCSP, "CPSignHash")) == 0) { throw 25; }
		if ((CPVerifySignature_My = (D_CPVerifySignature)GetProcAddress(hInstCSP, "CPVerifySignature")) == 0) { throw 26; }

	}
	catch (int err)
	{
		ret = err;
		if (hInstCSP) FreeLibrary(hInstCSP);
	}
	return ret;
}


DWORD TumarCSPGetError(HCRYPTPROV hProv)
{
	DWORD err = 0;
	DWORD len = sizeof(DWORD);
	CPGetProvParam_My(hProv, PP_LAST_ERROR, reinterpret_cast<BYTE*>(&err), &len, 0);
	return err;
}

/////////////////////////////////////////////////////
		// OCSP-		
/////////////////////////////////////////////////////
int CreateOCSPRequest(char* pathCert, char* prof)
{
	int ret = 0;
	HCRYPTPROV hProv = 0;
	HCRYPTKEY hKey = 0, hExpKey = 0;
	long l = 0;
	FILE* f = NULL;
	unsigned char* Cert = NULL;
	DWORD sz = 0, len=0;
	unsigned char* WBuf2 = NULL;
	try
	{
		if ((f = fopen(pathCert, "rb")) == NULL) throw ERROR_FILE_NOT_FOUND;		
		l = ftell(f);
		fseek(f, 0L, SEEK_END);
		sz = ftell(f);
		fseek(f, l, SEEK_SET);
		Cert = new unsigned char[sz];
		sz = fread(Cert, sizeof(unsigned char), sz, f);
		fclose(f);
		if (!CPAcquireContext_My(&hProv, prof, 0, NULL)) throw TumarCSPGetError(hProv);
		if (!CPGetUserKey_My(hProv, AT_SIGNATURE, &hExpKey)) throw TumarCSPGetError(hProv);
		if (!CPImportKey_My(hProv, Cert, sz, 0, 0, &hKey)) throw TumarCSPGetError(hProv);
		if (!CPExportKey_My(hProv, hKey, hExpKey, PUBLICKEYBLOB_OCSP, 0, NULL, &len)) throw TumarCSPGetError(hProv);
		WBuf2 = new unsigned char[len];
		if (!CPExportKey_My(hProv, hKey, hExpKey, PUBLICKEYBLOB_OCSP, 0, WBuf2, &len)) throw TumarCSPGetError(hProv);					
		//   WBuf2      OCSP,     OCSP  
		//        ,         OCSP_FILE 
	}
	catch (DWORD err)
	{
		ret = err;
	}
	CPDestroyKey_My(hProv, hKey);
	CPDestroyKey_My(hProv, hExpKey);
	CPReleaseContext_My(hProv, 0);
	if (Cert) delete[] Cert;
	if (WBuf2) delete[] WBuf2;
	return ret;
}

//////////////////////////////////////////////////////
	// TSP-
/////////////////////////////////////////////////////
int CreateTSPRequest(char* prof, BYTE* data, int dataLen)
{
	int ret = 0;
	HCRYPTPROV hProv = 0;
	HCRYPTHASH hHash = 0;
	DWORD len = 0, dw = 0;
	unsigned char* WBuf = NULL;
	try
	{
		if (!CPAcquireContext_My(&hProv, prof, 0, nullptr)) throw TumarCSPGetError(hProv);
		if (!CPCreateHash_My(hProv, CALG_TGR3411, 0, 0, &hHash)) throw TumarCSPGetError(hProv);
		if (!CPHashData_My(hProv, hHash, data, dataLen, 0)) throw TumarCSPGetError(hProv);
		if (!CPSetHashParam_My(hProv, hHash, HP_TIME_STAMP_OID, (BYTE*)TSP_POLICY, 0))  throw TumarCSPGetError(hProv);
		dw = 1;
		if (!CPSetHashParam_My(hProv, hHash, HP_TIME_STAMP_CRT, (BYTE*)&dw, 0)) throw TumarCSPGetError(hProv);
		if (!CPGetHashParam_My(hProv, hHash, HP_TIME_STAMP_REQ, NULL, &len, 0)) throw TumarCSPGetError(hProv);
		WBuf = new unsigned char[len];
		if (!CPGetHashParam_My(hProv, hHash, HP_TIME_STAMP_REQ, WBuf, &len, 0)) throw TumarCSPGetError(hProv);
		//   WBuf      TSP,      TSP  
		//     ,           TSP_FILE 
	}
	catch (DWORD err)
	{
		ret = err;
	}
	if (WBuf) delete[] WBuf;
	CPDestroyHash_My(hProv, hHash);
	CPReleaseContext_My(hProv, 0);
	return ret;
}

/////////////////////////////////////////////////////
		//    (PKCS7)
/////////////////////////////////////////////////////

int CreatePKCS7(char* prof, char* pathOCSP, char* pathTSP, char* path2Save)
{
	int ret = 0;
	FILE* f = NULL;
	long l = 0;
	HCRYPTPROV hProv = 0;
	HCRYPTHASH hHash = 0;
	HCRYPTKEY hKey = 0;
	DWORD keyType = AT_SIGNATURE;
	DWORD certSize = 0, signDataSize = 0, ocsp_len = 0, tsp_len = 0, len=0;	
	unsigned char *sign = NULL, *ocsp=NULL, *tsp = NULL, *certBlob = NULL;	
	try
	{
		if (!CPAcquireContext_My(&hProv, prof, 0, nullptr)) throw TumarCSPGetError(hProv);
		if (!CPGetUserKey_My(hProv, AT_SIGNATURE, &hKey))
		{
			if (!CPGetUserKey_My(hProv, AT_KEYEXCHANGE, &hKey)) throw TumarCSPGetError(hProv);
			keyType = AT_KEYEXCHANGE;
		}
		if (!CPGetKeyParam_My(hProv, hKey, KP_CERTIFICATE, NULL, (unsigned long*)&certSize, 0)) throw TumarCSPGetError(hProv);
		certBlob = new unsigned char[certSize];
		if (!CPGetKeyParam_My(hProv, hKey, KP_CERTIFICATE, certBlob, (unsigned long*)&certSize, 0)) throw TumarCSPGetError(hProv);
		if (!CPCreateHash_My(hProv, CALG_TGR3411, 0, 0, &hHash)) throw TumarCSPGetError(hProv);
		signDataSize = strlen(DATA2SIGN);
		if (!CPHashData_My(hProv, hHash, (BYTE*)DATA2SIGN, signDataSize, 0))  throw TumarCSPGetError(hProv);
		if (!CPSetHashParam_My(hProv, hHash, HP_PKCS7_CERTIFICATE, certBlob, 0)) throw TumarCSPGetError(hProv);
		if (!CPSetHashParam_My(hProv, hHash, HP_PKCS7_DATA_SIZE, reinterpret_cast<BYTE*>(&signDataSize), 0)) throw TumarCSPGetError(hProv);
		if (!CPSetHashParam_My(hProv, hHash, HP_PKCS7_DATA, (BYTE*)DATA2SIGN, 0)) throw TumarCSPGetError(hProv);

		if ((f = fopen(pathOCSP, "rb")) != NULL)
		{
			l = ftell(f);
			fseek(f, 0L, SEEK_END);
			ocsp_len = ftell(f);
			fseek(f, l, SEEK_SET);
			ocsp = new unsigned char[ocsp_len];
			ocsp_len = fread(ocsp, sizeof(unsigned char), ocsp_len, f);
			fclose(f);
		}
		if (ocsp_len > 0) //   OCSP
		{
			if (!CPSetHashParam_My(hProv, hHash, HP_PKCS9_CUR_OID, (BYTE*)szOID_PKIX_OCSP_BASIC_SIGNED_RESPONSE, 0)) throw TumarCSPGetError(hProv);
			if (!CPSetHashParam_My(hProv, hHash, HP_PKCS9A_SIZE, (BYTE*)&ocsp_len, 0)) throw TumarCSPGetError(hProv);
			if (!CPSetHashParam_My(hProv, hHash, HP_PKCS9A_DATA, (BYTE*)ocsp, 0)) throw TumarCSPGetError(hProv);
		}

		if ((f = fopen(pathTSP, "rb")) != NULL)
		{
			l = ftell(f);
			fseek(f, 0L, SEEK_END);
			tsp_len = ftell(f);
			fseek(f, l, SEEK_SET);
			tsp = new unsigned char[tsp_len];
			tsp_len = fread(tsp, sizeof(unsigned char), tsp_len, f);
			fclose(f);
		}
		if (tsp_len > 0)  //   TSP
		{
			if (!CPSetHashParam_My(hProv, hHash, HP_PKCS9_CUR_OID, (BYTE*)OID_PKCS9_TIMESTAMPATTR, 0)) throw TumarCSPGetError(hProv);
			if (!CPSetHashParam_My(hProv, hHash, HP_PKCS9A_SIZE, (BYTE*)&tsp_len, 0)) throw TumarCSPGetError(hProv);
			if (!CPSetHashParam_My(hProv, hHash, HP_PKCS9A_DATA, (BYTE*)tsp, 0)) throw TumarCSPGetError(hProv);
		}
		if (!CPSignHash_My(hProv, hHash, keyType, nullptr, CRYPT_SIGN_PKCS7, nullptr, &len)) throw TumarCSPGetError(hProv);	
		sign = new unsigned char[len];		
		if (!CPSignHash_My(hProv, hHash, keyType, nullptr, CRYPT_SIGN_PKCS7, sign, &len)) throw TumarCSPGetError(hProv);

		f = fopen(path2Save, "wb");
		fwrite(sign, len, 1, f);
		fclose(f);
	}
	catch (DWORD err)
	{
		ret = err;
	}
	if (hKey) CPDestroyKey_My(hProv, hKey);
	if (hHash) CPDestroyHash_My(hProv, hHash);
	if (hProv) CPReleaseContext_My(hProv, 0);
	if (sign) delete[] sign;
	if (ocsp) delete[] ocsp;
	if (tsp) delete[] tsp;
	return ret;
}

///////////////////////////////////////////////////////////////////////////////
	//         OCSP  TSP//
	//////////////////////////////////////////////////////////////////////////////

int VerifyPKCS7(char* messPath, char* signerCertPath, char* tspCertPath)
{
	int ret = 0;
	FILE* f = NULL;
	long l = 0;
	HCRYPTPROV hProv = 0;
	HCRYPTHASH hHash = 0, hHashTSP = 0;	
	HCRYPTKEY hKey = 0,  hKeyOCSP = 0, hKeyTSP = 0;
	DWORD len = 0, dw = 0, sz = 0, lenOCSP = 0, lenTSP = 0, lenTspCert = 0;
	unsigned char* sign = NULL, *signerCert=NULL, * content=NULL, *CertOcsp=NULL, *tspCert=NULL, *WBuf2=NULL;
	unsigned char ocspProperty[256];
	unsigned char wb[512]{ 0 };
	char* st = NULL;
	try
	{
		if ((f = fopen(messPath, "rb")) != NULL) //   
		{
			l = ftell(f);
			fseek(f, 0L, SEEK_END);
			len = ftell(f);
			fseek(f, l, SEEK_SET);
			sign = new unsigned char[len];
			len = fread(sign, sizeof(unsigned char), len, f);
			fclose(f);
		}

		if ((f = fopen(signerCertPath, "rb")) != NULL)//   
		{
			l = ftell(f);
			fseek(f, 0L, SEEK_END);
			sz = ftell(f);
			fseek(f, l, SEEK_SET);
			signerCert = new unsigned char[sz];
			sz = fread(signerCert, sizeof(unsigned char), sz, f);
			fclose(f);
		}

		if (!CPAcquireContext_My(&hProv, NULL, CRYPT_VERIFYCONTEXT, NULL)) throw TumarCSPGetError(hProv);
		if (!CPImportKey_My(hProv, signerCert, sz, 0, 0, &hKey)) throw TumarCSPGetError(hProv);
		if (!CPVerifySignature_My(hProv, 0, sign, len, hKey, 0, CRYPT_OBJECT_P7A)) 
		{
			printf("Verify signature error\r\n"); 
			throw TumarCSPGetError(hProv);
		}
		
			// OK	
			//   
		if (!CPCreateHash_My(hProv, CALG_TGR3411, 0, 0, &hHash)) throw TumarCSPGetError(hProv);
		if (!CPSetHashParam_My(hProv, hHash, HP_PKCS7_BODY, sign, 0)) throw TumarCSPGetError(hProv);
		if (!CPGetHashParam_My(hProv, hHash, HP_PKCS7_DATA, NULL, &sz, 0)) throw TumarCSPGetError(hProv);
		content = new unsigned char[sz];
		if (!CPGetHashParam_My(hProv, hHash, HP_PKCS7_DATA, content, &sz, 0)) throw TumarCSPGetError(hProv);
		printf(" : %s", content);

		//    OCSP			
		if (!CPSetHashParam_My(hProv, hHash, HP_PKCS9_CUR_OID, (BYTE*)szOID_PKIX_OCSP_BASIC_SIGNED_RESPONSE, 0)) throw TumarCSPGetError(hProv);
		lenOCSP = sizeof(DWORD);
		if (CPGetHashParam_My(hProv, hHash, HP_PKCS9A_SIZE, (BYTE*)&l, &lenOCSP, 0)) //    -     
		{
			if (!CPGetHashParam_My(hProv, hHash, HP_PKCS9A_DATA, NULL, &lenOCSP, 0)) throw TumarCSPGetError(hProv);
			WBuf2 = new unsigned char[lenOCSP];
			if (!CPGetHashParam_My(hProv, hHash, HP_PKCS9A_DATA, WBuf2, &lenOCSP, 0)) throw TumarCSPGetError(hProv);
			if (!CPImportKey_My(hProv, WBuf2, lenOCSP, 0, 0, &hKeyOCSP)) throw TumarCSPGetError(hProv);
			//      OCSP:
			len = sizeof(ocspProperty);
			if (!CPGetKeyParam_My(hProv, hKeyOCSP, KP_OCSP_REP_TIME, ocspProperty, &len, 0)) throw TumarCSPGetError(hProv);
			ocspProperty[len] = 0; printf("ProducedAt: %s\r\n", (char*)ocspProperty);
			//        :
			len = sizeof(ocspProperty);
			if (!CPGetKeyParam_My(hProv, hKeyOCSP, KP_OCSP_REP_CRT_SN, ocspProperty, &len, 0)) throw TumarCSPGetError(hProv);
			printf("SerialNumber: SN: %02X,%02X ..\r\n", ocspProperty[0], ocspProperty[1]);
			//    :
			len = sizeof(dw);
			if (!CPGetKeyParam_My(hProv, hKeyOCSP, KP_OCSP_REP_CRT_STATUS, (BYTE*)&dw, &len, 0)) throw TumarCSPGetError(hProv);
			switch (dw)
			{
					case 0: {st = (char*)"good";    break; }
					case 1: {st = (char*)"revoked"; break; }
					case 2: {st = (char*)"unknown"; break; }
					default: st = (char*)"error status";
			}
			printf("CertStatus: %s\r\n", st);
			if (dw == 1) 
			{ // revoked
				  //    ,  :
					len = sizeof(ocspProperty);
					if (!CPGetKeyParam_My(hProv, hKeyOCSP, KP_OCSP_REP_REV_TIME, ocspProperty, &len, 0)) throw TumarCSPGetError(hProv);
					ocspProperty[len] = 0; printf("RevocationTime: %s\r\n", (char*)ocspProperty);
					//   :
					len = sizeof(dw);
					if (!CPGetKeyParam_My(hProv, hKeyOCSP, KP_OCSP_REP_REV_REASON, (BYTE*)&dw, &len, 0)) throw TumarCSPGetError(hProv);
					printf("RevocationReason: %d\r\n", dw);
			}
			//     "":
			len = sizeof(ocspProperty);
			if (!CPGetKeyParam_My(hProv, hKeyOCSP, KP_OCSP_REP_THIS_UPD, ocspProperty, &len, 0)) throw TumarCSPGetError(hProv);
			ocspProperty[len] = 0; printf("ThisUpdate: %s\r\n", (char*)ocspProperty);
			//     "":
			len = sizeof(ocspProperty);
			if (!CPGetKeyParam_My(hProv, hKeyOCSP, KP_OCSP_REP_NEXT_UPD, ocspProperty, &len, 0)) throw TumarCSPGetError(hProv);
			ocspProperty[len] = 0; printf("NextUpdate: %s\r\n", (char*)ocspProperty);
			//    OCSP-: 				
			if (!CPGetKeyParam_My(hProv, hKeyOCSP, KP_CERTIFICATE, NULL, &len, 0)) throw TumarCSPGetError(hProv);
			CertOcsp = new unsigned char[len];
			if (!CPGetKeyParam_My(hProv, hKeyOCSP, KP_CERTIFICATE, CertOcsp, &len, 0)) throw TumarCSPGetError(hProv);
			CPDestroyKey_My(hProv, hKeyOCSP);
			//   OCSP
			if (!CPImportKey_My(hProv, CertOcsp, len, 0, 0, &hKeyOCSP)) throw TumarCSPGetError(hProv);
			//    
			if (!CPVerifySignature_My(hProv, 0, WBuf2, lenOCSP, hKeyOCSP, NULL, CRYPT_OBJECT_OCSP)) throw TumarCSPGetError(hProv);		
		}
		else
		{
			printf("    OCSP\r\n");
		}

		if (WBuf2)
		{
			delete[] WBuf2;
			WBuf2 = NULL;
		}

		//   TSP			
		if (!CPSetHashParam_My(hProv, hHash, HP_PKCS9_CUR_OID, (BYTE*)OID_PKCS9_TIMESTAMPATTR, 0)) throw TumarCSPGetError(hProv);
		lenTSP = sizeof(DWORD);
		if (CPGetHashParam_My(hProv, hHash, HP_PKCS9A_SIZE, (BYTE*)&l, &lenTSP, 0)) //    -   
		{
			if (!CPGetHashParam_My(hProv, hHash, HP_PKCS9A_DATA, NULL, &lenTSP, 0)) throw TumarCSPGetError(hProv);
			WBuf2 = new unsigned char[lenTSP];
			if (!CPGetHashParam_My(hProv, hHash, HP_PKCS9A_DATA, WBuf2, &lenTSP, 0)) throw TumarCSPGetError(hProv);
			//     				
			if ((f = fopen(tspCertPath, "rb")) != NULL)//   
			{
				l = ftell(f);
				fseek(f, 0L, SEEK_END);
				lenTspCert = ftell(f);
				fseek(f, l, SEEK_SET);
				tspCert = new unsigned char[lenTspCert];
				lenTspCert = fread(tspCert, sizeof(unsigned char), lenTspCert, f);
				fclose(f);
				//     
				if (!CPImportKey_My(hProv, tspCert, lenTspCert, 0, 0, &hKeyTSP)) throw TumarCSPGetError(hProv);
				//  
				if (!CPVerifySignature_My(hProv, 0, WBuf2, lenTSP, hKeyTSP, NULL, CRYPT_OBJECT_TSP)) throw TumarCSPGetError(hProv);
			}
			
			if (!CPCreateHash_My(hProv, CALG_TGR3411, 0, 0, &hHashTSP)) throw TumarCSPGetError(hProv);
			//     
			if (!CPSetHashParam_My(hProv, hHashTSP, HP_TSTAMP_BODY, WBuf2, 0)) throw TumarCSPGetError(hProv);
			//   
			len = sizeof(dw);
			if (!CPGetHashParam_My(hProv, hHashTSP, HP_TSTAMP_STSTUS, (BYTE*)&dw, &len, 0)) throw TumarCSPGetError(hProv);
			printf("Status = %d\r\n", dw);
			//      TSP
			len = sizeof(wb);
			if (!CPGetHashParam_My(hProv, hHashTSP, HP_PKCS7_SI_SN, wb, &len, 0)) throw TumarCSPGetError(hProv);
			printf("SN (size=%d) : %02X %02X ...\r\n", len, wb[0], wb[1]);
			if (dw == 0) 
			{
				//  
				len = sizeof(wb);
				if (!CPGetHashParam_My(hProv, hHashTSP, HP_TSTAMP_HASH, wb, &len, 0)) throw TumarCSPGetError(hProv);
				printf("Hash (size=%d) = %02X %02X ...\r\n", len, wb[0], wb[1]);
				//  
				len = sizeof(wb);
				if (!CPGetHashParam_My(hProv, hHashTSP, HP_TSTAMP_POLICIE, wb, &len, 0)) throw TumarCSPGetError(hProv);
				wb[len] = 0;
				printf("Policie = %s\r\n", (char*)wb);
				//  
				len = sizeof(wb);
				if (!CPGetHashParam_My(hProv, hHashTSP, HP_TSTAMP_TIME, wb, &len, 0)) throw TumarCSPGetError(hProv);
				wb[len] = 0;
				printf("Time = %s\r\n", (char*)wb);
				//   
				len = sizeof(wb);
				if (!CPGetHashParam_My(hProv, hHashTSP, HP_TSTAMP_SN, wb, &len, 0)) throw TumarCSPGetError(hProv);
				printf("SN (size=%d) = %02X %02X ...\r\n", len, wb[0], wb[1]);
				//  NONCE
				len = sizeof(wb);
				if (!CPGetHashParam_My(hProv, hHashTSP, HP_TSTAMP_NONCE, wb, &len, 0)) throw TumarCSPGetError(hProv);
				printf("Nonce (size=%d) = %02X %02X ...\r\n", len, wb[0], wb[1]);
				//  DN
				len = sizeof(wb);
				if (!CPGetHashParam_My(hProv, hHashTSP, HP_TSTAMP_DN, wb, &len, 0)) throw TumarCSPGetError(hProv);
				wb[len] = 0;
				printf("DN = [%s]\r\n", (char*)wb);
			}			
		}
		else
		{
			printf("    \r\n");
		}
}			
catch (DWORD err)
{
	ret = err;
}
if (CertOcsp) delete[] CertOcsp;
if (sign) delete[] sign;
if (signerCert) delete[] signerCert;
if (content) delete[] content;
if (WBuf2)  delete[] WBuf2;
if (tspCert) delete[] tspCert;
if (hKeyOCSP)	CPDestroyKey_My(hProv, hKeyOCSP);
if (hKeyTSP)	CPDestroyKey_My(hProv, hKeyTSP);
if (hHashTSP)	CPDestroyHash_My(hProv, hHashTSP);
if (hProv) CPReleaseContext_My(hProv, 0);
return ret;
}


int main(void)
{	
	int ret = 0;	
	try
	{
		ret = LoadTumarCSP();
		if (ret != 0) throw ret;
		ret = CreateTSPRequest((char*)PROFILE, (BYTE*)DATA2SIGN, strlen(DATA2SIGN));
		if (ret != 0) throw ret;
		ret = CreateOCSPRequest((char*)CERT_FILE, (char*)PROFILE);
		if (ret != 0) throw ret;		
		ret = CreatePKCS7((char*)PROFILE, (char*)OCSP_FILE, (char*)TSP_FILE, (char*)PKCS7_FILE);
		if (ret != 0) throw ret;	
		ret = VerifyPKCS7((char*)PKCS7_FILE, (char*)SIGNERCERT, (char*)TSP_CERT);
		if (ret != 0) throw ret;
	}
	catch (DWORD err)
	{
		printf("error: %x", err);
		ret = err;
	}
	
	if (hInstCSP) FreeLibrary(hInstCSP);
	getchar();
	return ret;
}
