/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cms;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cms.IssuerAndSerialNumber;
import kz.gamma.asn1.cms.RecipientKeyIdentifier;

public class KeyAgreeRecipientIdentifier
extends ASN1Encodable {
    private IssuerAndSerialNumber issuerSerial;
    private RecipientKeyIdentifier rKeyID;

    private KeyAgreeRecipientIdentifier(ASN1Sequence seq) {
        this.issuerSerial = IssuerAndSerialNumber.getInstance(seq);
        this.rKeyID = null;
    }

    public static KeyAgreeRecipientIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return KeyAgreeRecipientIdentifier.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static KeyAgreeRecipientIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof KeyAgreeRecipientIdentifier) {
            return (KeyAgreeRecipientIdentifier)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new KeyAgreeRecipientIdentifier((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier: " + obj.getClass().getName());
    }

    public KeyAgreeRecipientIdentifier(IssuerAndSerialNumber issuerSerial) {
        this.issuerSerial = issuerSerial;
        this.rKeyID = null;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerSerial;
    }

    public RecipientKeyIdentifier getRKeyID() {
        return this.rKeyID;
    }

    @Override
    public DERObject toASN1Object() {
        if (this.issuerSerial != null) {
            return this.issuerSerial.toASN1Object();
        }
        return new DERTaggedObject(false, 0, this.rKeyID);
    }
}

